/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.impl.display;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.octol1ttle.flightassistant.FAKeyMappings;
import ru.octol1ttle.flightassistant.FlightAssistant;
import ru.octol1ttle.flightassistant.api.autoflight.ControlInput;
import ru.octol1ttle.flightassistant.api.computer.ComputerBus;
import ru.octol1ttle.flightassistant.api.display.Display;
import ru.octol1ttle.flightassistant.api.display.HudFrame;
import ru.octol1ttle.flightassistant.api.util.FATickCounter;
import ru.octol1ttle.flightassistant.api.util.extensions.GuiGraphicsExtensionsKt;
import ru.octol1ttle.flightassistant.api.util.extensions.MutableComponentExtensionsKt;
import ru.octol1ttle.flightassistant.config.FAConfig;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00192\u00020\u0001:\u0002\u0019\u001aB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\"\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00072\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lru/octol1ttle/flightassistant/impl/display/AutomationModesDisplay;", "Lru/octol1ttle/flightassistant/api/display/Display;", "computers", "Lru/octol1ttle/flightassistant/api/computer/ComputerBus;", "<init>", "(Lru/octol1ttle/flightassistant/api/computer/ComputerBus;)V", "thrustDisplay", "Lru/octol1ttle/flightassistant/impl/display/AutomationModesDisplay$ModeDisplay;", "pitchDisplay", "headingDisplay", "automationStatusDisplay", "allowedByConfig", "", "render", "", "guiGraphics", "Lnet/minecraft/client/gui/GuiGraphics;", "renderThrustMode", "renderPitchMode", "renderInput", "display", "input", "Lru/octol1ttle/flightassistant/api/autoflight/ControlInput;", "renderAutomaticsMode", "renderFaulted", "Companion", "ModeDisplay", "flightassistant-forge"})
public final class AutomationModesDisplay
extends Display {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ModeDisplay thrustDisplay;
    @NotNull
    private final ModeDisplay pitchDisplay;
    @NotNull
    private final ModeDisplay headingDisplay;
    @NotNull
    private final ModeDisplay automationStatusDisplay;
    @NotNull
    private static final ResourceLocation ID = FlightAssistant.INSTANCE.id$flightassistant_forge("automation_modes");
    private static final float TOTAL_MODES = 4.0f;

    public AutomationModesDisplay(@NotNull ComputerBus computers) {
        Intrinsics.checkNotNullParameter((Object)computers, (String)"computers");
        super(computers);
        this.thrustDisplay = new ModeDisplay(1);
        this.pitchDisplay = new ModeDisplay(2);
        this.headingDisplay = new ModeDisplay(3);
        this.automationStatusDisplay = new ModeDisplay(4);
    }

    @Override
    public boolean allowedByConfig() {
        return FAConfig.INSTANCE.getDisplay().getShowAutomationModes();
    }

    @Override
    public void render(@NotNull GuiGraphics guiGraphics) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        this.renderThrustMode(guiGraphics);
        this.renderPitchMode(guiGraphics);
        this.renderInput(guiGraphics, this.headingDisplay, this.getComputers().getHeading().getActiveInput());
        this.renderAutomaticsMode(guiGraphics);
    }

    private final void renderThrustMode(GuiGraphics guiGraphics) {
        boolean thrustUnusable = this.getComputers().getThrust().getNoThrustSource() || this.getComputers().getThrust().getReverseUnsupported();
        ControlInput input = this.getComputers().getThrust().getActiveInput();
        if (input != null && FAKeyMappings.INSTANCE.isHoldingThrust() || FAKeyMappings.INSTANCE.getGlobalAutomationOverride().m_90857_()) {
            MutableComponent mutableComponent = Component.m_237115_((String)"mode.flightassistant.thrust.override");
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
            this.thrustDisplay.render(guiGraphics, (Component)MutableComponentExtensionsKt.setColor(mutableComponent, GuiGraphicsExtensionsKt.getCautionColor()), ControlInput.Status.ACTIVE, GuiGraphicsExtensionsKt.getCautionColor());
            return;
        }
        if (input != null) {
            this.thrustDisplay.render(guiGraphics, input.getText(), input.getStatus(), thrustUnusable || input.getStatus() == ControlInput.Status.ACTIVE && input.getPriority().compareTo((Enum)ControlInput.Priority.NORMAL) < 0 ? Integer.valueOf(GuiGraphicsExtensionsKt.getCautionColor()) : null);
            return;
        }
        if (this.getComputers().getThrust().getThrustLocked()) {
            MutableComponent mutableComponent;
            if (this.getComputers().getThrust().getCurrent() == 1.0f) {
                MutableComponent mutableComponent2 = Component.m_237115_((String)"mode.flightassistant.thrust.locked_toga");
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent2, (String)"translatable(...)");
                mutableComponent = MutableComponentExtensionsKt.setColor(mutableComponent2, GuiGraphicsExtensionsKt.getPrimaryColor());
            } else {
                MutableComponent mutableComponent3 = Component.m_237115_((String)"mode.flightassistant.thrust.locked");
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent3, (String)"translatable(...)");
                mutableComponent = MutableComponentExtensionsKt.setColor(mutableComponent3, GuiGraphicsExtensionsKt.getPrimaryColor());
            }
            this.thrustDisplay.render(guiGraphics, (Component)mutableComponent, ControlInput.Status.ACTIVE, FATickCounter.INSTANCE.getTotalTicks() % 20 >= 10 ? GuiGraphicsExtensionsKt.getCautionColor() : 0);
            return;
        }
        if (!(this.getComputers().getThrust().getCurrent() == 0.0f)) {
            MutableComponent mutableComponent;
            if (this.getComputers().getThrust().getCurrent() == 1.0f) {
                MutableComponent mutableComponent4 = Component.m_237115_((String)"mode.flightassistant.thrust.manual.toga");
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent4, (String)"translatable(...)");
                mutableComponent = MutableComponentExtensionsKt.setColor(mutableComponent4, GuiGraphicsExtensionsKt.getSecondaryColor());
            } else {
                mutableComponent = this.getComputers().getThrust().getCurrent() < 0.0f ? Component.m_237115_((String)"mode.flightassistant.thrust.manual.reverse") : Component.m_237115_((String)"mode.flightassistant.thrust.manual");
            }
            this.thrustDisplay.render(guiGraphics, (Component)mutableComponent, ControlInput.Status.ACTIVE, thrustUnusable ? Integer.valueOf(GuiGraphicsExtensionsKt.getCautionColor()) : null);
            return;
        }
        ModeDisplay.render$default(this.thrustDisplay, guiGraphics, null, ControlInput.Status.ACTIVE, null, 8, null);
    }

    private final void renderPitchMode(GuiGraphics guiGraphics) {
        if (FAKeyMappings.INSTANCE.getGlobalAutomationOverride().m_90857_()) {
            MutableComponent mutableComponent = Component.m_237115_((String)"mode.flightassistant.vertical.override");
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
            this.pitchDisplay.render(guiGraphics, (Component)MutableComponentExtensionsKt.setColor(mutableComponent, GuiGraphicsExtensionsKt.getCautionColor()), ControlInput.Status.ACTIVE, GuiGraphicsExtensionsKt.getCautionColor());
            return;
        }
        this.renderInput(guiGraphics, this.pitchDisplay, this.getComputers().getPitch().getActiveInput());
    }

    private final void renderInput(GuiGraphics guiGraphics, ModeDisplay display, ControlInput input) {
        if (input != null) {
            display.render(guiGraphics, input.getText(), input.getStatus(), input.getStatus() == ControlInput.Status.ACTIVE && input.getPriority().compareTo((Enum)ControlInput.Priority.NORMAL) < 0 ? Integer.valueOf(GuiGraphicsExtensionsKt.getCautionColor()) : null);
        } else {
            ModeDisplay.render$default(display, guiGraphics, null, ControlInput.Status.ACTIVE, null, 8, null);
        }
    }

    private final void renderAutomaticsMode(GuiGraphics guiGraphics) {
        MutableComponent mutableComponent = Component.m_237119_();
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"empty(...)");
        MutableComponent text = mutableComponent;
        if (this.getComputers().getAutoflight().getFlightDirectors()) {
            MutableComponent mutableComponent2 = Component.m_237115_((String)"short.flightassistant.flight_directors_alt");
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent2, (String)"translatable(...)");
            MutableComponentExtensionsKt.appendWithSeparation$default(text, (Component)mutableComponent2, null, 2, null);
        }
        if (this.getComputers().getAutoflight().getAutoThrust()) {
            MutableComponent mutableComponent3 = Component.m_237115_((String)"short.flightassistant.auto_thrust");
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent3, (String)"translatable(...)");
            MutableComponentExtensionsKt.appendWithSeparation$default(text, (Component)mutableComponent3, null, 2, null);
        }
        if (this.getComputers().getAutoflight().getAutopilot()) {
            MutableComponent mutableComponent4 = Component.m_237115_((String)"short.flightassistant.autopilot");
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent4, (String)"translatable(...)");
            MutableComponentExtensionsKt.appendWithSeparation$default(text, (Component)mutableComponent4, null, 2, null);
        }
        Integer color = this.getComputers().getAutoflight().getAutopilotAlert() ? Integer.valueOf(GuiGraphicsExtensionsKt.getWarningColor()) : (this.getComputers().getAutoflight().getAutoThrustAlert() ? Integer.valueOf(GuiGraphicsExtensionsKt.getCautionColor()) : null);
        List list = text.m_7360_();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSiblings(...)");
        this.automationStatusDisplay.render(guiGraphics, (Component)(!((Collection)list).isEmpty() || color != null ? text : null), ControlInput.Status.ACTIVE, FATickCounter.INSTANCE.getTotalTicks() % 20 >= 10 || color == null ? color : Integer.valueOf(0));
    }

    @Override
    public void renderFaulted(@NotNull GuiGraphics guiGraphics) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        GuiGraphics $this$renderFaulted_u24lambda_u240 = guiGraphics;
        boolean bl = false;
        int x = GuiGraphicsExtensionsKt.getCenterX($this$renderFaulted_u24lambda_u240);
        int y = HudFrame.INSTANCE.getTop() - 9;
        MutableComponent mutableComponent = Component.m_237115_((String)"short.flightassistant.automation_modes");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        GuiGraphicsExtensionsKt.drawMiddleAlignedString$default($this$renderFaulted_u24lambda_u240, (Component)mutableComponent, x, y, GuiGraphicsExtensionsKt.getWarningColor(), false, 16, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lru/octol1ttle/flightassistant/impl/display/AutomationModesDisplay$Companion;", "", "<init>", "()V", "ID", "Lnet/minecraft/resources/ResourceLocation;", "getID", "()Lnet/minecraft/resources/ResourceLocation;", "TOTAL_MODES", "", "flightassistant-forge"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceLocation getID() {
            return ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J3\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lru/octol1ttle/flightassistant/impl/display/AutomationModesDisplay$ModeDisplay;", "", "order", "", "<init>", "(I)V", "lastText", "Lnet/minecraft/network/chat/Component;", "textChangedAt", "render", "", "guiGraphics", "Lnet/minecraft/client/gui/GuiGraphics;", "text", "status", "Lru/octol1ttle/flightassistant/api/autoflight/ControlInput$Status;", "borderColor", "(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/network/chat/Component;Lru/octol1ttle/flightassistant/api/autoflight/ControlInput$Status;Ljava/lang/Integer;)V", "flightassistant-forge"})
    public static final class ModeDisplay {
        private final int order;
        @Nullable
        private Component lastText;
        private int textChangedAt;

        public ModeDisplay(int order) {
            this.order = order;
        }

        public final void render(@NotNull GuiGraphics guiGraphics, @Nullable Component text, @NotNull ControlInput.Status status, @Nullable Integer borderColor) {
            Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
            Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
            int farLeft = HudFrame.INSTANCE.getLeft() + 1;
            int farRight = HudFrame.INSTANCE.getRight() - 1;
            int farWidth = farRight - farLeft;
            int singleWidth = MathKt.roundToInt((float)(((float)farWidth - 3.0f) / 4.0f));
            int leftX = farLeft + (singleWidth + 1) * (this.order - 1);
            int rightX = this.order == 4 ? farRight + 1 : leftX + singleWidth;
            int y = HudFrame.INSTANCE.getTop() - 9;
            if (status == ControlInput.Status.ACTIVE && !Objects.equals(text, this.lastText)) {
                this.textChangedAt = FATickCounter.INSTANCE.getTotalTicks();
                this.lastText = text;
            }
            if (text != null) {
                int n;
                switch (WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
                    case 1: {
                        n = GuiGraphicsExtensionsKt.getPrimaryColor();
                        break;
                    }
                    case 2: {
                        n = GuiGraphicsExtensionsKt.getPrimaryAdvisoryColor();
                        break;
                    }
                    case 3: {
                        n = GuiGraphicsExtensionsKt.getCautionColor();
                        break;
                    }
                    case 4: {
                        return;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                int color = n;
                GuiGraphicsExtensionsKt.drawMiddleAlignedString$default(guiGraphics, text, (leftX + rightX) / 2, y, color, false, 16, null);
                if (borderColor != null || FATickCounter.INSTANCE.getTotalTicks() <= this.textChangedAt + 100) {
                    Integer n2 = borderColor;
                    guiGraphics.m_280637_(leftX, y - 2, rightX - leftX, 11, n2 != null ? n2 : GuiGraphicsExtensionsKt.getSecondaryColor());
                }
            }
        }

        public static /* synthetic */ void render$default(ModeDisplay modeDisplay, GuiGraphics guiGraphics, Component component, ControlInput.Status status, Integer n, int n2, Object object) {
            if ((n2 & 4) != 0) {
                status = ControlInput.Status.ACTIVE;
            }
            if ((n2 & 8) != 0) {
                n = null;
            }
            modeDisplay.render(guiGraphics, component, status, n);
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ControlInput.Status.values().length];
                try {
                    nArray[ControlInput.Status.ACTIVE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ControlInput.Status.ARMED.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ControlInput.Status.UNAVAILABLE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ControlInput.Status.DISABLED.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

