/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.impl.display;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.RangesKt;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import ru.octol1ttle.flightassistant.FlightAssistant;
import ru.octol1ttle.flightassistant.api.autoflight.ControlInput;
import ru.octol1ttle.flightassistant.api.computer.ComputerBus;
import ru.octol1ttle.flightassistant.api.display.Display;
import ru.octol1ttle.flightassistant.api.display.HudFrame;
import ru.octol1ttle.flightassistant.api.util.FATickCounter;
import ru.octol1ttle.flightassistant.api.util.FloatLerper;
import ru.octol1ttle.flightassistant.api.util.ScreenSpace;
import ru.octol1ttle.flightassistant.api.util.extensions.GuiGraphicsExtensionsKt;
import ru.octol1ttle.flightassistant.config.FAConfig;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lru/octol1ttle/flightassistant/impl/display/FlightDirectorsDisplay;", "Lru/octol1ttle/flightassistant/api/display/Display;", "computers", "Lru/octol1ttle/flightassistant/api/computer/ComputerBus;", "<init>", "(Lru/octol1ttle/flightassistant/api/computer/ComputerBus;)V", "pitchTargetLerper", "Lru/octol1ttle/flightassistant/api/util/FloatLerper;", "headingTargetLerper", "allowedByConfig", "", "render", "", "guiGraphics", "Lnet/minecraft/client/gui/GuiGraphics;", "renderFaulted", "Companion", "flightassistant-forge"})
public final class FlightDirectorsDisplay
extends Display {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FloatLerper pitchTargetLerper;
    @NotNull
    private final FloatLerper headingTargetLerper;
    @NotNull
    private static final ResourceLocation ID = FlightAssistant.INSTANCE.id$flightassistant_forge("flight_directors");

    public FlightDirectorsDisplay(@NotNull ComputerBus computers) {
        Intrinsics.checkNotNullParameter((Object)computers, (String)"computers");
        super(computers);
        this.pitchTargetLerper = new FloatLerper();
        this.headingTargetLerper = new FloatLerper();
    }

    @Override
    public boolean allowedByConfig() {
        return FAConfig.INSTANCE.getDisplay().getShowFlightDirectors();
    }

    @Override
    public void render(@NotNull GuiGraphics guiGraphics) {
        ControlInput headingInput;
        ControlInput pitchInput;
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        if (!this.getComputers().getAutoflight().getFlightDirectors() || this.getComputers().getHudData().isViewMirrored()) {
            return;
        }
        GuiGraphics $this$render_u24lambda_u242 = guiGraphics;
        boolean bl = false;
        int halfWidth = (int)(HudFrame.INSTANCE.getWidth() / 10.0f);
        PoseStack poseStack = $this$render_u24lambda_u242.m_280168_();
        Intrinsics.checkNotNullExpressionValue((Object)poseStack, (String)"pose(...)");
        GuiGraphicsExtensionsKt.push(poseStack);
        $this$render_u24lambda_u242.m_280168_().m_252880_(0.0f, 0.0f, -100.0f);
        $this$render_u24lambda_u242.m_280168_().m_272245_(Axis.f_252393_.m_252977_(this.getComputers().getHudData().getRoll()), GuiGraphicsExtensionsKt.getCenterXF($this$render_u24lambda_u242), GuiGraphicsExtensionsKt.getCenterYF($this$render_u24lambda_u242), 0.0f);
        $this$render_u24lambda_u242.m_280588_(HudFrame.INSTANCE.getLeft(), HudFrame.INSTANCE.getTop(), HudFrame.INSTANCE.getRight(), HudFrame.INSTANCE.getBottom());
        ControlInput controlInput = pitchInput = this.getComputers().getPitch().getActiveInput();
        Float pitchTarget = this.pitchTargetLerper.get(controlInput != null ? Float.valueOf(controlInput.getTarget()) : null, FATickCounter.INSTANCE.getTimePassed() * 1.5f);
        if (pitchTarget != null && pitchInput != null && pitchInput.getPriority().compareTo((Enum)ControlInput.Priority.NORMAL) >= 0) {
            Integer n = ScreenSpace.INSTANCE.getY(pitchTarget.floatValue());
            if (n != null) {
                int it = ((Number)n).intValue();
                boolean bl2 = false;
                $this$render_u24lambda_u242.m_280656_(GuiGraphicsExtensionsKt.getCenterX($this$render_u24lambda_u242) - halfWidth, GuiGraphicsExtensionsKt.getCenterX($this$render_u24lambda_u242) + halfWidth, RangesKt.coerceIn((int)it, (ClosedRange)((ClosedRange)RangesKt.until((int)(HudFrame.INSTANCE.getTop() + 1), (int)(HudFrame.INSTANCE.getBottom() - 1)))), GuiGraphicsExtensionsKt.getPrimaryAdvisoryColor());
            }
        }
        ControlInput controlInput2 = headingInput = this.getComputers().getHeading().getActiveInput();
        Float headingTarget = this.headingTargetLerper.get(controlInput2 != null ? Float.valueOf(controlInput2.getTarget()) : null, FATickCounter.INSTANCE.getTimePassed() * 1.5f);
        if (headingTarget != null && headingInput != null && headingInput.getPriority().compareTo((Enum)ControlInput.Priority.NORMAL) >= 0) {
            Integer n = ScreenSpace.INSTANCE.getX(headingTarget.floatValue());
            if (n != null) {
                int it = ((Number)n).intValue();
                boolean bl3 = false;
                $this$render_u24lambda_u242.m_280315_(RangesKt.coerceIn((int)it, (ClosedRange)((ClosedRange)RangesKt.until((int)(HudFrame.INSTANCE.getLeft() + 1), (int)(HudFrame.INSTANCE.getRight() - 1)))), GuiGraphicsExtensionsKt.getCenterY($this$render_u24lambda_u242) - halfWidth, GuiGraphicsExtensionsKt.getCenterY($this$render_u24lambda_u242) + halfWidth, GuiGraphicsExtensionsKt.getPrimaryAdvisoryColor());
            }
        }
        $this$render_u24lambda_u242.m_280618_();
        PoseStack poseStack2 = $this$render_u24lambda_u242.m_280168_();
        Intrinsics.checkNotNullExpressionValue((Object)poseStack2, (String)"pose(...)");
        GuiGraphicsExtensionsKt.pop(poseStack2);
    }

    @Override
    public void renderFaulted(@NotNull GuiGraphics guiGraphics) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        GuiGraphics $this$renderFaulted_u24lambda_u243 = guiGraphics;
        boolean bl = false;
        MutableComponent mutableComponent = Component.m_237115_((String)"short.flightassistant.flight_directors");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        GuiGraphicsExtensionsKt.drawMiddleAlignedString$default($this$renderFaulted_u24lambda_u243, (Component)mutableComponent, GuiGraphicsExtensionsKt.getCenterX($this$renderFaulted_u24lambda_u243), HudFrame.INSTANCE.getTop() + 30, GuiGraphicsExtensionsKt.getWarningColor(), false, 16, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lru/octol1ttle/flightassistant/impl/display/FlightDirectorsDisplay$Companion;", "", "<init>", "()V", "ID", "Lnet/minecraft/resources/ResourceLocation;", "getID", "()Lnet/minecraft/resources/ResourceLocation;", "flightassistant-forge"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceLocation getID() {
            return ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

