/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.impl.computer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_1144;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.octol1ttle.flightassistant.FlightAssistant;
import ru.octol1ttle.flightassistant.api.ModuleController;
import ru.octol1ttle.flightassistant.api.computer.Computer;
import ru.octol1ttle.flightassistant.api.computer.ComputerBus;
import ru.octol1ttle.flightassistant.api.computer.ComputerEvent;
import ru.octol1ttle.flightassistant.api.computer.ComputerQuery;
import ru.octol1ttle.flightassistant.api.computer.ComputerRegistrationCallback;
import ru.octol1ttle.flightassistant.api.util.FATickCounter;
import ru.octol1ttle.flightassistant.config.FAConfig;
import ru.octol1ttle.flightassistant.impl.computer.autoflight.AutoFlightComputer;
import ru.octol1ttle.flightassistant.impl.computer.autoflight.FireworkComputer;
import ru.octol1ttle.flightassistant.impl.computer.autoflight.FlightPlanComputer;
import ru.octol1ttle.flightassistant.impl.computer.autoflight.base.HeadingComputer;
import ru.octol1ttle.flightassistant.impl.computer.autoflight.base.PitchComputer;
import ru.octol1ttle.flightassistant.impl.computer.autoflight.base.RollComputer;
import ru.octol1ttle.flightassistant.impl.computer.autoflight.base.ThrustComputer;
import ru.octol1ttle.flightassistant.impl.computer.data.AirDataComputer;
import ru.octol1ttle.flightassistant.impl.computer.data.HudDisplayDataComputer;
import ru.octol1ttle.flightassistant.impl.computer.safety.AlertComputer;
import ru.octol1ttle.flightassistant.impl.computer.safety.ChunkStatusComputer;
import ru.octol1ttle.flightassistant.impl.computer.safety.ElytraStatusComputer;
import ru.octol1ttle.flightassistant.impl.computer.safety.FlightProtectionsComputer;
import ru.octol1ttle.flightassistant.impl.computer.safety.GroundProximityComputer;
import ru.octol1ttle.flightassistant.impl.computer.safety.StallComputer;
import ru.octol1ttle.flightassistant.impl.computer.safety.VoidProximityComputer;
import ru.octol1ttle.flightassistant.mixin.ClientLevelRunningNormallyInvoker;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\b\u0007\b\u00c0\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\u000b\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000e\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001f\u0010\u0011\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0013\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u000fJ\u0015\u0010\u0015\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001f\u0010\u0019\u001a\u00020\u00182\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u000f\u0010\u001b\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u0005J\u000f\u0010\u001d\u001a\u00020\u0018H\u0000\u00a2\u0006\u0004\b\u001c\u0010\u0005J\u000f\u0010\u001e\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u0005J\u0017\u0010#\u001a\u00020\u00182\u0006\u0010 \u001a\u00020\u001fH\u0000\u00a2\u0006\u0004\b!\u0010\"J9\u0010)\u001a\u0004\u0018\u00018\u0001\"\u0004\b\u0000\u0010$\"\u0004\b\u0001\u0010%2\u0006\u0010&\u001a\u00028\u00002\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010'H\u0017\u00a2\u0006\u0004\b)\u0010*J!\u0010.\u001a\u00020\u0018\"\b\b\u0000\u0010,*\u00020+2\u0006\u0010-\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b.\u0010/J)\u00104\u001a\b\u0012\u0004\u0012\u00028\u000003\"\u0004\b\u0000\u001002\f\u00102\u001a\b\u0012\u0004\u0012\u00028\u000001H\u0016\u00a2\u0006\u0004\b4\u00105J\u0017\u00106\u001a\u00020\u00182\u0006\u0010&\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b6\u00107R \u00109\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0002088\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b9\u0010:R\u001a\u0010;\u001a\u00020\r8\u0016X\u0096D\u00a2\u0006\f\n\u0004\b;\u0010<\u001a\u0004\b=\u0010>\u00a8\u0006?"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/ComputerHost;", "Lru/octol1ttle/flightassistant/api/ModuleController;", "Lru/octol1ttle/flightassistant/api/computer/Computer;", "Lru/octol1ttle/flightassistant/api/computer/ComputerBus;", "<init>", "()V", "", "Lnet/minecraft/class_2960;", "identifiers", "()Ljava/util/Set;", "identifier", "get", "(Lnet/minecraft/class_2960;)Lru/octol1ttle/flightassistant/api/computer/Computer;", "", "isEnabled", "(Lnet/minecraft/class_2960;)Z", "enabled", "setEnabled", "(Lnet/minecraft/class_2960;Z)Z", "isFaulted", "", "getFaultCount", "(Lnet/minecraft/class_2960;)I", "module", "", "register", "(Lnet/minecraft/class_2960;Lru/octol1ttle/flightassistant/api/computer/Computer;)V", "registerBuiltin", "sendRegistrationEvent$flightassistant_fabric", "sendRegistrationEvent", "logRegisterComplete", "", "partialTick", "tick$flightassistant_fabric", "(F)V", "tick", "C", "T", "computer", "Lkotlin/Function1;", "call", "guardedCall", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "Lru/octol1ttle/flightassistant/api/computer/ComputerEvent;", "Event", "event", "dispatchEvent", "(Lru/octol1ttle/flightassistant/api/computer/ComputerEvent;)V", "Response", "Lru/octol1ttle/flightassistant/api/computer/ComputerQuery;", "query", "", "dispatchQuery", "(Lru/octol1ttle/flightassistant/api/computer/ComputerQuery;)Ljava/util/Collection;", "onComputerFault", "(Lru/octol1ttle/flightassistant/api/computer/Computer;)V", "", "computers", "Ljava/util/Map;", "modulesResettable", "Z", "getModulesResettable", "()Z", "flightassistant-fabric"})
@SourceDebugExtension(value={"SMAP\nComputerHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComputerHost.kt\nru/octol1ttle/flightassistant/impl/computer/ComputerHost\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,180:1\n1869#2,2:181\n1869#2,2:183\n*S KotlinDebug\n*F\n+ 1 ComputerHost.kt\nru/octol1ttle/flightassistant/impl/computer/ComputerHost\n*L\n95#1:181,2\n96#1:183,2\n*E\n"})
public final class ComputerHost
implements ModuleController<Computer>,
ComputerBus {
    @NotNull
    public static final ComputerHost INSTANCE = new ComputerHost();
    @NotNull
    private static final Map<class_2960, Computer> computers = new LinkedHashMap();
    private static final boolean modulesResettable = true;

    private ComputerHost() {
    }

    @Override
    public boolean getModulesResettable() {
        return modulesResettable;
    }

    @NotNull
    public Set<class_2960> identifiers() {
        return computers.keySet();
    }

    @Override
    @NotNull
    public Computer get(@NotNull class_2960 identifier) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Computer computer = computers.get(identifier);
        if (computer == null) {
            throw new IllegalArgumentException("No computer registered with ID: " + identifier);
        }
        return computer;
    }

    @Override
    public boolean isEnabled(@NotNull class_2960 identifier) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        return this.get(identifier).getEnabled();
    }

    @Override
    public boolean setEnabled(@NotNull class_2960 identifier, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Computer computer = this.get(identifier);
        boolean oldEnabled = computer.getEnabled();
        computer.setEnabled$flightassistant_fabric(enabled);
        computer.reset();
        if (!computer.getEnabled()) {
            computer.setFaulted$flightassistant_fabric(false);
        }
        return oldEnabled;
    }

    @Override
    public boolean isFaulted(@NotNull class_2960 identifier) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        return this.get(identifier).getFaulted();
    }

    public final int getFaultCount(@NotNull class_2960 identifier) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        return this.get(identifier).getFaultCount();
    }

    private final void register(class_2960 identifier, Computer module) {
        if (FlightAssistant.INSTANCE.getInitComplete$flightassistant_fabric()) {
            throw new IllegalStateException("Initialization is already complete, but trying to register a computer with identifier: " + identifier);
        }
        if (computers.containsKey(identifier)) {
            throw new IllegalArgumentException("Already registered computer with identifier: " + identifier);
        }
        computers.put(identifier, module);
    }

    private final void registerBuiltin() {
        this.register(AirDataComputer.Companion.getID(), new AirDataComputer(this, FlightAssistant.INSTANCE.getMc$flightassistant_fabric()));
        this.register(HudDisplayDataComputer.Companion.getID(), new HudDisplayDataComputer(this, FlightAssistant.INSTANCE.getMc$flightassistant_fabric()));
        this.register(FlightProtectionsComputer.Companion.getID(), new FlightProtectionsComputer(this));
        this.register(StallComputer.Companion.getID(), new StallComputer(this));
        this.register(VoidProximityComputer.Companion.getID(), new VoidProximityComputer(this));
        this.register(GroundProximityComputer.Companion.getID(), new GroundProximityComputer(this));
        this.register(ElytraStatusComputer.Companion.getID(), new ElytraStatusComputer(this));
        this.register(ChunkStatusComputer.Companion.getID(), new ChunkStatusComputer(this));
        this.register(FlightPlanComputer.Companion.getID(), new FlightPlanComputer(this));
        this.register(AutoFlightComputer.Companion.getID(), new AutoFlightComputer(this));
        this.register(FireworkComputer.Companion.getID(), new FireworkComputer(this, FlightAssistant.INSTANCE.getMc$flightassistant_fabric()));
        this.register(PitchComputer.Companion.getID(), new PitchComputer(this));
        this.register(HeadingComputer.Companion.getID(), new HeadingComputer(this));
        this.register(RollComputer.Companion.getID(), new RollComputer(this));
        this.register(ThrustComputer.Companion.getID(), new ThrustComputer(this));
        class_2960 class_29602 = AlertComputer.Companion.getID();
        ComputerBus computerBus = this;
        class_1144 class_11442 = FlightAssistant.INSTANCE.getMc$flightassistant_fabric().method_1483();
        Intrinsics.checkNotNullExpressionValue((Object)class_11442, (String)"getSoundManager(...)");
        this.register(class_29602, new AlertComputer(computerBus, class_11442));
    }

    public final void sendRegistrationEvent$flightassistant_fabric() {
        Computer p0;
        this.registerBuiltin();
        ((ComputerRegistrationCallback)ComputerRegistrationCallback.EVENT.invoker()).register(this, this::register);
        Iterable $this$forEach$iv = computers.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            p0 = (Computer)element$iv;
            boolean bl = false;
            p0.subscribeToEvents();
        }
        $this$forEach$iv = computers.values();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            p0 = (Computer)element$iv;
            boolean bl = false;
            p0.invokeEvents();
        }
        this.logRegisterComplete();
    }

    private final void logRegisterComplete() {
        ArrayList<String> namespaces = new ArrayList<String>();
        for (class_2960 id : computers.keySet()) {
            if (namespaces.contains(id.method_12836())) continue;
            namespaces.add(id.method_12836());
        }
        FlightAssistant.INSTANCE.getLogger$flightassistant_fabric().info("Registered {} computers from mods: {}", (Object)computers.size(), (Object)CollectionsKt.joinToString$default((Iterable)namespaces, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
    }

    /*
     * Unable to fully structure code
     */
    public final void tick$flightassistant_fabric(float partialTick) {
        if (FlightAssistant.INSTANCE.getMc$flightassistant_fabric().method_1493()) ** GOTO lbl-1000
        v0 = FlightAssistant.INSTANCE.getMc$flightassistant_fabric();
        Intrinsics.checkNotNull((Object)v0, (String)"null cannot be cast to non-null type ru.octol1ttle.flightassistant.mixin.ClientLevelRunningNormallyInvoker");
        if (!((ClientLevelRunningNormallyInvoker)v0).invokeIsLevelRunningNormally()) lbl-1000:
        // 2 sources

        {
            v1 = true;
        } else {
            v1 = false;
        }
        paused = v1;
        v2 = FlightAssistant.INSTANCE.getMc$flightassistant_fabric().field_1724;
        Intrinsics.checkNotNull((Object)v2);
        FATickCounter.INSTANCE.tick(v2, partialTick, paused);
        if (paused || FATickCounter.INSTANCE.getTicksSinceWorldLoad() < FATickCounter.INSTANCE.getWorldLoadWaitTime() || !FAConfig.INSTANCE.getGlobal$flightassistant_fabric().getModEnabled$flightassistant_fabric()) {
            return;
        }
        FlightAssistant.INSTANCE.getProfiler$flightassistant_fabric().method_15396("flightassistant:computer_host");
        for (Map.Entry<class_2960, Computer> var4_4 : ComputerHost.computers.entrySet()) {
            id = var4_4.getKey();
            computer = var4_4.getValue();
            FlightAssistant.INSTANCE.getProfiler$flightassistant_fabric().method_15396(id.toString());
            if (!computer.isDisabledOrFaulted()) {
                try {
                    var7_7 = FATickCounter.INSTANCE.getTicksPassed();
                    var8_9 = 0;
                    while (var8_9 < var7_7) {
                        it = var8_9++;
                        $i$a$-repeat-ComputerHost$tick$1 = false;
                        computer.tick();
                    }
                    computer.renderTick();
                }
                catch (Throwable t) {
                    this.onComputerFault(computer);
                    FlightAssistant.INSTANCE.getLogger$flightassistant_fabric().error("Exception ticking computer with identifier: " + id, t);
                }
            }
            FlightAssistant.INSTANCE.getProfiler$flightassistant_fabric().method_15407();
        }
        FlightAssistant.INSTANCE.getProfiler$flightassistant_fabric().method_15407();
    }

    @Override
    @Deprecated(message="Will be private")
    @Nullable
    public <C, T> T guardedCall(C computer, @NotNull Function1<? super C, ? extends T> call) {
        Intrinsics.checkNotNullParameter(call, (String)"call");
        try {
            return (T)call.invoke(computer);
        }
        catch (Throwable t) {
            if (!(computer instanceof Computer)) {
                return null;
            }
            this.onComputerFault((Computer)computer);
            FlightAssistant.INSTANCE.getLogger$flightassistant_fabric().error("Exception invoking guarded call", t);
            return null;
        }
    }

    @Override
    public <Event extends ComputerEvent> void dispatchEvent(@NotNull Event event) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        for (Computer computer : computers.values()) {
            if (computer.isDisabledOrFaulted()) continue;
            this.guardedCall(computer, arg_0 -> ComputerHost.dispatchEvent$lambda$2(event, arg_0));
        }
    }

    @Override
    @NotNull
    public <Response> Collection<Response> dispatchQuery(@NotNull ComputerQuery<Response> query) {
        Intrinsics.checkNotNullParameter(query, (String)"query");
        for (Computer computer : computers.values()) {
            if (computer.isDisabledOrFaulted()) continue;
            this.guardedCall(computer, arg_0 -> ComputerHost.dispatchQuery$lambda$3(query, arg_0));
        }
        return query.getResponses$flightassistant_fabric();
    }

    private final void onComputerFault(Computer computer) {
        computer.setFaulted$flightassistant_fabric(true);
        int n = computer.getFaultCount();
        computer.setFaultCount$flightassistant_fabric(n + 1);
        computer.reset();
    }

    @Override
    public boolean toggleEnabled(@NotNull class_2960 identifier) {
        return ModuleController.super.toggleEnabled(identifier);
    }

    @Override
    @NotNull
    public AirDataComputer getData() {
        return ComputerBus.super.getData();
    }

    @Override
    @NotNull
    public HudDisplayDataComputer getHudData() {
        return ComputerBus.super.getHudData();
    }

    @Override
    @NotNull
    public AutoFlightComputer getAutoflight() {
        return ComputerBus.super.getAutoflight();
    }

    @Override
    @NotNull
    public FireworkComputer getFirework() {
        return ComputerBus.super.getFirework();
    }

    @Override
    @NotNull
    public FlightPlanComputer getPlan() {
        return ComputerBus.super.getPlan();
    }

    @Override
    @NotNull
    public HeadingComputer getHeading() {
        return ComputerBus.super.getHeading();
    }

    @Override
    @NotNull
    public PitchComputer getPitch() {
        return ComputerBus.super.getPitch();
    }

    @Override
    @NotNull
    public RollComputer getRoll() {
        return ComputerBus.super.getRoll();
    }

    @Override
    @NotNull
    public ThrustComputer getThrust() {
        return ComputerBus.super.getThrust();
    }

    @Override
    @NotNull
    public AlertComputer getAlert() {
        return ComputerBus.super.getAlert();
    }

    @Override
    @NotNull
    public ChunkStatusComputer getChunk() {
        return ComputerBus.super.getChunk();
    }

    @Override
    @NotNull
    public ElytraStatusComputer getElytra() {
        return ComputerBus.super.getElytra();
    }

    @Override
    @NotNull
    public FlightProtectionsComputer getProtections() {
        return ComputerBus.super.getProtections();
    }

    @Override
    @NotNull
    public GroundProximityComputer getGpws() {
        return ComputerBus.super.getGpws();
    }

    @Override
    @NotNull
    public StallComputer getStall() {
        return ComputerBus.super.getStall();
    }

    @Override
    @NotNull
    public VoidProximityComputer getVoidProximity() {
        return ComputerBus.super.getVoidProximity();
    }

    private static final Unit dispatchEvent$lambda$2(ComputerEvent $event, Computer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.handleEvent($event);
        return Unit.INSTANCE;
    }

    private static final Unit dispatchQuery$lambda$3(ComputerQuery $query, Computer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.handleQuery($query);
        return Unit.INSTANCE;
    }
}

