/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.impl.computer.autoflight;

import dev.architectury.event.CompoundEventResult;
import dev.architectury.event.events.common.InteractionEvent;
import java.util.Iterator;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1671;
import net.minecraft.class_1781;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_636;
import net.minecraft.class_746;
import net.minecraft.class_9284;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.octol1ttle.flightassistant.FlightAssistant;
import ru.octol1ttle.flightassistant.api.autoflight.thrust.ThrustSource;
import ru.octol1ttle.flightassistant.api.autoflight.thrust.ThrustSourceRegistrationCallback;
import ru.octol1ttle.flightassistant.api.computer.Computer;
import ru.octol1ttle.flightassistant.api.computer.ComputerBus;
import ru.octol1ttle.flightassistant.api.computer.ComputerQuery;
import ru.octol1ttle.flightassistant.api.util.FATickCounter;
import ru.octol1ttle.flightassistant.api.util.LimitedFIFOQueue;
import ru.octol1ttle.flightassistant.api.util.event.FireworkBoostCallback;
import ru.octol1ttle.flightassistant.config.FAConfig;
import ru.octol1ttle.flightassistant.impl.computer.data.AirDataComputer;
import ru.octol1ttle.flightassistant.impl.computer.safety.GroundProximityComputer;
import ru.octol1ttle.flightassistant.impl.display.StatusDisplay;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 F2\u00020\u00012\u00020\u0002:\u0001FB\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\f\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\f\u0010\u000bJ\u001d\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0017J\u000f\u0010\u0019\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001f\u0010\u001d\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u000f\u0010\u001f\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u001f\u0010\u001aJ\u0017\u0010\"\u001a\u00020\t2\u0006\u0010!\u001a\u00020 H\u0016\u00a2\u0006\u0004\b\"\u0010#J#\u0010'\u001a\u00020\t\"\u0004\b\u0000\u0010$2\f\u0010&\u001a\b\u0012\u0004\u0012\u00028\u00000%H\u0016\u00a2\u0006\u0004\b'\u0010(J\u000f\u0010)\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b)\u0010\u000bR\u0014\u0010\u0006\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010*R\u001a\u0010,\u001a\u00020+8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b,\u0010-\u001a\u0004\b.\u0010/R\u001a\u00100\u001a\u00020\u00118\u0016X\u0096D\u00a2\u0006\f\n\u0004\b0\u00101\u001a\u0004\b2\u0010\u001aR\u0016\u00104\u001a\u0002038\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b4\u00105R\u0018\u00106\u001a\u0004\u0018\u0001038\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b6\u00107R\"\u00108\u001a\u00020\u00118\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b8\u00101\u001a\u0004\b9\u0010\u001a\"\u0004\b:\u0010;R\"\u0010<\u001a\u0002038\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b<\u00105\u001a\u0004\b=\u0010>\"\u0004\b?\u0010@R\u001d\u0010B\u001a\b\u0012\u0004\u0012\u0002030A8\u0006\u00a2\u0006\f\n\u0004\bB\u0010C\u001a\u0004\bD\u0010E\u00a8\u0006G"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/autoflight/FireworkComputer;", "Lru/octol1ttle/flightassistant/api/computer/Computer;", "Lru/octol1ttle/flightassistant/api/autoflight/thrust/ThrustSource;", "Lru/octol1ttle/flightassistant/api/computer/ComputerBus;", "computers", "Lnet/minecraft/class_310;", "mc", "<init>", "(Lru/octol1ttle/flightassistant/api/computer/ComputerBus;Lnet/minecraft/class_310;)V", "", "subscribeToEvents", "()V", "tick", "Lnet/minecraft/class_1657;", "player", "Lnet/minecraft/class_1268;", "hand", "", "isEmptyOrSafe", "(Lnet/minecraft/class_1657;Lnet/minecraft/class_1268;)Z", "Lnet/minecraft/class_1799;", "stack", "isFireworkAndSafe", "(Lnet/minecraft/class_1799;)Z", "hasNoExplosions", "anyTerrainAhead", "()Z", "tryActivateFirework", "(Lnet/minecraft/class_1657;)V", "useFirework", "(Lnet/minecraft/class_1657;Lnet/minecraft/class_1268;)V", "isAvailable", "", "currentThrust", "tickThrust", "(F)V", "Response", "Lru/octol1ttle/flightassistant/api/computer/ComputerQuery;", "query", "handleQuery", "(Lru/octol1ttle/flightassistant/api/computer/ComputerQuery;)V", "reset", "Lnet/minecraft/class_310;", "Lru/octol1ttle/flightassistant/api/autoflight/thrust/ThrustSource$Priority;", "priority", "Lru/octol1ttle/flightassistant/api/autoflight/thrust/ThrustSource$Priority;", "getPriority", "()Lru/octol1ttle/flightassistant/api/autoflight/thrust/ThrustSource$Priority;", "supportsReverse", "Z", "getSupportsReverse", "", "safeFireworkCount", "I", "safeFireworkSlot", "Ljava/lang/Integer;", "waitingForResponse", "getWaitingForResponse", "setWaitingForResponse", "(Z)V", "lastActivationTime", "getLastActivationTime", "()I", "setLastActivationTime", "(I)V", "Lru/octol1ttle/flightassistant/api/util/LimitedFIFOQueue;", "responseTimes", "Lru/octol1ttle/flightassistant/api/util/LimitedFIFOQueue;", "getResponseTimes", "()Lru/octol1ttle/flightassistant/api/util/LimitedFIFOQueue;", "Companion", "flightassistant-fabric"})
public final class FireworkComputer
extends Computer
implements ThrustSource {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final class_310 mc;
    @NotNull
    private final ThrustSource.Priority priority;
    private final boolean supportsReverse;
    private int safeFireworkCount;
    @Nullable
    private Integer safeFireworkSlot;
    private boolean waitingForResponse;
    private int lastActivationTime;
    @NotNull
    private final LimitedFIFOQueue<Integer> responseTimes;
    @NotNull
    private static final class_2960 ID = FlightAssistant.INSTANCE.id$flightassistant_fabric("firework");
    private static final float FIREWORK_SPEED = 33.33f;

    public FireworkComputer(@NotNull ComputerBus computers, @NotNull class_310 mc) {
        Intrinsics.checkNotNullParameter((Object)computers, (String)"computers");
        Intrinsics.checkNotNullParameter((Object)mc, (String)"mc");
        super(computers);
        this.mc = mc;
        this.priority = ThrustSource.Priority.LOW;
        this.responseTimes = new LimitedFIFOQueue(5);
    }

    @Override
    @NotNull
    public ThrustSource.Priority getPriority() {
        return this.priority;
    }

    @Override
    public boolean getSupportsReverse() {
        return this.supportsReverse;
    }

    public final boolean getWaitingForResponse() {
        return this.waitingForResponse;
    }

    public final void setWaitingForResponse(boolean bl) {
        this.waitingForResponse = bl;
    }

    public final int getLastActivationTime() {
        return this.lastActivationTime;
    }

    public final void setLastActivationTime(int n) {
        this.lastActivationTime = n;
    }

    @NotNull
    public final LimitedFIFOQueue<Integer> getResponseTimes() {
        return this.responseTimes;
    }

    @Override
    public void subscribeToEvents() {
        ThrustSourceRegistrationCallback.EVENT.register(arg_0 -> FireworkComputer.subscribeToEvents$lambda$0(this, arg_0));
        InteractionEvent.RIGHT_CLICK_ITEM.register((arg_0, arg_1) -> FireworkComputer.subscribeToEvents$lambda$1(this, arg_0, arg_1));
        FireworkBoostCallback.EVENT.register((arg_0, arg_1) -> FireworkComputer.subscribeToEvents$lambda$2(this, arg_0, arg_1));
    }

    @Override
    public void tick() {
        if (!this.getComputers().getData().getFlying()) {
            this.waitingForResponse = false;
        }
        this.safeFireworkSlot = null;
        int lastSlotCount = 0;
        int n = class_1661.method_7368();
        for (int slot = 0; slot < n; ++slot) {
            class_1799 stack;
            Intrinsics.checkNotNullExpressionValue((Object)this.getComputers().getData().getPlayer().method_31548().method_5438(slot), (String)"getItem(...)");
            if (!this.isFireworkAndSafe(stack) || this.safeFireworkSlot != null && stack.method_7947() >= lastSlotCount) continue;
            this.safeFireworkSlot = slot;
            lastSlotCount = stack.method_7947();
        }
        this.safeFireworkCount = 0;
        Iterator iterator = this.getComputers().getData().getPlayer().method_31548().field_7547.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Object e = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            class_1799 stack = (class_1799)e;
            if (!this.isFireworkAndSafe(stack)) continue;
            this.safeFireworkCount += stack.method_7947();
        }
        class_1799 class_17992 = this.getComputers().getData().getPlayer().method_6079();
        Intrinsics.checkNotNullExpressionValue((Object)class_17992, (String)"getOffhandItem(...)");
        if (this.isFireworkAndSafe(class_17992)) {
            this.safeFireworkCount += this.getComputers().getData().getPlayer().method_6079().method_7947();
        }
    }

    public final boolean isEmptyOrSafe(@NotNull class_1657 player, @NotNull class_1268 hand) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        class_1799 class_17992 = player.method_5998(hand);
        Intrinsics.checkNotNullExpressionValue((Object)class_17992, (String)"getItemInHand(...)");
        return this.hasNoExplosions(class_17992);
    }

    private final boolean isFireworkAndSafe(class_1799 stack) {
        return stack.method_7909() instanceof class_1781 && this.hasNoExplosions(stack);
    }

    private final boolean hasNoExplosions(class_1799 stack) {
        Object object = (class_9284)stack.method_57824(class_9334.field_49616);
        return !(object != null && (object = object.comp_2392()) != null ? !object.isEmpty() : false);
    }

    private final boolean anyTerrainAhead() {
        class_243 velocity = this.getComputers().getData().getPlayer().method_5663().method_1021((double)33.33f);
        GroundProximityComputer groundProximityComputer = this.getComputers().getGpws();
        Intrinsics.checkNotNull((Object)velocity);
        return groundProximityComputer.computeObstacleImpactTime(velocity, this.getComputers().getGpws().getCautionThreshold()) <= this.getComputers().getGpws().getWarningThreshold();
    }

    private final void tryActivateFirework(class_1657 player) {
        if (FATickCounter.INSTANCE.getTotalTicks() < this.lastActivationTime + 10) {
            return;
        }
        class_1799 class_17992 = player.method_6079();
        Intrinsics.checkNotNullExpressionValue((Object)class_17992, (String)"getOffhandItem(...)");
        if (this.isFireworkAndSafe(class_17992)) {
            this.useFirework(player, class_1268.field_5810);
        } else if (this.safeFireworkSlot != null) {
            class_1661 class_16612 = player.method_31548();
            Integer n = this.safeFireworkSlot;
            Intrinsics.checkNotNull((Object)n);
            class_16612.field_7545 = n;
            this.useFirework(player, class_1268.field_5808);
        }
    }

    private final void useFirework(class_1657 player, class_1268 hand) {
        class_636 class_6362 = this.mc.field_1761;
        Intrinsics.checkNotNull((Object)class_6362);
        class_6362.method_2919(player, hand);
        this.lastActivationTime = FATickCounter.INSTANCE.getTotalTicks();
        this.waitingForResponse = true;
    }

    @Override
    public boolean isAvailable() {
        return this.safeFireworkSlot != null;
    }

    @Override
    public void tickThrust(float currentThrust) {
        if ((double)currentThrust > this.getComputers().getData().getForwardVelocityPerSecond().method_1033() / (double)33.33f && !this.anyTerrainAhead()) {
            this.tryActivateFirework((class_1657)this.getComputers().getData().getPlayer());
        }
    }

    @Override
    public <Response> void handleQuery(@NotNull ComputerQuery<Response> query) {
        Intrinsics.checkNotNullParameter(query, (String)"query");
        if (query instanceof StatusDisplay.StatusMessageQuery && Intrinsics.areEqual((Object)this.getComputers().getThrust().getThrustSource(), (Object)this)) {
            StatusDisplay.StatusMessageQuery statusMessageQuery = (StatusDisplay.StatusMessageQuery)query;
            Object[] objectArray = new Object[]{this.safeFireworkCount};
            class_5250 class_52502 = class_2561.method_43469((String)"status.flightassistant.firework_count", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"translatable(...)");
            statusMessageQuery.respond(class_52502);
        }
    }

    @Override
    public void reset() {
        this.safeFireworkCount = 0;
        this.safeFireworkSlot = null;
        this.waitingForResponse = false;
        this.lastActivationTime = 0;
        this.responseTimes.clear();
    }

    private static final void subscribeToEvents$lambda$0(FireworkComputer this$0, Consumer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.accept(this$0);
    }

    /*
     * Unable to fully structure code
     */
    private static final CompoundEventResult subscribeToEvents$lambda$1(FireworkComputer this$0, class_1657 player, class_1268 hand) {
        block4: {
            v0 = player.method_5998(hand);
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getItemInHand(...)");
            stack = v0;
            if (!player.method_37908().method_8608() || !this$0.getComputers().getData().getFlying() || !(stack.method_7909() instanceof class_1781)) break block4;
            if (!FAConfig.INSTANCE.getSafety().getFireworkLockExplosive()) ** GOTO lbl-1000
            Intrinsics.checkNotNull((Object)player);
            Intrinsics.checkNotNull((Object)hand);
            if (!this$0.isEmptyOrSafe(player, hand)) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
            explosive = v1;
            v2 = anyTerrainAhead = FAConfig.INSTANCE.getSafety().getFireworkLockObstacles() != false && this$0.anyTerrainAhead() != false;
            if (AirDataComputer.automationsAllowed$default(this$0.getComputers().getData(), false, 1, null) && (explosive || anyTerrainAhead)) {
                return CompoundEventResult.interruptFalse((Object)stack);
            }
            if (!this$0.waitingForResponse) {
                this$0.lastActivationTime = FATickCounter.INSTANCE.getTotalTicks();
                this$0.waitingForResponse = true;
            }
        }
        return CompoundEventResult.pass();
    }

    private static final void subscribeToEvents$lambda$2(FireworkComputer this$0, class_1671 class_16712, class_746 class_7462) {
        Intrinsics.checkNotNullParameter((Object)class_7462, (String)"<unused var>");
        if (this$0.waitingForResponse) {
            this$0.waitingForResponse = false;
            this$0.responseTimes.add(FATickCounter.INSTANCE.getTotalTicks() - this$0.lastActivationTime);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\n\u001a\u00020\t8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/autoflight/FireworkComputer$Companion;", "", "<init>", "()V", "Lnet/minecraft/class_2960;", "ID", "Lnet/minecraft/class_2960;", "getID", "()Lnet/minecraft/class_2960;", "", "FIREWORK_SPEED", "F", "flightassistant-fabric"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final class_2960 getID() {
            return ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

