/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.impl.display;

import kotlin.Metadata;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_7833;
import org.jetbrains.annotations.NotNull;
import ru.octol1ttle.flightassistant.FlightAssistant;
import ru.octol1ttle.flightassistant.api.autoflight.ControlInput;
import ru.octol1ttle.flightassistant.api.computer.ComputerBus;
import ru.octol1ttle.flightassistant.api.display.Display;
import ru.octol1ttle.flightassistant.api.display.HudFrame;
import ru.octol1ttle.flightassistant.api.util.FATickCounter;
import ru.octol1ttle.flightassistant.api.util.FloatLerper;
import ru.octol1ttle.flightassistant.api.util.ScreenSpace;
import ru.octol1ttle.flightassistant.api.util.extensions.GuiGraphicsExtensionsKt;
import ru.octol1ttle.flightassistant.api.util.extensions.StringExtensionsKt;
import ru.octol1ttle.flightassistant.config.FAConfig;
import ru.octol1ttle.flightassistant.config.options.DisplayOptions;
import ru.octol1ttle.flightassistant.impl.computer.autoflight.AutoFlightComputer;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u0013\u0010\u000e\u001a\u00020\u000b*\u00020\tH\u0002\u00a2\u0006\u0004\b\u000e\u0010\rJ\u0013\u0010\u000f\u001a\u00020\u000b*\u00020\tH\u0002\u00a2\u0006\u0004\b\u000f\u0010\rJ\u0013\u0010\u0010\u001a\u00020\u000b*\u00020\tH\u0002\u00a2\u0006\u0004\b\u0010\u0010\rJ\u001b\u0010\u0013\u001a\u00020\u000b*\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J#\u0010\u0017\u001a\u00020\u000b*\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ#\u0010\u001c\u001a\u00020\u000b*\u00020\t2\u0006\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u0018J\u0017\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u001d\u0010\rR\u0014\u0010\u001f\u001a\u00020\u001e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\u001e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010 \u00a8\u0006#"}, d2={"Lru/octol1ttle/flightassistant/impl/display/AttitudeDisplay;", "Lru/octol1ttle/flightassistant/api/display/Display;", "Lru/octol1ttle/flightassistant/api/computer/ComputerBus;", "computers", "<init>", "(Lru/octol1ttle/flightassistant/api/computer/ComputerBus;)V", "", "allowedByConfig", "()Z", "Lnet/minecraft/class_332;", "guiGraphics", "", "render", "(Lnet/minecraft/class_332;)V", "renderHorizon", "renderPitchBars", "renderPitchLimits", "", "pitch", "drawPitchReferenceMark", "(Lnet/minecraft/class_332;F)V", "", "y", "drawPitchBar", "(Lnet/minecraft/class_332;II)V", "getPitchBarColor", "(F)I", "x", "renderPitchTarget", "renderFaulted", "Lru/octol1ttle/flightassistant/api/util/FloatLerper;", "minimumLerper", "Lru/octol1ttle/flightassistant/api/util/FloatLerper;", "maximumLerper", "Companion", "flightassistant-fabric"})
public final class AttitudeDisplay
extends Display {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FloatLerper minimumLerper;
    @NotNull
    private final FloatLerper maximumLerper;
    @NotNull
    private static final class_2960 ID = FlightAssistant.INSTANCE.id$flightassistant_fabric("attitude");

    public AttitudeDisplay(@NotNull ComputerBus computers) {
        Intrinsics.checkNotNullParameter((Object)computers, (String)"computers");
        super(computers);
        this.minimumLerper = new FloatLerper();
        this.maximumLerper = new FloatLerper();
    }

    @Override
    public boolean allowedByConfig() {
        return FAConfig.INSTANCE.getDisplay().getShowAttitude() != DisplayOptions.AttitudeDisplayMode.DISABLED;
    }

    @Override
    public void render(@NotNull class_332 guiGraphics) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        if (this.getComputers().getHudData().isViewMirrored()) {
            return;
        }
        class_332 $this$render_u24lambda_u240 = guiGraphics;
        boolean bl = false;
        class_4587 class_45872 = $this$render_u24lambda_u240.method_51448();
        Intrinsics.checkNotNullExpressionValue((Object)class_45872, (String)"pose(...)");
        GuiGraphicsExtensionsKt.push(class_45872);
        $this$render_u24lambda_u240.method_51448().method_46416(0.0f, 0.0f, -200.0f);
        $this$render_u24lambda_u240.method_51448().method_49278(class_7833.field_40717.rotationDegrees(this.getComputers().getHudData().getRoll()), GuiGraphicsExtensionsKt.getCenterXF($this$render_u24lambda_u240), GuiGraphicsExtensionsKt.getCenterYF($this$render_u24lambda_u240), 0.0f);
        if (!FAConfig.INSTANCE.getDisplay().getDrawPitchOutsideFrame()) {
            HudFrame.INSTANCE.scissor($this$render_u24lambda_u240);
        }
        if (FAConfig.INSTANCE.getDisplay().getShowAttitude().compareTo((Enum)DisplayOptions.AttitudeDisplayMode.HORIZON_ONLY) <= 0) {
            this.renderHorizon($this$render_u24lambda_u240);
        }
        if (FAConfig.INSTANCE.getDisplay().getShowAttitude() == DisplayOptions.AttitudeDisplayMode.HORIZON_AND_LADDER) {
            this.renderPitchBars($this$render_u24lambda_u240);
            this.renderPitchLimits($this$render_u24lambda_u240);
            this.drawPitchReferenceMark($this$render_u24lambda_u240, 47.5f);
            this.drawPitchReferenceMark($this$render_u24lambda_u240, -2.2f);
            this.drawPitchReferenceMark($this$render_u24lambda_u240, -38.5f);
        }
        if (!FAConfig.INSTANCE.getDisplay().getDrawPitchOutsideFrame()) {
            $this$render_u24lambda_u240.method_44380();
        }
        class_4587 class_45873 = $this$render_u24lambda_u240.method_51448();
        Intrinsics.checkNotNullExpressionValue((Object)class_45873, (String)"pose(...)");
        GuiGraphicsExtensionsKt.pop(class_45873);
        if (FAConfig.INSTANCE.getDisplay().getShowAutomationModes()) {
            this.renderPitchTarget($this$render_u24lambda_u240, GuiGraphicsExtensionsKt.getCenterX($this$render_u24lambda_u240) - 6, GuiGraphicsExtensionsKt.getCenterY($this$render_u24lambda_u240) - 10);
        }
    }

    private final void renderHorizon(class_332 $this$renderHorizon) {
        block0: {
            Integer n = ScreenSpace.INSTANCE.getY(0.0f);
            if (n == null) break block0;
            int it = ((Number)n).intValue();
            boolean bl = false;
            int color = this.getPitchBarColor(0.0f);
            int leftXEnd = (int)(GuiGraphicsExtensionsKt.getCenterXF($this$renderHorizon) - GuiGraphicsExtensionsKt.getHalfWidth($this$renderHorizon) * 0.025f);
            int leftXStart = (int)((float)leftXEnd - GuiGraphicsExtensionsKt.getHalfWidth($this$renderHorizon) * 0.3f);
            GuiGraphicsExtensionsKt.drawRightAlignedString$default($this$renderHorizon, "0", leftXStart - 3, it - 3, color, false, 16, null);
            $this$renderHorizon.method_25292(leftXStart, leftXEnd, it, color);
            int rightXStart = (int)(GuiGraphicsExtensionsKt.getCenterXF($this$renderHorizon) + GuiGraphicsExtensionsKt.getHalfWidth($this$renderHorizon) * 0.025f);
            int rightXEnd = (int)((float)rightXStart + GuiGraphicsExtensionsKt.getHalfWidth($this$renderHorizon) * 0.3f);
            $this$renderHorizon.method_25292(rightXStart, rightXEnd, it, color);
            GuiGraphicsExtensionsKt.drawString$default($this$renderHorizon, "0", rightXEnd + 5, it - 3, color, false, 16, null);
        }
    }

    private final void renderPitchBars(class_332 $this$renderPitchBars) {
        int step = FAConfig.INSTANCE.getDisplay().getAttitudeDegreeStep();
        int nextUp = class_3532.method_28139((int)((int)this.getComputers().getData().getPitch()), (int)step);
        if (step <= 0) {
            throw new IllegalArgumentException("Step must be positive, was: " + step + ".");
        }
        int i = nextUp;
        int n = ProgressionUtilKt.getProgressionLastElement((int)nextUp, (int)90, (int)step);
        if (i <= n) {
            while (true) {
                Integer n2 = ScreenSpace.INSTANCE.getY(i);
                if (n2 == null) {
                    break;
                }
                this.drawPitchBar($this$renderPitchBars, i, n2);
                if (i == n) break;
                i += step;
            }
        }
        int nextDown = class_3532.method_38961((double)this.getComputers().getData().getPitch(), (int)step);
        if (step <= 0) {
            throw new IllegalArgumentException("Step must be positive, was: " + step + ".");
        }
        n = -step;
        int i2 = nextDown;
        int n3 = ProgressionUtilKt.getProgressionLastElement((int)nextDown, (int)-90, (int)n);
        if (n3 <= i2) {
            while (true) {
                Integer n4 = ScreenSpace.INSTANCE.getY(i2);
                if (n4 == null) {
                    break;
                }
                this.drawPitchBar($this$renderPitchBars, i2, n4);
                if (i2 == n3) break;
                i2 += n;
            }
        }
    }

    private final void renderPitchLimits(class_332 $this$renderPitchLimits) {
        int y;
        float max;
        int step = FAConfig.INSTANCE.getDisplay().getAttitudeDegreeStep() / 2;
        class_5250 class_52502 = class_2561.method_43470((String)"V");
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"literal(...)");
        class_2561 arrowText = (class_2561)class_52502;
        ControlInput maxInput = this.getComputers().getPitch().getMaximumPitch();
        ControlInput minInput = this.getComputers().getPitch().getMinimumPitch();
        ControlInput controlInput = maxInput;
        Float f = this.maximumLerper.get(controlInput != null ? Float.valueOf(controlInput.getTarget()) : null, FATickCounter.INSTANCE.getTimePassed() * 2.0f);
        ControlInput controlInput2 = minInput;
        Float f2 = this.minimumLerper.get(controlInput2 != null ? Float.valueOf(controlInput2.getTarget()) : null, FATickCounter.INSTANCE.getTimePassed() * 2.0f);
        float min = RangesKt.coerceAtMost((float)(f2 != null ? f2.floatValue() : -90.0f), (float)max);
        for (max = (v28650) != null ? (v28650).floatValue() : 90.0f; max <= 180.0f; max += (float)step) {
            Integer n = ScreenSpace.INSTANCE.getY(max);
            if (n == null) {
                break;
            }
            y = n;
            ControlInput controlInput3 = maxInput;
            GuiGraphicsExtensionsKt.drawMiddleAlignedString$default($this$renderPitchLimits, arrowText, GuiGraphicsExtensionsKt.getCenterX($this$renderPitchLimits), y - 9, (controlInput3 != null ? controlInput3.getStatus() : null) == ControlInput.Status.ACTIVE ? GuiGraphicsExtensionsKt.getWarningColor() : GuiGraphicsExtensionsKt.getCautionColor(), false, 16, null);
        }
        while (min >= -180.0f) {
            Integer n = ScreenSpace.INSTANCE.getY(min);
            if (n == null) {
                break;
            }
            y = n;
            class_4587 class_45872 = $this$renderPitchLimits.method_51448();
            Intrinsics.checkNotNullExpressionValue((Object)class_45872, (String)"pose(...)");
            GuiGraphicsExtensionsKt.push(class_45872);
            $this$renderPitchLimits.method_51448().method_46416(GuiGraphicsExtensionsKt.getCenterXF($this$renderPitchLimits), (float)y, 0.0f);
            $this$renderPitchLimits.method_51448().method_22907(class_7833.field_40717.rotationDegrees(180.0f));
            ControlInput controlInput4 = minInput;
            GuiGraphicsExtensionsKt.drawMiddleAlignedString$default($this$renderPitchLimits, arrowText, 0, -9, (controlInput4 != null ? controlInput4.getStatus() : null) == ControlInput.Status.ACTIVE ? GuiGraphicsExtensionsKt.getWarningColor() : GuiGraphicsExtensionsKt.getCautionColor(), false, 16, null);
            class_4587 class_45873 = $this$renderPitchLimits.method_51448();
            Intrinsics.checkNotNullExpressionValue((Object)class_45873, (String)"pose(...)");
            GuiGraphicsExtensionsKt.pop(class_45873);
            min -= (float)step;
        }
    }

    private final void drawPitchReferenceMark(class_332 $this$drawPitchReferenceMark, float pitch) {
        Integer n = ScreenSpace.INSTANCE.getY(pitch);
        if (n == null) {
            return;
        }
        int y = n;
        int color = this.getPitchBarColor(pitch);
        int leftXEnd = (int)(GuiGraphicsExtensionsKt.getCenterXF($this$drawPitchReferenceMark) - GuiGraphicsExtensionsKt.getHalfWidth($this$drawPitchReferenceMark) * 0.025f);
        int leftXStart = (int)((float)leftXEnd - GuiGraphicsExtensionsKt.getHalfWidth($this$drawPitchReferenceMark) * 0.05f);
        GuiGraphicsExtensionsKt.hLineDashed($this$drawPitchReferenceMark, leftXStart, leftXEnd, y, 2, color);
        int rightXStart = (int)(GuiGraphicsExtensionsKt.getCenterXF($this$drawPitchReferenceMark) + GuiGraphicsExtensionsKt.getHalfWidth($this$drawPitchReferenceMark) * 0.025f);
        int rightXEnd = (int)((float)rightXStart + GuiGraphicsExtensionsKt.getHalfWidth($this$drawPitchReferenceMark) * 0.05f);
        GuiGraphicsExtensionsKt.hLineDashed($this$drawPitchReferenceMark, rightXStart, rightXEnd, y, 2, color);
    }

    private final void drawPitchBar(class_332 $this$drawPitchBar, int pitch, int y) {
        if (pitch == 0) {
            return;
        }
        int color = this.getPitchBarColor(pitch);
        int leftXEnd = (int)(GuiGraphicsExtensionsKt.getCenterXF($this$drawPitchBar) - GuiGraphicsExtensionsKt.getHalfWidth($this$drawPitchBar) * 0.05f);
        int leftXStart = (int)((float)leftXEnd - GuiGraphicsExtensionsKt.getHalfWidth($this$drawPitchBar) * 0.075f);
        GuiGraphicsExtensionsKt.drawRightAlignedString$default($this$drawPitchBar, String.valueOf(pitch), leftXStart - 2, pitch > 0 ? y : y - 4, color, false, 16, null);
        $this$drawPitchBar.method_25301(leftXStart, y, y + 5 * MathKt.getSign((int)pitch), color);
        GuiGraphicsExtensionsKt.hLineDashed($this$drawPitchBar, leftXStart, leftXEnd, y, pitch < 0 ? 3 : 1, color);
        int rightXStart = (int)(GuiGraphicsExtensionsKt.getCenterXF($this$drawPitchBar) + GuiGraphicsExtensionsKt.getHalfWidth($this$drawPitchBar) * 0.05f);
        int rightXEnd = (int)((float)rightXStart + GuiGraphicsExtensionsKt.getHalfWidth($this$drawPitchBar) * 0.075f);
        GuiGraphicsExtensionsKt.hLineDashed($this$drawPitchBar, rightXStart, rightXEnd, y, pitch < 0 ? 3 : 1, color);
        $this$drawPitchBar.method_25301(rightXEnd, y, y + 5 * MathKt.getSign((int)pitch), color);
        GuiGraphicsExtensionsKt.drawString$default($this$drawPitchBar, String.valueOf(pitch), rightXEnd + 4, pitch > 0 ? y : y - 4, color, false, 16, null);
    }

    private final int getPitchBarColor(float pitch) {
        ControlInput min = this.getComputers().getPitch().getMinimumPitch();
        ControlInput max = this.getComputers().getPitch().getMaximumPitch();
        return max != null && pitch > max.getTarget() ? (max.getStatus() == ControlInput.Status.ACTIVE ? GuiGraphicsExtensionsKt.getWarningColor() : GuiGraphicsExtensionsKt.getCautionColor()) : (min != null && pitch < min.getTarget() ? (min.getStatus() == ControlInput.Status.ACTIVE ? GuiGraphicsExtensionsKt.getWarningColor() : GuiGraphicsExtensionsKt.getCautionColor()) : GuiGraphicsExtensionsKt.getPrimaryColor());
    }

    private final void renderPitchTarget(class_332 $this$renderPitchTarget, int x, int y) {
        AutoFlightComputer.VerticalMode active = this.getComputers().getAutoflight().getActiveVerticalMode();
        if (this.getComputers().getAutoflight().getPitchInput() != null && active instanceof AutoFlightComputer.FollowsPitchMode) {
            Object[] objectArray = new Object[]{Float.valueOf(((AutoFlightComputer.FollowsPitchMode)((Object)active)).getTargetPitch())};
            GuiGraphicsExtensionsKt.drawRightAlignedString$default($this$renderPitchTarget, StringExtensionsKt.formatRoot("%.1f", objectArray), x, y, GuiGraphicsExtensionsKt.getPrimaryAdvisoryColor(), false, 16, null);
        }
    }

    @Override
    public void renderFaulted(@NotNull class_332 guiGraphics) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        class_332 $this$renderFaulted_u24lambda_u242 = guiGraphics;
        boolean bl = false;
        class_5250 class_52502 = class_2561.method_43471((String)"short.flightassistant.attitude");
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"translatable(...)");
        GuiGraphicsExtensionsKt.drawMiddleAlignedString$default($this$renderFaulted_u24lambda_u242, (class_2561)class_52502, GuiGraphicsExtensionsKt.getCenterX($this$renderFaulted_u24lambda_u242), GuiGraphicsExtensionsKt.getCenterY($this$renderFaulted_u24lambda_u242) - 16, GuiGraphicsExtensionsKt.getWarningColor(), false, 16, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lru/octol1ttle/flightassistant/impl/display/AttitudeDisplay$Companion;", "", "<init>", "()V", "Lnet/minecraft/class_2960;", "ID", "Lnet/minecraft/class_2960;", "getID", "()Lnet/minecraft/class_2960;", "flightassistant-fabric"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final class_2960 getID() {
            return ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

