/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.api.util;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.ClosedRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000&\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\u0015\u0010\u0002\u001a\u00020\u00002\u0006\u0010\u0001\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003\u001a\u0015\u0010\u0002\u001a\u00020\u00042\u0006\u0010\u0001\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0005\u001a\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0001\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0007\u0010\b\u001a\u0011\u0010\t\u001a\u00020\u0000*\u00020\u0000\u00a2\u0006\u0004\b\t\u0010\u0003\u001a\u001f\u0010\f\u001a\u00020\u0000*\u00020\u00002\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00000\n\u00a2\u0006\u0004\b\f\u0010\r\u001a\u0011\u0010\t\u001a\u00020\u0004*\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\u0005\u001a\u001f\u0010\f\u001a\u00020\u0004*\u00020\u00042\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e\u00a2\u0006\u0004\b\f\u0010\u000f\u001a%\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"", "value", "degrees", "(F)F", "", "(D)D", "", "furtherFromZero", "(F)I", "requireFinite", "Lkotlin/ranges/ClosedFloatingPointRange;", "range", "requireIn", "(FLkotlin/ranges/ClosedFloatingPointRange;)F", "Lkotlin/ranges/ClosedRange;", "(DLkotlin/ranges/ClosedRange;)D", "from", "to", "valueRange", "findShortestPath", "(FFF)F", "flightassistant-neoforge"})
public final class MathHelperKt {
    public static final float degrees(float value) {
        return (float)((double)value * 57.29577951308232);
    }

    public static final double degrees(double value) {
        return value * 57.29577951308232;
    }

    public static final int furtherFromZero(float value) {
        return value < 0.0f ? (int)Math.floor(value) : (int)Math.ceil(value);
    }

    public static final float requireFinite(float $this$requireFinite) {
        float f = $this$requireFinite;
        if (!(!Float.isInfinite(f) && !Float.isNaN(f))) {
            boolean bl = false;
            String string = "Float value invalid; expected finite value, got " + $this$requireFinite;
            throw new IllegalArgumentException(string.toString());
        }
        return $this$requireFinite;
    }

    public static final float requireIn(float $this$requireIn, @NotNull ClosedFloatingPointRange<Float> range) {
        Intrinsics.checkNotNullParameter(range, (String)"range");
        MathHelperKt.requireFinite($this$requireIn);
        if (!range.contains((Comparable)Float.valueOf($this$requireIn))) {
            boolean bl = false;
            String string = "Float value invalid; expected [" + range.getStart() + "; " + range.getEndInclusive() + "], got " + $this$requireIn;
            throw new IllegalArgumentException(string.toString());
        }
        return $this$requireIn;
    }

    public static final double requireFinite(double $this$requireFinite) {
        double d = $this$requireFinite;
        if (!(!Double.isInfinite(d) && !Double.isNaN(d))) {
            boolean bl = false;
            String string = "Double value invalid; expected finite value, got " + $this$requireFinite;
            throw new IllegalArgumentException(string.toString());
        }
        return $this$requireFinite;
    }

    public static final double requireIn(double $this$requireIn, @NotNull ClosedRange<Double> range) {
        Intrinsics.checkNotNullParameter(range, (String)"range");
        MathHelperKt.requireFinite($this$requireIn);
        if (!range.contains((Comparable)Double.valueOf($this$requireIn))) {
            boolean bl = false;
            String string = "Double value invalid; expected [" + range.getStart() + "; " + range.getEndInclusive() + "], got " + $this$requireIn;
            throw new IllegalArgumentException(string.toString());
        }
        return $this$requireIn;
    }

    public static final float findShortestPath(float from, float to, float valueRange) {
        float diff = (to - from) % valueRange;
        if ((double)diff >= (double)valueRange * 0.5) {
            diff -= valueRange;
        }
        if ((double)diff < (double)(-valueRange) * 0.5) {
            diff += valueRange;
        }
        return diff;
    }
}

