/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.api.util.extensions;

import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.jetbrains.annotations.NotNull;
import ru.octol1ttle.flightassistant.FlightAssistant;
import ru.octol1ttle.flightassistant.config.FAConfig;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b \u001a)\u0010\u0006\u001a\u00020\u0005*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0006\u0010\u0007\u001a9\u0010\r\u001a\u00020\u0005*\u00020\u00002\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b\u00a2\u0006\u0004\b\r\u0010\u000e\u001a\u0015\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012\u001a1\u0010\u0013\u001a\u00020\u0005*\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b\u00a2\u0006\u0004\b\u0013\u0010\u0014\u001a1\u0010\u0015\u001a\u00020\u0005*\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b\u00a2\u0006\u0004\b\u0015\u0010\u0014\u001a1\u0010\u0016\u001a\u00020\u0005*\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b\u00a2\u0006\u0004\b\u0016\u0010\u0014\u001a\u0015\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0017\u00a2\u0006\u0004\b\u0011\u0010\u0018\u001a1\u0010\u0013\u001a\u00020\b*\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b\u00a2\u0006\u0004\b\u0013\u0010\u0019\u001a\u0017\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001c\u001a1\u0010\u0015\u001a\u00020\u0005*\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b\u00a2\u0006\u0004\b\u0015\u0010\u001d\u001a1\u0010\u0016\u001a\u00020\u0005*\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b\u00a2\u0006\u0004\b\u0016\u0010\u001d\u001a9\u0010 \u001a\u00020\u0005*\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\u001e\u00a2\u0006\u0004\b \u0010!\u001a)\u0010$\u001a\u00020\u0005*\u00020\"2\u0006\u0010\u0002\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\b2\u0006\u0010#\u001a\u00020\b\u00a2\u0006\u0004\b$\u0010%\"\u001a\u0010'\u001a\u00020&8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b'\u0010(\u001a\u0004\b)\u0010*\"\u0011\u0010-\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010,\"\u0015\u00100\u001a\u00020\u0001*\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b.\u0010/\"\u0015\u00102\u001a\u00020\u0001*\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b1\u0010/\"\u0015\u00105\u001a\u00020\b*\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b3\u00104\"\u0015\u00107\u001a\u00020\u0001*\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b6\u0010/\"\u0015\u00109\u001a\u00020\b*\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b8\u00104\"\u0014\u0010:\u001a\u00020\b8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b:\u0010;\"\u0011\u0010=\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b<\u0010,\"\u0011\u0010?\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b>\u0010,\"\u0011\u0010A\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b@\u0010,\"\u0011\u0010C\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\bB\u0010,\"\u0011\u0010E\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\bD\u0010,\u00a8\u0006F"}, d2={"Lnet/minecraft/client/gui/GuiGraphics;", "", "x", "y", "scale", "", "fusedTranslateScale", "(Lnet/minecraft/client/gui/GuiGraphics;FFF)V", "", "x1", "x2", "dashCount", "color", "drawHorizontalLineDashed", "(Lnet/minecraft/client/gui/GuiGraphics;IIIII)V", "", "text", "getTextWidth", "(Ljava/lang/String;)I", "drawText", "(Lnet/minecraft/client/gui/GuiGraphics;Ljava/lang/String;III)V", "drawRightAlignedText", "drawMiddleAlignedText", "Lnet/minecraft/network/chat/Component;", "(Lnet/minecraft/network/chat/Component;)I", "(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/network/chat/Component;III)I", "original", "getContrasting", "(I)I", "(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/network/chat/Component;III)V", "", "highlight", "drawHighlightedCenteredText", "(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/network/chat/Component;IIIZ)V", "Lcom/mojang/blaze3d/vertex/PoseStack;", "z", "translate", "(Lcom/mojang/blaze3d/vertex/PoseStack;III)V", "Lnet/minecraft/client/gui/Font;", "textRenderer", "Lnet/minecraft/client/gui/Font;", "getTextRenderer", "()Lnet/minecraft/client/gui/Font;", "getFontHeight", "()I", "fontHeight", "getHalfWidth", "(Lnet/minecraft/client/gui/GuiGraphics;)F", "halfWidth", "getCenterXF", "centerXF", "getCenterX", "(Lnet/minecraft/client/gui/GuiGraphics;)I", "centerX", "getCenterYF", "centerYF", "getCenterY", "centerY", "emptyColor", "I", "getPrimaryColor", "primaryColor", "getSecondaryColor", "secondaryColor", "getAdvisoryColor", "advisoryColor", "getCautionColor", "cautionColor", "getWarningColor", "warningColor", "flightassistant-neoforge"})
public final class DrawContextExtensionsKt {
    @NotNull
    private static final Font textRenderer;
    public static final int emptyColor = 0;

    @NotNull
    public static final Font getTextRenderer() {
        return textRenderer;
    }

    public static final int getFontHeight() {
        return DrawContextExtensionsKt.textRenderer.lineHeight;
    }

    public static final float getHalfWidth(@NotNull GuiGraphics $this$halfWidth) {
        Intrinsics.checkNotNullParameter((Object)$this$halfWidth, (String)"<this>");
        return (float)$this$halfWidth.guiWidth() * 0.5f;
    }

    public static final float getCenterXF(@NotNull GuiGraphics $this$centerXF) {
        Intrinsics.checkNotNullParameter((Object)$this$centerXF, (String)"<this>");
        return DrawContextExtensionsKt.getHalfWidth($this$centerXF);
    }

    public static final int getCenterX(@NotNull GuiGraphics $this$centerX) {
        Intrinsics.checkNotNullParameter((Object)$this$centerX, (String)"<this>");
        return (int)DrawContextExtensionsKt.getCenterXF($this$centerX);
    }

    public static final float getCenterYF(@NotNull GuiGraphics $this$centerYF) {
        Intrinsics.checkNotNullParameter((Object)$this$centerYF, (String)"<this>");
        return (float)$this$centerYF.guiHeight() * 0.5f;
    }

    public static final int getCenterY(@NotNull GuiGraphics $this$centerY) {
        Intrinsics.checkNotNullParameter((Object)$this$centerY, (String)"<this>");
        return (int)DrawContextExtensionsKt.getCenterYF($this$centerY);
    }

    public static final int getPrimaryColor() {
        return FAConfig.INSTANCE.getDisplay().getPrimaryColor().getRGB();
    }

    public static final int getSecondaryColor() {
        return FAConfig.INSTANCE.getDisplay().getSecondaryColor().getRGB();
    }

    public static final int getAdvisoryColor() {
        return FAConfig.INSTANCE.getDisplay().getAdvisoryColor().getRGB();
    }

    public static final int getCautionColor() {
        return FAConfig.INSTANCE.getDisplay().getCautionColor().getRGB();
    }

    public static final int getWarningColor() {
        return FAConfig.INSTANCE.getDisplay().getWarningColor().getRGB();
    }

    public static final void fusedTranslateScale(@NotNull GuiGraphics $this$fusedTranslateScale, float x, float y, float scale) {
        Intrinsics.checkNotNullParameter((Object)$this$fusedTranslateScale, (String)"<this>");
        $this$fusedTranslateScale.pose().translate(x, y, 0.0f);
        $this$fusedTranslateScale.pose().scale(scale, scale, 1.0f);
    }

    public static final void drawHorizontalLineDashed(@NotNull GuiGraphics $this$drawHorizontalLineDashed, int x1, int x2, int y, int dashCount, int color) {
        Intrinsics.checkNotNullParameter((Object)$this$drawHorizontalLineDashed, (String)"<this>");
        int width = x2 - x1;
        int segmentCount = dashCount * 2 - 1;
        int dashSize = width / segmentCount;
        for (int i = 0; i < segmentCount; ++i) {
            if (i % 2 != 0) continue;
            int dx1 = i * dashSize + x1;
            int dx2 = i == segmentCount - 1 ? x2 : (i + 1) * dashSize + x1;
            $this$drawHorizontalLineDashed.hLine(dx1, dx2, y, color);
        }
    }

    public static final int getTextWidth(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return textRenderer.width(text);
    }

    public static final void drawText(@NotNull GuiGraphics $this$drawText, @NotNull String text, int x, int y, int color) {
        Intrinsics.checkNotNullParameter((Object)$this$drawText, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        $this$drawText.drawString(textRenderer, text, x, y, color, false);
    }

    public static final void drawRightAlignedText(@NotNull GuiGraphics $this$drawRightAlignedText, @NotNull String text, int x, int y, int color) {
        Intrinsics.checkNotNullParameter((Object)$this$drawRightAlignedText, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        $this$drawRightAlignedText.drawString(textRenderer, text, x - textRenderer.width(text), y, color, false);
    }

    public static final void drawMiddleAlignedText(@NotNull GuiGraphics $this$drawMiddleAlignedText, @NotNull String text, int x, int y, int color) {
        Intrinsics.checkNotNullParameter((Object)$this$drawMiddleAlignedText, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        $this$drawMiddleAlignedText.drawString(textRenderer, text, x - textRenderer.width(text) / 2 + 1, y, color, false);
    }

    public static final int getTextWidth(@NotNull Component text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return textRenderer.width((FormattedText)text);
    }

    public static final int drawText(@NotNull GuiGraphics $this$drawText, @NotNull Component text, int x, int y, int color) {
        Intrinsics.checkNotNullParameter((Object)$this$drawText, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        $this$drawText.drawString(textRenderer, text, x, y, color, false);
        return 1;
    }

    private static final int getContrasting(int original) {
        int red = original >> 16 & 0xFF;
        int green = original >> 8 & 0xFF;
        int blue = original >> 0 & 0xFF;
        double luma = (0.299 * (double)red + 0.587 * (double)green + 0.114 * (double)blue) / 255.0;
        return luma > 0.5 ? Color.BLACK.getRGB() : Color.WHITE.getRGB();
    }

    public static final void drawRightAlignedText(@NotNull GuiGraphics $this$drawRightAlignedText, @NotNull Component text, int x, int y, int color) {
        Intrinsics.checkNotNullParameter((Object)$this$drawRightAlignedText, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        $this$drawRightAlignedText.drawString(textRenderer, text, x - DrawContextExtensionsKt.getTextWidth(text), y, color, false);
    }

    public static final void drawMiddleAlignedText(@NotNull GuiGraphics $this$drawMiddleAlignedText, @NotNull Component text, int x, int y, int color) {
        Intrinsics.checkNotNullParameter((Object)$this$drawMiddleAlignedText, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        $this$drawMiddleAlignedText.drawString(textRenderer, text, x - DrawContextExtensionsKt.getTextWidth(text) / 2 + 1, y, color, false);
    }

    public static final void drawHighlightedCenteredText(@NotNull GuiGraphics $this$drawHighlightedCenteredText, @NotNull Component text, int x, int y, int color, boolean highlight) {
        Intrinsics.checkNotNullParameter((Object)$this$drawHighlightedCenteredText, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        $this$drawHighlightedCenteredText.pose().pushPose();
        if (highlight) {
            int halfWidth = DrawContextExtensionsKt.getTextWidth(text) / 2;
            $this$drawHighlightedCenteredText.fill(x - halfWidth - 1, y - 1, x + halfWidth + 2, y + 8, color);
            PoseStack poseStack = $this$drawHighlightedCenteredText.pose();
            Intrinsics.checkNotNullExpressionValue((Object)poseStack, (String)"getMatrices(...)");
            DrawContextExtensionsKt.translate(poseStack, 0, 0, 100);
            DrawContextExtensionsKt.drawMiddleAlignedText($this$drawHighlightedCenteredText, text, x, y, DrawContextExtensionsKt.getContrasting(color));
        } else {
            DrawContextExtensionsKt.drawMiddleAlignedText($this$drawHighlightedCenteredText, text, x, y, color);
        }
        $this$drawHighlightedCenteredText.pose().popPose();
    }

    public static final void translate(@NotNull PoseStack $this$translate, int x, int y, int z) {
        Intrinsics.checkNotNullParameter((Object)$this$translate, (String)"<this>");
        $this$translate.translate((float)x, (float)y, (float)z);
    }

    static {
        Font font = FlightAssistant.INSTANCE.getMc$flightassistant_neoforge().font;
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"textRenderer");
        textRenderer = font;
    }
}

