/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.impl.alert.fault.computer;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.octol1ttle.flightassistant.api.alert.Alert;
import ru.octol1ttle.flightassistant.api.alert.AlertData;
import ru.octol1ttle.flightassistant.api.alert.ECAMAlert;
import ru.octol1ttle.flightassistant.api.computer.ComputerView;
import ru.octol1ttle.flightassistant.api.util.extensions.DrawContextExtensionsKt;
import ru.octol1ttle.flightassistant.impl.computer.ComputerHost;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0010\u0018\u00002\u00020\u00012\u00020\u0002B;\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0010\b\u0002\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\t\u0012\b\b\u0002\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J/\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u0014\u0010\u0006\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u001aR\u0014\u0010\b\u001a\u00020\u00078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\u001bR\u001c\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\t8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010\u001cR\u001a\u0010\f\u001a\u00020\u000b8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\f\u0010\u001d\u001a\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020\u00148\u0016X\u0096D\u00a2\u0006\f\n\u0004\b \u0010!\u001a\u0004\b\"\u0010#\u00a8\u0006$"}, d2={"Lru/octol1ttle/flightassistant/impl/alert/fault/computer/ComputerFaultAlert;", "Lru/octol1ttle/flightassistant/api/alert/Alert;", "Lru/octol1ttle/flightassistant/api/alert/ECAMAlert;", "Lru/octol1ttle/flightassistant/api/computer/ComputerView;", "computers", "Lnet/minecraft/resources/ResourceLocation;", "identifier", "Lnet/minecraft/network/chat/Component;", "alertText", "", "extraTexts", "Lru/octol1ttle/flightassistant/api/alert/AlertData;", "data", "<init>", "(Lru/octol1ttle/flightassistant/api/computer/ComputerView;Lnet/minecraft/resources/ResourceLocation;Lnet/minecraft/network/chat/Component;Ljava/util/Collection;Lru/octol1ttle/flightassistant/api/alert/AlertData;)V", "", "shouldActivate", "()Z", "Lnet/minecraft/client/gui/GuiGraphics;", "drawContext", "", "firstLineX", "otherLinesX", "firstLineY", "render", "(Lnet/minecraft/client/gui/GuiGraphics;III)I", "Lnet/minecraft/resources/ResourceLocation;", "Lnet/minecraft/network/chat/Component;", "Ljava/util/Collection;", "Lru/octol1ttle/flightassistant/api/alert/AlertData;", "getData", "()Lru/octol1ttle/flightassistant/api/alert/AlertData;", "priorityOffset", "I", "getPriorityOffset", "()I", "flightassistant-neoforge"})
public final class ComputerFaultAlert
extends Alert
implements ECAMAlert {
    @NotNull
    private final ResourceLocation identifier;
    @NotNull
    private final Component alertText;
    @Nullable
    private final Collection<Component> extraTexts;
    @NotNull
    private final AlertData data;
    private final int priorityOffset;

    public ComputerFaultAlert(@NotNull ComputerView computers, @NotNull ResourceLocation identifier, @NotNull Component alertText, @Nullable Collection<? extends Component> extraTexts, @NotNull AlertData data) {
        Intrinsics.checkNotNullParameter((Object)computers, (String)"computers");
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Intrinsics.checkNotNullParameter((Object)alertText, (String)"alertText");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        super(computers);
        this.identifier = identifier;
        this.alertText = alertText;
        this.extraTexts = extraTexts;
        this.data = data;
        this.priorityOffset = 25;
    }

    public /* synthetic */ ComputerFaultAlert(ComputerView computerView, ResourceLocation resourceLocation, Component component, Collection collection, AlertData alertData, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            collection = null;
        }
        if ((n & 0x10) != 0) {
            alertData = AlertData.Companion.getMASTER_CAUTION();
        }
        this(computerView, resourceLocation, component, collection, alertData);
    }

    @Override
    @NotNull
    public AlertData getData() {
        return this.data;
    }

    @Override
    public int getPriorityOffset() {
        return this.priorityOffset;
    }

    @Override
    public boolean shouldActivate() {
        return ComputerHost.INSTANCE.isFaulted(this.identifier);
    }

    @Override
    public int render(@NotNull GuiGraphics drawContext, int firstLineX, int otherLinesX, int firstLineY) {
        int n;
        Intrinsics.checkNotNullParameter((Object)drawContext, (String)"drawContext");
        int color = ((Number)this.getData().getColorSupplier().invoke()).intValue();
        int i = 0;
        i += DrawContextExtensionsKt.drawText(drawContext, this.alertText, firstLineX, firstLineY, color);
        int y = firstLineY + 11;
        if (this.extraTexts != null) {
            for (Component text : this.extraTexts) {
                i += DrawContextExtensionsKt.drawText(drawContext, text, otherLinesX, y, DrawContextExtensionsKt.getAdvisoryColor());
                y += 10;
            }
        }
        if (ComputerHost.INSTANCE.getFaultCount(this.identifier) == 1) {
            MutableComponent mutableComponent = Component.translatable((String)"alert.flightassistant.fault.computer.reset");
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
            n = DrawContextExtensionsKt.drawText(drawContext, (Component)mutableComponent, otherLinesX, y, DrawContextExtensionsKt.getAdvisoryColor());
        } else {
            n = 0;
        }
        return i += n;
    }
}

