/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.impl.alert.firework;

import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import ru.octol1ttle.flightassistant.api.alert.Alert;
import ru.octol1ttle.flightassistant.api.alert.AlertData;
import ru.octol1ttle.flightassistant.api.alert.ECAMAlert;
import ru.octol1ttle.flightassistant.api.computer.ComputerView;
import ru.octol1ttle.flightassistant.api.util.extensions.DrawContextExtensionsKt;
import ru.octol1ttle.flightassistant.config.FAConfig;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ/\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0006\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u000e8\u0016X\u0096D\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u001a\u001a\u00020\u00198\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lru/octol1ttle/flightassistant/impl/alert/firework/FireworkExplosiveAlert;", "Lru/octol1ttle/flightassistant/api/alert/Alert;", "Lru/octol1ttle/flightassistant/api/alert/ECAMAlert;", "Lru/octol1ttle/flightassistant/api/computer/ComputerView;", "computers", "Lnet/minecraft/world/InteractionHand;", "hand", "<init>", "(Lru/octol1ttle/flightassistant/api/computer/ComputerView;Lnet/minecraft/world/InteractionHand;)V", "", "shouldActivate", "()Z", "Lnet/minecraft/client/gui/GuiGraphics;", "drawContext", "", "firstLineX", "otherLinesX", "firstLineY", "render", "(Lnet/minecraft/client/gui/GuiGraphics;III)I", "Lnet/minecraft/world/InteractionHand;", "priorityOffset", "I", "getPriorityOffset", "()I", "Lru/octol1ttle/flightassistant/api/alert/AlertData;", "data", "Lru/octol1ttle/flightassistant/api/alert/AlertData;", "getData", "()Lru/octol1ttle/flightassistant/api/alert/AlertData;", "flightassistant-neoforge"})
public final class FireworkExplosiveAlert
extends Alert
implements ECAMAlert {
    @NotNull
    private final InteractionHand hand;
    private final int priorityOffset;
    @NotNull
    private final AlertData data;

    public FireworkExplosiveAlert(@NotNull ComputerView computers, @NotNull InteractionHand hand) {
        Intrinsics.checkNotNullParameter((Object)computers, (String)"computers");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        super(computers);
        this.hand = hand;
        this.priorityOffset = 5;
        this.data = AlertData.Companion.getMASTER_CAUTION();
    }

    @Override
    public int getPriorityOffset() {
        return this.priorityOffset;
    }

    @Override
    @NotNull
    public AlertData getData() {
        return this.data;
    }

    @Override
    public boolean shouldActivate() {
        return FAConfig.INSTANCE.getSafety().getFireworkExplosiveAlert() && !this.getComputers().getFirework().isEmptyOrSafe((Player)this.getComputers().getData().getPlayer(), this.hand);
    }

    @Override
    public int render(@NotNull GuiGraphics drawContext, int firstLineX, int otherLinesX, int firstLineY) {
        Intrinsics.checkNotNullParameter((Object)drawContext, (String)"drawContext");
        String string = this.hand.toString().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        MutableComponent mutableComponent = Component.translatable((String)("alert.flightassistant.firework.explosive." + string));
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        return DrawContextExtensionsKt.drawText(drawContext, (Component)mutableComponent, firstLineX, firstLineY, DrawContextExtensionsKt.getCautionColor());
    }
}

