/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.impl.alert.stall;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;
import ru.octol1ttle.flightassistant.api.alert.Alert;
import ru.octol1ttle.flightassistant.api.alert.AlertData;
import ru.octol1ttle.flightassistant.api.alert.CenteredAlert;
import ru.octol1ttle.flightassistant.api.computer.ComputerView;
import ru.octol1ttle.flightassistant.api.util.FATickCounter;
import ru.octol1ttle.flightassistant.api.util.extensions.DrawContextExtensionsKt;
import ru.octol1ttle.flightassistant.config.FAConfig;
import ru.octol1ttle.flightassistant.config.options.SafetyOptions;
import ru.octol1ttle.flightassistant.impl.computer.safety.StallComputer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001f\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0014\u001a\u00020\u00138\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lru/octol1ttle/flightassistant/impl/alert/stall/ApproachingStallAlert;", "Lru/octol1ttle/flightassistant/api/alert/Alert;", "Lru/octol1ttle/flightassistant/api/alert/CenteredAlert;", "Lru/octol1ttle/flightassistant/api/computer/ComputerView;", "computers", "<init>", "(Lru/octol1ttle/flightassistant/api/computer/ComputerView;)V", "", "shouldActivate", "()Z", "Lru/octol1ttle/flightassistant/config/options/SafetyOptions$AlertMethod;", "getAlertMethod", "()Lru/octol1ttle/flightassistant/config/options/SafetyOptions$AlertMethod;", "Lnet/minecraft/client/gui/GuiGraphics;", "drawContext", "", "y", "render", "(Lnet/minecraft/client/gui/GuiGraphics;I)Z", "Lru/octol1ttle/flightassistant/api/alert/AlertData;", "data", "Lru/octol1ttle/flightassistant/api/alert/AlertData;", "getData", "()Lru/octol1ttle/flightassistant/api/alert/AlertData;", "flightassistant-neoforge"})
public final class ApproachingStallAlert
extends Alert
implements CenteredAlert {
    @NotNull
    private final AlertData data;

    public ApproachingStallAlert(@NotNull ComputerView computers) {
        Intrinsics.checkNotNullParameter((Object)computers, (String)"computers");
        super(computers);
        this.data = AlertData.Companion.getAPPROACHING_STALL();
    }

    @Override
    @NotNull
    public AlertData getData() {
        return this.data;
    }

    @Override
    public boolean shouldActivate() {
        return FAConfig.INSTANCE.getSafety().getStallAlertMode().caution() && this.getComputers().getStall().getStatus() == StallComputer.Status.APPROACHING_STALL;
    }

    @Override
    @NotNull
    public SafetyOptions.AlertMethod getAlertMethod() {
        return FAConfig.INSTANCE.getSafety().getStallAlertMethod();
    }

    @Override
    public boolean render(@NotNull GuiGraphics drawContext, int y) {
        Intrinsics.checkNotNullParameter((Object)drawContext, (String)"drawContext");
        MutableComponent mutableComponent = Component.translatable((String)"alert.flightassistant.stall");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        DrawContextExtensionsKt.drawHighlightedCenteredText(drawContext, (Component)mutableComponent, DrawContextExtensionsKt.getCenterX(drawContext), y, DrawContextExtensionsKt.getCautionColor(), FATickCounter.INSTANCE.getTotalTicks() % 40 >= 20);
        return true;
    }
}

