/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.impl.computer;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.RangesKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.octol1ttle.flightassistant.FlightAssistant;
import ru.octol1ttle.flightassistant.api.computer.Computer;
import ru.octol1ttle.flightassistant.api.computer.ComputerView;
import ru.octol1ttle.flightassistant.api.util.FATickCounter;
import ru.octol1ttle.flightassistant.api.util.MathHelperKt;
import ru.octol1ttle.flightassistant.api.util.RenderMatrices;
import ru.octol1ttle.flightassistant.api.util.extensions.LivingEntityExtensionsKt;
import ru.octol1ttle.flightassistant.config.FAConfig;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0007\n\u0002\b\u0019\u0018\u0000 N2\u00020\u0001:\u0001NB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\r\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0015\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0011\u0010\u0014\u001a\u0004\u0018\u00010\u0013H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0017\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u000f\u0010\u0019\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u0019\u0010\nR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u001aR\u0011\u0010\u001e\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010!\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0011\u0010%\u001a\u00020\"8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R$\u0010'\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\u00168\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b'\u0010(\u001a\u0004\b)\u0010\u0018R\u0011\u0010,\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u0011\u00100\u001a\u00020-8F\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R.\u00101\u001a\u0004\u0018\u00010\u00132\b\u0010&\u001a\u0004\u0018\u00010\u00138\u0006@BX\u0086\u000e\u00a2\u0006\u0012\n\u0004\b1\u00102\u001a\u0004\b3\u0010\u0015\"\u0004\b4\u00105R\u0014\u00109\u001a\u0002068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u00108R\u0011\u0010;\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b:\u0010 R$\u0010<\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\u00168\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b<\u0010(\u001a\u0004\b=\u0010\u0018R$\u0010>\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\u00168\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b>\u0010(\u001a\u0004\b?\u0010\u0018R\u0011\u0010A\u001a\u0002068F\u00a2\u0006\u0006\u001a\u0004\b@\u00108R\u0011\u0010C\u001a\u0002068F\u00a2\u0006\u0006\u001a\u0004\bB\u00108R\u0011\u0010E\u001a\u0002068F\u00a2\u0006\u0006\u001a\u0004\bD\u00108R*\u0010F\u001a\u0002062\u0006\u0010&\u001a\u0002068\u0006@BX\u0086\u000e\u00a2\u0006\u0012\n\u0004\bF\u0010G\u001a\u0004\bH\u00108\"\u0004\bI\u0010JR\u0011\u0010L\u001a\u0002068F\u00a2\u0006\u0006\u001a\u0004\bK\u00108R\u0011\u0010M\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\bM\u0010 \u00a8\u0006O"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/AirDataComputer;", "Lru/octol1ttle/flightassistant/api/computer/Computer;", "Lru/octol1ttle/flightassistant/api/computer/ComputerView;", "computers", "Lnet/minecraft/client/Minecraft;", "mc", "<init>", "(Lru/octol1ttle/flightassistant/api/computer/ComputerView;Lnet/minecraft/client/Minecraft;)V", "", "tick", "()V", "", "checkFlying", "automationsAllowed", "(Z)Z", "Lnet/minecraft/world/damagesource/DamageSource;", "source", "isInvulnerableTo", "(Lnet/minecraft/world/damagesource/DamageSource;)Z", "", "computeGroundLevel", "()Ljava/lang/Double;", "Lnet/minecraft/world/phys/Vec3;", "computeForwardVelocity", "()Lnet/minecraft/world/phys/Vec3;", "reset", "Lnet/minecraft/client/Minecraft;", "Lnet/minecraft/client/player/LocalPlayer;", "getPlayer", "()Lnet/minecraft/client/player/LocalPlayer;", "player", "getFlying", "()Z", "flying", "Lnet/minecraft/client/multiplayer/ClientLevel;", "getWorld", "()Lnet/minecraft/client/multiplayer/ClientLevel;", "world", "value", "position", "Lnet/minecraft/world/phys/Vec3;", "getPosition", "getAltitude", "()D", "altitude", "", "getVoidLevel", "()I", "voidLevel", "groundLevel", "Ljava/lang/Double;", "getGroundLevel", "setGroundLevel", "(Ljava/lang/Double;)V", "", "getFallDistance", "()F", "fallDistance", "getFallDistanceSafe", "fallDistanceSafe", "velocity", "getVelocity", "forwardVelocity", "getForwardVelocity", "getPitch", "pitch", "getYaw", "yaw", "getHeading", "heading", "roll", "F", "getRoll", "setRoll", "(F)V", "getFlightPitch", "flightPitch", "isCurrentChunkLoaded", "Companion", "flightassistant-neoforge"})
public final class AirDataComputer
extends Computer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Minecraft mc;
    @NotNull
    private Vec3 position;
    @Nullable
    private Double groundLevel;
    @NotNull
    private Vec3 velocity;
    @NotNull
    private Vec3 forwardVelocity;
    private float roll;
    @NotNull
    private static final ResourceLocation ID = FlightAssistant.INSTANCE.id$flightassistant_neoforge("air_data");

    public AirDataComputer(@NotNull ComputerView computers, @NotNull Minecraft mc) {
        Intrinsics.checkNotNullParameter((Object)computers, (String)"computers");
        Intrinsics.checkNotNullParameter((Object)mc, (String)"mc");
        super(computers);
        this.mc = mc;
        Vec3 vec3 = Vec3.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"ZERO");
        this.position = vec3;
        Vec3 vec32 = Vec3.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"ZERO");
        this.velocity = vec32;
        Vec3 vec33 = Vec3.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)vec33, (String)"ZERO");
        this.forwardVelocity = vec33;
    }

    @NotNull
    public final LocalPlayer getPlayer() {
        LocalPlayer localPlayer = this.mc.player;
        if (localPlayer == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        return localPlayer;
    }

    public final boolean getFlying() {
        return LivingEntityExtensionsKt.getFallFlying((LivingEntity)this.getPlayer());
    }

    @NotNull
    public final ClientLevel getWorld() {
        ClientLevel clientLevel = this.mc.level;
        if (clientLevel == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        return clientLevel;
    }

    @NotNull
    public final Vec3 getPosition() {
        return this.position;
    }

    public final double getAltitude() {
        return this.position.y;
    }

    public final int getVoidLevel() {
        return this.getWorld().getMinBuildHeight() - 64;
    }

    @Nullable
    public final Double getGroundLevel() {
        return this.groundLevel;
    }

    private final void setGroundLevel(Double value) {
        Double d = value;
        this.groundLevel = d != null ? Double.valueOf(MathHelperKt.requireIn(d, (ClosedRange<Double>)((ClosedRange)RangesKt.rangeTo((double)this.getWorld().getMinBuildHeight(), (double)Double.MAX_VALUE)))) : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final float getFallDistance() {
        if (this.groundLevel == null) return Float.MAX_VALUE;
        Double d = this.groundLevel;
        Intrinsics.checkNotNull((Object)d);
        if (d == Double.MAX_VALUE) {
            return Float.MAX_VALUE;
        }
        boolean bl = false;
        if (bl) {
            return Float.MAX_VALUE;
        }
        float f = this.getPlayer().fallDistance;
        double d2 = this.getAltitude();
        Double d3 = this.groundLevel;
        Intrinsics.checkNotNull((Object)d3);
        float f2 = Math.max(f, (float)(d2 - d3));
        return f2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean getFallDistanceSafe() {
        if (this.getPlayer().isInWater()) return true;
        if (this.getFallDistance() <= (float)this.getPlayer().getMaxFallDistance()) return true;
        DamageSource damageSource = this.getPlayer().damageSources().fall();
        Intrinsics.checkNotNullExpressionValue((Object)damageSource, (String)"fall(...)");
        if (!this.isInvulnerableTo(damageSource)) return false;
        return true;
    }

    @NotNull
    public final Vec3 getVelocity() {
        return this.velocity;
    }

    @NotNull
    public final Vec3 getForwardVelocity() {
        return this.forwardVelocity;
    }

    public final float getPitch() {
        return -MathHelperKt.requireIn(this.getPlayer().getXRot(), (ClosedFloatingPointRange<Float>)RangesKt.rangeTo((float)-90.0f, (float)90.0f));
    }

    public final float getYaw() {
        return MathHelperKt.requireIn(Mth.wrapDegrees((float)this.getPlayer().getYRot()), (ClosedFloatingPointRange<Float>)RangesKt.rangeTo((float)-180.0f, (float)180.0f));
    }

    public final float getHeading() {
        return MathHelperKt.requireIn(this.getYaw() + 180.0f, (ClosedFloatingPointRange<Float>)RangesKt.rangeTo((float)0.0f, (float)360.0f));
    }

    public final float getRoll() {
        return this.roll;
    }

    private final void setRoll(float value) {
        this.roll = MathHelperKt.requireIn(value, (ClosedFloatingPointRange<Float>)RangesKt.rangeTo((float)-180.0f, (float)180.0f));
    }

    public final float getFlightPitch() {
        return MathHelperKt.degrees((float)Math.asin(this.velocity.normalize().y));
    }

    public final boolean isCurrentChunkLoaded() {
        return this.getWorld().getChunkSource().hasChunk(this.getPlayer().chunkPosition().x, this.getPlayer().chunkPosition().z);
    }

    @Override
    public void tick() {
        this.position = this.getPlayer().getPosition(FATickCounter.INSTANCE.getTickProgress());
        this.setGroundLevel(this.computeGroundLevel());
        this.velocity = this.getPlayer().getDeltaMovementLerped(FATickCounter.INSTANCE.getTickProgress());
        this.forwardVelocity = this.computeForwardVelocity();
        this.setRoll(MathHelperKt.degrees((float)Math.atan2(-RenderMatrices.INSTANCE.getWorldSpaceMatrix().m10(), RenderMatrices.INSTANCE.getWorldSpaceMatrix().m11())));
    }

    public final boolean automationsAllowed(boolean checkFlying) {
        return (!checkFlying || this.getFlying()) && (FAConfig.INSTANCE.getGlobal$flightassistant_neoforge().getAutomationsAllowedInOverlays$flightassistant_neoforge() || this.mc.screen == null && this.mc.getOverlay() == null);
    }

    public static /* synthetic */ boolean automationsAllowed$default(AirDataComputer airDataComputer, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return airDataComputer.automationsAllowed(bl);
    }

    public final boolean isInvulnerableTo(@NotNull DamageSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (!FAConfig.INSTANCE.getSafety().getConsiderInvulnerability()) {
            return false;
        }
        return this.getPlayer().isInvulnerableTo(source) || this.getPlayer().getAbilities().invulnerable && !source.is(DamageTypeTags.BYPASSES_INVULNERABILITY) || this.getPlayer().getAbilities().mayfly && source.is(DamageTypeTags.IS_FALL);
    }

    private final Double computeGroundLevel() {
        if (!this.isCurrentChunkLoaded()) {
            return this.groundLevel;
        }
        double minY = RangesKt.coerceAtLeast((double)this.getWorld().getMinBuildHeight(), (double)(this.getAltitude() - (double)2500));
        BlockHitResult blockHitResult = this.getWorld().clip(new ClipContext(this.position, this.position.with(Direction.Axis.Y, minY), ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)this.getPlayer()));
        Intrinsics.checkNotNullExpressionValue((Object)blockHitResult, (String)"raycast(...)");
        BlockHitResult result = blockHitResult;
        if (result.getType() == HitResult.Type.MISS) {
            return result.getLocation().y > (double)this.getWorld().getMinBuildHeight() ? Double.valueOf(Double.MAX_VALUE) : null;
        }
        return result.getLocation().y;
    }

    private final Vec3 computeForwardVelocity() {
        Vec3 vec3 = this.getPlayer().getLookAngle().normalize();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"normalize(...)");
        Vec3 normalizedRotation = vec3;
        Vec3 vec32 = this.velocity.normalize();
        Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"normalize(...)");
        Vec3 normalizedVelocity = vec32;
        Vec3 vec33 = this.velocity.scale(RangesKt.coerceAtLeast((double)normalizedRotation.dot(normalizedVelocity), (double)0.0));
        Intrinsics.checkNotNullExpressionValue((Object)vec33, (String)"multiply(...)");
        return vec33;
    }

    @Override
    public void reset() {
        this.position = Vec3.ZERO;
        this.setGroundLevel(null);
        this.velocity = Vec3.ZERO;
        this.forwardVelocity = Vec3.ZERO;
        this.setRoll(0.0f);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/AirDataComputer$Companion;", "", "<init>", "()V", "Lnet/minecraft/resources/ResourceLocation;", "ID", "Lnet/minecraft/resources/ResourceLocation;", "getID", "()Lnet/minecraft/resources/ResourceLocation;", "flightassistant-neoforge"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceLocation getID() {
            return ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

