/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.impl.computer;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import ru.octol1ttle.flightassistant.FlightAssistant;
import ru.octol1ttle.flightassistant.api.ModuleController;
import ru.octol1ttle.flightassistant.api.computer.Computer;
import ru.octol1ttle.flightassistant.api.computer.ComputerRegistrationCallback;
import ru.octol1ttle.flightassistant.api.computer.ComputerView;
import ru.octol1ttle.flightassistant.api.util.FATickCounter;
import ru.octol1ttle.flightassistant.config.FAConfig;
import ru.octol1ttle.flightassistant.impl.computer.AirDataComputer;
import ru.octol1ttle.flightassistant.impl.computer.autoflight.AutomationsComputer;
import ru.octol1ttle.flightassistant.impl.computer.autoflight.AutopilotLogicComputer;
import ru.octol1ttle.flightassistant.impl.computer.autoflight.FireworkComputer;
import ru.octol1ttle.flightassistant.impl.computer.autoflight.HeadingComputer;
import ru.octol1ttle.flightassistant.impl.computer.autoflight.PitchComputer;
import ru.octol1ttle.flightassistant.impl.computer.autoflight.RollComputer;
import ru.octol1ttle.flightassistant.impl.computer.autoflight.ThrustComputer;
import ru.octol1ttle.flightassistant.impl.computer.safety.AlertComputer;
import ru.octol1ttle.flightassistant.impl.computer.safety.ChunkStatusComputer;
import ru.octol1ttle.flightassistant.impl.computer.safety.ElytraStatusComputer;
import ru.octol1ttle.flightassistant.impl.computer.safety.FlightProtectionsComputer;
import ru.octol1ttle.flightassistant.impl.computer.safety.GroundProximityComputer;
import ru.octol1ttle.flightassistant.impl.computer.safety.StallComputer;
import ru.octol1ttle.flightassistant.impl.computer.safety.VoidProximityComputer;
import ru.octol1ttle.flightassistant.mixin.ClientShouldTickInvoker;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u000b\u0010\nJ\u001f\u0010\r\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0015\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0015\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u0012H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001f\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u000f\u0010\u0019\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u0005J\u000f\u0010\u001b\u001a\u00020\u0016H\u0000\u00a2\u0006\u0004\b\u001a\u0010\u0005J\u000f\u0010\u001c\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u0005J\u0017\u0010!\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001dH\u0000\u00a2\u0006\u0004\b\u001f\u0010 J\u0017\u0010\"\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\"\u0010#R \u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00020$8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010&\u00a8\u0006'"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/ComputerHost;", "Lru/octol1ttle/flightassistant/api/ModuleController;", "Lru/octol1ttle/flightassistant/api/computer/Computer;", "Lru/octol1ttle/flightassistant/api/computer/ComputerView;", "<init>", "()V", "Lnet/minecraft/resources/ResourceLocation;", "identifier", "", "isEnabled", "(Lnet/minecraft/resources/ResourceLocation;)Z", "isFaulted", "enabled", "setEnabled", "(Lnet/minecraft/resources/ResourceLocation;Z)Z", "", "getFaultCount", "(Lnet/minecraft/resources/ResourceLocation;)I", "", "identifiers", "()Ljava/util/Set;", "module", "", "register", "(Lnet/minecraft/resources/ResourceLocation;Lru/octol1ttle/flightassistant/api/computer/Computer;)V", "registerBuiltin", "sendRegistrationEvent$flightassistant_neoforge", "sendRegistrationEvent", "logRegisterComplete", "", "tickDelta", "tick$flightassistant_neoforge", "(F)V", "tick", "get", "(Lnet/minecraft/resources/ResourceLocation;)Lru/octol1ttle/flightassistant/api/computer/Computer;", "", "computers", "Ljava/util/Map;", "flightassistant-neoforge"})
public final class ComputerHost
implements ModuleController<Computer>,
ComputerView {
    @NotNull
    public static final ComputerHost INSTANCE = new ComputerHost();
    @NotNull
    private static final Map<ResourceLocation, Computer> computers = new LinkedHashMap();

    private ComputerHost() {
    }

    @Override
    public boolean isEnabled(@NotNull ResourceLocation identifier) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        return this.get(identifier).getEnabled();
    }

    @Override
    public boolean isFaulted(@NotNull ResourceLocation identifier) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        return this.get(identifier).getFaulted();
    }

    @Override
    public boolean setEnabled(@NotNull ResourceLocation identifier, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Computer computer = this.get(identifier);
        boolean oldEnabled = computer.getEnabled();
        computer.setEnabled(enabled);
        computer.reset();
        return oldEnabled;
    }

    public final int getFaultCount(@NotNull ResourceLocation identifier) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        return this.get(identifier).getFaultCount();
    }

    @NotNull
    public Set<ResourceLocation> identifiers() {
        return computers.keySet();
    }

    @Override
    public void register(@NotNull ResourceLocation identifier, @NotNull Computer module) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        if (FlightAssistant.INSTANCE.getInitComplete$flightassistant_neoforge()) {
            throw new IllegalStateException("Initialization is already complete, but trying to register a computer with identifier: " + identifier);
        }
        if (computers.containsKey(identifier)) {
            throw new IllegalArgumentException("Already registered computer with identifier: " + identifier);
        }
        computers.put(identifier, module);
    }

    private final void registerBuiltin() {
        this.register(AirDataComputer.Companion.getID(), new AirDataComputer(this, FlightAssistant.INSTANCE.getMc$flightassistant_neoforge()));
        this.register(FlightProtectionsComputer.Companion.getID(), new FlightProtectionsComputer(this));
        this.register(StallComputer.Companion.getID(), new StallComputer(this));
        this.register(VoidProximityComputer.Companion.getID(), new VoidProximityComputer(this));
        this.register(GroundProximityComputer.Companion.getID(), new GroundProximityComputer(this));
        this.register(ElytraStatusComputer.Companion.getID(), new ElytraStatusComputer(this));
        this.register(ChunkStatusComputer.Companion.getID(), new ChunkStatusComputer(this));
        this.register(AutomationsComputer.Companion.getID(), new AutomationsComputer(this));
        this.register(AutopilotLogicComputer.Companion.getID(), new AutopilotLogicComputer(this));
        this.register(FireworkComputer.Companion.getID(), new FireworkComputer(this, FlightAssistant.INSTANCE.getMc$flightassistant_neoforge()));
        this.register(PitchComputer.Companion.getID(), new PitchComputer(this));
        this.register(HeadingComputer.Companion.getID(), new HeadingComputer(this));
        this.register(RollComputer.Companion.getID(), new RollComputer(this));
        this.register(ThrustComputer.Companion.getID(), new ThrustComputer(this));
        ResourceLocation resourceLocation = AlertComputer.Companion.getID();
        ComputerView computerView = this;
        SoundManager soundManager = FlightAssistant.INSTANCE.getMc$flightassistant_neoforge().getSoundManager();
        Intrinsics.checkNotNullExpressionValue((Object)soundManager, (String)"getSoundManager(...)");
        this.register(resourceLocation, new AlertComputer(computerView, soundManager));
    }

    public final void sendRegistrationEvent$flightassistant_neoforge() {
        this.registerBuiltin();
        ((ComputerRegistrationCallback)ComputerRegistrationCallback.EVENT.invoker()).register(this, this::register);
        for (Computer computer : computers.values()) {
            computer.subscribeToEvents();
        }
        for (Computer computer : computers.values()) {
            computer.invokeEvents();
        }
        this.logRegisterComplete();
    }

    private final void logRegisterComplete() {
        ArrayList<String> namespaces = new ArrayList<String>();
        for (ResourceLocation id : computers.keySet()) {
            if (namespaces.contains(id.getNamespace())) continue;
            namespaces.add(id.getNamespace());
        }
        FlightAssistant.INSTANCE.getLogger$flightassistant_neoforge().info("Registered {} computers from mods: {}", (Object)computers.size(), (Object)CollectionsKt.joinToString$default((Iterable)namespaces, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
    }

    /*
     * Unable to fully structure code
     */
    public final void tick$flightassistant_neoforge(float tickDelta) {
        if (FlightAssistant.INSTANCE.getMc$flightassistant_neoforge().isPaused()) ** GOTO lbl-1000
        v0 = FlightAssistant.INSTANCE.getMc$flightassistant_neoforge();
        Intrinsics.checkNotNull((Object)v0, (String)"null cannot be cast to non-null type ru.octol1ttle.flightassistant.mixin.ClientShouldTickInvoker");
        if (!((ClientShouldTickInvoker)v0).invokeShouldTick()) lbl-1000:
        // 2 sources

        {
            v1 = true;
        } else {
            v1 = false;
        }
        paused = v1;
        v2 = FlightAssistant.INSTANCE.getMc$flightassistant_neoforge().player;
        Intrinsics.checkNotNull((Object)v2);
        FATickCounter.INSTANCE.tick(v2, tickDelta, paused);
        if (paused || FATickCounter.INSTANCE.getTicksSinceWorldLoad() < FATickCounter.INSTANCE.getWorldLoadWaitTime() || !FAConfig.INSTANCE.getGlobal$flightassistant_neoforge().getModEnabled$flightassistant_neoforge()) {
            return;
        }
        for (Map.Entry<ResourceLocation, Computer> var4_4 : ComputerHost.computers.entrySet()) {
            id = var4_4.getKey();
            computer = var4_4.getValue();
            if (!computer.getEnabled()) continue;
            try {
                computer.tick();
                computer.setFaulted(false);
            }
            catch (Throwable t) {
                computer.setFaulted(true);
                var8_8 = computer.getFaultCount();
                computer.setFaultCount(var8_8 + 1);
                computer.setEnabled(false);
                computer.reset();
                FlightAssistant.INSTANCE.getLogger$flightassistant_neoforge().atError().setCause(t).log("Exception ticking computer with identifier: {}", (Object)id);
            }
        }
    }

    @Override
    @NotNull
    public Computer get(@NotNull ResourceLocation identifier) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Computer computer = computers.get(identifier);
        if (computer == null) {
            throw new IllegalArgumentException("No computer registered with ID: " + identifier);
        }
        return computer;
    }

    @Override
    public boolean toggleEnabled(@NotNull ResourceLocation identifier) {
        return ModuleController.DefaultImpls.toggleEnabled(this, identifier);
    }

    @Override
    @NotNull
    public AirDataComputer getData() {
        return ComputerView.DefaultImpls.getData(this);
    }

    @Override
    @NotNull
    public AutomationsComputer getAutomations() {
        return ComputerView.DefaultImpls.getAutomations(this);
    }

    @Override
    @NotNull
    public AutopilotLogicComputer getAutopilot() {
        return ComputerView.DefaultImpls.getAutopilot(this);
    }

    @Override
    @NotNull
    public FireworkComputer getFirework() {
        return ComputerView.DefaultImpls.getFirework(this);
    }

    @Override
    @NotNull
    public HeadingComputer getHeading() {
        return ComputerView.DefaultImpls.getHeading(this);
    }

    @Override
    @NotNull
    public PitchComputer getPitch() {
        return ComputerView.DefaultImpls.getPitch(this);
    }

    @Override
    @NotNull
    public RollComputer getRoll() {
        return ComputerView.DefaultImpls.getRoll(this);
    }

    @Override
    @NotNull
    public ThrustComputer getThrust() {
        return ComputerView.DefaultImpls.getThrust(this);
    }

    @Override
    @NotNull
    public AlertComputer getAlert() {
        return ComputerView.DefaultImpls.getAlert(this);
    }

    @Override
    @NotNull
    public ChunkStatusComputer getChunk() {
        return ComputerView.DefaultImpls.getChunk(this);
    }

    @Override
    @NotNull
    public ElytraStatusComputer getElytra() {
        return ComputerView.DefaultImpls.getElytra(this);
    }

    @Override
    @NotNull
    public FlightProtectionsComputer getProtections() {
        return ComputerView.DefaultImpls.getProtections(this);
    }

    @Override
    @NotNull
    public GroundProximityComputer getGpws() {
        return ComputerView.DefaultImpls.getGpws(this);
    }

    @Override
    @NotNull
    public StallComputer getStall() {
        return ComputerView.DefaultImpls.getStall(this);
    }

    @Override
    @NotNull
    public VoidProximityComputer getVoidProximity() {
        return ComputerView.DefaultImpls.getVoidProximity(this);
    }
}

