/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.impl.computer.autoflight;

import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.octol1ttle.flightassistant.FlightAssistant;
import ru.octol1ttle.flightassistant.api.autoflight.ControlInput;
import ru.octol1ttle.flightassistant.api.autoflight.FlightController;
import ru.octol1ttle.flightassistant.api.autoflight.heading.HeadingControllerRegistrationCallback;
import ru.octol1ttle.flightassistant.api.autoflight.pitch.PitchControllerRegistrationCallback;
import ru.octol1ttle.flightassistant.api.autoflight.roll.RollControllerRegistrationCallback;
import ru.octol1ttle.flightassistant.api.autoflight.thrust.ThrustChangeCallback;
import ru.octol1ttle.flightassistant.api.autoflight.thrust.ThrustControllerRegistrationCallback;
import ru.octol1ttle.flightassistant.api.computer.Computer;
import ru.octol1ttle.flightassistant.api.computer.ComputerView;
import ru.octol1ttle.flightassistant.api.util.FATickCounter;
import ru.octol1ttle.flightassistant.api.util.event.ChangeLookDirectionEvents;
import ru.octol1ttle.flightassistant.impl.computer.autoflight.AutopilotLogicComputer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u0007\n\u0002\b\u0005\u0018\u0000 ,2\u00020\u00012\u00020\u0002:\u0001,B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\n\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\n\u0010\tJ\u0015\u0010\r\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ!\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u000b2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\u0011\u0010\u0012J!\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u000b2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\u0014\u0010\u0012J\u0011\u0010\u0016\u001a\u0004\u0018\u00010\u0015H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0011\u0010\u0018\u001a\u0004\u0018\u00010\u0015H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0017J\u0011\u0010\u0019\u001a\u0004\u0018\u00010\u0015H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u0017J\u0011\u0010\u001a\u001a\u0004\u0018\u00010\u0015H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u0017J\u000f\u0010\u001b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u001b\u0010\tR$\u0010\f\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u000b8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\f\u0010\u001d\u001a\u0004\b\u001e\u0010\u001fR$\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u000b8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\u000f\u0010\u001d\u001a\u0004\b \u0010\u001fR\"\u0010!\u001a\u00020\u000b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b!\u0010\u001d\u001a\u0004\b\"\u0010\u001f\"\u0004\b#\u0010\u000eR$\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u000b8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\u0013\u0010\u001d\u001a\u0004\b$\u0010\u001fR\"\u0010%\u001a\u00020\u000b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b%\u0010\u001d\u001a\u0004\b&\u0010\u001f\"\u0004\b'\u0010\u000eR\u0016\u0010)\u001a\u00020(8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b)\u0010*R\u0016\u0010+\u001a\u00020(8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b+\u0010*\u00a8\u0006-"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/autoflight/AutomationsComputer;", "Lru/octol1ttle/flightassistant/api/computer/Computer;", "Lru/octol1ttle/flightassistant/api/autoflight/FlightController;", "Lru/octol1ttle/flightassistant/api/computer/ComputerView;", "computers", "<init>", "(Lru/octol1ttle/flightassistant/api/computer/ComputerView;)V", "", "subscribeToEvents", "()V", "tick", "", "flightDirectors", "setFlightDirectors", "(Z)V", "autoThrust", "alert", "setAutoThrust", "(ZLjava/lang/Boolean;)V", "autopilot", "setAutoPilot", "Lru/octol1ttle/flightassistant/api/autoflight/ControlInput;", "getThrustInput", "()Lru/octol1ttle/flightassistant/api/autoflight/ControlInput;", "getPitchInput", "getHeadingInput", "getRollInput", "reset", "value", "Z", "getFlightDirectors", "()Z", "getAutoThrust", "autoThrustAlert", "getAutoThrustAlert", "setAutoThrustAlert", "getAutopilot", "autopilotAlert", "getAutopilotAlert", "setAutopilotAlert", "", "pitchResistance", "F", "headingResistance", "Companion", "flightassistant-neoforge"})
public final class AutomationsComputer
extends Computer
implements FlightController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean flightDirectors;
    private boolean autoThrust;
    private boolean autoThrustAlert;
    private boolean autopilot;
    private boolean autopilotAlert;
    private float pitchResistance;
    private float headingResistance;
    @NotNull
    private static final ResourceLocation ID = FlightAssistant.INSTANCE.id$flightassistant_neoforge("automations");

    public AutomationsComputer(@NotNull ComputerView computers) {
        Intrinsics.checkNotNullParameter((Object)computers, (String)"computers");
        super(computers);
    }

    public final boolean getFlightDirectors() {
        return this.flightDirectors;
    }

    public final boolean getAutoThrust() {
        return this.autoThrust;
    }

    public final boolean getAutoThrustAlert() {
        return this.autoThrustAlert;
    }

    public final void setAutoThrustAlert(boolean bl) {
        this.autoThrustAlert = bl;
    }

    public final boolean getAutopilot() {
        return this.autopilot;
    }

    public final boolean getAutopilotAlert() {
        return this.autopilotAlert;
    }

    public final void setAutopilotAlert(boolean bl) {
        this.autopilotAlert = bl;
    }

    @Override
    public void subscribeToEvents() {
        ThrustControllerRegistrationCallback.EVENT.register((Object)new ThrustControllerRegistrationCallback(this){
            final /* synthetic */ AutomationsComputer this$0;
            {
                this.this$0 = $receiver;
            }

            public final void register(Consumer<FlightController> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                it.accept(this.this$0);
            }
        });
        PitchControllerRegistrationCallback.EVENT.register((Object)new PitchControllerRegistrationCallback(this){
            final /* synthetic */ AutomationsComputer this$0;
            {
                this.this$0 = $receiver;
            }

            public final void register(Consumer<FlightController> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                it.accept(this.this$0);
            }
        });
        HeadingControllerRegistrationCallback.EVENT.register((Object)new HeadingControllerRegistrationCallback(this){
            final /* synthetic */ AutomationsComputer this$0;
            {
                this.this$0 = $receiver;
            }

            public final void register(Consumer<FlightController> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                it.accept(this.this$0);
            }
        });
        RollControllerRegistrationCallback.EVENT.register((Object)new RollControllerRegistrationCallback(this){
            final /* synthetic */ AutomationsComputer this$0;
            {
                this.this$0 = $receiver;
            }

            public final void register(Consumer<FlightController> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                it.accept(this.this$0);
            }
        });
        ThrustChangeCallback.EVENT.register((Object)new ThrustChangeCallback(this){
            final /* synthetic */ AutomationsComputer this$0;
            {
                this.this$0 = $receiver;
            }

            public final void onThrustChange(float f, float f2, ControlInput input) {
                ControlInput controlInput = input;
                if (!Intrinsics.areEqual((Object)(controlInput != null ? controlInput.getIdentifier() : null), (Object)AutopilotLogicComputer.Companion.getID())) {
                    this.this$0.setAutoThrust(false, true);
                }
                if (input == null && this.this$0.getAutoThrustAlert()) {
                    this.this$0.setAutoThrustAlert(false);
                }
            }
        });
        ChangeLookDirectionEvents.PITCH.register((arg_0, arg_1) -> AutomationsComputer.subscribeToEvents$lambda$0(this, arg_0, arg_1));
        ChangeLookDirectionEvents.HEADING.register((arg_0, arg_1) -> AutomationsComputer.subscribeToEvents$lambda$1(this, arg_0, arg_1));
    }

    @Override
    public void tick() {
        if (this.getComputers().getProtections().getProtectionsLost() || !this.getComputers().getData().isCurrentChunkLoaded()) {
            this.reset();
            return;
        }
        if (this.getComputers().getPitch().getManualOverride$flightassistant_neoforge()) {
            this.setAutoPilot(false, false);
        }
        this.pitchResistance = RangesKt.coerceAtLeast((float)(this.pitchResistance - FATickCounter.INSTANCE.getTimePassed() * 10.0f), (float)0.0f);
        this.headingResistance = RangesKt.coerceAtLeast((float)(this.headingResistance - FATickCounter.INSTANCE.getTimePassed() * 20.0f), (float)0.0f);
        if (this.autoThrust) {
            this.autoThrustAlert = false;
            if (this.getComputers().getThrust().getFaulted()) {
                this.setAutoThrust(false, true);
            }
        }
        if (this.autopilot) {
            this.autopilotAlert = false;
            ControlInput pitchInput = this.getComputers().getPitch().getActiveInput();
            if (this.getComputers().getPitch().disabledOrFaulted() || pitchInput != null && !Intrinsics.areEqual((Object)pitchInput.getIdentifier(), (Object)AutopilotLogicComputer.Companion.getID())) {
                this.setAutoPilot(false, true);
            }
            ControlInput headingInput = this.getComputers().getHeading().getActiveInput();
            if (this.getComputers().getHeading().disabledOrFaulted() || headingInput != null && !Intrinsics.areEqual((Object)headingInput.getIdentifier(), (Object)AutopilotLogicComputer.Companion.getID())) {
                this.setAutoPilot(false, true);
            }
        }
    }

    public final void setFlightDirectors(boolean flightDirectors) {
        this.flightDirectors = flightDirectors;
    }

    public final void setAutoThrust(boolean autoThrust, @Nullable Boolean alert) {
        if (alert != null) {
            this.autoThrustAlert = this.autoThrust && !autoThrust && alert != false;
        }
        this.autoThrust = autoThrust;
    }

    public static /* synthetic */ void setAutoThrust$default(AutomationsComputer automationsComputer, boolean bl, Boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl2 = null;
        }
        automationsComputer.setAutoThrust(bl, bl2);
    }

    public final void setAutoPilot(boolean autopilot, @Nullable Boolean alert) {
        if (alert != null) {
            this.autopilotAlert = this.autopilot && !autopilot && alert != false;
        }
        this.autopilot = autopilot;
    }

    public static /* synthetic */ void setAutoPilot$default(AutomationsComputer automationsComputer, boolean bl, Boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl2 = null;
        }
        automationsComputer.setAutoPilot(bl, bl2);
    }

    @Override
    @Nullable
    public ControlInput getThrustInput() {
        if (!this.autoThrust) {
            return null;
        }
        return this.getComputers().getAutopilot().computeThrust();
    }

    @Override
    @Nullable
    public ControlInput getPitchInput() {
        if (!this.flightDirectors && !this.autopilot) {
            return null;
        }
        return this.getComputers().getAutopilot().computePitch(this.autopilot);
    }

    @Override
    @Nullable
    public ControlInput getHeadingInput() {
        if (!this.flightDirectors && !this.autopilot) {
            return null;
        }
        return this.getComputers().getAutopilot().computeHeading(this.autopilot);
    }

    @Override
    @Nullable
    public ControlInput getRollInput() {
        if (!this.autopilot) {
            return null;
        }
        return new ControlInput(0.0f, ControlInput.Priority.NORMAL, null, 0.0f, false, null, 60, null);
    }

    @Override
    public void reset() {
        this.flightDirectors = false;
        if (this.autoThrust) {
            this.autoThrustAlert = true;
        }
        this.autoThrust = false;
        if (this.autopilot) {
            this.autopilotAlert = true;
        }
        this.autopilot = false;
        this.pitchResistance = 0.0f;
        this.headingResistance = 0.0f;
    }

    private static final void subscribeToEvents$lambda$0(AutomationsComputer this$0, float pitchDelta, List output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        if (this$0.autopilot) {
            this$0.pitchResistance += Math.abs(pitchDelta);
            if (this$0.pitchResistance < 20.0f) {
                output.add(new ControlInput(0.0f, ControlInput.Priority.NORMAL, null, 0.0f, false, null, 60, null));
                return;
            }
            this$0.setAutoPilot(false, true);
        }
        this$0.pitchResistance = 0.0f;
    }

    private static final void subscribeToEvents$lambda$1(AutomationsComputer this$0, float headingDelta, List output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        if (this$0.autopilot) {
            this$0.headingResistance += Math.abs(headingDelta);
            if (this$0.headingResistance < 40.0f) {
                output.add(new ControlInput(0.0f, ControlInput.Priority.NORMAL, null, 0.0f, false, null, 60, null));
                return;
            }
            this$0.setAutoPilot(false, true);
        }
        this$0.headingResistance = 0.0f;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/autoflight/AutomationsComputer$Companion;", "", "<init>", "()V", "Lnet/minecraft/resources/ResourceLocation;", "ID", "Lnet/minecraft/resources/ResourceLocation;", "getID", "()Lnet/minecraft/resources/ResourceLocation;", "flightassistant-neoforge"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceLocation getID() {
            return ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

