/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.impl.computer.autoflight;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.RangesKt;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.octol1ttle.flightassistant.FlightAssistant;
import ru.octol1ttle.flightassistant.api.autoflight.ControlInput;
import ru.octol1ttle.flightassistant.api.computer.Computer;
import ru.octol1ttle.flightassistant.api.computer.ComputerView;
import ru.octol1ttle.flightassistant.api.util.MathHelperKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 '2\u00020\u0001:\u0004()*'B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\r\u0010\fJ\u000f\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0011\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0010R\"\u0010\u0013\u001a\u00020\u00128\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\"\u0010\u001a\u001a\u00020\u00198\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\"\u0010!\u001a\u00020 8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b!\u0010\"\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&\u00a8\u0006+"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/autoflight/AutopilotLogicComputer;", "Lru/octol1ttle/flightassistant/api/computer/Computer;", "Lru/octol1ttle/flightassistant/api/computer/ComputerView;", "computers", "<init>", "(Lru/octol1ttle/flightassistant/api/computer/ComputerView;)V", "Lru/octol1ttle/flightassistant/api/autoflight/ControlInput;", "computeThrust", "()Lru/octol1ttle/flightassistant/api/autoflight/ControlInput;", "", "active", "computePitch", "(Z)Lru/octol1ttle/flightassistant/api/autoflight/ControlInput;", "computeHeading", "", "tick", "()V", "reset", "Lru/octol1ttle/flightassistant/impl/computer/autoflight/AutopilotLogicComputer$ThrustMode;", "thrustMode", "Lru/octol1ttle/flightassistant/impl/computer/autoflight/AutopilotLogicComputer$ThrustMode;", "getThrustMode", "()Lru/octol1ttle/flightassistant/impl/computer/autoflight/AutopilotLogicComputer$ThrustMode;", "setThrustMode", "(Lru/octol1ttle/flightassistant/impl/computer/autoflight/AutopilotLogicComputer$ThrustMode;)V", "Lru/octol1ttle/flightassistant/impl/computer/autoflight/AutopilotLogicComputer$VerticalMode;", "verticalMode", "Lru/octol1ttle/flightassistant/impl/computer/autoflight/AutopilotLogicComputer$VerticalMode;", "getVerticalMode", "()Lru/octol1ttle/flightassistant/impl/computer/autoflight/AutopilotLogicComputer$VerticalMode;", "setVerticalMode", "(Lru/octol1ttle/flightassistant/impl/computer/autoflight/AutopilotLogicComputer$VerticalMode;)V", "Lru/octol1ttle/flightassistant/impl/computer/autoflight/AutopilotLogicComputer$LateralMode;", "lateralMode", "Lru/octol1ttle/flightassistant/impl/computer/autoflight/AutopilotLogicComputer$LateralMode;", "getLateralMode", "()Lru/octol1ttle/flightassistant/impl/computer/autoflight/AutopilotLogicComputer$LateralMode;", "setLateralMode", "(Lru/octol1ttle/flightassistant/impl/computer/autoflight/AutopilotLogicComputer$LateralMode;)V", "Companion", "ThrustMode", "VerticalMode", "LateralMode", "flightassistant-neoforge"})
public final class AutopilotLogicComputer
extends Computer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private ThrustMode thrustMode;
    @NotNull
    private VerticalMode verticalMode;
    @NotNull
    private LateralMode lateralMode;
    @NotNull
    private static final ResourceLocation ID = FlightAssistant.INSTANCE.id$flightassistant_neoforge("autopilot_logic");

    public AutopilotLogicComputer(@NotNull ComputerView computers) {
        Intrinsics.checkNotNullParameter((Object)computers, (String)"computers");
        super(computers);
        this.thrustMode = new ThrustMode(ThrustMode.Type.SelectedSpeed, 0.0f, null, null, 12, null);
        this.verticalMode = new VerticalMode(VerticalMode.Type.SelectedPitch, 0.0f);
        this.lateralMode = new LateralMode(LateralMode.Type.SelectedHeading, Float.valueOf(360.0f), null, null, 12, null);
    }

    @NotNull
    public final ThrustMode getThrustMode() {
        return this.thrustMode;
    }

    public final void setThrustMode(@NotNull ThrustMode thrustMode) {
        Intrinsics.checkNotNullParameter((Object)thrustMode, (String)"<set-?>");
        this.thrustMode = thrustMode;
    }

    @NotNull
    public final VerticalMode getVerticalMode() {
        return this.verticalMode;
    }

    public final void setVerticalMode(@NotNull VerticalMode verticalMode) {
        Intrinsics.checkNotNullParameter((Object)verticalMode, (String)"<set-?>");
        this.verticalMode = verticalMode;
    }

    @NotNull
    public final LateralMode getLateralMode() {
        return this.lateralMode;
    }

    public final void setLateralMode(@NotNull LateralMode lateralMode) {
        Intrinsics.checkNotNullParameter((Object)lateralMode, (String)"<set-?>");
        this.lateralMode = lateralMode;
    }

    @Nullable
    public final ControlInput computeThrust() {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.thrustMode.getType().ordinal()]) {
            case 1 -> {
                Float v0 = this.getComputers().getThrust().calculateThrustForSpeed(this.thrustMode.getSpeed());
                Object[] var1_1 = new Object[]{MathKt.roundToInt((float)this.thrustMode.getSpeed())};
                ControlInput v1 = new ControlInput(v0 != null ? v0.floatValue() : 0.0f, ControlInput.Priority.NORMAL, (Component)Component.translatable((String)"mode.flightassistant.thrust.selected_speed", (Object[])var1_1), 0.0f, false, ID, 24, null);
                yield v1;
            }
            case 2 -> {
                MutableComponent v7;
                float v5;
                boolean useClimbThrust;
                if (!this.verticalMode.isAltitude()) {
                    yield null;
                }
                boolean nearTarget = Math.abs((double)this.verticalMode.getPitchOrAltitude() - this.getComputers().getData().getAltitude()) <= 5.0;
                boolean v3 = useClimbThrust = nearTarget || (double)this.verticalMode.getPitchOrAltitude() > this.getComputers().getData().getAltitude();
                if (useClimbThrust) {
                    Float v4 = this.thrustMode.getClimbThrust();
                    Intrinsics.checkNotNull((Object)v4);
                    v5 = v4.floatValue();
                } else {
                    Float v6 = this.thrustMode.getDescendThrust();
                    Intrinsics.checkNotNull((Object)v6);
                    v5 = v6.floatValue();
                }
                if (useClimbThrust) {
                    v7 = Component.translatable((String)"mode.flightassistant.thrust.climb");
                } else {
                    Float v8 = this.thrustMode.getDescendThrust();
                    Intrinsics.checkNotNull((Object)v8);
                    v7 = !(v8.floatValue() == 0.0f) ? Component.translatable((String)"mode.flightassistant.thrust.descend") : Component.translatable((String)"mode.flightassistant.thrust.idle");
                }
                yield new ControlInput(v5, ControlInput.Priority.NORMAL, (Component)v7, 0.0f, false, ID, 24, null);
            }
            case 3 -> null;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Nullable
    public final ControlInput computePitch(boolean active) {
        return switch (WhenMappings.$EnumSwitchMapping$1[this.verticalMode.getType().ordinal()]) {
            case 1 -> {
                float v0 = this.verticalMode.getPitchOrAltitude();
                Object[] var2_2 = new Object[1];
                String var3_4 = "%.1f";
                Object[] var4_6 = new Object[]{Float.valueOf(this.verticalMode.getPitchOrAltitude())};
                Intrinsics.checkNotNullExpressionValue((Object)String.format(var3_4, Arrays.copyOf(var4_6, var4_6.length)), (String)"format(...)");
                ControlInput v1 = new ControlInput(v0, ControlInput.Priority.NORMAL, (Component)Component.translatable((String)"mode.flightassistant.vertical.selected_pitch", (Object[])var2_2), 0.0f, active, ID, 8, null);
                yield v1;
            }
            case 2 -> {
                Object[] var9_15;
                String var8_14;
                float diff = (float)((double)this.verticalMode.getPitchOrAltitude() - this.getComputers().getData().getAltitude());
                float abs = Math.abs(diff);
                float neutralPitch = this.getComputers().getThrust().getAltitudeHoldPitch();
                float finalPitch = 0.0f;
                Component text = null;
                if (diff >= 0.0f) {
                    finalPitch = this.getComputers().getThrust().getOptimumClimbPitch();
                    Object[] var7_10 = new Object[1];
                    var8_14 = "%.0f";
                    var9_15 = new Object[]{Float.valueOf(this.verticalMode.getPitchOrAltitude())};
                    Intrinsics.checkNotNullExpressionValue((Object)String.format(var8_14, Arrays.copyOf(var9_15, var9_15.length)), (String)"format(...)");
                    text = (Component)Component.translatable((String)"mode.flightassistant.vertical.selected_altitude.climb", (Object[])var7_10);
                    distanceFromNeutral2 = finalPitch - neutralPitch;
                    finalPitch -= distanceFromNeutral2 * 0.6f * ((Number)((Object)RangesKt.coerceIn((Comparable)Float.valueOf((200.0f - abs) / 100.0f), (ClosedFloatingPointRange)RangesKt.rangeTo((float)0.0f, (float)1.0f)))).floatValue();
                    finalPitch -= distanceFromNeutral2 * 0.4f * ((Number)((Object)RangesKt.coerceIn((Comparable)Float.valueOf((100.0f - abs) / 100.0f), (ClosedFloatingPointRange)RangesKt.rangeTo((float)0.0f, (float)1.0f)))).floatValue();
                } else {
                    finalPitch = -35.0f;
                    Object[] distanceFromNeutral = new Object[1];
                    var8_14 = "%.0f";
                    var9_15 = new Object[]{Float.valueOf(this.verticalMode.getPitchOrAltitude())};
                    Intrinsics.checkNotNullExpressionValue((Object)String.format(var8_14, Arrays.copyOf(var9_15, var9_15.length)), (String)"format(...)");
                    text = (Component)Component.translatable((String)"mode.flightassistant.vertical.selected_altitude.descend", (Object[])distanceFromNeutral);
                    distanceFromNeutral2 = finalPitch - neutralPitch;
                    finalPitch -= distanceFromNeutral2 * 0.4f * ((Number)((Object)RangesKt.coerceIn((Comparable)Float.valueOf((100.0f - abs) / 50.0f), (ClosedFloatingPointRange)RangesKt.rangeTo((float)0.0f, (float)1.0f)))).floatValue();
                    finalPitch -= distanceFromNeutral2 * 0.6f * ((Number)((Object)RangesKt.coerceIn((Comparable)Float.valueOf((50.0f - abs) / 50.0f), (ClosedFloatingPointRange)RangesKt.rangeTo((float)0.0f, (float)1.0f)))).floatValue();
                }
                if (abs <= 5.0f) {
                    Object[] var7_13 = new Object[1];
                    var8_14 = "%.0f";
                    var9_15 = new Object[]{Float.valueOf(this.verticalMode.getPitchOrAltitude())};
                    Intrinsics.checkNotNullExpressionValue((Object)String.format(var8_14, Arrays.copyOf(var9_15, var9_15.length)), (String)"format(...)");
                    text = (Component)Component.translatable((String)"mode.flightassistant.vertical.selected_altitude.hold", (Object[])var7_13);
                }
                yield new ControlInput(finalPitch, ControlInput.Priority.NORMAL, text, 1.5f, active, ID);
            }
            case 3 -> null;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Nullable
    public final ControlInput computeHeading(boolean active) {
        return switch (WhenMappings.$EnumSwitchMapping$2[this.lateralMode.getType().ordinal()]) {
            case 1 -> {
                Float v0 = this.lateralMode.getHeading();
                Intrinsics.checkNotNull((Object)v0);
                float v1 = v0.floatValue();
                Object[] var2_2 = new Object[1];
                String var3_4 = "%.0f";
                Object[] var4_6 = new Object[1];
                Intrinsics.checkNotNull((Object)this.lateralMode.getHeading());
                Intrinsics.checkNotNullExpressionValue((Object)String.format(var3_4, Arrays.copyOf(var4_6, var4_6.length)), (String)"format(...)");
                ControlInput v2 = new ControlInput(v1, ControlInput.Priority.NORMAL, (Component)Component.translatable((String)"mode.flightassistant.lateral.selected_heading", (Object[])var2_2), 0.0f, active, ID, 8, null);
                yield v2;
            }
            case 2 -> {
                Double v4 = this.lateralMode.getX();
                Intrinsics.checkNotNull((Object)v4);
                double v5 = -(v4 - this.getComputers().getData().getPosition().x);
                Double v6 = this.lateralMode.getZ();
                Intrinsics.checkNotNull((Object)v6);
                float v7 = (float)MathHelperKt.degrees(Math.atan2(v5, v6 - this.getComputers().getData().getPosition().z)) + 180.0f;
                Object[] var2_3 = new Object[2];
                String var3_5 = "%.0f";
                Object[] var4_7 = new Object[1];
                Intrinsics.checkNotNull((Object)this.lateralMode.getX());
                Intrinsics.checkNotNullExpressionValue((Object)String.format(var3_5, Arrays.copyOf(var4_7, var4_7.length)), (String)"format(...)");
                var3_5 = "%.0f";
                var4_7 = new Object[1];
                Intrinsics.checkNotNull((Object)this.lateralMode.getZ());
                Intrinsics.checkNotNullExpressionValue((Object)String.format(var3_5, Arrays.copyOf(var4_7, var4_7.length)), (String)"format(...)");
                ControlInput v8 = new ControlInput(v7, ControlInput.Priority.NORMAL, (Component)Component.translatable((String)"mode.flightassistant.lateral.selected_coordinates", (Object[])var2_3), 0.0f, active, ID, 8, null);
                yield v8;
            }
            case 3 -> null;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Override
    public void tick() {
    }

    @Override
    public void reset() {
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/autoflight/AutopilotLogicComputer$Companion;", "", "<init>", "()V", "Lnet/minecraft/resources/ResourceLocation;", "ID", "Lnet/minecraft/resources/ResourceLocation;", "getID", "()Lnet/minecraft/resources/ResourceLocation;", "flightassistant-neoforge"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceLocation getID() {
            return ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0017\u0018\u00002\u00020\u0001:\u0001\u001cB3\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\t\u0010\nR\"\u0010\u0003\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010\u000b\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR$\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R$\u0010\u0007\u001a\u0004\u0018\u00010\u00068\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0007\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R$\u0010\b\u001a\u0004\u0018\u00010\u00068\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\b\u0010\u0015\u001a\u0004\b\u001a\u0010\u0017\"\u0004\b\u001b\u0010\u0019\u00a8\u0006\u001d"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/autoflight/AutopilotLogicComputer$LateralMode;", "", "Lru/octol1ttle/flightassistant/impl/computer/autoflight/AutopilotLogicComputer$LateralMode$Type;", "type", "", "heading", "", "x", "z", "<init>", "(Lru/octol1ttle/flightassistant/impl/computer/autoflight/AutopilotLogicComputer$LateralMode$Type;Ljava/lang/Float;Ljava/lang/Double;Ljava/lang/Double;)V", "Lru/octol1ttle/flightassistant/impl/computer/autoflight/AutopilotLogicComputer$LateralMode$Type;", "getType", "()Lru/octol1ttle/flightassistant/impl/computer/autoflight/AutopilotLogicComputer$LateralMode$Type;", "setType", "(Lru/octol1ttle/flightassistant/impl/computer/autoflight/AutopilotLogicComputer$LateralMode$Type;)V", "Ljava/lang/Float;", "getHeading", "()Ljava/lang/Float;", "setHeading", "(Ljava/lang/Float;)V", "Ljava/lang/Double;", "getX", "()Ljava/lang/Double;", "setX", "(Ljava/lang/Double;)V", "getZ", "setZ", "Type", "flightassistant-neoforge"})
    public static final class LateralMode {
        @NotNull
        private Type type;
        @Nullable
        private Float heading;
        @Nullable
        private Double x;
        @Nullable
        private Double z;

        public LateralMode(@NotNull Type type, @Nullable Float heading, @Nullable Double x, @Nullable Double z) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            this.type = type;
            this.heading = heading;
            this.x = x;
            this.z = z;
        }

        public /* synthetic */ LateralMode(Type type, Float f, Double d, Double d2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                f = null;
            }
            if ((n & 4) != 0) {
                d = null;
            }
            if ((n & 8) != 0) {
                d2 = null;
            }
            this(type, f, d, d2);
        }

        @NotNull
        public final Type getType() {
            return this.type;
        }

        public final void setType(@NotNull Type type) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"<set-?>");
            this.type = type;
        }

        @Nullable
        public final Float getHeading() {
            return this.heading;
        }

        public final void setHeading(@Nullable Float f) {
            this.heading = f;
        }

        @Nullable
        public final Double getX() {
            return this.x;
        }

        public final void setX(@Nullable Double d) {
            this.x = d;
        }

        @Nullable
        public final Double getZ() {
            return this.z;
        }

        public final void setZ(@Nullable Double d) {
            this.z = d;
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/autoflight/AutopilotLogicComputer$LateralMode$Type;", "", "<init>", "(Ljava/lang/String;I)V", "SelectedHeading", "SelectedCoordinates", "WaypointCoordinates", "flightassistant-neoforge"})
        public static final class Type
        extends Enum<Type> {
            public static final /* enum */ Type SelectedHeading = new Type();
            public static final /* enum */ Type SelectedCoordinates = new Type();
            public static final /* enum */ Type WaypointCoordinates = new Type();
            private static final /* synthetic */ Type[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static Type[] values() {
                return (Type[])$VALUES.clone();
            }

            public static Type valueOf(String value) {
                return Enum.valueOf(Type.class, value);
            }

            @NotNull
            public static EnumEntries<Type> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = typeArray = new Type[]{Type.SelectedHeading, Type.SelectedCoordinates, Type.WaypointCoordinates};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0018\u0018\u00002\u00020\u0001:\u0001\u001bB/\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0004\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\b\u0010\tR\"\u0010\u0003\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010\n\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\"\u0010\u0005\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R$\u0010\u0006\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0006\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R$\u0010\u0007\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0007\u0010\u0014\u001a\u0004\b\u0019\u0010\u0016\"\u0004\b\u001a\u0010\u0018\u00a8\u0006\u001c"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/autoflight/AutopilotLogicComputer$ThrustMode;", "", "Lru/octol1ttle/flightassistant/impl/computer/autoflight/AutopilotLogicComputer$ThrustMode$Type;", "type", "", "speed", "climbThrust", "descendThrust", "<init>", "(Lru/octol1ttle/flightassistant/impl/computer/autoflight/AutopilotLogicComputer$ThrustMode$Type;FLjava/lang/Float;Ljava/lang/Float;)V", "Lru/octol1ttle/flightassistant/impl/computer/autoflight/AutopilotLogicComputer$ThrustMode$Type;", "getType", "()Lru/octol1ttle/flightassistant/impl/computer/autoflight/AutopilotLogicComputer$ThrustMode$Type;", "setType", "(Lru/octol1ttle/flightassistant/impl/computer/autoflight/AutopilotLogicComputer$ThrustMode$Type;)V", "F", "getSpeed", "()F", "setSpeed", "(F)V", "Ljava/lang/Float;", "getClimbThrust", "()Ljava/lang/Float;", "setClimbThrust", "(Ljava/lang/Float;)V", "getDescendThrust", "setDescendThrust", "Type", "flightassistant-neoforge"})
    public static final class ThrustMode {
        @NotNull
        private Type type;
        private float speed;
        @Nullable
        private Float climbThrust;
        @Nullable
        private Float descendThrust;

        public ThrustMode(@NotNull Type type, float speed, @Nullable Float climbThrust, @Nullable Float descendThrust) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            this.type = type;
            this.speed = speed;
            this.climbThrust = climbThrust;
            this.descendThrust = descendThrust;
        }

        public /* synthetic */ ThrustMode(Type type, float f, Float f2, Float f3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                f2 = null;
            }
            if ((n & 8) != 0) {
                f3 = null;
            }
            this(type, f, f2, f3);
        }

        @NotNull
        public final Type getType() {
            return this.type;
        }

        public final void setType(@NotNull Type type) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"<set-?>");
            this.type = type;
        }

        public final float getSpeed() {
            return this.speed;
        }

        public final void setSpeed(float f) {
            this.speed = f;
        }

        @Nullable
        public final Float getClimbThrust() {
            return this.climbThrust;
        }

        public final void setClimbThrust(@Nullable Float f) {
            this.climbThrust = f;
        }

        @Nullable
        public final Float getDescendThrust() {
            return this.descendThrust;
        }

        public final void setDescendThrust(@Nullable Float f) {
            this.descendThrust = f;
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/autoflight/AutopilotLogicComputer$ThrustMode$Type;", "", "<init>", "(Ljava/lang/String;I)V", "SelectedSpeed", "VerticalTarget", "WaypointThrust", "flightassistant-neoforge"})
        public static final class Type
        extends Enum<Type> {
            public static final /* enum */ Type SelectedSpeed = new Type();
            public static final /* enum */ Type VerticalTarget = new Type();
            public static final /* enum */ Type WaypointThrust = new Type();
            private static final /* synthetic */ Type[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static Type[] values() {
                return (Type[])$VALUES.clone();
            }

            public static Type valueOf(String value) {
                return Enum.valueOf(Type.class, value);
            }

            @NotNull
            public static EnumEntries<Type> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = typeArray = new Type[]{Type.SelectedSpeed, Type.VerticalTarget, Type.WaypointThrust};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000e\u0018\u00002\u00020\u0001:\u0001\u0015B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nR\"\u0010\u0003\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010\u000b\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\"\u0010\u0005\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0016"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/autoflight/AutopilotLogicComputer$VerticalMode;", "", "Lru/octol1ttle/flightassistant/impl/computer/autoflight/AutopilotLogicComputer$VerticalMode$Type;", "type", "", "pitchOrAltitude", "<init>", "(Lru/octol1ttle/flightassistant/impl/computer/autoflight/AutopilotLogicComputer$VerticalMode$Type;F)V", "", "isAltitude", "()Z", "Lru/octol1ttle/flightassistant/impl/computer/autoflight/AutopilotLogicComputer$VerticalMode$Type;", "getType", "()Lru/octol1ttle/flightassistant/impl/computer/autoflight/AutopilotLogicComputer$VerticalMode$Type;", "setType", "(Lru/octol1ttle/flightassistant/impl/computer/autoflight/AutopilotLogicComputer$VerticalMode$Type;)V", "F", "getPitchOrAltitude", "()F", "setPitchOrAltitude", "(F)V", "Type", "flightassistant-neoforge"})
    public static final class VerticalMode {
        @NotNull
        private Type type;
        private float pitchOrAltitude;

        public VerticalMode(@NotNull Type type, float pitchOrAltitude) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            this.type = type;
            this.pitchOrAltitude = pitchOrAltitude;
        }

        @NotNull
        public final Type getType() {
            return this.type;
        }

        public final void setType(@NotNull Type type) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"<set-?>");
            this.type = type;
        }

        public final float getPitchOrAltitude() {
            return this.pitchOrAltitude;
        }

        public final void setPitchOrAltitude(float f) {
            this.pitchOrAltitude = f;
        }

        public final boolean isAltitude() {
            return this.type == Type.SelectedAltitude || this.type == Type.WaypointAltitude;
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/autoflight/AutopilotLogicComputer$VerticalMode$Type;", "", "<init>", "(Ljava/lang/String;I)V", "SelectedPitch", "SelectedAltitude", "WaypointAltitude", "flightassistant-neoforge"})
        public static final class Type
        extends Enum<Type> {
            public static final /* enum */ Type SelectedPitch = new Type();
            public static final /* enum */ Type SelectedAltitude = new Type();
            public static final /* enum */ Type WaypointAltitude = new Type();
            private static final /* synthetic */ Type[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static Type[] values() {
                return (Type[])$VALUES.clone();
            }

            public static Type valueOf(String value) {
                return Enum.valueOf(Type.class, value);
            }

            @NotNull
            public static EnumEntries<Type> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = typeArray = new Type[]{Type.SelectedPitch, Type.SelectedAltitude, Type.WaypointAltitude};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[ThrustMode.Type.values().length];
            try {
                nArray[ThrustMode.Type.SelectedSpeed.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ThrustMode.Type.VerticalTarget.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ThrustMode.Type.WaypointThrust.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[VerticalMode.Type.values().length];
            try {
                nArray[VerticalMode.Type.SelectedPitch.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VerticalMode.Type.SelectedAltitude.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VerticalMode.Type.WaypointAltitude.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[LateralMode.Type.values().length];
            try {
                nArray[LateralMode.Type.SelectedHeading.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LateralMode.Type.SelectedCoordinates.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LateralMode.Type.WaypointCoordinates.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

