/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.impl.computer.autoflight;

import dev.architectury.event.CompoundEventResult;
import dev.architectury.event.events.common.InteractionEvent;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.RangesKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.FireworkRocketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.Fireworks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.octol1ttle.flightassistant.FlightAssistant;
import ru.octol1ttle.flightassistant.api.autoflight.thrust.ThrustSource;
import ru.octol1ttle.flightassistant.api.autoflight.thrust.ThrustSourceRegistrationCallback;
import ru.octol1ttle.flightassistant.api.computer.Computer;
import ru.octol1ttle.flightassistant.api.computer.ComputerView;
import ru.octol1ttle.flightassistant.api.util.FATickCounter;
import ru.octol1ttle.flightassistant.api.util.LimitedFIFOQueue;
import ru.octol1ttle.flightassistant.api.util.event.FireworkBoostCallback;
import ru.octol1ttle.flightassistant.config.FAConfig;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 K2\u00020\u00012\u00020\u0002:\u0001KB\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\f\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\f\u0010\u000bJ\u001d\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0017J\u0017\u0010\u0019\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001f\u0010\u001b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u000f\u0010\u001d\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0017\u0010!\u001a\u00020\t2\u0006\u0010 \u001a\u00020\u001fH\u0016\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010$\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u001fH\u0016\u00a2\u0006\u0004\b$\u0010%J\u000f\u0010&\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b&\u0010\u000bR\u0014\u0010\u0006\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010'R\u001a\u0010)\u001a\u00020(8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b)\u0010*\u001a\u0004\b+\u0010,R\u001a\u0010-\u001a\u00020\u00118\u0016X\u0096D\u00a2\u0006\f\n\u0004\b-\u0010.\u001a\u0004\b/\u0010\u001eR\u001a\u00100\u001a\u00020\u001f8\u0016X\u0096D\u00a2\u0006\f\n\u0004\b0\u00101\u001a\u0004\b2\u00103R\u001a\u00104\u001a\u00020\u001f8\u0016X\u0096D\u00a2\u0006\f\n\u0004\b4\u00101\u001a\u0004\b5\u00103R\u0016\u00107\u001a\u0002068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b7\u00108R\u0018\u00109\u001a\u0004\u0018\u0001068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b9\u0010:R\"\u0010;\u001a\u00020\u00118\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b;\u0010.\u001a\u0004\b<\u0010\u001e\"\u0004\b=\u0010>R\"\u0010?\u001a\u0002068\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b?\u00108\u001a\u0004\b@\u0010A\"\u0004\bB\u0010CR(\u0010E\u001a\b\u0012\u0004\u0012\u0002060D8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bE\u0010F\u001a\u0004\bG\u0010H\"\u0004\bI\u0010J\u00a8\u0006L"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/autoflight/FireworkComputer;", "Lru/octol1ttle/flightassistant/api/computer/Computer;", "Lru/octol1ttle/flightassistant/api/autoflight/thrust/ThrustSource;", "Lru/octol1ttle/flightassistant/api/computer/ComputerView;", "computers", "Lnet/minecraft/client/Minecraft;", "mc", "<init>", "(Lru/octol1ttle/flightassistant/api/computer/ComputerView;Lnet/minecraft/client/Minecraft;)V", "", "subscribeToEvents", "()V", "tick", "Lnet/minecraft/world/entity/player/Player;", "player", "Lnet/minecraft/world/InteractionHand;", "hand", "", "isEmptyOrSafe", "(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Z", "Lnet/minecraft/world/item/ItemStack;", "stack", "isFireworkAndSafe", "(Lnet/minecraft/world/item/ItemStack;)Z", "hasNoExplosions", "tryActivateFirework", "(Lnet/minecraft/world/entity/player/Player;)V", "useFirework", "(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)V", "isAvailable", "()Z", "", "currentThrust", "tickThrust", "(F)V", "targetSpeed", "calculateThrustForSpeed", "(F)F", "reset", "Lnet/minecraft/client/Minecraft;", "Lru/octol1ttle/flightassistant/api/autoflight/thrust/ThrustSource$Priority;", "priority", "Lru/octol1ttle/flightassistant/api/autoflight/thrust/ThrustSource$Priority;", "getPriority", "()Lru/octol1ttle/flightassistant/api/autoflight/thrust/ThrustSource$Priority;", "supportsReverse", "Z", "getSupportsReverse", "optimumClimbPitch", "F", "getOptimumClimbPitch", "()F", "altitudeHoldPitch", "getAltitudeHoldPitch", "", "safeFireworkCount", "I", "safeFireworkSlot", "Ljava/lang/Integer;", "waitingForResponse", "getWaitingForResponse", "setWaitingForResponse", "(Z)V", "lastActivationTime", "getLastActivationTime", "()I", "setLastActivationTime", "(I)V", "Lru/octol1ttle/flightassistant/api/util/LimitedFIFOQueue;", "responseTimes", "Lru/octol1ttle/flightassistant/api/util/LimitedFIFOQueue;", "getResponseTimes", "()Lru/octol1ttle/flightassistant/api/util/LimitedFIFOQueue;", "setResponseTimes", "(Lru/octol1ttle/flightassistant/api/util/LimitedFIFOQueue;)V", "Companion", "flightassistant-neoforge"})
public final class FireworkComputer
extends Computer
implements ThrustSource {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Minecraft mc;
    @NotNull
    private final ThrustSource.Priority priority;
    private final boolean supportsReverse;
    private final float optimumClimbPitch;
    private final float altitudeHoldPitch;
    private int safeFireworkCount;
    @Nullable
    private Integer safeFireworkSlot;
    private boolean waitingForResponse;
    private int lastActivationTime;
    @NotNull
    private LimitedFIFOQueue<Integer> responseTimes;
    @NotNull
    private static final ResourceLocation ID = FlightAssistant.INSTANCE.id$flightassistant_neoforge("firework");

    public FireworkComputer(@NotNull ComputerView computers, @NotNull Minecraft mc) {
        Intrinsics.checkNotNullParameter((Object)computers, (String)"computers");
        Intrinsics.checkNotNullParameter((Object)mc, (String)"mc");
        super(computers);
        this.mc = mc;
        this.priority = ThrustSource.Priority.LOW;
        this.optimumClimbPitch = 55.0f;
        this.altitudeHoldPitch = 2.0f;
        this.responseTimes = new LimitedFIFOQueue(5);
    }

    @Override
    @NotNull
    public ThrustSource.Priority getPriority() {
        return this.priority;
    }

    @Override
    public boolean getSupportsReverse() {
        return this.supportsReverse;
    }

    @Override
    public float getOptimumClimbPitch() {
        return this.optimumClimbPitch;
    }

    @Override
    public float getAltitudeHoldPitch() {
        return this.altitudeHoldPitch;
    }

    public final boolean getWaitingForResponse() {
        return this.waitingForResponse;
    }

    public final void setWaitingForResponse(boolean bl) {
        this.waitingForResponse = bl;
    }

    public final int getLastActivationTime() {
        return this.lastActivationTime;
    }

    public final void setLastActivationTime(int n) {
        this.lastActivationTime = n;
    }

    @NotNull
    public final LimitedFIFOQueue<Integer> getResponseTimes() {
        return this.responseTimes;
    }

    public final void setResponseTimes(@NotNull LimitedFIFOQueue<Integer> limitedFIFOQueue) {
        Intrinsics.checkNotNullParameter(limitedFIFOQueue, (String)"<set-?>");
        this.responseTimes = limitedFIFOQueue;
    }

    @Override
    public void subscribeToEvents() {
        ThrustSourceRegistrationCallback.EVENT.register((Object)new ThrustSourceRegistrationCallback(this){
            final /* synthetic */ FireworkComputer this$0;
            {
                this.this$0 = $receiver;
            }

            public final void register(Consumer<ThrustSource> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                it.accept(this.this$0);
            }
        });
        InteractionEvent.RIGHT_CLICK_ITEM.register((arg_0, arg_1) -> FireworkComputer.subscribeToEvents$lambda$0(this, arg_0, arg_1));
        FireworkBoostCallback.EVENT.register((Object)new FireworkBoostCallback(this){
            final /* synthetic */ FireworkComputer this$0;
            {
                this.this$0 = $receiver;
            }

            public final void onFireworkBoost(FireworkRocketEntity fireworkRocketEntity, LocalPlayer localPlayer) {
                Intrinsics.checkNotNullParameter((Object)localPlayer, (String)"<unused var>");
                if (this.this$0.getWaitingForResponse()) {
                    this.this$0.setWaitingForResponse(false);
                    this.this$0.getResponseTimes().add(FATickCounter.INSTANCE.getTotalTicks() - this.this$0.getLastActivationTime());
                }
            }
        });
    }

    @Override
    public void tick() {
        if (!this.getComputers().getData().getFlying()) {
            this.waitingForResponse = false;
        }
        this.safeFireworkCount = 0;
        this.safeFireworkSlot = null;
        int lastSlotCount = 0;
        int n = Inventory.getSelectionSize();
        for (int slot = 0; slot < n; ++slot) {
            ItemStack stack;
            Intrinsics.checkNotNullExpressionValue((Object)this.getComputers().getData().getPlayer().getInventory().getItem(slot), (String)"getStack(...)");
            if (!this.isFireworkAndSafe(stack)) continue;
            this.safeFireworkCount += stack.getCount();
            if (this.safeFireworkSlot != null && stack.getCount() >= lastSlotCount) continue;
            this.safeFireworkSlot = slot;
            lastSlotCount = stack.getCount();
        }
    }

    public final boolean isEmptyOrSafe(@NotNull Player player, @NotNull InteractionHand hand) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        ItemStack itemStack = player.getItemInHand(hand);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getStackInHand(...)");
        return this.hasNoExplosions(itemStack);
    }

    private final boolean isFireworkAndSafe(ItemStack stack) {
        return stack.getItem() instanceof FireworkRocketItem && this.hasNoExplosions(stack);
    }

    private final boolean hasNoExplosions(ItemStack stack) {
        Object object = (Fireworks)stack.get(DataComponents.FIREWORKS);
        return !(object != null && (object = object.explosions()) != null ? !object.isEmpty() : false);
    }

    private final void tryActivateFirework(Player player) {
        if (FATickCounter.INSTANCE.getTotalTicks() < this.lastActivationTime + 10) {
            return;
        }
        ItemStack itemStack = player.getOffhandItem();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getOffHandStack(...)");
        if (this.isFireworkAndSafe(itemStack)) {
            this.useFirework(player, InteractionHand.OFF_HAND);
        } else if (this.safeFireworkSlot != null) {
            Inventory inventory = player.getInventory();
            Integer n = this.safeFireworkSlot;
            Intrinsics.checkNotNull((Object)n);
            inventory.selected = n;
            this.useFirework(player, InteractionHand.MAIN_HAND);
        }
    }

    private final void useFirework(Player player, InteractionHand hand) {
        MultiPlayerGameMode multiPlayerGameMode = this.mc.gameMode;
        Intrinsics.checkNotNull((Object)multiPlayerGameMode);
        multiPlayerGameMode.useItem(player, hand);
        this.lastActivationTime = FATickCounter.INSTANCE.getTotalTicks();
        this.waitingForResponse = true;
    }

    @Override
    public boolean isAvailable() {
        return this.safeFireworkCount > 0;
    }

    @Override
    public void tickThrust(float currentThrust) {
        if ((double)currentThrust > this.getComputers().getData().getForwardVelocity().length() * (double)20.0f / (double)30.0f) {
            this.tryActivateFirework((Player)this.getComputers().getData().getPlayer());
        }
    }

    @Override
    public float calculateThrustForSpeed(float targetSpeed) {
        return ((Number)((Object)RangesKt.coerceIn((Comparable)Float.valueOf(targetSpeed / 30.0f), (ClosedFloatingPointRange)RangesKt.rangeTo((float)0.0f, (float)1.0f)))).floatValue();
    }

    @Override
    public void reset() {
        this.safeFireworkCount = 0;
        this.safeFireworkSlot = null;
        this.waitingForResponse = false;
        this.lastActivationTime = 0;
        this.responseTimes.clear();
    }

    private static final CompoundEventResult subscribeToEvents$lambda$0(FireworkComputer this$0, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getStackInHand(...)");
        ItemStack stack = itemStack;
        if (!player.level().isClientSide()) {
            return CompoundEventResult.pass();
        }
        if (FAConfig.INSTANCE.getSafety().getFireworkLockExplosive()) {
            Intrinsics.checkNotNull((Object)player);
            Intrinsics.checkNotNull((Object)hand);
            if (!this$0.isEmptyOrSafe(player, hand)) {
                return CompoundEventResult.interruptFalse((Object)stack);
            }
        }
        if (!this$0.waitingForResponse && stack.getItem() instanceof FireworkRocketItem) {
            this$0.lastActivationTime = FATickCounter.INSTANCE.getTotalTicks();
            this$0.waitingForResponse = true;
        }
        return CompoundEventResult.pass();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/autoflight/FireworkComputer$Companion;", "", "<init>", "()V", "Lnet/minecraft/resources/ResourceLocation;", "ID", "Lnet/minecraft/resources/ResourceLocation;", "getID", "()Lnet/minecraft/resources/ResourceLocation;", "flightassistant-neoforge"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceLocation getID() {
            return ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

