/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.impl.computer.autoflight;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.RangesKt;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.octol1ttle.flightassistant.FlightAssistant;
import ru.octol1ttle.flightassistant.api.autoflight.ControlInput;
import ru.octol1ttle.flightassistant.api.autoflight.FlightController;
import ru.octol1ttle.flightassistant.api.autoflight.heading.HeadingControllerRegistrationCallback;
import ru.octol1ttle.flightassistant.api.computer.Computer;
import ru.octol1ttle.flightassistant.api.computer.ComputerView;
import ru.octol1ttle.flightassistant.api.util.FATickCounter;
import ru.octol1ttle.flightassistant.api.util.MathHelperKt;
import ru.octol1ttle.flightassistant.api.util.extensions.CollectionExtensionsKt;
import ru.octol1ttle.flightassistant.impl.computer.AirDataComputer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\bJ/\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0012\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0012\u0010\bR\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00138\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016R(\u0010\u0019\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00178\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001e"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/autoflight/HeadingComputer;", "Lru/octol1ttle/flightassistant/api/computer/Computer;", "Lru/octol1ttle/flightassistant/api/computer/ComputerView;", "computers", "<init>", "(Lru/octol1ttle/flightassistant/api/computer/ComputerView;)V", "", "invokeEvents", "()V", "tick", "Lnet/minecraft/world/entity/player/Player;", "player", "", "current", "target", "deltaTimeMultiplier", "smoothSetHeading", "(Lnet/minecraft/world/entity/player/Player;FFF)V", "reset", "", "Lru/octol1ttle/flightassistant/api/autoflight/FlightController;", "controllers", "Ljava/util/List;", "Lru/octol1ttle/flightassistant/api/autoflight/ControlInput;", "value", "activeInput", "Lru/octol1ttle/flightassistant/api/autoflight/ControlInput;", "getActiveInput", "()Lru/octol1ttle/flightassistant/api/autoflight/ControlInput;", "Companion", "flightassistant-neoforge"})
@SourceDebugExtension(value={"SMAP\nHeadingComputer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HeadingComputer.kt\nru/octol1ttle/flightassistant/impl/computer/autoflight/HeadingComputer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,67:1\n1611#2,9:68\n1863#2:77\n1864#2:79\n1620#2:80\n1053#2:81\n1#3:78\n*S KotlinDebug\n*F\n+ 1 HeadingComputer.kt\nru/octol1ttle/flightassistant/impl/computer/autoflight/HeadingComputer\n*L\n28#1:68,9\n28#1:77\n28#1:79\n28#1:80\n28#1:81\n28#1:78\n*E\n"})
public final class HeadingComputer
extends Computer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<FlightController> controllers;
    @Nullable
    private ControlInput activeInput;
    @NotNull
    private static final ResourceLocation ID = FlightAssistant.INSTANCE.id$flightassistant_neoforge("heading");

    public HeadingComputer(@NotNull ComputerView computers) {
        Intrinsics.checkNotNullParameter((Object)computers, (String)"computers");
        super(computers);
        this.controllers = new ArrayList();
    }

    @Nullable
    public final ControlInput getActiveInput() {
        return this.activeInput;
    }

    @Override
    public void invokeEvents() {
        ((HeadingControllerRegistrationCallback)HeadingControllerRegistrationCallback.EVENT.invoker()).register(p0 -> this.controllers.add((FlightController)p0));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void tick() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = CollectionExtensionsKt.filterNonFaulted(this.controllers);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ControlInput it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            FlightController it = (FlightController)element$iv$iv;
            boolean bl2 = false;
            if (it.getHeadingInput() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        List inputs = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ControlInput it = (ControlInput)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getPriority().getValue());
                it = (ControlInput)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getPriority().getValue()));
            }
        });
        if (inputs.isEmpty()) {
            this.activeInput = null;
            return;
        }
        float heading = this.getComputers().getData().getHeading();
        ControlInput finalInput = (ControlInput)CollectionsKt.firstOrNull(CollectionExtensionsKt.getActiveHighestPriority(inputs));
        if (finalInput == null) {
            this.activeInput = null;
            return;
        }
        this.activeInput = finalInput;
        if (AirDataComputer.automationsAllowed$default(this.getComputers().getData(), false, 1, null) && finalInput.getActive()) {
            this.smoothSetHeading((Player)this.getComputers().getData().getPlayer(), heading, MathHelperKt.requireIn(finalInput.getTarget(), (ClosedFloatingPointRange<Float>)RangesKt.rangeTo((float)0.0f, (float)360.0f)), MathHelperKt.requireIn(finalInput.getDeltaTimeMultiplier(), (ClosedFloatingPointRange<Float>)RangesKt.rangeTo((float)0.001f, (float)Float.MAX_VALUE)));
        }
    }

    private final void smoothSetHeading(Player player, float current, float target, float deltaTimeMultiplier) {
        float diff = MathHelperKt.findShortestPath(current, target, 360.0f);
        float closeDistanceMultiplier = diff == 0.0f ? 1.0f : RangesKt.coerceAtLeast((float)(1.0f / Math.abs(diff)), (float)1.0f);
        float delta = diff * ((Number)((Object)RangesKt.coerceIn((Comparable)Float.valueOf(FATickCounter.INSTANCE.getTimePassed() * deltaTimeMultiplier * closeDistanceMultiplier), (ClosedFloatingPointRange)RangesKt.rangeTo((float)0.0f, (float)1.0f)))).floatValue();
        player.setYRot(player.getYRot() + delta);
        player.yRotO += delta;
    }

    @Override
    public void reset() {
        this.activeInput = null;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/autoflight/HeadingComputer$Companion;", "", "<init>", "()V", "Lnet/minecraft/resources/ResourceLocation;", "ID", "Lnet/minecraft/resources/ResourceLocation;", "getID", "()Lnet/minecraft/resources/ResourceLocation;", "flightassistant-neoforge"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceLocation getID() {
            return ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

