/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.impl.computer.autoflight;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.RangesKt;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import ru.octol1ttle.flightassistant.FlightAssistant;
import ru.octol1ttle.flightassistant.api.autoflight.ControlInput;
import ru.octol1ttle.flightassistant.api.autoflight.FlightController;
import ru.octol1ttle.flightassistant.api.autoflight.roll.RollControllerRegistrationCallback;
import ru.octol1ttle.flightassistant.api.autoflight.roll.RollSource;
import ru.octol1ttle.flightassistant.api.autoflight.roll.RollSourceRegistrationCallback;
import ru.octol1ttle.flightassistant.api.computer.Computer;
import ru.octol1ttle.flightassistant.api.computer.ComputerView;
import ru.octol1ttle.flightassistant.api.util.FATickCounter;
import ru.octol1ttle.flightassistant.api.util.MathHelperKt;
import ru.octol1ttle.flightassistant.api.util.extensions.CollectionExtensionsKt;
import ru.octol1ttle.flightassistant.impl.computer.AirDataComputer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\bJ'\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0011\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0011\u0010\bR\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0014\u00a8\u0006\u0018"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/autoflight/RollComputer;", "Lru/octol1ttle/flightassistant/api/computer/Computer;", "Lru/octol1ttle/flightassistant/api/computer/ComputerView;", "computers", "<init>", "(Lru/octol1ttle/flightassistant/api/computer/ComputerView;)V", "", "invokeEvents", "()V", "tick", "Lru/octol1ttle/flightassistant/api/autoflight/roll/RollSource;", "rollSource", "", "target", "deltaTimeMultiplier", "smoothSetRoll", "(Lru/octol1ttle/flightassistant/api/autoflight/roll/RollSource;FF)V", "reset", "", "sources", "Ljava/util/List;", "Lru/octol1ttle/flightassistant/api/autoflight/FlightController;", "controllers", "Companion", "flightassistant-neoforge"})
@SourceDebugExtension(value={"SMAP\nRollComputer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RollComputer.kt\nru/octol1ttle/flightassistant/impl/computer/autoflight/RollComputer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,60:1\n669#2,11:61\n1611#2,9:72\n1863#2:81\n1864#2:83\n1620#2:84\n1053#2:85\n1#3:82\n*S KotlinDebug\n*F\n+ 1 RollComputer.kt\nru/octol1ttle/flightassistant/impl/computer/autoflight/RollComputer\n*L\n29#1:61,11\n31#1:72,9\n31#1:81\n31#1:83\n31#1:84\n31#1:85\n31#1:82\n*E\n"})
public final class RollComputer
extends Computer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<RollSource> sources;
    @NotNull
    private final List<FlightController> controllers;
    @NotNull
    private static final ResourceLocation ID = FlightAssistant.INSTANCE.id$flightassistant_neoforge("roll");

    public RollComputer(@NotNull ComputerView computers) {
        Intrinsics.checkNotNullParameter((Object)computers, (String)"computers");
        super(computers);
        this.sources = new ArrayList();
        this.controllers = new ArrayList();
    }

    @Override
    public void invokeEvents() {
        ((RollSourceRegistrationCallback)RollSourceRegistrationCallback.EVENT.invoker()).register(p0 -> this.sources.add((RollSource)p0));
        ((RollControllerRegistrationCallback)RollControllerRegistrationCallback.EVENT.invoker()).register(p0 -> this.controllers.add((FlightController)p0));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void tick() {
        void $this$mapNotNullTo$iv$iv;
        Iterable iterable;
        Iterable single$iv;
        block7: {
            Iterable $this$singleOrNull$iv = CollectionExtensionsKt.filterNonFaulted(this.sources);
            boolean $i$f$singleOrNull = false;
            single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                RollSource it = (RollSource)element$iv;
                boolean bl = false;
                if (!it.isActive()) continue;
                if (found$iv) {
                    iterable = null;
                    break block7;
                }
                single$iv = (Iterable)element$iv;
                found$iv = true;
            }
            iterable = !found$iv ? null : single$iv;
        }
        RollSource rollSource = (RollSource)((Object)iterable);
        if (rollSource == null) {
            return;
        }
        RollSource rollSource2 = rollSource;
        Iterable $this$mapNotNull$iv = CollectionExtensionsKt.filterNonFaulted(this.controllers);
        boolean $i$f$mapNotNull = false;
        single$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ControlInput it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            FlightController it = (FlightController)element$iv$iv;
            boolean bl2 = false;
            if (it.getRollInput() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        List inputs = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ControlInput it = (ControlInput)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getPriority().getValue());
                it = (ControlInput)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getPriority().getValue()));
            }
        });
        if (inputs.isEmpty()) {
            return;
        }
        ControlInput controlInput = (ControlInput)CollectionsKt.firstOrNull(CollectionExtensionsKt.getActiveHighestPriority(inputs));
        if (controlInput == null) {
            return;
        }
        ControlInput finalInput = controlInput;
        if (AirDataComputer.automationsAllowed$default(this.getComputers().getData(), false, 1, null) && finalInput.getActive()) {
            this.smoothSetRoll(rollSource2, MathHelperKt.requireIn(finalInput.getTarget(), (ClosedFloatingPointRange<Float>)RangesKt.rangeTo((float)-180.0f, (float)180.0f)), MathHelperKt.requireIn(finalInput.getDeltaTimeMultiplier(), (ClosedFloatingPointRange<Float>)RangesKt.rangeTo((float)0.001f, (float)Float.MAX_VALUE)));
        }
    }

    private final void smoothSetRoll(RollSource rollSource, float target, float deltaTimeMultiplier) {
        float diff = MathHelperKt.findShortestPath(rollSource.getRoll(), target, 360.0f);
        float closeDistanceMultiplier = diff == 0.0f ? 1.0f : RangesKt.coerceAtLeast((float)(1.0f / Math.abs(diff)), (float)1.0f);
        float delta = diff * ((Number)((Object)RangesKt.coerceIn((Comparable)Float.valueOf(FATickCounter.INSTANCE.getTimePassed() * deltaTimeMultiplier * closeDistanceMultiplier), (ClosedFloatingPointRange)RangesKt.rangeTo((float)0.0f, (float)1.0f)))).floatValue();
        rollSource.addRoll(delta);
    }

    @Override
    public void reset() {
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/autoflight/RollComputer$Companion;", "", "<init>", "()V", "Lnet/minecraft/resources/ResourceLocation;", "ID", "Lnet/minecraft/resources/ResourceLocation;", "getID", "()Lnet/minecraft/resources/ResourceLocation;", "flightassistant-neoforge"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceLocation getID() {
            return ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

