/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.impl.computer.safety;

import java.time.Duration;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundPlayerCommandPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.octol1ttle.flightassistant.FlightAssistant;
import ru.octol1ttle.flightassistant.api.computer.Computer;
import ru.octol1ttle.flightassistant.api.computer.ComputerView;
import ru.octol1ttle.flightassistant.api.util.extensions.ItemStackExtensionsKt;
import ru.octol1ttle.flightassistant.config.FAConfig;
import ru.octol1ttle.flightassistant.config.options.DisplayOptions;
import ru.octol1ttle.flightassistant.impl.computer.AirDataComputer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000  2\u00020\u0001:\u0001 B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u000b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0019\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u0015\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0018\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u000f\u0010\u001a\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u001a\u0010\bR\u0018\u0010\u001b\u001a\u0004\u0018\u00010\u000f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR\u0018\u0010\u001e\u001a\u0004\u0018\u00010\u001d8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001f\u00a8\u0006!"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/safety/ElytraStatusComputer;", "Lru/octol1ttle/flightassistant/api/computer/Computer;", "Lru/octol1ttle/flightassistant/api/computer/ComputerView;", "computers", "<init>", "(Lru/octol1ttle/flightassistant/api/computer/ComputerView;)V", "", "tick", "()V", "Lru/octol1ttle/flightassistant/impl/computer/AirDataComputer;", "data", "sendSwitchState", "(Lru/octol1ttle/flightassistant/impl/computer/AirDataComputer;)V", "Lnet/minecraft/world/entity/player/Player;", "player", "Lnet/minecraft/world/item/ItemStack;", "findActiveElytra", "(Lnet/minecraft/world/entity/player/Player;)Lnet/minecraft/world/item/ItemStack;", "Lru/octol1ttle/flightassistant/config/options/DisplayOptions$DurabilityUnits;", "units", "Lnet/minecraft/network/chat/Component;", "formatDurability", "(Lru/octol1ttle/flightassistant/config/options/DisplayOptions$DurabilityUnits;Lnet/minecraft/world/entity/player/Player;)Lnet/minecraft/network/chat/Component;", "", "getRemainingFlightTime", "(Lnet/minecraft/world/entity/player/Player;)Ljava/lang/Integer;", "reset", "activeElytra", "Lnet/minecraft/world/item/ItemStack;", "", "syncedFlyingState", "Ljava/lang/Boolean;", "Companion", "flightassistant-neoforge"})
public final class ElytraStatusComputer
extends Computer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private ItemStack activeElytra;
    @Nullable
    private Boolean syncedFlyingState;
    @NotNull
    private static final ResourceLocation ID = FlightAssistant.INSTANCE.id$flightassistant_neoforge("elytra_status");

    public ElytraStatusComputer(@NotNull ComputerView computers) {
        Intrinsics.checkNotNullParameter((Object)computers, (String)"computers");
        super(computers);
    }

    @Override
    public void tick() {
        boolean notLookingToClutch;
        AirDataComputer data = this.getComputers().getData();
        this.activeElytra = this.findActiveElytra((Player)data.getPlayer());
        if (data.getPlayer().onGround()) {
            this.syncedFlyingState = null;
            return;
        }
        if (this.syncedFlyingState != null) {
            if (!Intrinsics.areEqual((Object)this.syncedFlyingState, (Object)data.getFlying())) {
                this.syncedFlyingState = null;
            }
            return;
        }
        if (!data.automationsAllowed(false)) {
            return;
        }
        if (FAConfig.INSTANCE.getSafety().getElytraCloseUnderwater() && data.getFlying() && data.getPlayer().isUnderWater()) {
            this.sendSwitchState(data);
        }
        boolean flying = data.getFlying() || data.getPlayer().getAbilities().mayfly;
        Iterable iterable = data.getPlayer().getArmorSlots();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getArmorItems(...)");
        boolean hasUsableElytra = CollectionsKt.contains((Iterable)iterable, (Object)this.activeElytra) && ItemStackExtensionsKt.canUse(this.activeElytra);
        boolean bl = notLookingToClutch = data.getPitch() > -70.0f;
        if (FAConfig.INSTANCE.getSafety().getElytraAutoOpen() && !data.getFallDistanceSafe() && !flying && hasUsableElytra && notLookingToClutch) {
            this.sendSwitchState(data);
        }
    }

    private final void sendSwitchState(AirDataComputer data) {
        this.syncedFlyingState = data.getFlying();
        data.getPlayer().connection.send((Packet)new ServerboundPlayerCommandPacket((Entity)data.getPlayer(), ServerboundPlayerCommandPacket.Action.START_FALL_FLYING));
    }

    private final ItemStack findActiveElytra(Player player) {
        ItemStack stack;
        for (Object t : player.getArmorSlots()) {
            Intrinsics.checkNotNullExpressionValue(t, (String)"next(...)");
            stack = (ItemStack)t;
            if (!(stack.getItem() instanceof ElytraItem)) continue;
            return stack;
        }
        for (Object t : player.getHandSlots()) {
            Intrinsics.checkNotNullExpressionValue(t, (String)"next(...)");
            stack = (ItemStack)t;
            if (!(stack.getItem() instanceof ElytraItem)) continue;
            return stack;
        }
        return null;
    }

    @Nullable
    public final Component formatDurability(@NotNull DisplayOptions.DurabilityUnits units, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)((Object)units), (String)"units");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        ItemStack itemStack = this.activeElytra;
        if (itemStack == null) {
            return null;
        }
        ItemStack active = itemStack;
        if (!active.isDamageableItem()) {
            return (Component)Component.translatable((String)"short.flightassistant.infinite");
        }
        int unbreakingLevel = EnchantmentHelper.getItemEnchantmentLevel((Holder)((Holder)player.level().registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolder(Enchantments.UNBREAKING).get()), (ItemStack)active);
        return switch (WhenMappings.$EnumSwitchMapping$0[units.ordinal()]) {
            case 1 -> (Component)Component.literal((String)String.valueOf(active.getMaxDamage() - active.getDamageValue()));
            case 2 -> (Component)Component.literal((String)(MathKt.roundToInt((float)((float)Math.rint((float)((active.getMaxDamage() - active.getDamageValue() - 1) * 100) / (float)active.getMaxDamage()))) + "%"));
            case 3 -> {
                Integer v2 = this.getRemainingFlightTime(player);
                Intrinsics.checkNotNull((Object)v2);
                Duration v3 = Duration.ofSeconds(v2.intValue());
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"ofSeconds(...)");
                Duration duration = v3;
                int v4 = switch (unbreakingLevel) {
                    case 0 -> duration.toSecondsPart();
                    case 1 -> Mth.quantize((double)duration.toSecondsPart(), (int)5);
                    case 2 -> Mth.quantize((double)duration.toSecondsPart(), (int)15);
                    default -> Mth.quantize((double)duration.toSecondsPart(), (int)30);
                };
                int seconds = v4;
                int v5 = duration.toMinutesPart();
                String var7_7 = "%02d";
                Object[] var8_8 = new Object[]{seconds};
                String v6 = String.format(var7_7, Arrays.copyOf(var8_8, var8_8.length));
                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"format(...)");
                yield (Component)Component.literal((String)(v5 + ":" + v6));
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Nullable
    public final Integer getRemainingFlightTime(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        ItemStack itemStack = this.activeElytra;
        if (itemStack == null) {
            return null;
        }
        ItemStack active = itemStack;
        if (!active.isDamageableItem()) {
            return Integer.MAX_VALUE;
        }
        int unbreakingLevel = EnchantmentHelper.getItemEnchantmentLevel((Holder)((Holder)player.level().registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolder(Enchantments.UNBREAKING).get()), (ItemStack)active);
        return (active.getMaxDamage() - active.getDamageValue() - 1) * (unbreakingLevel + 1);
    }

    @Override
    public void reset() {
        this.activeElytra = null;
        this.syncedFlyingState = null;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/safety/ElytraStatusComputer$Companion;", "", "<init>", "()V", "Lnet/minecraft/resources/ResourceLocation;", "ID", "Lnet/minecraft/resources/ResourceLocation;", "getID", "()Lnet/minecraft/resources/ResourceLocation;", "flightassistant-neoforge"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceLocation getID() {
            return ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DisplayOptions.DurabilityUnits.values().length];
            try {
                nArray[DisplayOptions.DurabilityUnits.RAW.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayOptions.DurabilityUnits.PERCENTAGE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DisplayOptions.DurabilityUnits.TIME.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

