/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.impl.computer.safety;

import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.RangesKt;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.octol1ttle.flightassistant.FlightAssistant;
import ru.octol1ttle.flightassistant.api.autoflight.ControlInput;
import ru.octol1ttle.flightassistant.api.autoflight.FlightController;
import ru.octol1ttle.flightassistant.api.autoflight.pitch.PitchControllerRegistrationCallback;
import ru.octol1ttle.flightassistant.api.autoflight.pitch.PitchLimiter;
import ru.octol1ttle.flightassistant.api.autoflight.pitch.PitchLimiterRegistrationCallback;
import ru.octol1ttle.flightassistant.api.autoflight.thrust.ThrustControllerRegistrationCallback;
import ru.octol1ttle.flightassistant.api.computer.Computer;
import ru.octol1ttle.flightassistant.api.computer.ComputerView;
import ru.octol1ttle.flightassistant.api.util.MathHelperKt;
import ru.octol1ttle.flightassistant.config.FAConfig;
import ru.octol1ttle.flightassistant.impl.computer.AirDataComputer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 %2\u00020\u00012\u00020\u00022\u00020\u0003:\u0002&%B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u000b\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\nJ\u0017\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001f\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0011\u0010\u0015\u001a\u0004\u0018\u00010\u0014H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0011\u0010\u0017\u001a\u0004\u0018\u00010\u0014H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0016J\u0011\u0010\u0018\u001a\u0004\u0018\u00010\u0014H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0016J\u000f\u0010\u0019\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u0019\u0010\nR\u0016\u0010\u001a\u001a\u00020\u000e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR$\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010!R\u0016\u0010\"\u001a\u00020\u000e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\"\u0010\u001bR$\u0010#\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b#\u0010\u001f\u001a\u0004\b$\u0010!\u00a8\u0006'"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/safety/GroundProximityComputer;", "Lru/octol1ttle/flightassistant/api/computer/Computer;", "Lru/octol1ttle/flightassistant/api/autoflight/pitch/PitchLimiter;", "Lru/octol1ttle/flightassistant/api/autoflight/FlightController;", "Lru/octol1ttle/flightassistant/api/computer/ComputerView;", "computers", "<init>", "(Lru/octol1ttle/flightassistant/api/computer/ComputerView;)V", "", "subscribeToEvents", "()V", "tick", "Lru/octol1ttle/flightassistant/impl/computer/AirDataComputer;", "data", "", "computeGroundImpactTime", "(Lru/octol1ttle/flightassistant/impl/computer/AirDataComputer;)F", "lookAheadTime", "computeObstacleImpactTime", "(Lru/octol1ttle/flightassistant/impl/computer/AirDataComputer;F)F", "Lru/octol1ttle/flightassistant/api/autoflight/ControlInput;", "getMinimumPitch", "()Lru/octol1ttle/flightassistant/api/autoflight/ControlInput;", "getThrustInput", "getPitchInput", "reset", "groundImpactTime", "F", "Lru/octol1ttle/flightassistant/impl/computer/safety/GroundProximityComputer$Status;", "value", "groundImpactStatus", "Lru/octol1ttle/flightassistant/impl/computer/safety/GroundProximityComputer$Status;", "getGroundImpactStatus", "()Lru/octol1ttle/flightassistant/impl/computer/safety/GroundProximityComputer$Status;", "obstacleImpactTime", "obstacleImpactStatus", "getObstacleImpactStatus", "Companion", "Status", "flightassistant-neoforge"})
public final class GroundProximityComputer
extends Computer
implements PitchLimiter,
FlightController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private float groundImpactTime;
    @NotNull
    private Status groundImpactStatus;
    private float obstacleImpactTime;
    @NotNull
    private Status obstacleImpactStatus;
    @NotNull
    private static final ResourceLocation ID = FlightAssistant.INSTANCE.id$flightassistant_neoforge("ground_proximity");

    public GroundProximityComputer(@NotNull ComputerView computers) {
        Intrinsics.checkNotNullParameter((Object)computers, (String)"computers");
        super(computers);
        this.groundImpactTime = Float.MAX_VALUE;
        this.groundImpactStatus = Status.SAFE;
        this.obstacleImpactTime = Float.MAX_VALUE;
        this.obstacleImpactStatus = Status.SAFE;
    }

    @NotNull
    public final Status getGroundImpactStatus() {
        return this.groundImpactStatus;
    }

    @NotNull
    public final Status getObstacleImpactStatus() {
        return this.obstacleImpactStatus;
    }

    @Override
    public void subscribeToEvents() {
        ThrustControllerRegistrationCallback.EVENT.register((Object)new ThrustControllerRegistrationCallback(this){
            final /* synthetic */ GroundProximityComputer this$0;
            {
                this.this$0 = $receiver;
            }

            public final void register(Consumer<FlightController> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                it.accept(this.this$0);
            }
        });
        PitchLimiterRegistrationCallback.EVENT.register((Object)new PitchLimiterRegistrationCallback(this){
            final /* synthetic */ GroundProximityComputer this$0;
            {
                this.this$0 = $receiver;
            }

            public final void register(Consumer<PitchLimiter> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                it.accept(this.this$0);
            }
        });
        PitchControllerRegistrationCallback.EVENT.register((Object)new PitchControllerRegistrationCallback(this){
            final /* synthetic */ GroundProximityComputer this$0;
            {
                this.this$0 = $receiver;
            }

            public final void register(Consumer<FlightController> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                it.accept(this.this$0);
            }
        });
    }

    @Override
    public void tick() {
        AirDataComputer data = this.getComputers().getData();
        if (!data.getFlying() || data.getPlayer().isInWater()) {
            this.groundImpactStatus = Status.SAFE;
            this.obstacleImpactStatus = Status.SAFE;
            return;
        }
        boolean anyBlocksAbove = (double)data.getWorld().getHeight(Heightmap.Types.MOTION_BLOCKING, data.getPlayer().getBlockX(), data.getPlayer().getBlockZ()) > data.getPlayer().getY();
        float clearThreshold = anyBlocksAbove ? 7.5f : 15.0f;
        float cautionThreshold = anyBlocksAbove ? 5.0f : 10.0f;
        float warningThreshold = anyBlocksAbove ? 2.5f : 5.0f;
        float recoverThreshold = anyBlocksAbove ? 0.5f : 0.75f;
        this.groundImpactTime = MathHelperKt.requireIn(this.computeGroundImpactTime(data), (ClosedFloatingPointRange<Float>)RangesKt.rangeTo((float)0.0f, (float)Float.MAX_VALUE));
        DamageSource damageSource = data.getPlayer().damageSources().fall();
        Intrinsics.checkNotNullExpressionValue((Object)damageSource, (String)"fall(...)");
        this.groundImpactStatus = data.isInvulnerableTo(damageSource) ? Status.SAFE : (this.groundImpactStatus == Status.SAFE && (data.getVelocity().y * (double)20 > -10.0 || this.groundImpactTime > cautionThreshold) ? Status.SAFE : (data.getFallDistanceSafe() || data.getVelocity().y * (double)20 > -7.5 || this.groundImpactTime > clearThreshold ? Status.SAFE : (this.groundImpactStatus.compareTo((Enum)Status.CAUTION) >= 0 && this.groundImpactTime > warningThreshold ? Status.CAUTION : (this.groundImpactStatus.compareTo((Enum)Status.WARNING) >= 0 && this.groundImpactTime > recoverThreshold ? Status.WARNING : Status.RECOVER))));
        this.obstacleImpactTime = MathHelperKt.requireIn(this.computeObstacleImpactTime(data, clearThreshold), (ClosedFloatingPointRange<Float>)RangesKt.rangeTo((float)0.0f, (float)Float.MAX_VALUE));
        DamageSource damageSource2 = data.getPlayer().damageSources().flyIntoWall();
        Intrinsics.checkNotNullExpressionValue((Object)damageSource2, (String)"flyIntoWall(...)");
        this.obstacleImpactStatus = data.isInvulnerableTo(damageSource2) ? Status.SAFE : (this.obstacleImpactStatus == Status.SAFE && (data.getVelocity().horizontalDistance() * (double)10 - (double)3 < (double)(data.getPlayer().getHealth() * 0.5f) || this.obstacleImpactTime > this.groundImpactTime * 1.1f || this.obstacleImpactTime > cautionThreshold) ? Status.SAFE : (data.getVelocity().horizontalDistance() * (double)10 - (double)3 < (double)(data.getPlayer().getHealth() * 0.25f) || this.obstacleImpactTime > this.groundImpactTime * 1.5f || this.obstacleImpactTime > clearThreshold ? Status.SAFE : (this.obstacleImpactStatus.compareTo((Enum)Status.CAUTION) >= 0 && this.obstacleImpactTime > warningThreshold ? Status.CAUTION : (this.obstacleImpactStatus.compareTo((Enum)Status.WARNING) >= 0 && this.obstacleImpactTime > recoverThreshold ? Status.WARNING : Status.RECOVER))));
    }

    private final float computeGroundImpactTime(AirDataComputer data) {
        if (data.getVelocity().y >= 0.0) {
            return Float.MAX_VALUE;
        }
        Double groundLevel = data.getGroundLevel();
        double impactLevel = groundLevel == null || Intrinsics.areEqual((Double)groundLevel, (double)Double.MAX_VALUE) ? (double)data.getVoidLevel() : groundLevel;
        return (float)(Math.max(0.0, data.getAltitude() - impactLevel) / (data.getVelocity().y * -20.0));
    }

    private final float computeObstacleImpactTime(AirDataComputer data, float lookAheadTime) {
        Vec3 vec3 = data.getPosition().add(data.getVelocity().multiply((double)lookAheadTime * 20.0, 0.0, (double)lookAheadTime * 20.0));
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"add(...)");
        Vec3 end = vec3;
        BlockHitResult blockHitResult = data.getWorld().clip(new ClipContext(data.getPosition(), end, ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)data.getPlayer()));
        Intrinsics.checkNotNullExpressionValue((Object)blockHitResult, (String)"raycast(...)");
        BlockHitResult result = blockHitResult;
        if (result.getType() != HitResult.Type.BLOCK) {
            return Float.MAX_VALUE;
        }
        Vec3 vec32 = data.getPosition().add(data.getVelocity().scale((double)lookAheadTime * 20.0));
        Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"add(...)");
        Vec3 otherEnd = vec32;
        BlockHitResult blockHitResult2 = data.getWorld().clip(new ClipContext(data.getPosition(), otherEnd, ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)data.getPlayer()));
        Intrinsics.checkNotNullExpressionValue((Object)blockHitResult2, (String)"raycast(...)");
        BlockHitResult otherResult = blockHitResult2;
        if (otherResult.getType() != HitResult.Type.BLOCK) {
            return Float.MAX_VALUE;
        }
        Vec3 vec33 = result.getLocation().subtract(data.getPosition());
        Intrinsics.checkNotNullExpressionValue((Object)vec33, (String)"subtract(...)");
        Vec3 relative = vec33;
        return (float)(relative.horizontalDistance() / (data.getVelocity().horizontalDistance() * (double)20.0f));
    }

    @Override
    @Nullable
    public ControlInput getMinimumPitch() {
        if (this.groundImpactStatus.compareTo((Enum)Status.WARNING) <= 0 && FAConfig.INSTANCE.getSafety().getSinkRateLimitPitch() || this.obstacleImpactStatus.compareTo((Enum)Status.WARNING) <= 0 && FAConfig.INSTANCE.getSafety().getObstacleLimitPitch()) {
            return new ControlInput(RangesKt.coerceAtMost((float)this.getComputers().getData().getPitch(), (float)0.0f), ControlInput.Priority.HIGH, (Component)Component.translatable((String)"mode.flightassistant.vertical.terrain_protection"), 0.0f, false, null, 56, null);
        }
        return null;
    }

    @Override
    @Nullable
    public ControlInput getThrustInput() {
        if ((this.groundImpactStatus.compareTo((Enum)Status.CAUTION) <= 0 && FAConfig.INSTANCE.getSafety().getSinkRateAutoThrust() || this.obstacleImpactStatus.compareTo((Enum)Status.CAUTION) <= 0 && FAConfig.INSTANCE.getSafety().getObstacleAutoThrust()) && this.getComputers().getData().getPitch() <= this.getComputers().getThrust().getAltitudeHoldPitch()) {
            return new ControlInput(0.0f, ControlInput.Priority.HIGH, (Component)Component.translatable((String)"mode.flightassistant.thrust.idle"), 0.0f, this.groundImpactStatus.compareTo((Enum)Status.WARNING) <= 0 && FAConfig.INSTANCE.getSafety().getSinkRateAutoThrust() || this.obstacleImpactStatus.compareTo((Enum)Status.WARNING) <= 0 && FAConfig.INSTANCE.getSafety().getObstacleAutoThrust(), null, 40, null);
        }
        return null;
    }

    @Override
    @Nullable
    public ControlInput getPitchInput() {
        if (this.groundImpactStatus.compareTo((Enum)Status.WARNING) <= 0 && FAConfig.INSTANCE.getSafety().getSinkRateAutoPitch() || this.obstacleImpactStatus.compareTo((Enum)Status.WARNING) <= 0 && FAConfig.INSTANCE.getSafety().getObstacleAutoPitch()) {
            float minImpactTime = Math.min(this.groundImpactTime, this.obstacleImpactTime);
            if (minImpactTime == 0.0f) {
                return null;
            }
            return new ControlInput(90.0f, ControlInput.Priority.HIGH, (Component)Component.translatable((String)"mode.flightassistant.vertical.terrain_escape"), 1.0f / minImpactTime, this.groundImpactStatus == Status.RECOVER && FAConfig.INSTANCE.getSafety().getSinkRateAutoPitch() || this.obstacleImpactStatus == Status.RECOVER && FAConfig.INSTANCE.getSafety().getObstacleAutoPitch(), null, 32, null);
        }
        return null;
    }

    @Override
    public void reset() {
        this.groundImpactTime = Float.MAX_VALUE;
        this.groundImpactStatus = Status.SAFE;
        this.obstacleImpactTime = Float.MAX_VALUE;
        this.obstacleImpactStatus = Status.SAFE;
    }

    @Override
    @Nullable
    public ControlInput getMaximumPitch() {
        return PitchLimiter.DefaultImpls.getMaximumPitch(this);
    }

    @Override
    @Nullable
    public ControlInput getHeadingInput() {
        return FlightController.DefaultImpls.getHeadingInput(this);
    }

    @Override
    @Nullable
    public ControlInput getRollInput() {
        return FlightController.DefaultImpls.getRollInput(this);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/safety/GroundProximityComputer$Companion;", "", "<init>", "()V", "Lnet/minecraft/resources/ResourceLocation;", "ID", "Lnet/minecraft/resources/ResourceLocation;", "getID", "()Lnet/minecraft/resources/ResourceLocation;", "flightassistant-neoforge"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceLocation getID() {
            return ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/safety/GroundProximityComputer$Status;", "", "<init>", "(Ljava/lang/String;I)V", "RECOVER", "WARNING", "CAUTION", "SAFE", "flightassistant-neoforge"})
    public static final class Status
    extends Enum<Status> {
        public static final /* enum */ Status RECOVER = new Status();
        public static final /* enum */ Status WARNING = new Status();
        public static final /* enum */ Status CAUTION = new Status();
        public static final /* enum */ Status SAFE = new Status();
        private static final /* synthetic */ Status[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Status[] values() {
            return (Status[])$VALUES.clone();
        }

        public static Status valueOf(String value) {
            return Enum.valueOf(Status.class, value);
        }

        @NotNull
        public static EnumEntries<Status> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = statusArray = new Status[]{Status.RECOVER, Status.WARNING, Status.CAUTION, Status.SAFE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

