/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.impl.computer.safety;

import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.octol1ttle.flightassistant.FlightAssistant;
import ru.octol1ttle.flightassistant.api.autoflight.ControlInput;
import ru.octol1ttle.flightassistant.api.autoflight.FlightController;
import ru.octol1ttle.flightassistant.api.autoflight.pitch.PitchLimiter;
import ru.octol1ttle.flightassistant.api.autoflight.pitch.PitchLimiterRegistrationCallback;
import ru.octol1ttle.flightassistant.api.autoflight.thrust.ThrustControllerRegistrationCallback;
import ru.octol1ttle.flightassistant.api.computer.Computer;
import ru.octol1ttle.flightassistant.api.computer.ComputerView;
import ru.octol1ttle.flightassistant.config.FAConfig;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0005\u0018\u0000 \u001a2\u00020\u00012\u00020\u00022\u00020\u0003:\u0002\u001b\u001aB\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u000b\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\nJ\u0011\u0010\r\u001a\u0004\u0018\u00010\fH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0011\u0010\u000f\u001a\u0004\u0018\u00010\fH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u000eJ\u000f\u0010\u0010\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u0010\u0010\nR$\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00118\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0018\u001a\u00020\u00178\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001c"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/safety/StallComputer;", "Lru/octol1ttle/flightassistant/api/computer/Computer;", "Lru/octol1ttle/flightassistant/api/autoflight/pitch/PitchLimiter;", "Lru/octol1ttle/flightassistant/api/autoflight/FlightController;", "Lru/octol1ttle/flightassistant/api/computer/ComputerView;", "computers", "<init>", "(Lru/octol1ttle/flightassistant/api/computer/ComputerView;)V", "", "subscribeToEvents", "()V", "tick", "Lru/octol1ttle/flightassistant/api/autoflight/ControlInput;", "getThrustInput", "()Lru/octol1ttle/flightassistant/api/autoflight/ControlInput;", "getMaximumPitch", "reset", "Lru/octol1ttle/flightassistant/impl/computer/safety/StallComputer$Status;", "value", "status", "Lru/octol1ttle/flightassistant/impl/computer/safety/StallComputer$Status;", "getStatus", "()Lru/octol1ttle/flightassistant/impl/computer/safety/StallComputer$Status;", "", "maximumSafePitch", "F", "Companion", "Status", "flightassistant-neoforge"})
public final class StallComputer
extends Computer
implements PitchLimiter,
FlightController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Status status;
    private float maximumSafePitch;
    @NotNull
    private static final ResourceLocation ID = FlightAssistant.INSTANCE.id$flightassistant_neoforge("stall");

    public StallComputer(@NotNull ComputerView computers) {
        Intrinsics.checkNotNullParameter((Object)computers, (String)"computers");
        super(computers);
        this.status = Status.SAFE;
        this.maximumSafePitch = 90.0f;
    }

    @NotNull
    public final Status getStatus() {
        return this.status;
    }

    @Override
    public void subscribeToEvents() {
        PitchLimiterRegistrationCallback.EVENT.register((Object)new PitchLimiterRegistrationCallback(this){
            final /* synthetic */ StallComputer this$0;
            {
                this.this$0 = $receiver;
            }

            public final void register(Consumer<PitchLimiter> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                it.accept(this.this$0);
            }
        });
        ThrustControllerRegistrationCallback.EVENT.register((Object)new ThrustControllerRegistrationCallback(this){
            final /* synthetic */ StallComputer this$0;
            {
                this.this$0 = $receiver;
            }

            public final void register(Consumer<FlightController> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                it.accept(this.this$0);
            }
        });
    }

    @Override
    public void tick() {
        float angleOfAttack = this.getComputers().getData().getPitch() - this.getComputers().getData().getFlightPitch();
        this.status = this.getComputers().getData().getFlying() && !this.getComputers().getData().getFallDistanceSafe() && angleOfAttack > 90.0f ? (this.status == Status.FULL_STALL || this.getComputers().getData().getVelocity().y * (double)20 <= -10.0 ? Status.FULL_STALL : Status.APPROACHING_STALL) : Status.SAFE;
        this.maximumSafePitch = (float)RangesKt.coerceAtMost((double)((double)this.getComputers().getData().getFlightPitch() + 90.0), (double)(this.getComputers().getData().getForwardVelocity().length() * 20.0 * 3.0 + 45.0));
    }

    @Override
    @Nullable
    public ControlInput getThrustInput() {
        if (FAConfig.INSTANCE.getSafety().getStallAutoThrust() && this.status != Status.SAFE) {
            return new ControlInput(1.0f, ControlInput.Priority.HIGHEST, (Component)Component.translatable((String)"mode.flightassistant.thrust.toga"), 0.0f, this.status == Status.FULL_STALL, null, 40, null);
        }
        return null;
    }

    @Override
    @Nullable
    public ControlInput getMaximumPitch() {
        if (this.maximumSafePitch > 90.0f || this.getComputers().getData().getFallDistanceSafe()) {
            return null;
        }
        return new ControlInput(this.maximumSafePitch, ControlInput.Priority.HIGHEST, (Component)Component.translatable((String)"mode.flightassistant.vertical.stall_protection"), 1.5f, FAConfig.INSTANCE.getSafety().getStallLimitPitch(), null, 32, null);
    }

    @Override
    public void reset() {
        this.status = Status.SAFE;
        this.maximumSafePitch = 90.0f;
    }

    @Override
    @Nullable
    public ControlInput getMinimumPitch() {
        return PitchLimiter.DefaultImpls.getMinimumPitch(this);
    }

    @Override
    @Nullable
    public ControlInput getPitchInput() {
        return FlightController.DefaultImpls.getPitchInput(this);
    }

    @Override
    @Nullable
    public ControlInput getHeadingInput() {
        return FlightController.DefaultImpls.getHeadingInput(this);
    }

    @Override
    @Nullable
    public ControlInput getRollInput() {
        return FlightController.DefaultImpls.getRollInput(this);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/safety/StallComputer$Companion;", "", "<init>", "()V", "Lnet/minecraft/resources/ResourceLocation;", "ID", "Lnet/minecraft/resources/ResourceLocation;", "getID", "()Lnet/minecraft/resources/ResourceLocation;", "flightassistant-neoforge"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceLocation getID() {
            return ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/safety/StallComputer$Status;", "", "<init>", "(Ljava/lang/String;I)V", "FULL_STALL", "APPROACHING_STALL", "SAFE", "flightassistant-neoforge"})
    public static final class Status
    extends Enum<Status> {
        public static final /* enum */ Status FULL_STALL = new Status();
        public static final /* enum */ Status APPROACHING_STALL = new Status();
        public static final /* enum */ Status SAFE = new Status();
        private static final /* synthetic */ Status[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Status[] values() {
            return (Status[])$VALUES.clone();
        }

        public static Status valueOf(String value) {
            return Enum.valueOf(Status.class, value);
        }

        @NotNull
        public static EnumEntries<Status> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = statusArray = new Status[]{Status.FULL_STALL, Status.APPROACHING_STALL, Status.SAFE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

