/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.impl.computer.safety;

import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.RangesKt;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.octol1ttle.flightassistant.FlightAssistant;
import ru.octol1ttle.flightassistant.api.autoflight.ControlInput;
import ru.octol1ttle.flightassistant.api.autoflight.FlightController;
import ru.octol1ttle.flightassistant.api.autoflight.pitch.PitchControllerRegistrationCallback;
import ru.octol1ttle.flightassistant.api.autoflight.pitch.PitchLimiter;
import ru.octol1ttle.flightassistant.api.autoflight.pitch.PitchLimiterRegistrationCallback;
import ru.octol1ttle.flightassistant.api.autoflight.thrust.ThrustControllerRegistrationCallback;
import ru.octol1ttle.flightassistant.api.computer.Computer;
import ru.octol1ttle.flightassistant.api.computer.ComputerView;
import ru.octol1ttle.flightassistant.config.FAConfig;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u00182\u00020\u00012\u00020\u00022\u00020\u0003:\u0002\u0019\u0018B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u000b\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\nJ\u0011\u0010\r\u001a\u0004\u0018\u00010\fH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0011\u0010\u000f\u001a\u0004\u0018\u00010\fH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u000eJ\u0011\u0010\u0010\u001a\u0004\u0018\u00010\fH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u000eJ\u000f\u0010\u0011\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u0011\u0010\nR$\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00128\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001a"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/safety/VoidProximityComputer;", "Lru/octol1ttle/flightassistant/api/computer/Computer;", "Lru/octol1ttle/flightassistant/api/autoflight/pitch/PitchLimiter;", "Lru/octol1ttle/flightassistant/api/autoflight/FlightController;", "Lru/octol1ttle/flightassistant/api/computer/ComputerView;", "computers", "<init>", "(Lru/octol1ttle/flightassistant/api/computer/ComputerView;)V", "", "subscribeToEvents", "()V", "tick", "Lru/octol1ttle/flightassistant/api/autoflight/ControlInput;", "getMinimumPitch", "()Lru/octol1ttle/flightassistant/api/autoflight/ControlInput;", "getPitchInput", "getThrustInput", "reset", "Lru/octol1ttle/flightassistant/impl/computer/safety/VoidProximityComputer$Status;", "value", "status", "Lru/octol1ttle/flightassistant/impl/computer/safety/VoidProximityComputer$Status;", "getStatus", "()Lru/octol1ttle/flightassistant/impl/computer/safety/VoidProximityComputer$Status;", "Companion", "Status", "flightassistant-neoforge"})
public final class VoidProximityComputer
extends Computer
implements PitchLimiter,
FlightController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Status status;
    @NotNull
    private static final ResourceLocation ID = FlightAssistant.INSTANCE.id$flightassistant_neoforge("void_proximity");

    public VoidProximityComputer(@NotNull ComputerView computers) {
        Intrinsics.checkNotNullParameter((Object)computers, (String)"computers");
        super(computers);
        this.status = Status.ABOVE_GROUND;
    }

    @NotNull
    public final Status getStatus() {
        return this.status;
    }

    @Override
    public void subscribeToEvents() {
        PitchLimiterRegistrationCallback.EVENT.register((Object)new PitchLimiterRegistrationCallback(this){
            final /* synthetic */ VoidProximityComputer this$0;
            {
                this.this$0 = $receiver;
            }

            public final void register(Consumer<PitchLimiter> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                it.accept(this.this$0);
            }
        });
        PitchControllerRegistrationCallback.EVENT.register((Object)new PitchControllerRegistrationCallback(this){
            final /* synthetic */ VoidProximityComputer this$0;
            {
                this.this$0 = $receiver;
            }

            public final void register(Consumer<FlightController> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                it.accept(this.this$0);
            }
        });
        ThrustControllerRegistrationCallback.EVENT.register((Object)new ThrustControllerRegistrationCallback(this){
            final /* synthetic */ VoidProximityComputer this$0;
            {
                this.this$0 = $receiver;
            }

            public final void register(Consumer<FlightController> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                it.accept(this.this$0);
            }
        });
    }

    @Override
    public void tick() {
        double heightAboveDamageAltitude;
        this.status = this.getComputers().getData().getGroundLevel() != null ? Status.ABOVE_GROUND : ((heightAboveDamageAltitude = this.getComputers().getData().getAltitude() - (double)this.getComputers().getData().getVoidLevel()) > 16.0 ? Status.CLEAR_OF_DAMAGE_ALTITUDE : (this.status != Status.REACHED_DAMAGE_ALTITUDE && heightAboveDamageAltitude > 1.0 ? Status.APPROACHING_DAMAGE_ALTITUDE : Status.REACHED_DAMAGE_ALTITUDE));
    }

    @Override
    @Nullable
    public ControlInput getMinimumPitch() {
        if (FAConfig.INSTANCE.getSafety().getVoidLimitPitch() && this.status != Status.ABOVE_GROUND) {
            return new ControlInput(((Number)((Object)RangesKt.coerceIn((Comparable)Float.valueOf((float)((double)-90.0f + ((double)this.getComputers().getData().getWorld().getMinBuildHeight() - (this.getComputers().getData().getAltitude() + this.getComputers().getData().getVelocity().y * (double)20)) / (double)64.0f * (double)105.0f)), (ClosedFloatingPointRange)RangesKt.rangeTo((float)-35.0f, (float)this.getComputers().getThrust().getOptimumClimbPitch())))).floatValue(), ControlInput.Priority.HIGH, (Component)Component.translatable((String)"mode.flightassistant.vertical.void_protection"), 0.0f, false, null, 56, null);
        }
        return null;
    }

    @Override
    @Nullable
    public ControlInput getPitchInput() {
        if (FAConfig.INSTANCE.getSafety().getVoidAutoPitch() && this.status.compareTo((Enum)Status.APPROACHING_DAMAGE_ALTITUDE) <= 0) {
            return new ControlInput(this.getComputers().getThrust().getOptimumClimbPitch(), ControlInput.Priority.HIGH, (Component)Component.translatable((String)"mode.flightassistant.vertical.void_escape"), 0.0f, this.status == Status.REACHED_DAMAGE_ALTITUDE && this.getComputers().getThrust().getCurrent() > 0.99f && !this.getComputers().getThrust().getNoThrustSource(), null, 40, null);
        }
        return null;
    }

    @Override
    @Nullable
    public ControlInput getThrustInput() {
        if (FAConfig.INSTANCE.getSafety().getVoidAutoThrust() && this.status.compareTo((Enum)Status.APPROACHING_DAMAGE_ALTITUDE) <= 0) {
            return new ControlInput(1.0f, ControlInput.Priority.HIGH, (Component)Component.translatable((String)"mode.flightassistant.thrust.toga"), 0.0f, this.status == Status.REACHED_DAMAGE_ALTITUDE, null, 40, null);
        }
        return null;
    }

    @Override
    public void reset() {
        this.status = Status.ABOVE_GROUND;
    }

    @Override
    @Nullable
    public ControlInput getMaximumPitch() {
        return PitchLimiter.DefaultImpls.getMaximumPitch(this);
    }

    @Override
    @Nullable
    public ControlInput getHeadingInput() {
        return FlightController.DefaultImpls.getHeadingInput(this);
    }

    @Override
    @Nullable
    public ControlInput getRollInput() {
        return FlightController.DefaultImpls.getRollInput(this);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/safety/VoidProximityComputer$Companion;", "", "<init>", "()V", "Lnet/minecraft/resources/ResourceLocation;", "ID", "Lnet/minecraft/resources/ResourceLocation;", "getID", "()Lnet/minecraft/resources/ResourceLocation;", "flightassistant-neoforge"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceLocation getID() {
            return ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/safety/VoidProximityComputer$Status;", "", "<init>", "(Ljava/lang/String;I)V", "REACHED_DAMAGE_ALTITUDE", "APPROACHING_DAMAGE_ALTITUDE", "CLEAR_OF_DAMAGE_ALTITUDE", "ABOVE_GROUND", "flightassistant-neoforge"})
    public static final class Status
    extends Enum<Status> {
        public static final /* enum */ Status REACHED_DAMAGE_ALTITUDE = new Status();
        public static final /* enum */ Status APPROACHING_DAMAGE_ALTITUDE = new Status();
        public static final /* enum */ Status CLEAR_OF_DAMAGE_ALTITUDE = new Status();
        public static final /* enum */ Status ABOVE_GROUND = new Status();
        private static final /* synthetic */ Status[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Status[] values() {
            return (Status[])$VALUES.clone();
        }

        public static Status valueOf(String value) {
            return Enum.valueOf(Status.class, value);
        }

        @NotNull
        public static EnumEntries<Status> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = statusArray = new Status[]{Status.REACHED_DAMAGE_ALTITUDE, Status.APPROACHING_DAMAGE_ALTITUDE, Status.CLEAR_OF_DAMAGE_ALTITUDE, Status.ABOVE_GROUND};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

