/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.impl.display;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import ru.octol1ttle.flightassistant.FlightAssistant;
import ru.octol1ttle.flightassistant.api.alert.Alert;
import ru.octol1ttle.flightassistant.api.alert.AlertCategory;
import ru.octol1ttle.flightassistant.api.alert.AlertData;
import ru.octol1ttle.flightassistant.api.alert.CenteredAlert;
import ru.octol1ttle.flightassistant.api.alert.ECAMAlert;
import ru.octol1ttle.flightassistant.api.computer.ComputerView;
import ru.octol1ttle.flightassistant.api.display.Display;
import ru.octol1ttle.flightassistant.api.display.HudFrame;
import ru.octol1ttle.flightassistant.api.util.extensions.DrawContextExtensionsKt;
import ru.octol1ttle.flightassistant.config.FAConfig;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u000e\u0010\rR\u0014\u0010\u0010\u001a\u00020\u000f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0013"}, d2={"Lru/octol1ttle/flightassistant/impl/display/AlertDisplay;", "Lru/octol1ttle/flightassistant/api/display/Display;", "Lru/octol1ttle/flightassistant/api/computer/ComputerView;", "computers", "<init>", "(Lru/octol1ttle/flightassistant/api/computer/ComputerView;)V", "", "allowedByConfig", "()Z", "Lnet/minecraft/client/gui/GuiGraphics;", "drawContext", "", "render", "(Lnet/minecraft/client/gui/GuiGraphics;)V", "renderFaulted", "Lnet/minecraft/network/chat/Style;", "withUnderline", "Lnet/minecraft/network/chat/Style;", "Companion", "flightassistant-neoforge"})
public final class AlertDisplay
extends Display {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Style withUnderline;
    @NotNull
    private static final ResourceLocation ID = FlightAssistant.INSTANCE.id$flightassistant_neoforge("alert");

    public AlertDisplay(@NotNull ComputerView computers) {
        Intrinsics.checkNotNullParameter((Object)computers, (String)"computers");
        super(computers);
        Style style = Style.EMPTY.withUnderlined(Boolean.valueOf(true));
        Intrinsics.checkNotNullExpressionValue((Object)style, (String)"withUnderline(...)");
        this.withUnderline = style;
    }

    @Override
    public boolean allowedByConfig() {
        return FAConfig.INSTANCE.getDisplay().getShowAlerts();
    }

    @Override
    public void render(@NotNull GuiGraphics drawContext) {
        Intrinsics.checkNotNullParameter((Object)drawContext, (String)"drawContext");
        GuiGraphics $this$render_u24lambda_u241 = drawContext;
        boolean bl = false;
        int x = HudFrame.INSTANCE.getLeft() + 10;
        int y = HudFrame.INSTANCE.getTop() + 5;
        boolean renderedCentered = false;
        for (AlertCategory category : this.getComputers().getAlert().getCategories()) {
            MutableComponent copy;
            Intrinsics.checkNotNullExpressionValue((Object)category.getCategoryText().copy(), (String)"copy(...)");
            MutableComponent mutableComponent = copy.setStyle(this.withUnderline);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"setStyle(...)");
            AlertData alertData = category.getFirstData((Function1<? super Alert, Boolean>)((Function1)AlertDisplay::render$lambda$1$lambda$0));
            if (alertData == null) continue;
            DrawContextExtensionsKt.drawText($this$render_u24lambda_u241, (Component)mutableComponent, x, y, ((Number)alertData.getColorSupplier().invoke()).intValue());
            copy.append(" ");
            boolean categoryRendered = false;
            int lastRenderedLines = 0;
            for (Alert alert : category.getActiveAlerts()) {
                if (!alert.getAlertMethod().screen()) continue;
                if (!renderedCentered && alert instanceof CenteredAlert) {
                    renderedCentered = ((CenteredAlert)((Object)alert)).render($this$render_u24lambda_u241, DrawContextExtensionsKt.getCenterY($this$render_u24lambda_u241) + 8);
                    categoryRendered = categoryRendered || renderedCentered;
                    y += DrawContextExtensionsKt.getFontHeight();
                }
                if (!(alert instanceof ECAMAlert)) continue;
                if (lastRenderedLines > 1) {
                    y += 3;
                }
                lastRenderedLines = ((ECAMAlert)((Object)alert)).render($this$render_u24lambda_u241, x + DrawContextExtensionsKt.getTextWidth((Component)copy), x, y);
                y += DrawContextExtensionsKt.getFontHeight();
                if (lastRenderedLines > 1) {
                    y += (DrawContextExtensionsKt.getFontHeight() + 1) * (lastRenderedLines - 1);
                }
                categoryRendered = true;
            }
            if (!categoryRendered) {
                y += DrawContextExtensionsKt.getFontHeight();
            }
            y += 3;
        }
    }

    @Override
    public void renderFaulted(@NotNull GuiGraphics drawContext) {
        Intrinsics.checkNotNullParameter((Object)drawContext, (String)"drawContext");
        GuiGraphics $this$renderFaulted_u24lambda_u242 = drawContext;
        boolean bl = false;
        int x = HudFrame.INSTANCE.getLeft() + 10;
        int y = HudFrame.INSTANCE.getTop() + 5;
        MutableComponent mutableComponent = Component.translatable((String)"short.flightassistant.alert");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        DrawContextExtensionsKt.drawText($this$renderFaulted_u24lambda_u242, (Component)mutableComponent, x, y, DrawContextExtensionsKt.getWarningColor());
    }

    private static final boolean render$lambda$1$lambda$0(Alert it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getAlertMethod().screen();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lru/octol1ttle/flightassistant/impl/display/AlertDisplay$Companion;", "", "<init>", "()V", "Lnet/minecraft/resources/ResourceLocation;", "ID", "Lnet/minecraft/resources/ResourceLocation;", "getID", "()Lnet/minecraft/resources/ResourceLocation;", "flightassistant-neoforge"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceLocation getID() {
            return ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

