/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.impl.display;

import kotlin.Metadata;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import ru.octol1ttle.flightassistant.FlightAssistant;
import ru.octol1ttle.flightassistant.api.computer.ComputerView;
import ru.octol1ttle.flightassistant.api.display.Display;
import ru.octol1ttle.flightassistant.api.display.HudFrame;
import ru.octol1ttle.flightassistant.api.util.extensions.DrawContextExtensionsKt;
import ru.octol1ttle.flightassistant.config.FAConfig;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0006\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ#\u0010\u0011\u001a\u00020\u000b*\u00020\t2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J#\u0010\u0014\u001a\u00020\u000b*\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J3\u0010\u0019\u001a\u00020\u0006*\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0017H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u001b\u0010\r\u00a8\u0006\u001d"}, d2={"Lru/octol1ttle/flightassistant/impl/display/AltitudeDisplay;", "Lru/octol1ttle/flightassistant/api/display/Display;", "Lru/octol1ttle/flightassistant/api/computer/ComputerView;", "computers", "<init>", "(Lru/octol1ttle/flightassistant/api/computer/ComputerView;)V", "", "allowedByConfig", "()Z", "Lnet/minecraft/client/gui/GuiGraphics;", "drawContext", "", "render", "(Lnet/minecraft/client/gui/GuiGraphics;)V", "", "x", "y", "renderAltitudeReading", "(Lnet/minecraft/client/gui/GuiGraphics;FF)V", "", "renderAltitudeScale", "(Lnet/minecraft/client/gui/GuiGraphics;II)V", "altitude", "", "currentAltitude", "drawAltitudeLine", "(Lnet/minecraft/client/gui/GuiGraphics;IIID)Z", "renderFaulted", "Companion", "flightassistant-neoforge"})
public final class AltitudeDisplay
extends Display {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final float READING_MATRIX_SCALE = 1.5f;
    @NotNull
    private static final ResourceLocation ID = FlightAssistant.INSTANCE.id$flightassistant_neoforge("altitude");

    public AltitudeDisplay(@NotNull ComputerView computers) {
        Intrinsics.checkNotNullParameter((Object)computers, (String)"computers");
        super(computers);
    }

    @Override
    public boolean allowedByConfig() {
        return FAConfig.INSTANCE.getDisplay().getShowAltitudeReading() || FAConfig.INSTANCE.getDisplay().getShowAltitudeScale();
    }

    @Override
    public void render(@NotNull GuiGraphics drawContext) {
        Intrinsics.checkNotNullParameter((Object)drawContext, (String)"drawContext");
        GuiGraphics $this$render_u24lambda_u240 = drawContext;
        boolean bl = false;
        if (FAConfig.INSTANCE.getDisplay().getShowAltitudeReading()) {
            this.renderAltitudeReading($this$render_u24lambda_u240, HudFrame.INSTANCE.getRightF(), DrawContextExtensionsKt.getCenterYF($this$render_u24lambda_u240));
        }
        if (FAConfig.INSTANCE.getDisplay().getShowAltitudeScale()) {
            this.renderAltitudeScale($this$render_u24lambda_u240, HudFrame.INSTANCE.getRight(), DrawContextExtensionsKt.getCenterY($this$render_u24lambda_u240));
        }
    }

    private final void renderAltitudeReading(GuiGraphics $this$renderAltitudeReading, float x, float y) {
        $this$renderAltitudeReading.pose().pushPose();
        DrawContextExtensionsKt.fusedTranslateScale($this$renderAltitudeReading, x, y, 1.5f);
        double altitude = this.getComputers().getData().getAltitude();
        String text = String.valueOf(MathKt.roundToInt((double)altitude));
        int width = DrawContextExtensionsKt.getTextWidth(text) + 5;
        int halfHeight = 6;
        $this$renderAltitudeReading.renderOutline(0, -halfHeight, width, halfHeight * 2 - 1, DrawContextExtensionsKt.getPrimaryColor());
        int textY = -4;
        DrawContextExtensionsKt.drawText($this$renderAltitudeReading, text, 3, textY, DrawContextExtensionsKt.getPrimaryColor());
        $this$renderAltitudeReading.pose().popPose();
    }

    private final void renderAltitudeScale(GuiGraphics $this$renderAltitudeScale, int x, int y) {
        int i;
        int n;
        int n2;
        int altitudeRoundedUp;
        int i2;
        double altitude = this.getComputers().getData().getAltitude();
        int minY = HudFrame.INSTANCE.getTop();
        int maxY = RangesKt.coerceIn((int)((int)((double)y + (double)2 * (altitude - (double)this.getComputers().getData().getWorld().getMinBuildHeight() + 1.0))), (ClosedRange)((ClosedRange)new IntRange(minY - 1, HudFrame.INSTANCE.getBottom())));
        $this$renderAltitudeScale.vLine(x, minY, maxY, DrawContextExtensionsKt.getPrimaryColor());
        $this$renderAltitudeScale.enableScissor(0, minY, $this$renderAltitudeScale.guiWidth(), maxY + 1);
        int scissorMaxY = ((Number)(FAConfig.INSTANCE.getDisplay().getShowAltitudeReading() ? (Number)Float.valueOf((float)y - 9.0f) : (Number)maxY)).intValue();
        $this$renderAltitudeScale.enableScissor(0, minY, $this$renderAltitudeScale.guiWidth(), scissorMaxY + 1);
        $this$renderAltitudeScale.hLine(x, x + 30, y, DrawContextExtensionsKt.getPrimaryColor());
        $this$renderAltitudeScale.hLine(x, x + 35, minY, DrawContextExtensionsKt.getPrimaryColor());
        if (maxY < scissorMaxY) {
            $this$renderAltitudeScale.hLine(x, x + 35, maxY, DrawContextExtensionsKt.getPrimaryColor());
        }
        if ((i2 = (altitudeRoundedUp = Mth.roundToward((int)MathKt.roundToInt((double)altitude), (int)5))) <= (n2 = ProgressionUtilKt.getProgressionLastElement((int)altitudeRoundedUp, (int)(n = altitudeRoundedUp + 1000), (int)5))) {
            while (this.drawAltitudeLine($this$renderAltitudeScale, x, y, i2, altitude) && i2 != n2) {
                i2 += 5;
            }
        }
        $this$renderAltitudeScale.disableScissor();
        $this$renderAltitudeScale.enableScissor(0, ((Number)(FAConfig.INSTANCE.getDisplay().getShowAltitudeReading() ? (Number)Float.valueOf((float)y + 7.5f) : (Number)minY)).intValue(), $this$renderAltitudeScale.guiWidth(), maxY + 1);
        $this$renderAltitudeScale.hLine(x, x + 35, maxY, DrawContextExtensionsKt.getPrimaryColor());
        int altitudeRoundedDown = Mth.quantize((double)altitude, (int)5);
        int n3 = RangesKt.coerceAtLeast((int)(altitudeRoundedDown - 1000), (int)this.getComputers().getData().getWorld().getMinBuildHeight());
        int n4 = ProgressionUtilKt.getProgressionLastElement((int)altitudeRoundedDown, (int)n3, (int)-5);
        if (n4 <= i) {
            for (i = altitudeRoundedDown; this.drawAltitudeLine($this$renderAltitudeScale, x, y, i, altitude) && i != n4; i -= 5) {
            }
        }
        $this$renderAltitudeScale.disableScissor();
        $this$renderAltitudeScale.fill(x - 3, y, x - 1, (int)((double)y - (double)2 * (this.getComputers().getData().getVelocity().y * (double)20)), DrawContextExtensionsKt.getSecondaryColor());
        $this$renderAltitudeScale.disableScissor();
    }

    private final boolean drawAltitudeLine(GuiGraphics $this$drawAltitudeLine, int x, int y, int altitude, double currentAltitude) {
        int textY = (int)((double)y + (double)2 * (currentAltitude - (double)altitude));
        if (textY < HudFrame.INSTANCE.getTop() - 100 || textY > HudFrame.INSTANCE.getBottom() + 100) {
            return false;
        }
        $this$drawAltitudeLine.hLine(x + 5, x, textY, DrawContextExtensionsKt.getPrimaryColor());
        if (altitude % 20 == 0) {
            DrawContextExtensionsKt.drawText($this$drawAltitudeLine, String.valueOf(altitude), x + 8, textY - 3, DrawContextExtensionsKt.getPrimaryColor());
        }
        return true;
    }

    @Override
    public void renderFaulted(@NotNull GuiGraphics drawContext) {
        Intrinsics.checkNotNullParameter((Object)drawContext, (String)"drawContext");
        GuiGraphics $this$renderFaulted_u24lambda_u241 = drawContext;
        boolean bl = false;
        MutableComponent mutableComponent = Component.translatable((String)"short.flightassistant.altitude");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        DrawContextExtensionsKt.drawText($this$renderFaulted_u24lambda_u241, (Component)mutableComponent, HudFrame.INSTANCE.getRight(), DrawContextExtensionsKt.getCenterY($this$renderFaulted_u24lambda_u241) - 5, DrawContextExtensionsKt.getWarningColor());
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0017\u0010\b\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lru/octol1ttle/flightassistant/impl/display/AltitudeDisplay$Companion;", "", "<init>", "()V", "", "READING_MATRIX_SCALE", "F", "Lnet/minecraft/resources/ResourceLocation;", "ID", "Lnet/minecraft/resources/ResourceLocation;", "getID", "()Lnet/minecraft/resources/ResourceLocation;", "flightassistant-neoforge"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceLocation getID() {
            return ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

