/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.impl.display;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import kotlin.Metadata;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import ru.octol1ttle.flightassistant.FlightAssistant;
import ru.octol1ttle.flightassistant.api.autoflight.ControlInput;
import ru.octol1ttle.flightassistant.api.computer.ComputerView;
import ru.octol1ttle.flightassistant.api.display.Display;
import ru.octol1ttle.flightassistant.api.display.HudFrame;
import ru.octol1ttle.flightassistant.api.util.ScreenSpace;
import ru.octol1ttle.flightassistant.api.util.extensions.DrawContextExtensionsKt;
import ru.octol1ttle.flightassistant.config.FAConfig;
import ru.octol1ttle.flightassistant.config.options.DisplayOptions;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u0013\u0010\u000e\u001a\u00020\u000b*\u00020\tH\u0002\u00a2\u0006\u0004\b\u000e\u0010\rJ\u0013\u0010\u000f\u001a\u00020\u000b*\u00020\tH\u0002\u00a2\u0006\u0004\b\u000f\u0010\rJ\u0013\u0010\u0010\u001a\u00020\u000b*\u00020\tH\u0002\u00a2\u0006\u0004\b\u0010\u0010\rJ#\u0010\u0014\u001a\u00020\u000b*\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u0016\u0010\r\u00a8\u0006\u0018"}, d2={"Lru/octol1ttle/flightassistant/impl/display/AttitudeDisplay;", "Lru/octol1ttle/flightassistant/api/display/Display;", "Lru/octol1ttle/flightassistant/api/computer/ComputerView;", "computers", "<init>", "(Lru/octol1ttle/flightassistant/api/computer/ComputerView;)V", "", "allowedByConfig", "()Z", "Lnet/minecraft/client/gui/GuiGraphics;", "drawContext", "", "render", "(Lnet/minecraft/client/gui/GuiGraphics;)V", "renderHorizon", "renderPitchBars", "renderPitchLimits", "", "pitch", "y", "drawPitchBar", "(Lnet/minecraft/client/gui/GuiGraphics;II)V", "renderFaulted", "Companion", "flightassistant-neoforge"})
public final class AttitudeDisplay
extends Display {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final ResourceLocation ID = FlightAssistant.INSTANCE.id$flightassistant_neoforge("attitude");

    public AttitudeDisplay(@NotNull ComputerView computers) {
        Intrinsics.checkNotNullParameter((Object)computers, (String)"computers");
        super(computers);
    }

    @Override
    public boolean allowedByConfig() {
        return FAConfig.INSTANCE.getDisplay().getShowAttitude() != DisplayOptions.AttitudeDisplayMode.DISABLED;
    }

    @Override
    public void render(@NotNull GuiGraphics drawContext) {
        Intrinsics.checkNotNullParameter((Object)drawContext, (String)"drawContext");
        GuiGraphics $this$render_u24lambda_u240 = drawContext;
        boolean bl = false;
        $this$render_u24lambda_u240.pose().pushPose();
        PoseStack poseStack = $this$render_u24lambda_u240.pose();
        Intrinsics.checkNotNullExpressionValue((Object)poseStack, (String)"getMatrices(...)");
        DrawContextExtensionsKt.translate(poseStack, 0, 0, -200);
        $this$render_u24lambda_u240.pose().rotateAround(Axis.ZN.rotationDegrees(this.getComputers().getData().getRoll()), DrawContextExtensionsKt.getCenterXF($this$render_u24lambda_u240), DrawContextExtensionsKt.getCenterYF($this$render_u24lambda_u240), 0.0f);
        if (FAConfig.INSTANCE.getDisplay().getShowAttitude().compareTo((Enum)DisplayOptions.AttitudeDisplayMode.HORIZON_ONLY) <= 0) {
            this.renderHorizon($this$render_u24lambda_u240);
        }
        if (FAConfig.INSTANCE.getDisplay().getShowAttitude() == DisplayOptions.AttitudeDisplayMode.HORIZON_AND_LADDER) {
            this.renderPitchBars($this$render_u24lambda_u240);
            this.renderPitchLimits($this$render_u24lambda_u240);
        }
        $this$render_u24lambda_u240.pose().popPose();
    }

    private final void renderHorizon(GuiGraphics $this$renderHorizon) {
        if (!FAConfig.INSTANCE.getDisplay().getDrawHorizonOutsideFrame()) {
            HudFrame.INSTANCE.scissor($this$renderHorizon);
        }
        Integer n = ScreenSpace.getY$default(ScreenSpace.INSTANCE, 0.0f, false, 2, null);
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            int leftXEnd = (int)((double)DrawContextExtensionsKt.getCenterXF($this$renderHorizon) - (double)DrawContextExtensionsKt.getHalfWidth($this$renderHorizon) * 0.025);
            $this$renderHorizon.hLine(0, leftXEnd, it, DrawContextExtensionsKt.getPrimaryColor());
            int rightXStart = (int)((double)DrawContextExtensionsKt.getCenterXF($this$renderHorizon) + (double)DrawContextExtensionsKt.getHalfWidth($this$renderHorizon) * 0.025);
            $this$renderHorizon.hLine(rightXStart, $this$renderHorizon.guiWidth(), it, DrawContextExtensionsKt.getPrimaryColor());
        }
        if (!FAConfig.INSTANCE.getDisplay().getDrawHorizonOutsideFrame()) {
            $this$renderHorizon.disableScissor();
        }
    }

    private final void renderPitchBars(GuiGraphics $this$renderPitchBars) {
        int step = FAConfig.INSTANCE.getDisplay().getAttitudeDegreeStep();
        if (!FAConfig.INSTANCE.getDisplay().getDrawPitchOutsideFrame()) {
            HudFrame.INSTANCE.scissor($this$renderPitchBars);
        }
        int nextUp = Mth.roundToward((int)((int)this.getComputers().getData().getPitch()), (int)step);
        if (step <= 0) {
            throw new IllegalArgumentException("Step must be positive, was: " + step + ".");
        }
        int i = nextUp;
        int n = ProgressionUtilKt.getProgressionLastElement((int)nextUp, (int)90, (int)step);
        if (i <= n) {
            while (true) {
                Integer n2 = ScreenSpace.getY$default(ScreenSpace.INSTANCE, i, false, 2, null);
                if (n2 == null) {
                    break;
                }
                this.drawPitchBar($this$renderPitchBars, i, n2);
                if (i == n) break;
                i += step;
            }
        }
        int nextDown = Mth.quantize((double)this.getComputers().getData().getPitch(), (int)step);
        if (step <= 0) {
            throw new IllegalArgumentException("Step must be positive, was: " + step + ".");
        }
        n = -step;
        int i2 = nextDown;
        int n3 = ProgressionUtilKt.getProgressionLastElement((int)nextDown, (int)-90, (int)n);
        if (n3 <= i2) {
            while (true) {
                Integer n4 = ScreenSpace.getY$default(ScreenSpace.INSTANCE, i2, false, 2, null);
                if (n4 == null) {
                    break;
                }
                this.drawPitchBar($this$renderPitchBars, i2, n4);
                if (i2 == n3) break;
                i2 += n;
            }
        }
        if (!FAConfig.INSTANCE.getDisplay().getDrawPitchOutsideFrame()) {
            $this$renderPitchBars.disableScissor();
        }
    }

    private final void renderPitchLimits(GuiGraphics $this$renderPitchLimits) {
        int y;
        float max;
        int step = FAConfig.INSTANCE.getDisplay().getAttitudeDegreeStep() / 2;
        if (!FAConfig.INSTANCE.getDisplay().getDrawPitchOutsideFrame()) {
            HudFrame.INSTANCE.scissor($this$renderPitchLimits);
        }
        MutableComponent mutableComponent = Component.literal((String)"V");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"literal(...)");
        Component arrowText = (Component)mutableComponent;
        ControlInput maxInput = this.getComputers().getPitch().getMaximumPitch();
        ControlInput minInput = this.getComputers().getPitch().getMinimumPitch();
        ControlInput controlInput = maxInput;
        ControlInput controlInput2 = minInput;
        float min = RangesKt.coerceAtMost((float)(controlInput2 != null ? controlInput2.getTarget() : -90.0f), (float)max);
        for (max = (v22529) != null ? (v22529).getTarget() : 90.0f; max <= 180.0f; max += (float)step) {
            Integer n = ScreenSpace.getY$default(ScreenSpace.INSTANCE, max, false, 2, null);
            if (n == null) {
                break;
            }
            y = n;
            ControlInput controlInput3 = maxInput;
            DrawContextExtensionsKt.drawMiddleAlignedText($this$renderPitchLimits, arrowText, DrawContextExtensionsKt.getCenterX($this$renderPitchLimits), y, (controlInput3 != null ? controlInput3.getActive() : false) ? DrawContextExtensionsKt.getWarningColor() : DrawContextExtensionsKt.getCautionColor());
        }
        while (min >= -180.0f) {
            Integer n = ScreenSpace.getY$default(ScreenSpace.INSTANCE, min, false, 2, null);
            if (n == null) {
                break;
            }
            y = n;
            $this$renderPitchLimits.pose().pushPose();
            PoseStack poseStack = $this$renderPitchLimits.pose();
            Intrinsics.checkNotNullExpressionValue((Object)poseStack, (String)"getMatrices(...)");
            DrawContextExtensionsKt.translate(poseStack, DrawContextExtensionsKt.getCenterX($this$renderPitchLimits), y, 0);
            $this$renderPitchLimits.pose().mulPose(Axis.ZN.rotationDegrees(180.0f));
            ControlInput controlInput4 = minInput;
            DrawContextExtensionsKt.drawMiddleAlignedText($this$renderPitchLimits, arrowText, 0, 0, (controlInput4 != null ? controlInput4.getActive() : false) ? DrawContextExtensionsKt.getWarningColor() : DrawContextExtensionsKt.getCautionColor());
            $this$renderPitchLimits.pose().popPose();
            min -= (float)step;
        }
        if (!FAConfig.INSTANCE.getDisplay().getDrawPitchOutsideFrame()) {
            $this$renderPitchLimits.disableScissor();
        }
    }

    private final void drawPitchBar(GuiGraphics $this$drawPitchBar, int pitch, int y) {
        if (pitch == 0) {
            return;
        }
        ControlInput min = this.getComputers().getPitch().getMinimumPitch();
        ControlInput max = this.getComputers().getPitch().getMaximumPitch();
        int color = max != null && (float)pitch > max.getTarget() ? (max.getActive() ? DrawContextExtensionsKt.getWarningColor() : DrawContextExtensionsKt.getCautionColor()) : (min != null && (float)pitch < min.getTarget() ? (min.getActive() ? DrawContextExtensionsKt.getWarningColor() : DrawContextExtensionsKt.getCautionColor()) : DrawContextExtensionsKt.getPrimaryColor());
        int leftXEnd = (int)(DrawContextExtensionsKt.getCenterXF($this$drawPitchBar) - DrawContextExtensionsKt.getHalfWidth($this$drawPitchBar) * 0.05f);
        int leftXStart = (int)((float)leftXEnd - DrawContextExtensionsKt.getHalfWidth($this$drawPitchBar) * 0.075f);
        DrawContextExtensionsKt.drawRightAlignedText($this$drawPitchBar, String.valueOf(pitch), leftXStart - 2, pitch > 0 ? y : y - 4, color);
        $this$drawPitchBar.vLine(leftXStart, y, y + 5 * MathKt.getSign((int)pitch), color);
        DrawContextExtensionsKt.drawHorizontalLineDashed($this$drawPitchBar, leftXStart, leftXEnd, y, pitch < 0 ? 3 : 1, color);
        int rightXStart = (int)(DrawContextExtensionsKt.getCenterXF($this$drawPitchBar) + DrawContextExtensionsKt.getHalfWidth($this$drawPitchBar) * 0.05f);
        int rightXEnd = (int)((float)rightXStart + DrawContextExtensionsKt.getHalfWidth($this$drawPitchBar) * 0.075f);
        DrawContextExtensionsKt.drawHorizontalLineDashed($this$drawPitchBar, rightXStart, rightXEnd, y, pitch < 0 ? 3 : 1, color);
        $this$drawPitchBar.vLine(rightXEnd, y, y + 5 * MathKt.getSign((int)pitch), color);
        DrawContextExtensionsKt.drawText($this$drawPitchBar, String.valueOf(pitch), rightXEnd + 4, pitch > 0 ? y : y - 4, color);
    }

    @Override
    public void renderFaulted(@NotNull GuiGraphics drawContext) {
        Intrinsics.checkNotNullParameter((Object)drawContext, (String)"drawContext");
        GuiGraphics $this$renderFaulted_u24lambda_u242 = drawContext;
        boolean bl = false;
        MutableComponent mutableComponent = Component.translatable((String)"short.flightassistant.attitude");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        DrawContextExtensionsKt.drawMiddleAlignedText($this$renderFaulted_u24lambda_u242, (Component)mutableComponent, DrawContextExtensionsKt.getCenterX($this$renderFaulted_u24lambda_u242), DrawContextExtensionsKt.getCenterY($this$renderFaulted_u24lambda_u242) - 16, DrawContextExtensionsKt.getWarningColor());
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lru/octol1ttle/flightassistant/impl/display/AttitudeDisplay$Companion;", "", "<init>", "()V", "Lnet/minecraft/resources/ResourceLocation;", "ID", "Lnet/minecraft/resources/ResourceLocation;", "getID", "()Lnet/minecraft/resources/ResourceLocation;", "flightassistant-neoforge"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceLocation getID() {
            return ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

