/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.impl.display;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.octol1ttle.flightassistant.FAKeyBindings;
import ru.octol1ttle.flightassistant.FlightAssistant;
import ru.octol1ttle.flightassistant.api.autoflight.ControlInput;
import ru.octol1ttle.flightassistant.api.computer.ComputerView;
import ru.octol1ttle.flightassistant.api.display.Display;
import ru.octol1ttle.flightassistant.api.display.HudFrame;
import ru.octol1ttle.flightassistant.api.util.FATickCounter;
import ru.octol1ttle.flightassistant.api.util.MathHelperKt;
import ru.octol1ttle.flightassistant.api.util.extensions.DrawContextExtensionsKt;
import ru.octol1ttle.flightassistant.api.util.extensions.TextExtensionsKt;
import ru.octol1ttle.flightassistant.config.FAConfig;
import ru.octol1ttle.flightassistant.impl.computer.autoflight.AutopilotLogicComputer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001d\u001eB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u000e\u0010\rJ\u0017\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u000f\u0010\rJ)\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00102\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u0016\u0010\rJ\u0017\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u0017\u0010\rR\u0014\u0010\u0018\u001a\u00020\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u0019R\u0014\u0010\u001b\u001a\u00020\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u0019R\u0014\u0010\u001c\u001a\u00020\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u0019\u00a8\u0006\u001f"}, d2={"Lru/octol1ttle/flightassistant/impl/display/AutomationModesDisplay;", "Lru/octol1ttle/flightassistant/api/display/Display;", "Lru/octol1ttle/flightassistant/api/computer/ComputerView;", "computers", "<init>", "(Lru/octol1ttle/flightassistant/api/computer/ComputerView;)V", "", "allowedByConfig", "()Z", "Lnet/minecraft/client/gui/GuiGraphics;", "drawContext", "", "render", "(Lnet/minecraft/client/gui/GuiGraphics;)V", "renderThrustMode", "renderPitchMode", "Lru/octol1ttle/flightassistant/impl/display/AutomationModesDisplay$ModeDisplay;", "display", "Lru/octol1ttle/flightassistant/api/autoflight/ControlInput;", "input", "drawInput", "(Lnet/minecraft/client/gui/GuiGraphics;Lru/octol1ttle/flightassistant/impl/display/AutomationModesDisplay$ModeDisplay;Lru/octol1ttle/flightassistant/api/autoflight/ControlInput;)V", "renderAutomaticsMode", "renderFaulted", "thrustDisplay", "Lru/octol1ttle/flightassistant/impl/display/AutomationModesDisplay$ModeDisplay;", "pitchDisplay", "headingDisplay", "automationStatusDisplay", "Companion", "ModeDisplay", "flightassistant-neoforge"})
public final class AutomationModesDisplay
extends Display {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ModeDisplay thrustDisplay;
    @NotNull
    private final ModeDisplay pitchDisplay;
    @NotNull
    private final ModeDisplay headingDisplay;
    @NotNull
    private final ModeDisplay automationStatusDisplay;
    @NotNull
    private static final ResourceLocation ID = FlightAssistant.INSTANCE.id$flightassistant_neoforge("automation_modes");
    private static final float TOTAL_MODES = 5.0f;

    public AutomationModesDisplay(@NotNull ComputerView computers) {
        Intrinsics.checkNotNullParameter((Object)computers, (String)"computers");
        super(computers);
        this.thrustDisplay = new ModeDisplay(1);
        this.pitchDisplay = new ModeDisplay(2);
        this.headingDisplay = new ModeDisplay(3);
        this.automationStatusDisplay = new ModeDisplay(5);
    }

    @Override
    public boolean allowedByConfig() {
        return FAConfig.INSTANCE.getDisplay().getShowAutomationModes();
    }

    @Override
    public void render(@NotNull GuiGraphics drawContext) {
        Intrinsics.checkNotNullParameter((Object)drawContext, (String)"drawContext");
        this.renderThrustMode(drawContext);
        this.renderPitchMode(drawContext);
        this.drawInput(drawContext, this.headingDisplay, this.getComputers().getHeading().getActiveInput());
        this.renderAutomaticsMode(drawContext);
    }

    private final void renderThrustMode(GuiGraphics drawContext) {
        boolean thrustUnusable = this.getComputers().getThrust().getNoThrustSource() || this.getComputers().getThrust().getReverseUnsupported();
        ControlInput input = this.getComputers().getThrust().getActiveInput();
        if (input != null) {
            if (FAKeyBindings.INSTANCE.isHoldingThrust()) {
                MutableComponent mutableComponent = Component.translatable((String)"mode.flightassistant.thrust.override");
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
                this.thrustDisplay.render(drawContext, (Component)TextExtensionsKt.setColor(mutableComponent, DrawContextExtensionsKt.getCautionColor()), false, DrawContextExtensionsKt.getCautionColor());
            } else {
                this.thrustDisplay.render(drawContext, input.getText(), input.getActive(), thrustUnusable || input.getActive() && input.getPriority().compareTo((Enum)ControlInput.Priority.NORMAL) < 0 ? Integer.valueOf(DrawContextExtensionsKt.getCautionColor()) : null);
            }
            return;
        }
        MutableComponent mutableComponent = Component.literal((String)(MathHelperKt.furtherFromZero(this.getComputers().getThrust().getCurrent() * (float)100) + "%"));
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"literal(...)");
        MutableComponent thrustValueText = TextExtensionsKt.setColor(mutableComponent, DrawContextExtensionsKt.getPrimaryColor());
        if (this.getComputers().getThrust().getThrustLocked()) {
            MutableComponent mutableComponent2;
            if (this.getComputers().getThrust().getCurrent() > 0.99f) {
                MutableComponent mutableComponent3 = Component.translatable((String)"mode.flightassistant.thrust.locked_toga");
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent3, (String)"translatable(...)");
                mutableComponent2 = TextExtensionsKt.setColor(mutableComponent3, DrawContextExtensionsKt.getPrimaryColor());
            } else {
                Object[] objectArray = new Object[]{thrustValueText};
                MutableComponent mutableComponent4 = Component.translatable((String)"mode.flightassistant.thrust.locked", (Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent4, (String)"translatable(...)");
                mutableComponent2 = TextExtensionsKt.setColor(mutableComponent4, DrawContextExtensionsKt.getPrimaryColor());
            }
            this.thrustDisplay.render(drawContext, (Component)mutableComponent2, false, FATickCounter.INSTANCE.getTotalTicks() % 20 >= 10 ? DrawContextExtensionsKt.getCautionColor() : 0);
            return;
        }
        if (!(this.getComputers().getThrust().getCurrent() == 0.0f)) {
            MutableComponent mutableComponent5;
            if (this.getComputers().getThrust().getCurrent() > 0.99f) {
                MutableComponent mutableComponent6 = Component.translatable((String)"mode.flightassistant.thrust.manual_toga");
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent6, (String)"translatable(...)");
                mutableComponent5 = TextExtensionsKt.setColor(mutableComponent6, DrawContextExtensionsKt.getSecondaryColor());
            } else {
                Object[] objectArray = new Object[]{thrustValueText};
                mutableComponent5 = Component.translatable((String)"mode.flightassistant.thrust.manual", (Object[])objectArray);
            }
            ModeDisplay.render$default(this.thrustDisplay, drawContext, (Component)mutableComponent5, this.getComputers().getThrust().getCurrent() == 0.0f || this.getComputers().getThrust().getCurrent() > 0.99f, null, 8, null);
            return;
        }
        ModeDisplay.render$default(this.thrustDisplay, drawContext, null, true, null, 8, null);
    }

    private final void renderPitchMode(GuiGraphics drawContext) {
        if (this.getComputers().getPitch().getManualOverride$flightassistant_neoforge()) {
            MutableComponent mutableComponent = Component.translatable((String)"mode.flightassistant.vertical.override");
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
            this.pitchDisplay.render(drawContext, (Component)TextExtensionsKt.setColor(mutableComponent, DrawContextExtensionsKt.getCautionColor()), false, DrawContextExtensionsKt.getCautionColor());
            return;
        }
        this.drawInput(drawContext, this.pitchDisplay, this.getComputers().getPitch().getActiveInput());
    }

    private final void drawInput(GuiGraphics drawContext, ModeDisplay display, ControlInput input) {
        if (input != null) {
            display.render(drawContext, input.getText(), input.getActive(), input.getActive() && input.getPriority().compareTo((Enum)ControlInput.Priority.NORMAL) < 0 ? Integer.valueOf(DrawContextExtensionsKt.getCautionColor()) : null);
        } else {
            ModeDisplay.render$default(display, drawContext, null, true, null, 8, null);
        }
    }

    private final void renderAutomaticsMode(GuiGraphics drawContext) {
        MutableComponent mutableComponent = Component.empty();
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"empty(...)");
        MutableComponent text = mutableComponent;
        if (this.getComputers().getAutomations().getFlightDirectors()) {
            MutableComponent mutableComponent2 = Component.translatable((String)"short.flightassistant.flight_directors");
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent2, (String)"translatable(...)");
            TextExtensionsKt.appendWithSeparation(text, (Component)mutableComponent2);
        }
        if (this.getComputers().getAutomations().getAutoThrust()) {
            MutableComponent mutableComponent3 = Component.translatable((String)"short.flightassistant.auto_thrust");
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent3, (String)"translatable(...)");
            MutableComponent autoThrustText = mutableComponent3;
            ControlInput controlInput = this.getComputers().getThrust().getActiveInput();
            TextExtensionsKt.appendWithSeparation(text, (Component)(Intrinsics.areEqual((Object)(controlInput != null ? controlInput.getIdentifier() : null), (Object)AutopilotLogicComputer.Companion.getID()) ? autoThrustText : TextExtensionsKt.setColor(autoThrustText, DrawContextExtensionsKt.getAdvisoryColor())));
        }
        if (this.getComputers().getAutomations().getAutopilot()) {
            MutableComponent mutableComponent4 = Component.translatable((String)"short.flightassistant.autopilot");
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent4, (String)"translatable(...)");
            TextExtensionsKt.appendWithSeparation(text, (Component)mutableComponent4);
        }
        List list = text.getSiblings();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSiblings(...)");
        this.automationStatusDisplay.render(drawContext, (Component)(!((Collection)list).isEmpty() ? text : null), true, this.getComputers().getAutomations().getAutopilotAlert() ? Integer.valueOf(DrawContextExtensionsKt.getWarningColor()) : (this.getComputers().getAutomations().getAutoThrustAlert() ? Integer.valueOf(DrawContextExtensionsKt.getCautionColor()) : null));
    }

    @Override
    public void renderFaulted(@NotNull GuiGraphics drawContext) {
        Intrinsics.checkNotNullParameter((Object)drawContext, (String)"drawContext");
        GuiGraphics $this$renderFaulted_u24lambda_u240 = drawContext;
        boolean bl = false;
        int x = DrawContextExtensionsKt.getCenterX($this$renderFaulted_u24lambda_u240);
        int y = HudFrame.INSTANCE.getTop() - 9;
        MutableComponent mutableComponent = Component.translatable((String)"short.flightassistant.automation_modes");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        DrawContextExtensionsKt.drawMiddleAlignedText($this$renderFaulted_u24lambda_u240, (Component)mutableComponent, x, y, DrawContextExtensionsKt.getWarningColor());
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\n\u001a\u00020\t8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lru/octol1ttle/flightassistant/impl/display/AutomationModesDisplay$Companion;", "", "<init>", "()V", "Lnet/minecraft/resources/ResourceLocation;", "ID", "Lnet/minecraft/resources/ResourceLocation;", "getID", "()Lnet/minecraft/resources/ResourceLocation;", "", "TOTAL_MODES", "F", "flightassistant-neoforge"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceLocation getID() {
            return ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J5\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\u000b\u001a\u00020\n2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0010R\u0018\u0010\u0011\u001a\u0004\u0018\u00010\b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0013\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0010\u00a8\u0006\u0014"}, d2={"Lru/octol1ttle/flightassistant/impl/display/AutomationModesDisplay$ModeDisplay;", "", "", "order", "<init>", "(I)V", "Lnet/minecraft/client/gui/GuiGraphics;", "drawContext", "Lnet/minecraft/network/chat/Component;", "text", "", "active", "borderColor", "", "render", "(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/network/chat/Component;ZLjava/lang/Integer;)V", "I", "lastText", "Lnet/minecraft/network/chat/Component;", "textChangedAt", "flightassistant-neoforge"})
    public static final class ModeDisplay {
        private final int order;
        @Nullable
        private Component lastText;
        private int textChangedAt;

        public ModeDisplay(int order) {
            this.order = order;
        }

        public final void render(@NotNull GuiGraphics drawContext, @Nullable Component text, boolean active, @Nullable Integer borderColor) {
            Intrinsics.checkNotNullParameter((Object)drawContext, (String)"drawContext");
            int farLeft = HudFrame.INSTANCE.getLeft() - 35;
            int farRight = HudFrame.INSTANCE.getRight() + 35;
            int farWidth = farRight - farLeft;
            int singleWidth = MathKt.roundToInt((float)(((float)farWidth - 4.0f) / 5.0f));
            int leftX = farLeft + (singleWidth + 1) * (this.order - 1);
            int rightX = this.order == 5 ? farRight + 1 : leftX + singleWidth;
            int y = HudFrame.INSTANCE.getTop() - 10;
            if (active && !Objects.equals(text, this.lastText)) {
                this.textChangedAt = FATickCounter.INSTANCE.getTotalTicks();
                this.lastText = text;
            }
            if (text != null) {
                DrawContextExtensionsKt.drawMiddleAlignedText(drawContext, text, (leftX + rightX) / 2, y, active ? DrawContextExtensionsKt.getPrimaryColor() : DrawContextExtensionsKt.getSecondaryColor());
            }
            if (borderColor != null || FATickCounter.INSTANCE.getTotalTicks() <= this.textChangedAt + (text == null ? 60 : 100)) {
                Integer n = borderColor;
                drawContext.renderOutline(leftX, y - 2, rightX - leftX, 11, n != null ? n : DrawContextExtensionsKt.getSecondaryColor());
            }
        }

        public static /* synthetic */ void render$default(ModeDisplay modeDisplay, GuiGraphics guiGraphics, Component component, boolean bl, Integer n, int n2, Object object) {
            if ((n2 & 4) != 0) {
                bl = true;
            }
            if ((n2 & 8) != 0) {
                n = null;
            }
            modeDisplay.render(guiGraphics, component, bl, n);
        }
    }
}

