/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.impl.display;

import com.mojang.blaze3d.vertex.PoseStack;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import ru.octol1ttle.flightassistant.FlightAssistant;
import ru.octol1ttle.flightassistant.api.computer.ComputerView;
import ru.octol1ttle.flightassistant.api.display.Display;
import ru.octol1ttle.flightassistant.api.util.ScreenSpace;
import ru.octol1ttle.flightassistant.api.util.extensions.DrawContextExtensionsKt;
import ru.octol1ttle.flightassistant.config.FAConfig;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u000e\u0010\r\u00a8\u0006\u0010"}, d2={"Lru/octol1ttle/flightassistant/impl/display/FlightPathDisplay;", "Lru/octol1ttle/flightassistant/api/display/Display;", "Lru/octol1ttle/flightassistant/api/computer/ComputerView;", "computers", "<init>", "(Lru/octol1ttle/flightassistant/api/computer/ComputerView;)V", "", "allowedByConfig", "()Z", "Lnet/minecraft/client/gui/GuiGraphics;", "drawContext", "", "render", "(Lnet/minecraft/client/gui/GuiGraphics;)V", "renderFaulted", "Companion", "flightassistant-neoforge"})
public final class FlightPathDisplay
extends Display {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final ResourceLocation ID = FlightAssistant.INSTANCE.id$flightassistant_neoforge("flight_path");

    public FlightPathDisplay(@NotNull ComputerView computers) {
        Intrinsics.checkNotNullParameter((Object)computers, (String)"computers");
        super(computers);
    }

    @Override
    public boolean allowedByConfig() {
        return FAConfig.INSTANCE.getDisplay().getShowFlightPathVector();
    }

    @Override
    public void render(@NotNull GuiGraphics drawContext) {
        Intrinsics.checkNotNullParameter((Object)drawContext, (String)"drawContext");
        GuiGraphics $this$render_u24lambda_u240 = drawContext;
        boolean bl = false;
        Vector3f vector3f = ScreenSpace.INSTANCE.getVector3f(this.getComputers().getData().getVelocity(), false);
        if (vector3f == null) {
            return;
        }
        Vector3f screenSpaceVec = vector3f;
        float trueX = screenSpaceVec.x;
        float trueY = screenSpaceVec.y;
        $this$render_u24lambda_u240.pose().pushPose();
        PoseStack poseStack = $this$render_u24lambda_u240.pose();
        Intrinsics.checkNotNullExpressionValue((Object)poseStack, (String)"getMatrices(...)");
        DrawContextExtensionsKt.translate(poseStack, 0, 0, -100);
        DrawContextExtensionsKt.fusedTranslateScale($this$render_u24lambda_u240, trueX, trueY, FAConfig.INSTANCE.getDisplay().getFlightPathVectorSize());
        int bodySideSize = 3;
        $this$render_u24lambda_u240.vLine(-bodySideSize, -bodySideSize, bodySideSize, DrawContextExtensionsKt.getPrimaryColor());
        $this$render_u24lambda_u240.vLine(bodySideSize, -bodySideSize, bodySideSize, DrawContextExtensionsKt.getPrimaryColor());
        $this$render_u24lambda_u240.hLine(-bodySideSize, bodySideSize, -bodySideSize, DrawContextExtensionsKt.getPrimaryColor());
        $this$render_u24lambda_u240.hLine(-bodySideSize, bodySideSize, bodySideSize, DrawContextExtensionsKt.getPrimaryColor());
        int stabilizerSize = 5;
        $this$render_u24lambda_u240.vLine(0, -bodySideSize - stabilizerSize, -bodySideSize, DrawContextExtensionsKt.getPrimaryColor());
        int wingSize = 5;
        $this$render_u24lambda_u240.hLine(-bodySideSize - wingSize, -bodySideSize, 0, DrawContextExtensionsKt.getPrimaryColor());
        $this$render_u24lambda_u240.hLine(bodySideSize, bodySideSize + wingSize, 0, DrawContextExtensionsKt.getPrimaryColor());
        $this$render_u24lambda_u240.pose().popPose();
    }

    @Override
    public void renderFaulted(@NotNull GuiGraphics drawContext) {
        Intrinsics.checkNotNullParameter((Object)drawContext, (String)"drawContext");
        GuiGraphics $this$renderFaulted_u24lambda_u241 = drawContext;
        boolean bl = false;
        MutableComponent mutableComponent = Component.translatable((String)"short.flightassistant.flight_path");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        DrawContextExtensionsKt.drawMiddleAlignedText($this$renderFaulted_u24lambda_u241, (Component)mutableComponent, DrawContextExtensionsKt.getCenterX($this$renderFaulted_u24lambda_u241), DrawContextExtensionsKt.getCenterY($this$renderFaulted_u24lambda_u241) + 16, DrawContextExtensionsKt.getWarningColor());
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lru/octol1ttle/flightassistant/impl/display/FlightPathDisplay$Companion;", "", "<init>", "()V", "Lnet/minecraft/resources/ResourceLocation;", "ID", "Lnet/minecraft/resources/ResourceLocation;", "getID", "()Lnet/minecraft/resources/ResourceLocation;", "flightassistant-neoforge"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceLocation getID() {
            return ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

