/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.impl.display;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import ru.octol1ttle.flightassistant.FlightAssistant;
import ru.octol1ttle.flightassistant.api.computer.ComputerView;
import ru.octol1ttle.flightassistant.api.display.Display;
import ru.octol1ttle.flightassistant.api.display.HudFrame;
import ru.octol1ttle.flightassistant.api.util.ScreenSpace;
import ru.octol1ttle.flightassistant.api.util.extensions.DrawContextExtensionsKt;
import ru.octol1ttle.flightassistant.config.FAConfig;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u001b\u0010\u0010\u001a\u00020\u000b*\u00020\t2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J3\u0010\u0016\u001a\u00020\u000b*\u00020\t2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u0018\u0010\r\u00a8\u0006\u001a"}, d2={"Lru/octol1ttle/flightassistant/impl/display/HeadingDisplay;", "Lru/octol1ttle/flightassistant/api/display/Display;", "Lru/octol1ttle/flightassistant/api/computer/ComputerView;", "computers", "<init>", "(Lru/octol1ttle/flightassistant/api/computer/ComputerView;)V", "", "allowedByConfig", "()Z", "Lnet/minecraft/client/gui/GuiGraphics;", "drawContext", "", "render", "(Lnet/minecraft/client/gui/GuiGraphics;)V", "", "y", "drawHeading", "(Lnet/minecraft/client/gui/GuiGraphics;I)V", "x", "heading", "", "headingText", "drawHeadingLine", "(Lnet/minecraft/client/gui/GuiGraphics;IIILjava/lang/String;)V", "renderFaulted", "Companion", "flightassistant-neoforge"})
public final class HeadingDisplay
extends Display {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final ResourceLocation ID = FlightAssistant.INSTANCE.id$flightassistant_neoforge("heading");

    public HeadingDisplay(@NotNull ComputerView computers) {
        Intrinsics.checkNotNullParameter((Object)computers, (String)"computers");
        super(computers);
    }

    @Override
    public boolean allowedByConfig() {
        return FAConfig.INSTANCE.getDisplay().getShowHeadingReading() || FAConfig.INSTANCE.getDisplay().getShowHeadingScale();
    }

    @Override
    public void render(@NotNull GuiGraphics drawContext) {
        Intrinsics.checkNotNullParameter((Object)drawContext, (String)"drawContext");
        GuiGraphics $this$render_u24lambda_u241 = drawContext;
        boolean bl = false;
        if (FAConfig.INSTANCE.getDisplay().getShowHeadingReading()) {
            int x = DrawContextExtensionsKt.getCenterX($this$render_u24lambda_u241);
            int y = HudFrame.INSTANCE.getTop() - 25;
            $this$render_u24lambda_u241.renderOutline(x - 11, y, 23, 11, DrawContextExtensionsKt.getPrimaryColor());
            int headingInt = MathKt.roundToInt((float)this.getComputers().getData().getHeading());
            String string = "%03d";
            Object[] objectArray = new Object[]{headingInt == 0 ? 360 : headingInt};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            DrawContextExtensionsKt.drawMiddleAlignedText($this$render_u24lambda_u241, string2, x, y + 2, DrawContextExtensionsKt.getPrimaryColor());
        }
        if (FAConfig.INSTANCE.getDisplay().getShowHeadingScale()) {
            if (!FAConfig.INSTANCE.getDisplay().getDrawHorizonOutsideFrame()) {
                HudFrame.INSTANCE.scissor($this$render_u24lambda_u241);
            }
            $this$render_u24lambda_u241.pose().pushPose();
            PoseStack poseStack = $this$render_u24lambda_u241.pose();
            Intrinsics.checkNotNullExpressionValue((Object)poseStack, (String)"getMatrices(...)");
            DrawContextExtensionsKt.translate(poseStack, 0, 0, -200);
            $this$render_u24lambda_u241.pose().rotateAround(Axis.ZN.rotationDegrees(this.getComputers().getData().getRoll()), DrawContextExtensionsKt.getCenterXF($this$render_u24lambda_u241), DrawContextExtensionsKt.getCenterYF($this$render_u24lambda_u241), 0.0f);
            Integer n = ScreenSpace.getY$default(ScreenSpace.INSTANCE, 0.0f, false, 2, null);
            if (n != null) {
                int it = ((Number)n).intValue();
                boolean bl2 = false;
                this.drawHeading($this$render_u24lambda_u241, it);
            }
            $this$render_u24lambda_u241.pose().popPose();
            if (!FAConfig.INSTANCE.getDisplay().getDrawHorizonOutsideFrame()) {
                $this$render_u24lambda_u241.disableScissor();
            }
        }
    }

    private final void drawHeading(GuiGraphics $this$drawHeading, int y) {
        String text;
        int x;
        int heading;
        int step = FAConfig.INSTANCE.getDisplay().getHeadingDegreeStep();
        int nextDown = Mth.quantize((double)this.getComputers().getData().getHeading(), (int)step);
        if (step <= 0) {
            throw new IllegalArgumentException("Step must be positive, was: " + step + ".");
        }
        int n = -step;
        int i = nextDown;
        int n2 = ProgressionUtilKt.getProgressionLastElement((int)nextDown, (int)-360, (int)n);
        if (n2 <= i) {
            while (true) {
                heading = i % 360;
                Integer n3 = ScreenSpace.getX$default(ScreenSpace.INSTANCE, heading, false, 2, null);
                if (n3 == null) {
                    break;
                }
                x = n3;
                text = String.valueOf(i > 0 ? i : 360 + i);
                this.drawHeadingLine($this$drawHeading, x, y, heading, text);
                if (i == n2) break;
                i += n;
            }
        }
        int nextUp = Mth.roundToward((int)MathKt.roundToInt((float)this.getComputers().getData().getHeading()), (int)step);
        if (step <= 0) {
            throw new IllegalArgumentException("Step must be positive, was: " + step + ".");
        }
        i = nextUp;
        n2 = ProgressionUtilKt.getProgressionLastElement((int)nextUp, (int)720, (int)step);
        if (i <= n2) {
            while (true) {
                heading = i % 360;
                Integer n4 = ScreenSpace.getX$default(ScreenSpace.INSTANCE, heading, false, 2, null);
                if (n4 == null) {
                    break;
                }
                x = n4;
                text = String.valueOf(heading == 0 ? 360 : heading);
                this.drawHeadingLine($this$drawHeading, x, y, heading, text);
                if (i == n2) break;
                i += step;
            }
        }
    }

    private final void drawHeadingLine(GuiGraphics $this$drawHeadingLine, int x, int y, int heading, String headingText) {
        $this$drawHeadingLine.vLine(x, y, y - 3, DrawContextExtensionsKt.getPrimaryColor());
        DrawContextExtensionsKt.drawMiddleAlignedText($this$drawHeadingLine, headingText, x, y - 12, DrawContextExtensionsKt.getPrimaryColor());
        if (heading % 90 == 0) {
            DrawContextExtensionsKt.drawMiddleAlignedText($this$drawHeadingLine, switch (heading) {
                case 0 -> "-Z";
                case 90 -> "+X";
                case 180 -> "+Z";
                case 270 -> "-X";
                default -> throw new IllegalArgumentException("Degree range out of bounds: " + heading);
            }, x, y + 3, DrawContextExtensionsKt.getPrimaryColor());
        }
    }

    @Override
    public void renderFaulted(@NotNull GuiGraphics drawContext) {
        Intrinsics.checkNotNullParameter((Object)drawContext, (String)"drawContext");
        GuiGraphics $this$renderFaulted_u24lambda_u242 = drawContext;
        boolean bl = false;
        MutableComponent mutableComponent = Component.translatable((String)"short.flightassistant.heading");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        DrawContextExtensionsKt.drawMiddleAlignedText($this$renderFaulted_u24lambda_u242, (Component)mutableComponent, DrawContextExtensionsKt.getCenterX($this$renderFaulted_u24lambda_u242), HudFrame.INSTANCE.getTop() - 25, DrawContextExtensionsKt.getWarningColor());
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lru/octol1ttle/flightassistant/impl/display/HeadingDisplay$Companion;", "", "<init>", "()V", "Lnet/minecraft/resources/ResourceLocation;", "ID", "Lnet/minecraft/resources/ResourceLocation;", "getID", "()Lnet/minecraft/resources/ResourceLocation;", "flightassistant-neoforge"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceLocation getID() {
            return ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

