/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.impl.display;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import ru.octol1ttle.flightassistant.FlightAssistant;
import ru.octol1ttle.flightassistant.api.computer.ComputerView;
import ru.octol1ttle.flightassistant.api.display.Display;
import ru.octol1ttle.flightassistant.api.display.HudFrame;
import ru.octol1ttle.flightassistant.api.util.extensions.DrawContextExtensionsKt;
import ru.octol1ttle.flightassistant.config.FAConfig;
import ru.octol1ttle.flightassistant.impl.computer.safety.VoidProximityComputer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u000e\u0010\r\u00a8\u0006\u0010"}, d2={"Lru/octol1ttle/flightassistant/impl/display/RadarAltitudeDisplay;", "Lru/octol1ttle/flightassistant/api/display/Display;", "Lru/octol1ttle/flightassistant/api/computer/ComputerView;", "computers", "<init>", "(Lru/octol1ttle/flightassistant/api/computer/ComputerView;)V", "", "allowedByConfig", "()Z", "Lnet/minecraft/client/gui/GuiGraphics;", "drawContext", "", "render", "(Lnet/minecraft/client/gui/GuiGraphics;)V", "renderFaulted", "Companion", "flightassistant-neoforge"})
public final class RadarAltitudeDisplay
extends Display {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final ResourceLocation ID = FlightAssistant.INSTANCE.id$flightassistant_neoforge("radar_altitude");

    public RadarAltitudeDisplay(@NotNull ComputerView computers) {
        Intrinsics.checkNotNullParameter((Object)computers, (String)"computers");
        super(computers);
    }

    @Override
    public boolean allowedByConfig() {
        return FAConfig.INSTANCE.getDisplay().getShowRadarAltitude();
    }

    @Override
    public void render(@NotNull GuiGraphics drawContext) {
        Intrinsics.checkNotNullParameter((Object)drawContext, (String)"drawContext");
        Double groundLevel = this.getComputers().getData().getGroundLevel();
        if (!this.getComputers().getData().isCurrentChunkLoaded() || groundLevel != null && groundLevel > this.getComputers().getData().getAltitude()) {
            this.renderFaulted(drawContext);
            return;
        }
        GuiGraphics $this$render_u24lambda_u240 = drawContext;
        boolean bl = false;
        int x = HudFrame.INSTANCE.getRight() - 1;
        int y = HudFrame.INSTANCE.getBottom() + 2;
        MutableComponent altType = null;
        String altString = null;
        int color = 0;
        if (groundLevel != null) {
            altType = Component.translatable((String)"short.flightassistant.ground");
            altString = String.valueOf(MathKt.roundToInt((double)(this.getComputers().getData().getAltitude() - groundLevel)));
            color = DrawContextExtensionsKt.getPrimaryColor();
        } else {
            altType = Component.translatable((String)"short.flightassistant.void");
            altString = String.valueOf(MathKt.roundToInt((double)(this.getComputers().getData().getAltitude() - (double)this.getComputers().getData().getVoidLevel())));
            color = switch (WhenMappings.$EnumSwitchMapping$0[this.getComputers().getVoidProximity().getStatus().ordinal()]) {
                case 1 -> DrawContextExtensionsKt.getWarningColor();
                case 2 -> DrawContextExtensionsKt.getCautionColor();
                default -> DrawContextExtensionsKt.getPrimaryColor();
            };
        }
        int xOffset = DrawContextExtensionsKt.getTextWidth((Component)altType) + 1;
        DrawContextExtensionsKt.drawText($this$render_u24lambda_u240, (Component)altType, x - xOffset, y + 2, color);
        $this$render_u24lambda_u240.renderOutline(x, y, DrawContextExtensionsKt.getTextWidth(altString) + 5, 11, color);
        DrawContextExtensionsKt.drawText($this$render_u24lambda_u240, altString, x + 3, y + 2, color);
    }

    @Override
    public void renderFaulted(@NotNull GuiGraphics drawContext) {
        Intrinsics.checkNotNullParameter((Object)drawContext, (String)"drawContext");
        GuiGraphics $this$renderFaulted_u24lambda_u241 = drawContext;
        boolean bl = false;
        MutableComponent mutableComponent = Component.translatable((String)"short.flightassistant.radar_altitude");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        DrawContextExtensionsKt.drawText($this$renderFaulted_u24lambda_u241, (Component)mutableComponent, HudFrame.INSTANCE.getRight() - 1, HudFrame.INSTANCE.getBottom() + 4, DrawContextExtensionsKt.getWarningColor());
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lru/octol1ttle/flightassistant/impl/display/RadarAltitudeDisplay$Companion;", "", "<init>", "()V", "Lnet/minecraft/resources/ResourceLocation;", "ID", "Lnet/minecraft/resources/ResourceLocation;", "getID", "()Lnet/minecraft/resources/ResourceLocation;", "flightassistant-neoforge"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceLocation getID() {
            return ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[VoidProximityComputer.Status.values().length];
            try {
                nArray[VoidProximityComputer.Status.REACHED_DAMAGE_ALTITUDE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VoidProximityComputer.Status.APPROACHING_DAMAGE_ALTITUDE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

