/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.impl.display;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import ru.octol1ttle.flightassistant.FlightAssistant;
import ru.octol1ttle.flightassistant.api.computer.ComputerView;
import ru.octol1ttle.flightassistant.api.display.Display;
import ru.octol1ttle.flightassistant.api.display.HudFrame;
import ru.octol1ttle.flightassistant.api.util.extensions.DrawContextExtensionsKt;
import ru.octol1ttle.flightassistant.config.FAConfig;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0007\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ#\u0010\u0011\u001a\u00020\u000b*\u00020\t2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J#\u0010\u0014\u001a\u00020\u000b*\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J;\u0010\u001a\u001a\u00020\u0006*\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u001c\u0010\r\u00a8\u0006\u001e"}, d2={"Lru/octol1ttle/flightassistant/impl/display/SpeedDisplay;", "Lru/octol1ttle/flightassistant/api/display/Display;", "Lru/octol1ttle/flightassistant/api/computer/ComputerView;", "computers", "<init>", "(Lru/octol1ttle/flightassistant/api/computer/ComputerView;)V", "", "allowedByConfig", "()Z", "Lnet/minecraft/client/gui/GuiGraphics;", "drawContext", "", "render", "(Lnet/minecraft/client/gui/GuiGraphics;)V", "", "x", "y", "renderSpeedReading", "(Lnet/minecraft/client/gui/GuiGraphics;FF)V", "", "renderSpeedScale", "(Lnet/minecraft/client/gui/GuiGraphics;II)V", "speed", "", "currentSpeed", "color", "drawSpeedLine", "(Lnet/minecraft/client/gui/GuiGraphics;IIIDI)Z", "renderFaulted", "Companion", "flightassistant-neoforge"})
public final class SpeedDisplay
extends Display {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final float READING_MATRIX_SCALE = 1.5f;
    @NotNull
    private static final ResourceLocation ID = FlightAssistant.INSTANCE.id$flightassistant_neoforge("speed");

    public SpeedDisplay(@NotNull ComputerView computers) {
        Intrinsics.checkNotNullParameter((Object)computers, (String)"computers");
        super(computers);
    }

    @Override
    public boolean allowedByConfig() {
        return FAConfig.INSTANCE.getDisplay().getShowSpeedReading() || FAConfig.INSTANCE.getDisplay().getShowSpeedScale();
    }

    @Override
    public void render(@NotNull GuiGraphics drawContext) {
        Intrinsics.checkNotNullParameter((Object)drawContext, (String)"drawContext");
        GuiGraphics $this$render_u24lambda_u240 = drawContext;
        boolean bl = false;
        if (FAConfig.INSTANCE.getDisplay().getShowSpeedReading()) {
            this.renderSpeedReading($this$render_u24lambda_u240, HudFrame.INSTANCE.getLeftF(), DrawContextExtensionsKt.getCenterYF($this$render_u24lambda_u240));
        }
        if (FAConfig.INSTANCE.getDisplay().getShowSpeedScale()) {
            this.renderSpeedScale($this$render_u24lambda_u240, HudFrame.INSTANCE.getLeft(), DrawContextExtensionsKt.getCenterY($this$render_u24lambda_u240));
        }
    }

    private final void renderSpeedReading(GuiGraphics $this$renderSpeedReading, float x, float y) {
        $this$renderSpeedReading.pose().pushPose();
        DrawContextExtensionsKt.fusedTranslateScale($this$renderSpeedReading, x * 1.005f, y, 1.5f);
        double speed = this.getComputers().getData().getForwardVelocity().length() * (double)20;
        int color = speed <= 0.0 ? DrawContextExtensionsKt.getWarningColor() : DrawContextExtensionsKt.getPrimaryColor();
        String text = String.valueOf(MathKt.roundToInt((double)speed));
        int width = DrawContextExtensionsKt.getTextWidth(text) + 5;
        int halfHeight = 6;
        int textY = -4;
        $this$renderSpeedReading.renderOutline(-width, -halfHeight, width, halfHeight * 2 - 1, color);
        DrawContextExtensionsKt.drawRightAlignedText($this$renderSpeedReading, text, -2, textY, color);
        $this$renderSpeedReading.pose().popPose();
    }

    private final void renderSpeedScale(GuiGraphics $this$renderSpeedScale, int x, int y) {
        int i;
        double speed = this.getComputers().getData().getForwardVelocity().length() * (double)20;
        int color = speed <= 0.0 ? DrawContextExtensionsKt.getWarningColor() : DrawContextExtensionsKt.getPrimaryColor();
        int minY = HudFrame.INSTANCE.getTop();
        int maxY = RangesKt.coerceIn((int)((int)((double)y + (double)DrawContextExtensionsKt.getFontHeight() * (speed + 1.0))), (ClosedRange)((ClosedRange)new IntRange(minY - 1, HudFrame.INSTANCE.getBottom())));
        $this$renderSpeedScale.vLine(x, minY, maxY, color);
        $this$renderSpeedScale.enableScissor(0, minY, $this$renderSpeedScale.guiWidth(), maxY + 1);
        $this$renderSpeedScale.enableScissor(0, minY, $this$renderSpeedScale.guiWidth(), ((Number)(FAConfig.INSTANCE.getDisplay().getShowSpeedReading() ? (Number)Float.valueOf((float)y - 9.0f) : (Number)maxY)).intValue() + 1);
        $this$renderSpeedScale.hLine(x - 30, x, y, color);
        $this$renderSpeedScale.hLine(x - 35, x, minY, color);
        int n = MathKt.roundToInt((double)speed) + 100;
        if (i <= n) {
            for (i = MathKt.roundToInt((double)speed); this.drawSpeedLine($this$renderSpeedScale, x, y, i, speed, color) && i != n; ++i) {
            }
        }
        $this$renderSpeedScale.disableScissor();
        $this$renderSpeedScale.enableScissor(0, ((Number)(FAConfig.INSTANCE.getDisplay().getShowSpeedReading() ? (Number)Float.valueOf((float)y + 7.5f) : (Number)minY)).intValue(), $this$renderSpeedScale.guiWidth(), maxY + 1);
        $this$renderSpeedScale.hLine(x - 35, x, maxY, color);
        for (i = MathKt.roundToInt((double)speed); -1 < i && this.drawSpeedLine($this$renderSpeedScale, x, y, i, speed, color); --i) {
        }
        $this$renderSpeedScale.disableScissor();
        $this$renderSpeedScale.disableScissor();
    }

    private final boolean drawSpeedLine(GuiGraphics $this$drawSpeedLine, int x, int y, int speed, double currentSpeed, int color) {
        int textY = (int)((double)y + (double)DrawContextExtensionsKt.getFontHeight() * (currentSpeed - (double)speed));
        if (textY < HudFrame.INSTANCE.getTop() - 100 || textY > HudFrame.INSTANCE.getBottom() + 100) {
            return false;
        }
        $this$drawSpeedLine.hLine(x - 5, x, textY, color);
        if (speed % 5 == 0) {
            DrawContextExtensionsKt.drawRightAlignedText($this$drawSpeedLine, String.valueOf(speed), x - 6, textY - 3, color);
        }
        return true;
    }

    @Override
    public void renderFaulted(@NotNull GuiGraphics drawContext) {
        Intrinsics.checkNotNullParameter((Object)drawContext, (String)"drawContext");
        GuiGraphics $this$renderFaulted_u24lambda_u241 = drawContext;
        boolean bl = false;
        MutableComponent mutableComponent = Component.translatable((String)"short.flightassistant.speed");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        DrawContextExtensionsKt.drawRightAlignedText($this$renderFaulted_u24lambda_u241, (Component)mutableComponent, HudFrame.INSTANCE.getLeft(), DrawContextExtensionsKt.getCenterY($this$renderFaulted_u24lambda_u241) - 5, DrawContextExtensionsKt.getWarningColor());
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0017\u0010\b\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lru/octol1ttle/flightassistant/impl/display/SpeedDisplay$Companion;", "", "<init>", "()V", "", "READING_MATRIX_SCALE", "F", "Lnet/minecraft/resources/ResourceLocation;", "ID", "Lnet/minecraft/resources/ResourceLocation;", "getID", "()Lnet/minecraft/resources/ResourceLocation;", "flightassistant-neoforge"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceLocation getID() {
            return ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

