/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.mixin.sound;

import com.mojang.blaze3d.audio.Channel;
import java.util.Map;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.ChannelAccess;
import net.minecraft.client.sounds.SoundEngine;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import ru.octol1ttle.flightassistant.api.util.SoundExtensions;

@Mixin(value={SoundEngine.class})
abstract class SoundSystemMixin
implements SoundExtensions {
    @Shadow
    private boolean loaded;
    @Shadow
    @Final
    private Map<SoundInstance, ChannelAccess.ChannelHandle> instanceToChannel;

    SoundSystemMixin() {
    }

    @Override
    public void flightassistant$applyVolume(SoundInstance soundInstance) {
        ChannelAccess.ChannelHandle sourceManager;
        if (this.loaded && (sourceManager = this.instanceToChannel.get(soundInstance)) != null) {
            sourceManager.execute(source -> source.setVolume(soundInstance.getVolume()));
        }
    }

    @Override
    public void flightassistant$setLooping(SoundInstance soundInstance, boolean looping) {
        ChannelAccess.ChannelHandle sourceManager;
        if (this.loaded && (sourceManager = this.instanceToChannel.get(soundInstance)) != null) {
            sourceManager.execute(source -> source.setLooping(looping));
        }
    }

    @Override
    public void flightassistant$pause(SoundInstance soundInstance) {
        ChannelAccess.ChannelHandle sourceManager;
        if (this.loaded && (sourceManager = this.instanceToChannel.get(soundInstance)) != null) {
            sourceManager.execute(Channel::pause);
        }
    }

    @Override
    public void flightassistant$resume(SoundInstance soundInstance) {
        ChannelAccess.ChannelHandle sourceManager;
        if (this.loaded && (sourceManager = this.instanceToChannel.get(soundInstance)) != null) {
            sourceManager.execute(Channel::unpause);
        }
    }
}

