/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.screen.status;

import com.google.common.collect.ImmutableList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import ru.octol1ttle.flightassistant.FlightAssistant;
import ru.octol1ttle.flightassistant.api.ModuleController;
import ru.octol1ttle.flightassistant.api.util.extensions.DrawContextExtensionsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0013\u0012BC\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\t\u0012\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\u0003H\u0014\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0011\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0010\u00a8\u0006\u0014"}, d2={"Lru/octol1ttle/flightassistant/screen/status/SystemStatusListWidget;", "Lnet/minecraft/client/gui/components/ContainerObjectSelectionList;", "Lru/octol1ttle/flightassistant/screen/status/SystemStatusListWidget$SystemStatusWidgetEntry;", "", "width", "height", "top", "bottom", "left", "Lru/octol1ttle/flightassistant/api/ModuleController;", "controller", "", "baseKey", "<init>", "(IIIIILru/octol1ttle/flightassistant/api/ModuleController;Ljava/lang/String;)V", "getScrollbarX", "()I", "getRowWidth", "Companion", "SystemStatusWidgetEntry", "flightassistant-neoforge"})
public final class SystemStatusListWidget
extends ContainerObjectSelectionList<SystemStatusWidgetEntry> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int Y_OFFSET = 5;

    public SystemStatusListWidget(int width, int height, int top, int bottom, int left, @NotNull ModuleController<?> controller, @NotNull String baseKey) {
        Intrinsics.checkNotNullParameter(controller, (String)"controller");
        Intrinsics.checkNotNullParameter((Object)baseKey, (String)"baseKey");
        super(FlightAssistant.INSTANCE.getMc$flightassistant_neoforge(), width, height, top, 25);
        int y = top + 5;
        for (ResourceLocation system : controller.identifiers()) {
            MutableComponent mutableComponent = Component.translatable((String)(baseKey + "." + system));
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
            this.addEntry((AbstractSelectionList.Entry)new SystemStatusWidgetEntry(left, y, width, system, (Component)mutableComponent, controller));
            y += 25;
        }
    }

    protected int getScrollbarPosition() {
        return this.getX() + this.width - 4;
    }

    public int getRowWidth() {
        return this.width;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lru/octol1ttle/flightassistant/screen/status/SystemStatusListWidget$Companion;", "", "<init>", "()V", "", "Y_OFFSET", "I", "flightassistant-neoforge"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 22\b\u0012\u0004\u0012\u00020\u00000\u0001:\u00012B;\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\n\u00a2\u0006\u0004\b\f\u0010\rJ_\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001d0\u001cH\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010!\u001a\n\u0012\u0006\b\u0001\u0012\u00020 0\u001cH\u0016\u00a2\u0006\u0004\b!\u0010\u001fR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\"\u001a\u0004\b#\u0010$R\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\"\u001a\u0004\b%\u0010$R\u0014\u0010\u0005\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\"R\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010&\u001a\u0004\b'\u0010(R\u0018\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010)R\u0014\u0010+\u001a\u00020*8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b+\u0010,R\u0014\u0010-\u001a\u00020*8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b-\u0010,R\u0014\u0010.\u001a\u00020*8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b.\u0010,R\u0014\u00100\u001a\u00020/8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b0\u00101\u00a8\u00063"}, d2={"Lru/octol1ttle/flightassistant/screen/status/SystemStatusListWidget$SystemStatusWidgetEntry;", "Lnet/minecraft/client/gui/components/ContainerObjectSelectionList$Entry;", "", "x", "y", "listWidth", "Lnet/minecraft/resources/ResourceLocation;", "identifier", "Lnet/minecraft/network/chat/Component;", "displayNameText", "Lru/octol1ttle/flightassistant/api/ModuleController;", "controller", "<init>", "(IIILnet/minecraft/resources/ResourceLocation;Lnet/minecraft/network/chat/Component;Lru/octol1ttle/flightassistant/api/ModuleController;)V", "Lnet/minecraft/client/gui/GuiGraphics;", "context", "index", "entryWidth", "entryHeight", "mouseX", "mouseY", "", "hovered", "", "tickDelta", "", "render", "(Lnet/minecraft/client/gui/GuiGraphics;IIIIIIIZF)V", "", "Lnet/minecraft/client/gui/components/events/GuiEventListener;", "children", "()Ljava/util/List;", "Lnet/minecraft/client/gui/narration/NarratableEntry;", "selectableChildren", "I", "getX", "()I", "getY", "Lnet/minecraft/resources/ResourceLocation;", "getIdentifier", "()Lnet/minecraft/resources/ResourceLocation;", "Lru/octol1ttle/flightassistant/api/ModuleController;", "Lnet/minecraft/client/gui/components/StringWidget;", "displayName", "Lnet/minecraft/client/gui/components/StringWidget;", "faultText", "offText", "Lnet/minecraft/client/gui/components/Button;", "toggleButton", "Lnet/minecraft/client/gui/components/Button;", "Companion", "flightassistant-neoforge"})
    public static final class SystemStatusWidgetEntry
    extends ContainerObjectSelectionList.Entry<SystemStatusWidgetEntry> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int x;
        private final int y;
        private final int listWidth;
        @NotNull
        private final ResourceLocation identifier;
        @NotNull
        private final ModuleController<?> controller;
        @NotNull
        private final StringWidget displayName;
        @NotNull
        private final StringWidget faultText;
        @NotNull
        private final StringWidget offText;
        @NotNull
        private final Button toggleButton;
        @NotNull
        private static final Component FAULT_TEXT;
        @NotNull
        private static final Component OFF_TEXT;
        @NotNull
        private static final Component ON_RESET_TEXT;

        public SystemStatusWidgetEntry(int x, int y, int listWidth, @NotNull ResourceLocation identifier, @NotNull Component displayNameText, @NotNull ModuleController<?> controller) {
            Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
            Intrinsics.checkNotNullParameter((Object)displayNameText, (String)"displayNameText");
            Intrinsics.checkNotNullParameter(controller, (String)"controller");
            this.x = x;
            this.y = y;
            this.listWidth = listWidth;
            this.identifier = identifier;
            this.controller = controller;
            StringWidget stringWidget = new StringWidget(this.x, this.y, this.listWidth / 2, 9, displayNameText, DrawContextExtensionsKt.getTextRenderer()).alignLeft();
            Intrinsics.checkNotNullExpressionValue((Object)stringWidget, (String)"alignLeft(...)");
            this.displayName = stringWidget;
            this.faultText = new StringWidget(this.x, this.y, this.listWidth / 8, 9, FAULT_TEXT, DrawContextExtensionsKt.getTextRenderer());
            this.offText = new StringWidget(this.x, this.y, this.listWidth / 8, 9, OFF_TEXT, DrawContextExtensionsKt.getTextRenderer());
            Button button = Button.builder((Component)OFF_TEXT, arg_0 -> SystemStatusWidgetEntry.toggleButton$lambda$0(this, arg_0)).pos(this.x, this.y).width(60).build();
            Intrinsics.checkNotNullExpressionValue((Object)button, (String)"build(...)");
            this.toggleButton = button;
        }

        public final int getX() {
            return this.x;
        }

        public final int getY() {
            return this.y;
        }

        @NotNull
        public final ResourceLocation getIdentifier() {
            return this.identifier;
        }

        public void render(@NotNull GuiGraphics context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            int renderY = y + 5;
            this.displayName.setX(this.x + 10);
            this.displayName.setY(renderY);
            this.displayName.render(context, mouseX, mouseY, tickDelta);
            this.toggleButton.setX(this.x + this.listWidth - this.toggleButton.getWidth() - 5);
            this.toggleButton.setY(renderY - this.toggleButton.getHeight() / 4 - 1);
            this.toggleButton.setMessage(this.controller.isEnabled(this.identifier) ? OFF_TEXT : ON_RESET_TEXT);
            this.toggleButton.render(context, mouseX, mouseY, tickDelta);
            this.offText.setX(this.toggleButton.getX() - this.toggleButton.getWidth() / 2 - DrawContextExtensionsKt.getTextRenderer().width((FormattedText)OFF_TEXT) - 2);
            this.offText.setY(renderY);
            this.offText.setColor(this.controller.isEnabled(this.identifier) ? 986895 : 0xFFFFFF);
            this.offText.render(context, mouseX, mouseY, tickDelta);
            this.faultText.setX(this.offText.getX() - DrawContextExtensionsKt.getTextRenderer().width((FormattedText)FAULT_TEXT) - 2);
            this.faultText.setY(renderY);
            this.faultText.setColor(this.controller.isFaulted(this.identifier) ? DrawContextExtensionsKt.getCautionColor() : 986895);
            this.faultText.render(context, mouseX, mouseY, tickDelta);
        }

        @NotNull
        public List<? extends GuiEventListener> children() {
            ImmutableList immutableList = ImmutableList.of((Object)this.displayName, (Object)this.faultText, (Object)this.offText, (Object)this.toggleButton);
            Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"of(...)");
            return (List)immutableList;
        }

        @NotNull
        public List<? extends NarratableEntry> narratables() {
            ImmutableList immutableList = ImmutableList.of((Object)this.displayName, (Object)this.faultText, (Object)this.offText, (Object)this.toggleButton);
            Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"of(...)");
            return (List)immutableList;
        }

        private static final void toggleButton$lambda$0(SystemStatusWidgetEntry this$0, Button it) {
            it.setMessage(this$0.controller.toggleEnabled(this$0.identifier) ? OFF_TEXT : ON_RESET_TEXT);
        }

        static {
            MutableComponent mutableComponent = Component.translatable((String)"menu.flightassistant.system.fault");
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
            FAULT_TEXT = (Component)mutableComponent;
            MutableComponent mutableComponent2 = Component.translatable((String)"menu.flightassistant.system.off");
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent2, (String)"translatable(...)");
            OFF_TEXT = (Component)mutableComponent2;
            MutableComponent mutableComponent3 = Component.translatable((String)"menu.flightassistant.system.on_reset");
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent3, (String)"translatable(...)");
            ON_RESET_TEXT = (Component)mutableComponent3;
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\u0006\u001a\u0004\b\n\u0010\bR\u0017\u0010\u000b\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010\u0006\u001a\u0004\b\f\u0010\b\u00a8\u0006\r"}, d2={"Lru/octol1ttle/flightassistant/screen/status/SystemStatusListWidget$SystemStatusWidgetEntry$Companion;", "", "<init>", "()V", "Lnet/minecraft/network/chat/Component;", "FAULT_TEXT", "Lnet/minecraft/network/chat/Component;", "getFAULT_TEXT", "()Lnet/minecraft/network/chat/Component;", "OFF_TEXT", "getOFF_TEXT", "ON_RESET_TEXT", "getON_RESET_TEXT", "flightassistant-neoforge"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Component getFAULT_TEXT() {
                return FAULT_TEXT;
            }

            @NotNull
            public final Component getOFF_TEXT() {
                return OFF_TEXT;
            }

            @NotNull
            public final Component getON_RESET_TEXT() {
                return ON_RESET_TEXT;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

