/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.impl.computer.safety;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.RangesKt;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.octol1ttle.flightassistant.FlightAssistant;
import ru.octol1ttle.flightassistant.api.autoflight.ControlInput;
import ru.octol1ttle.flightassistant.api.autoflight.FlightController;
import ru.octol1ttle.flightassistant.api.autoflight.pitch.PitchControllerRegistrationCallback;
import ru.octol1ttle.flightassistant.api.autoflight.thrust.ThrustControllerRegistrationCallback;
import ru.octol1ttle.flightassistant.api.computer.Computer;
import ru.octol1ttle.flightassistant.api.computer.ComputerBus;
import ru.octol1ttle.flightassistant.api.computer.ComputerQuery;
import ru.octol1ttle.flightassistant.api.util.MathHelperKt;
import ru.octol1ttle.flightassistant.api.util.extensions.LevelExtensionsKt;
import ru.octol1ttle.flightassistant.config.FAConfig;
import ru.octol1ttle.flightassistant.impl.computer.autoflight.base.PitchComputer;
import ru.octol1ttle.flightassistant.impl.computer.data.AirDataComputer;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b \u0018\u0000 O2\u00020\u00012\u00020\u0002:\u0002POB\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\n\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\n\u0010\tJ\u0017\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0011\u0010\u0011\u001a\u0004\u0018\u00010\u0010H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0014\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0016\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017JO\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00130\u001a2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00130\u001a2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00130\u001a2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00130\u001aH\u0002\u00a2\u0006\u0004\b\u001f\u0010 J\u000f\u0010!\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b!\u0010\u0017J\u001d\u0010$\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u0010\u00a2\u0006\u0004\b$\u0010%J#\u0010)\u001a\u00020\u0007\"\u0004\b\u0000\u0010&2\f\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00000'H\u0016\u00a2\u0006\u0004\b)\u0010*J)\u0010/\u001a\u0004\u0018\u00010.2\u0006\u0010+\u001a\u00020\u00182\u0006\u0010,\u001a\u00020\u00132\u0006\u0010-\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b/\u00100J\u0011\u00102\u001a\u0004\u0018\u000101H\u0016\u00a2\u0006\u0004\b2\u00103J\u0011\u00104\u001a\u0004\u0018\u000101H\u0016\u00a2\u0006\u0004\b4\u00103J\u000f\u00105\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b5\u0010\tR\u0016\u00106\u001a\u00020\u00108\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b6\u00107R$\u00109\u001a\u00020\u00182\u0006\u00108\u001a\u00020\u00188\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b9\u0010:\u001a\u0004\b;\u0010<R\u0016\u0010=\u001a\u00020\u00108\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b=\u00107R$\u0010>\u001a\u00020\u00182\u0006\u00108\u001a\u00020\u00188\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b>\u0010:\u001a\u0004\b?\u0010<R\u0011\u0010A\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b@\u0010\u0017R\u0011\u0010C\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\bB\u0010\u0017R\u0011\u0010E\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\bD\u0010\u0017R\u0011\u0010G\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\bF\u0010\u0017R$\u0010H\u001a\u0004\u0018\u00010\u00108\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bH\u0010I\u001a\u0004\bJ\u0010\u0012\"\u0004\bK\u0010LR\u0011\u0010N\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\bM\u0010\u0017\u00a8\u0006Q"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/safety/GroundProximityComputer;", "Lru/octol1ttle/flightassistant/api/computer/Computer;", "Lru/octol1ttle/flightassistant/api/autoflight/FlightController;", "Lru/octol1ttle/flightassistant/api/computer/ComputerBus;", "computers", "<init>", "(Lru/octol1ttle/flightassistant/api/computer/ComputerBus;)V", "", "subscribeToEvents", "()V", "tick", "Lnet/minecraft/class_243;", "offset", "Lnet/minecraft/class_3965;", "raycast", "(Lnet/minecraft/class_243;)Lnet/minecraft/class_3965;", "", "computeGroundY", "()Ljava/lang/Double;", "", "computeIsRecoveryUnsafe", "()Z", "computeThresholdMultiplier", "()D", "Lru/octol1ttle/flightassistant/impl/computer/safety/GroundProximityComputer$Status;", "current", "Lkotlin/Function0;", "safe", "caution", "warning", "recover", "computeStatus", "(Lru/octol1ttle/flightassistant/impl/computer/safety/GroundProximityComputer$Status;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)Lru/octol1ttle/flightassistant/impl/computer/safety/GroundProximityComputer$Status;", "computeGroundImpactTime", "velocity", "lookAheadTime", "computeObstacleImpactTime", "(Lnet/minecraft/class_243;D)D", "Response", "Lru/octol1ttle/flightassistant/api/computer/ComputerQuery;", "query", "handleQuery", "(Lru/octol1ttle/flightassistant/api/computer/ComputerQuery;)V", "status", "config", "forThrust", "Lru/octol1ttle/flightassistant/api/autoflight/ControlInput$Status;", "getControlInputStatus", "(Lru/octol1ttle/flightassistant/impl/computer/safety/GroundProximityComputer$Status;ZZ)Lru/octol1ttle/flightassistant/api/autoflight/ControlInput$Status;", "Lru/octol1ttle/flightassistant/api/autoflight/ControlInput;", "getThrustInput", "()Lru/octol1ttle/flightassistant/api/autoflight/ControlInput;", "getPitchInput", "reset", "groundImpactTime", "D", "value", "groundImpactStatus", "Lru/octol1ttle/flightassistant/impl/computer/safety/GroundProximityComputer$Status;", "getGroundImpactStatus", "()Lru/octol1ttle/flightassistant/impl/computer/safety/GroundProximityComputer$Status;", "obstacleImpactTime", "obstacleImpactStatus", "getObstacleImpactStatus", "getSafeThreshold", "safeThreshold", "getCautionThreshold", "cautionThreshold", "getWarningThreshold", "warningThreshold", "getRecoverThreshold", "recoverThreshold", "groundY", "Ljava/lang/Double;", "getGroundY", "setGroundY", "(Ljava/lang/Double;)V", "getGroundOrVoidY", "groundOrVoidY", "Companion", "Status", "flightassistant-fabric"})
public final class GroundProximityComputer
extends Computer
implements FlightController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private double groundImpactTime;
    @NotNull
    private Status groundImpactStatus;
    private double obstacleImpactTime;
    @NotNull
    private Status obstacleImpactStatus;
    @Nullable
    private Double groundY;
    @NotNull
    private static final class_2960 ID = FlightAssistant.INSTANCE.id$flightassistant_fabric("ground_proximity");

    public GroundProximityComputer(@NotNull ComputerBus computers) {
        Intrinsics.checkNotNullParameter((Object)computers, (String)"computers");
        super(computers);
        this.groundImpactTime = Double.MAX_VALUE;
        this.groundImpactStatus = Status.SAFE;
        this.obstacleImpactTime = Double.MAX_VALUE;
        this.obstacleImpactStatus = Status.SAFE;
    }

    @NotNull
    public final Status getGroundImpactStatus() {
        return this.groundImpactStatus;
    }

    @NotNull
    public final Status getObstacleImpactStatus() {
        return this.obstacleImpactStatus;
    }

    public final double getSafeThreshold() {
        return 10.0;
    }

    public final double getCautionThreshold() {
        return 7.5;
    }

    public final double getWarningThreshold() {
        return 3.0;
    }

    public final double getRecoverThreshold() {
        return 0.75;
    }

    @Nullable
    public final Double getGroundY() {
        return this.groundY;
    }

    public final void setGroundY(@Nullable Double d) {
        this.groundY = d;
    }

    public final double getGroundOrVoidY() {
        double d;
        if (this.groundY == null || Intrinsics.areEqual((Double)this.groundY, (double)Double.MAX_VALUE)) {
            d = this.getComputers().getData().getVoidY();
        } else {
            Double d2 = this.groundY;
            Intrinsics.checkNotNull((Object)d2);
            d = d2;
        }
        return d;
    }

    @Override
    public void subscribeToEvents() {
        ThrustControllerRegistrationCallback.EVENT.register(arg_0 -> GroundProximityComputer.subscribeToEvents$lambda$0(this, arg_0));
        PitchControllerRegistrationCallback.EVENT.register(arg_0 -> GroundProximityComputer.subscribeToEvents$lambda$1(this, arg_0));
    }

    @Override
    public void tick() {
        if (this.getComputers().getChunk().isCurrentLoaded()) {
            Double d = this.computeGroundY();
            Double d2 = this.groundY = d != null ? Double.valueOf(MathHelperKt.throwIfNotInRange(d, (ClosedRange<Double>)((ClosedRange)RangesKt.rangeTo((double)LevelExtensionsKt.getBottomY((class_1937)this.getComputers().getData().getLevel()), (double)Double.MAX_VALUE)))) : null;
        }
        if (!this.getComputers().getData().getFlying() || this.getComputers().getData().getPlayer().method_5799()) {
            this.groundImpactStatus = Status.SAFE;
            this.obstacleImpactStatus = Status.SAFE;
            return;
        }
        boolean isRecoveryUnsafe = this.computeIsRecoveryUnsafe();
        this.groundImpactTime = MathHelperKt.throwIfNotInRange(this.computeGroundImpactTime(), (ClosedRange<Double>)((ClosedRange)RangesKt.rangeTo((double)0.0, (double)Double.MAX_VALUE)));
        this.groundImpactStatus = this.computeStatus(this.groundImpactStatus, (Function0<Boolean>)((Function0)() -> GroundProximityComputer.tick$lambda$2(this)), (Function0<Boolean>)((Function0)() -> GroundProximityComputer.tick$lambda$3(this)), (Function0<Boolean>)((Function0)() -> GroundProximityComputer.tick$lambda$4(this)), (Function0<Boolean>)((Function0)() -> GroundProximityComputer.tick$lambda$5(this)));
        double thresholdMultiplier = this.computeThresholdMultiplier();
        double safe = Math.max(this.getRecoverThreshold(), this.getSafeThreshold() * thresholdMultiplier);
        double caution = Math.max(this.getRecoverThreshold(), this.getCautionThreshold() * thresholdMultiplier);
        double warning = Math.max(this.getRecoverThreshold(), this.getWarningThreshold() * thresholdMultiplier);
        this.obstacleImpactTime = MathHelperKt.throwIfNotInRange(this.computeObstacleImpactTime(this.getComputers().getData().getVelocityPerSecond(), safe), (ClosedRange<Double>)((ClosedRange)RangesKt.rangeTo((double)0.0, (double)Double.MAX_VALUE)));
        double damageOnCollision = this.getComputers().getData().getVelocity().method_37267() * (double)10 - (double)3;
        AirDataComputer airDataComputer = this.getComputers().getData();
        class_1282 class_12822 = this.getComputers().getData().getPlayer().method_48923().method_48828();
        Intrinsics.checkNotNullExpressionValue((Object)class_12822, (String)"flyIntoWall(...)");
        boolean invulnerable = airDataComputer.isInvulnerableTo(class_12822);
        this.obstacleImpactStatus = this.computeStatus(this.obstacleImpactStatus, (Function0<Boolean>)((Function0)() -> GroundProximityComputer.tick$lambda$6(invulnerable, damageOnCollision, this, thresholdMultiplier)), (Function0<Boolean>)((Function0)() -> GroundProximityComputer.tick$lambda$7(this, damageOnCollision, caution)), (Function0<Boolean>)((Function0)() -> GroundProximityComputer.tick$lambda$8(isRecoveryUnsafe, this, warning)), (Function0<Boolean>)((Function0)() -> GroundProximityComputer.tick$lambda$9(this)));
    }

    private final class_3965 raycast(class_243 offset) {
        class_3965 class_39652 = this.getComputers().getData().getLevel().method_17742(new class_3959(this.getComputers().getData().getPosition(), this.getComputers().getData().getPosition().method_1019(offset), class_3959.class_3960.field_17558, class_3959.class_242.field_1347, (class_1297)this.getComputers().getData().getPlayer()));
        Intrinsics.checkNotNullExpressionValue((Object)class_39652, (String)"clip(...)");
        return class_39652;
    }

    private final Double computeGroundY() {
        if (!this.getComputers().getChunk().isCurrentLoaded()) {
            return this.groundY;
        }
        class_238 playerBoundingBox = this.getComputers().getData().getPlayer().method_5829();
        double minY = RangesKt.coerceAtLeast((double)LevelExtensionsKt.getBottomY((class_1937)this.getComputers().getData().getLevel()), (double)(this.getComputers().getData().getAltitude() - 2500.0));
        class_243 diffFromMinY = new class_243(0.0, minY - playerBoundingBox.field_1322, 0.0);
        class_243 collisionResult = class_1297.method_20736((class_1297)((class_1297)this.getComputers().getData().getPlayer()), (class_243)diffFromMinY, (class_238)playerBoundingBox, (class_1937)((class_1937)this.getComputers().getData().getLevel()), (List)CollectionsKt.emptyList());
        double groundY = collisionResult.field_1351 + playerBoundingBox.field_1322;
        if (collisionResult.field_1351 + playerBoundingBox.field_1325 == minY || Intrinsics.areEqual((Object)collisionResult, (Object)diffFromMinY)) {
            return groundY > (double)LevelExtensionsKt.getBottomY((class_1937)this.getComputers().getData().getLevel()) ? Double.valueOf(Double.MAX_VALUE) : null;
        }
        class_3965 raycast = this.raycast(new class_243(0.0, minY - this.getComputers().getData().getPosition().field_1351, 0.0));
        if (raycast.method_17783() == class_239.class_240.field_1332) {
            return Math.max(raycast.method_17784().field_1351, groundY);
        }
        return groundY;
    }

    private final boolean computeIsRecoveryUnsafe() {
        int pitch = Math.max(0, (int)this.getComputers().getData().getPitch());
        int interval = 15;
        int n = -interval;
        int i = 90;
        int n2 = ProgressionUtilKt.getProgressionLastElement((int)90, (int)pitch, (int)n);
        if (n2 <= i) {
            while (true) {
                class_243 offset = class_243.method_1030((float)(-((float)i)), (float)this.getComputers().getData().getYaw());
                class_243 class_2432 = offset.method_1021(this.getComputers().getData().getVelocityPerSecond().method_1033() * this.getRecoverThreshold());
                Intrinsics.checkNotNullExpressionValue((Object)class_2432, (String)"scale(...)");
                class_3965 result = this.raycast(class_2432);
                if (result.method_17783() != class_239.class_240.field_1332) {
                    return false;
                }
                if (i == n2) break;
                i += n;
            }
        }
        return true;
    }

    private final double computeThresholdMultiplier() {
        double maxRaycastDistance = this.getComputers().getData().getVelocityPerSecond().method_1033() * this.getCautionThreshold();
        Object[] objectArray = new Double[]{-1.0, 0.0, 1.0};
        List xzOffsets = CollectionsKt.listOf((Object[])objectArray);
        Object[] objectArray2 = new Double[]{-1.0, 0.0, 1.0};
        List yOffsets = CollectionsKt.listOf((Object[])objectArray2);
        ArrayList<Double> distances = new ArrayList<Double>();
        Iterator iterator = xzOffsets.iterator();
        while (iterator.hasNext()) {
            double x = ((Number)iterator.next()).doubleValue();
            Iterator iterator2 = yOffsets.iterator();
            while (iterator2.hasNext()) {
                double y = ((Number)iterator2.next()).doubleValue();
                Iterator iterator3 = xzOffsets.iterator();
                while (iterator3.hasNext()) {
                    double z = ((Number)iterator3.next()).doubleValue();
                    class_243 offset = new class_243(x, y, z).method_1029().method_1021(maxRaycastDistance);
                    if (offset.method_1027() == 0.0) continue;
                    Intrinsics.checkNotNull((Object)offset);
                    class_3965 result = this.raycast(offset);
                    boolean bl = result.method_17783() == class_239.class_240.field_1332 ? distances.add(this.getComputers().getData().getPosition().method_1022(result.method_17784())) : distances.add(maxRaycastDistance);
                }
            }
        }
        return CollectionsKt.averageOfDouble((Iterable)distances) / maxRaycastDistance;
    }

    private final Status computeStatus(Status current, Function0<Boolean> safe, Function0<Boolean> caution, Function0<Boolean> warning, Function0<Boolean> recover) {
        if (((Boolean)safe.invoke()).booleanValue()) {
            return Status.SAFE;
        }
        Status status = current;
        while (true) {
            Status next = switch (WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
                case 1 -> {
                    if (((Boolean)caution.invoke()).booleanValue()) {
                        yield Status.CAUTION;
                    }
                    yield null;
                }
                case 2 -> {
                    if (((Boolean)caution.invoke()).booleanValue() && ((Boolean)warning.invoke()).booleanValue()) {
                        yield Status.WARNING;
                    }
                    yield null;
                }
                case 3 -> {
                    if (((Boolean)caution.invoke()).booleanValue() && ((Boolean)warning.invoke()).booleanValue() && ((Boolean)recover.invoke()).booleanValue()) {
                        yield Status.RECOVER;
                    }
                    yield null;
                }
                case 4 -> null;
                default -> throw new NoWhenBranchMatchedException();
            };
            if (next == null) break;
            status = next;
        }
        return status;
    }

    private final double computeGroundImpactTime() {
        if (this.getComputers().getData().getVelocity().field_1351 >= 0.0) {
            return Double.MAX_VALUE;
        }
        return Math.max(0.0, this.getComputers().getData().getAltitude() - this.getGroundOrVoidY()) / -this.getComputers().getData().getVelocityPerSecond().field_1351;
    }

    public final double computeObstacleImpactTime(@NotNull class_243 velocity, double lookAheadTime) {
        Intrinsics.checkNotNullParameter((Object)velocity, (String)"velocity");
        class_243 class_2432 = velocity.method_1021(lookAheadTime);
        Intrinsics.checkNotNullExpressionValue((Object)class_2432, (String)"scale(...)");
        class_3965 result = this.raycast(class_2432);
        if (result.method_17783() != class_239.class_240.field_1332) {
            return Double.MAX_VALUE;
        }
        return this.getComputers().getData().getPosition().method_1022(result.method_17784()) / velocity.method_1033();
    }

    @Override
    public <Response> void handleQuery(@NotNull ComputerQuery<Response> query) {
        Intrinsics.checkNotNullParameter(query, (String)"query");
        if (query instanceof PitchComputer.MinimumPitchQuery && (this.groundImpactStatus.compareTo((Enum)Status.WARNING) <= 0 && FAConfig.INSTANCE.getSafety().getSinkRateLimitPitch() || this.obstacleImpactStatus.compareTo((Enum)Status.WARNING) <= 0 && FAConfig.INSTANCE.getSafety().getObstacleLimitPitch())) {
            ((PitchComputer.MinimumPitchQuery)query).respond(new ControlInput(RangesKt.coerceAtMost((float)this.getComputers().getData().getPitch(), (float)15.0f), (class_2561)class_2561.method_43471((String)"mode.flightassistant.vertical.terrain_protection"), ControlInput.Priority.HIGH, 0.0f, null, 24, null));
        }
    }

    private final ControlInput.Status getControlInputStatus(Status status, boolean config, boolean forThrust) {
        Status activeThreshold;
        if (!config) {
            return ControlInput.Status.DISABLED;
        }
        Status armThreshold = forThrust ? Status.CAUTION : Status.WARNING;
        Status status2 = activeThreshold = forThrust ? Status.WARNING : Status.RECOVER;
        return status.compareTo((Enum)activeThreshold) <= 0 ? ControlInput.Status.ACTIVE : (status.compareTo((Enum)armThreshold) <= 0 ? ControlInput.Status.ARMED : null);
    }

    @Override
    @Nullable
    public ControlInput getThrustInput() {
        if (this.getComputers().getData().getPitch() > 15.0f) {
            return null;
        }
        ControlInput.Status sinkRateInputStatus = this.getControlInputStatus(this.groundImpactStatus, FAConfig.INSTANCE.getSafety().getSinkRateAutoThrust(), true);
        ControlInput.Status terrainInputStatus = this.getControlInputStatus(this.obstacleImpactStatus, FAConfig.INSTANCE.getSafety().getObstacleAutoThrust(), true);
        if (sinkRateInputStatus != null || terrainInputStatus != null) {
            return new ControlInput(0.0f, (class_2561)class_2561.method_43471((String)"mode.flightassistant.thrust.idle"), ControlInput.Priority.HIGH, 0.0f, ControlInput.Status.Companion.highest(sinkRateInputStatus, terrainInputStatus), 8, null);
        }
        return null;
    }

    @Override
    @Nullable
    public ControlInput getPitchInput() {
        ControlInput.Status sinkRateInputStatus = this.getControlInputStatus(this.groundImpactStatus, FAConfig.INSTANCE.getSafety().getSinkRateAutoPitch(), false);
        ControlInput.Status terrainInputStatus = this.getControlInputStatus(this.obstacleImpactStatus, FAConfig.INSTANCE.getSafety().getObstacleAutoPitch(), false);
        if (sinkRateInputStatus != null || terrainInputStatus != null) {
            double d = 1.0;
            Double d2 = MathHelperKt.inverseMin(this.groundImpactTime, this.obstacleImpactTime);
            if (d2 == null) {
                return null;
            }
            double d3 = d2;
            double deltaTimeMultiplier = Math.max(d, d3);
            return new ControlInput(90.0f, (class_2561)class_2561.method_43471((String)"mode.flightassistant.vertical.terrain_escape"), ControlInput.Priority.HIGH, (float)deltaTimeMultiplier, ControlInput.Status.Companion.highest(sinkRateInputStatus, terrainInputStatus));
        }
        return null;
    }

    @Override
    public void reset() {
        this.groundImpactTime = Double.MAX_VALUE;
        this.groundImpactStatus = Status.SAFE;
        this.obstacleImpactTime = Double.MAX_VALUE;
        this.obstacleImpactStatus = Status.SAFE;
        this.groundY = Double.MAX_VALUE;
    }

    @Override
    @Nullable
    public ControlInput getHeadingInput() {
        return FlightController.super.getHeadingInput();
    }

    @Override
    @Nullable
    public ControlInput getRollInput() {
        return FlightController.super.getRollInput();
    }

    private static final void subscribeToEvents$lambda$0(GroundProximityComputer this$0, Consumer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.accept(this$0);
    }

    private static final void subscribeToEvents$lambda$1(GroundProximityComputer this$0, Consumer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.accept(this$0);
    }

    private static final boolean tick$lambda$2(GroundProximityComputer this$0) {
        return this$0.getComputers().getData().getFallDistanceSafe() || this$0.getComputers().getData().getVelocityPerSecond().field_1351 > -8.5 || this$0.groundImpactTime >= this$0.getSafeThreshold();
    }

    private static final boolean tick$lambda$3(GroundProximityComputer this$0) {
        return this$0.getComputers().getData().getVelocityPerSecond().field_1351 <= -10.0 && this$0.groundImpactTime <= this$0.getCautionThreshold();
    }

    private static final boolean tick$lambda$4(GroundProximityComputer this$0) {
        return this$0.groundImpactTime <= this$0.getWarningThreshold();
    }

    private static final boolean tick$lambda$5(GroundProximityComputer this$0) {
        return this$0.groundImpactTime <= this$0.getRecoverThreshold();
    }

    private static final boolean tick$lambda$6(boolean $invulnerable, double $damageOnCollision, GroundProximityComputer this$0, double $thresholdMultiplier) {
        return $invulnerable || $damageOnCollision < (double)(this$0.getComputers().getData().getPlayer().method_6032() * 0.25f) || this$0.obstacleImpactTime * (double)1.2f > this$0.groundImpactTime || this$0.obstacleImpactTime >= this$0.getSafeThreshold() * $thresholdMultiplier;
    }

    private static final boolean tick$lambda$7(GroundProximityComputer this$0, double $damageOnCollision, double $caution) {
        return Math.abs(this$0.getComputers().getData().getYaw() - this$0.getComputers().getData().getFlightYaw()) < 10.0f && $damageOnCollision >= (double)(this$0.getComputers().getData().getPlayer().method_6032() * 0.5f) && this$0.obstacleImpactTime * (double)1.1f < this$0.groundImpactTime && this$0.obstacleImpactTime <= $caution;
    }

    private static final boolean tick$lambda$8(boolean $isRecoveryUnsafe, GroundProximityComputer this$0, double $warning) {
        return !$isRecoveryUnsafe && this$0.obstacleImpactTime <= $warning;
    }

    private static final boolean tick$lambda$9(GroundProximityComputer this$0) {
        return this$0.obstacleImpactTime <= this$0.getRecoverThreshold();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/safety/GroundProximityComputer$Companion;", "", "<init>", "()V", "Lnet/minecraft/class_2960;", "ID", "Lnet/minecraft/class_2960;", "getID", "()Lnet/minecraft/class_2960;", "flightassistant-fabric"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final class_2960 getID() {
            return ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/safety/GroundProximityComputer$Status;", "", "<init>", "(Ljava/lang/String;I)V", "RECOVER", "WARNING", "CAUTION", "SAFE", "flightassistant-fabric"})
    public static final class Status
    extends Enum<Status> {
        public static final /* enum */ Status RECOVER = new Status();
        public static final /* enum */ Status WARNING = new Status();
        public static final /* enum */ Status CAUTION = new Status();
        public static final /* enum */ Status SAFE = new Status();
        private static final /* synthetic */ Status[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Status[] values() {
            return (Status[])$VALUES.clone();
        }

        public static Status valueOf(String value) {
            return Enum.valueOf(Status.class, value);
        }

        @NotNull
        public static EnumEntries<Status> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = statusArray = new Status[]{Status.RECOVER, Status.WARNING, Status.CAUTION, Status.SAFE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Status.values().length];
            try {
                nArray[Status.SAFE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.CAUTION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.WARNING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.RECOVER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

