/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.impl.display;

import kotlin.Metadata;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import ru.octol1ttle.flightassistant.FlightAssistant;
import ru.octol1ttle.flightassistant.api.computer.ComputerBus;
import ru.octol1ttle.flightassistant.api.display.Display;
import ru.octol1ttle.flightassistant.api.display.HudFrame;
import ru.octol1ttle.flightassistant.api.util.MathHelperKt;
import ru.octol1ttle.flightassistant.api.util.extensions.GuiGraphicsExtensionsKt;
import ru.octol1ttle.flightassistant.api.util.extensions.StringExtensionsKt;
import ru.octol1ttle.flightassistant.config.FAConfig;
import ru.octol1ttle.flightassistant.impl.computer.autoflight.AutoFlightComputer;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\b\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u0013\u0010\u000e\u001a\u00020\u000b*\u00020\tH\u0002\u00a2\u0006\u0004\b\u000e\u0010\rJ#\u0010\u0012\u001a\u00020\u000b*\u00020\t2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013JK\u0010\u001a\u001a\u00020\u0006*\u00020\t2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ#\u0010\u001c\u001a\u00020\u000b*\u00020\t2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u0013J\u0017\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u001d\u0010\r\u00a8\u0006\u001f"}, d2={"Lru/octol1ttle/flightassistant/impl/display/HeadingDisplay;", "Lru/octol1ttle/flightassistant/api/display/Display;", "Lru/octol1ttle/flightassistant/api/computer/ComputerBus;", "computers", "<init>", "(Lru/octol1ttle/flightassistant/api/computer/ComputerBus;)V", "", "allowedByConfig", "()Z", "Lnet/minecraft/class_332;", "guiGraphics", "", "render", "(Lnet/minecraft/class_332;)V", "renderHeadingReading", "", "x", "y", "renderHeadingScale", "(Lnet/minecraft/class_332;II)V", "left", "right", "heading", "", "currentHeading", "isLeft", "drawHeadingLine", "(Lnet/minecraft/class_332;IIIIIFZ)Z", "renderHeadingTarget", "renderFaulted", "Companion", "flightassistant-fabric"})
public final class HeadingDisplay
extends Display {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final class_2960 ID = FlightAssistant.INSTANCE.id$flightassistant_fabric("heading");

    public HeadingDisplay(@NotNull ComputerBus computers) {
        Intrinsics.checkNotNullParameter((Object)computers, (String)"computers");
        super(computers);
    }

    @Override
    public boolean allowedByConfig() {
        return FAConfig.INSTANCE.getDisplay().getShowHeadingReading() || FAConfig.INSTANCE.getDisplay().getShowHeadingScale();
    }

    @Override
    public void render(@NotNull class_332 guiGraphics) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        class_332 $this$render_u24lambda_u240 = guiGraphics;
        boolean bl = false;
        if (FAConfig.INSTANCE.getDisplay().getShowHeadingReading()) {
            this.renderHeadingReading($this$render_u24lambda_u240);
        }
        if (FAConfig.INSTANCE.getDisplay().getShowHeadingScale()) {
            this.renderHeadingScale($this$render_u24lambda_u240, GuiGraphicsExtensionsKt.getCenterX($this$render_u24lambda_u240), HudFrame.INSTANCE.getBottom() + 1);
        }
        if (FAConfig.INSTANCE.getDisplay().getShowAutomationModes()) {
            this.renderHeadingTarget($this$render_u24lambda_u240, GuiGraphicsExtensionsKt.getCenterX($this$render_u24lambda_u240), HudFrame.INSTANCE.getBottom() - 8);
        }
    }

    private final void renderHeadingReading(class_332 $this$renderHeadingReading) {
        int x = GuiGraphicsExtensionsKt.getCenterX($this$renderHeadingReading);
        int y = HudFrame.INSTANCE.getBottom() + 1;
        int headingInt = MathKt.roundToInt((float)this.getComputers().getData().getHeading());
        $this$renderHeadingReading.method_49601(x - 11, y, 23, 11, GuiGraphicsExtensionsKt.getPrimaryColor());
        Object[] objectArray = new Object[]{headingInt};
        GuiGraphicsExtensionsKt.drawMiddleAlignedString$default($this$renderHeadingReading, StringExtensionsKt.formatRoot("%03d", objectArray), x, y + 2, GuiGraphicsExtensionsKt.getPrimaryColor(), false, 16, null);
    }

    private final void renderHeadingScale(class_332 $this$renderHeadingScale, int x, int y) {
        int i;
        int headingRoundedUp;
        int i2;
        int headingRoundedDown;
        int left = (int)((float)x - HudFrame.INSTANCE.getHeight() * 0.5f);
        int right = (int)((float)x + HudFrame.INSTANCE.getHeight() * 0.5f);
        $this$renderHeadingScale.method_25292(left, right, y, GuiGraphicsExtensionsKt.getPrimaryColor());
        $this$renderHeadingScale.method_25301(left, y, y + 20, GuiGraphicsExtensionsKt.getPrimaryColor());
        $this$renderHeadingScale.method_25301(right, y, y + 20, GuiGraphicsExtensionsKt.getPrimaryColor());
        $this$renderHeadingScale.method_44379(left, 0, x - 12, $this$renderHeadingScale.method_51443());
        int n = ProgressionUtilKt.getProgressionLastElement((int)headingRoundedDown, (int)-360, (int)-10);
        if (n <= i2) {
            for (i2 = headingRoundedDown = class_3532.method_38961((double)this.getComputers().getData().getHeading(), (int)10); this.drawHeadingLine($this$renderHeadingScale, x, y, left, right, i2, this.getComputers().getData().getHeading(), true) && i2 != n; i2 -= 10) {
            }
        }
        $this$renderHeadingScale.method_44380();
        $this$renderHeadingScale.method_44379(x + 13, 0, right, $this$renderHeadingScale.method_51443());
        int n2 = ProgressionUtilKt.getProgressionLastElement((int)headingRoundedUp, (int)720, (int)10);
        if (i <= n2) {
            for (i = headingRoundedUp = class_3532.method_28139((int)MathKt.roundToInt((float)this.getComputers().getData().getHeading()), (int)10); this.drawHeadingLine($this$renderHeadingScale, x, y, left, right, i, this.getComputers().getData().getHeading(), false) && i != n2; i += 10) {
            }
        }
        $this$renderHeadingScale.method_44380();
    }

    private final boolean drawHeadingLine(class_332 $this$drawHeadingLine, int x, int y, int left, int right, int heading, float currentHeading, boolean isLeft) {
        int textX = (int)((float)x + (float)2 * MathHelperKt.findShortestPath(currentHeading, heading, 360.0f));
        if (textX < left - 100 || textX > right + 100) {
            return false;
        }
        int wrappedHeading = heading > 0 ? heading % 360 : 360 + heading % 360;
        $this$drawHeadingLine.method_25301(textX, y, y + 3, GuiGraphicsExtensionsKt.getPrimaryColor());
        if (wrappedHeading % 30 == 0) {
            GuiGraphicsExtensionsKt.drawMiddleAlignedString$default($this$drawHeadingLine, String.valueOf(wrappedHeading == 0 ? 360 : wrappedHeading), textX, y + 4, GuiGraphicsExtensionsKt.getPrimaryColor(), false, 16, null);
        }
        if (wrappedHeading % 90 == 0) {
            $this$drawHeadingLine.method_44380();
            $this$drawHeadingLine.method_44379(left, 0, right, $this$drawHeadingLine.method_51443());
            GuiGraphicsExtensionsKt.drawMiddleAlignedString$default($this$drawHeadingLine, switch (wrappedHeading) {
                case 0, 360 -> "Z-";
                case 90 -> "X+";
                case 180 -> "Z+";
                case 270 -> "X-";
                default -> throw new IllegalArgumentException("Degree range out of bounds: " + heading);
            }, textX, y + 12, GuiGraphicsExtensionsKt.getPrimaryColor(), false, 16, null);
            $this$drawHeadingLine.method_44380();
            if (isLeft) {
                $this$drawHeadingLine.method_44379(left, 0, x - 12, $this$drawHeadingLine.method_51443());
            } else {
                $this$drawHeadingLine.method_44379(x + 13, 0, right, $this$drawHeadingLine.method_51443());
            }
        }
        return true;
    }

    private final void renderHeadingTarget(class_332 $this$renderHeadingTarget, int x, int y) {
        AutoFlightComputer.LateralMode active = this.getComputers().getAutoflight().getActiveLateralMode();
        if (this.getComputers().getAutoflight().getHeadingInput() != null && active instanceof AutoFlightComputer.FollowsHeadingMode) {
            Object[] objectArray = new Object[]{((AutoFlightComputer.FollowsHeadingMode)((Object)active)).getTargetHeading()};
            GuiGraphicsExtensionsKt.drawMiddleAlignedString$default($this$renderHeadingTarget, StringExtensionsKt.formatRoot("%03d", objectArray), x, y, GuiGraphicsExtensionsKt.getPrimaryAdvisoryColor(), false, 16, null);
        }
    }

    @Override
    public void renderFaulted(@NotNull class_332 guiGraphics) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        class_332 $this$renderFaulted_u24lambda_u241 = guiGraphics;
        boolean bl = false;
        class_5250 class_52502 = class_2561.method_43471((String)"short.flightassistant.heading");
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"translatable(...)");
        GuiGraphicsExtensionsKt.drawMiddleAlignedString$default($this$renderFaulted_u24lambda_u241, (class_2561)class_52502, GuiGraphicsExtensionsKt.getCenterX($this$renderFaulted_u24lambda_u241), HudFrame.INSTANCE.getBottom() + 1, GuiGraphicsExtensionsKt.getWarningColor(), false, 16, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lru/octol1ttle/flightassistant/impl/display/HeadingDisplay$Companion;", "", "<init>", "()V", "Lnet/minecraft/class_2960;", "ID", "Lnet/minecraft/class_2960;", "getID", "()Lnet/minecraft/class_2960;", "flightassistant-fabric"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final class_2960 getID() {
            return ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

