/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.impl.computer.safety;

import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.octol1ttle.flightassistant.FlightAssistant;
import ru.octol1ttle.flightassistant.api.autoflight.ControlInput;
import ru.octol1ttle.flightassistant.api.autoflight.FlightController;
import ru.octol1ttle.flightassistant.api.autoflight.thrust.ThrustControllerRegistrationCallback;
import ru.octol1ttle.flightassistant.api.computer.Computer;
import ru.octol1ttle.flightassistant.api.computer.ComputerBus;
import ru.octol1ttle.flightassistant.api.computer.ComputerQuery;
import ru.octol1ttle.flightassistant.config.FAConfig;
import ru.octol1ttle.flightassistant.impl.computer.autoflight.base.PitchComputer;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0005\u0018\u0000 \u001d2\u00020\u00012\u00020\u0002:\u0002\u001e\u001dB\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\n\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\n\u0010\tJ\u0011\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ#\u0010\u0011\u001a\u00020\u0007\"\u0004\b\u0000\u0010\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0013\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u0013\u0010\tR$\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00148\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019R\u0016\u0010\u001b\u001a\u00020\u001a8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001f"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/safety/StallComputer;", "Lru/octol1ttle/flightassistant/api/computer/Computer;", "Lru/octol1ttle/flightassistant/api/autoflight/FlightController;", "Lru/octol1ttle/flightassistant/api/computer/ComputerBus;", "computers", "<init>", "(Lru/octol1ttle/flightassistant/api/computer/ComputerBus;)V", "", "subscribeToEvents", "()V", "tick", "Lru/octol1ttle/flightassistant/api/autoflight/ControlInput;", "getThrustInput", "()Lru/octol1ttle/flightassistant/api/autoflight/ControlInput;", "Response", "Lru/octol1ttle/flightassistant/api/computer/ComputerQuery;", "query", "handleQuery", "(Lru/octol1ttle/flightassistant/api/computer/ComputerQuery;)V", "reset", "Lru/octol1ttle/flightassistant/impl/computer/safety/StallComputer$Status;", "value", "status", "Lru/octol1ttle/flightassistant/impl/computer/safety/StallComputer$Status;", "getStatus", "()Lru/octol1ttle/flightassistant/impl/computer/safety/StallComputer$Status;", "", "maximumSafePitch", "F", "Companion", "Status", "flightassistant-fabric"})
public final class StallComputer
extends Computer
implements FlightController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Status status;
    private float maximumSafePitch;
    @NotNull
    private static final class_2960 ID = FlightAssistant.INSTANCE.id$flightassistant_fabric("stall");

    public StallComputer(@NotNull ComputerBus computers) {
        Intrinsics.checkNotNullParameter((Object)computers, (String)"computers");
        super(computers);
        this.status = Status.SAFE;
        this.maximumSafePitch = 90.0f;
    }

    @NotNull
    public final Status getStatus() {
        return this.status;
    }

    @Override
    public void subscribeToEvents() {
        ThrustControllerRegistrationCallback.EVENT.register(arg_0 -> StallComputer.subscribeToEvents$lambda$0(this, arg_0));
    }

    @Override
    public void tick() {
        float angleOfAttack = this.getComputers().getData().getPitch() - this.getComputers().getData().getFlightPitch();
        this.status = this.getComputers().getData().getFlying() && !this.getComputers().getData().getFallDistanceSafe() && angleOfAttack > 90.0f ? (this.status == Status.FULL_STALL || this.getComputers().getData().getVelocityPerSecond().field_1351 <= -10.0 ? Status.FULL_STALL : Status.APPROACHING_STALL) : Status.SAFE;
        this.maximumSafePitch = (float)RangesKt.coerceAtMost((double)((double)this.getComputers().getData().getFlightPitch() + 90.0), (double)(this.getComputers().getData().getForwardVelocityPerSecond().method_1033() * 3.0 + 45.0));
    }

    @Override
    @Nullable
    public ControlInput getThrustInput() {
        if (this.status != Status.SAFE) {
            return new ControlInput(1.0f, (class_2561)class_2561.method_43471((String)"mode.flightassistant.thrust.toga"), ControlInput.Priority.HIGHEST, 0.0f, ControlInput.Status.Companion.fromBooleans$default(ControlInput.Status.Companion, this.status == Status.FULL_STALL, false, FAConfig.INSTANCE.getSafety().getStallAutoThrust(), 2, null), 8, null);
        }
        return null;
    }

    @Override
    public <Response> void handleQuery(@NotNull ComputerQuery<Response> query) {
        Intrinsics.checkNotNullParameter(query, (String)"query");
        if (query instanceof PitchComputer.MaximumPitchQuery && this.maximumSafePitch <= 90.0f && !this.getComputers().getData().getFallDistanceSafe()) {
            ((PitchComputer.MaximumPitchQuery)query).respond(new ControlInput(this.maximumSafePitch - 5.0f, (class_2561)class_2561.method_43471((String)"mode.flightassistant.vertical.stall_protection"), ControlInput.Priority.HIGHEST, 1.5f, ControlInput.Status.Companion.fromBooleans$default(ControlInput.Status.Companion, true, false, FAConfig.INSTANCE.getSafety().getStallLimitPitch(), 2, null)));
        }
    }

    @Override
    public void reset() {
        this.status = Status.SAFE;
        this.maximumSafePitch = 90.0f;
    }

    @Override
    @Nullable
    public ControlInput getPitchInput() {
        return FlightController.super.getPitchInput();
    }

    @Override
    @Nullable
    public ControlInput getHeadingInput() {
        return FlightController.super.getHeadingInput();
    }

    @Override
    @Nullable
    public ControlInput getRollInput() {
        return FlightController.super.getRollInput();
    }

    private static final void subscribeToEvents$lambda$0(StallComputer this$0, Consumer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.accept(this$0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/safety/StallComputer$Companion;", "", "<init>", "()V", "Lnet/minecraft/class_2960;", "ID", "Lnet/minecraft/class_2960;", "getID", "()Lnet/minecraft/class_2960;", "flightassistant-fabric"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final class_2960 getID() {
            return ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/safety/StallComputer$Status;", "", "<init>", "(Ljava/lang/String;I)V", "FULL_STALL", "APPROACHING_STALL", "SAFE", "flightassistant-fabric"})
    public static final class Status
    extends Enum<Status> {
        public static final /* enum */ Status FULL_STALL = new Status();
        public static final /* enum */ Status APPROACHING_STALL = new Status();
        public static final /* enum */ Status SAFE = new Status();
        private static final /* synthetic */ Status[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Status[] values() {
            return (Status[])$VALUES.clone();
        }

        public static Status valueOf(String value) {
            return Enum.valueOf(Status.class, value);
        }

        @NotNull
        public static EnumEntries<Status> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = statusArray = new Status[]{Status.FULL_STALL, Status.APPROACHING_STALL, Status.SAFE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

