/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.impl.alert.gpws;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;
import ru.octol1ttle.flightassistant.api.alert.Alert;
import ru.octol1ttle.flightassistant.api.alert.AlertData;
import ru.octol1ttle.flightassistant.api.alert.CenteredAlert;
import ru.octol1ttle.flightassistant.api.computer.ComputerBus;
import ru.octol1ttle.flightassistant.api.util.FATickCounter;
import ru.octol1ttle.flightassistant.api.util.extensions.GuiGraphicsExtensionsKt;
import ru.octol1ttle.flightassistant.config.FAConfig;
import ru.octol1ttle.flightassistant.config.options.SafetyOptions;
import ru.octol1ttle.flightassistant.impl.computer.autoflight.FlightPlanComputer;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\fH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lru/octol1ttle/flightassistant/impl/alert/gpws/DontSinkAlert;", "Lru/octol1ttle/flightassistant/api/alert/Alert;", "Lru/octol1ttle/flightassistant/api/alert/CenteredAlert;", "computers", "Lru/octol1ttle/flightassistant/api/computer/ComputerBus;", "<init>", "(Lru/octol1ttle/flightassistant/api/computer/ComputerBus;)V", "data", "Lru/octol1ttle/flightassistant/api/alert/AlertData;", "getData", "()Lru/octol1ttle/flightassistant/api/alert/AlertData;", "age", "", "shouldActivate", "", "render", "guiGraphics", "Lnet/minecraft/client/gui/GuiGraphics;", "y", "getAlertMethod", "Lru/octol1ttle/flightassistant/config/options/SafetyOptions$AlertMethod;", "flightassistant-neoforge"})
public final class DontSinkAlert
extends Alert
implements CenteredAlert {
    private int age;

    public DontSinkAlert(@NotNull ComputerBus computers) {
        Intrinsics.checkNotNullParameter((Object)computers, (String)"computers");
        super(computers);
    }

    @Override
    @NotNull
    public AlertData getData() {
        return AlertData.Companion.getDONT_SINK();
    }

    @Override
    public boolean shouldActivate() {
        if (!FAConfig.INSTANCE.getSafety().getAltitudeLossAlert()) {
            return false;
        }
        this.age = (this.getComputers().getPlan().getCurrentPhase() == FlightPlanComputer.FlightPhase.TAKEOFF || this.getComputers().getPlan().getCurrentPhase() == FlightPlanComputer.FlightPhase.GO_AROUND) && !this.getComputers().getData().getFallDistanceSafe() && this.getComputers().getData().getVelocityPerSecond().y <= -1.0 ? (this.age += FATickCounter.INSTANCE.getTicksPassed()) : 0;
        return this.age >= 20;
    }

    @Override
    public boolean render(@NotNull GuiGraphics guiGraphics, int y) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        MutableComponent mutableComponent = Component.translatable((String)"alert.flightassistant.gpws.dont_sink");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        GuiGraphicsExtensionsKt.drawHighlightedCenteredText$default(guiGraphics, (Component)mutableComponent, GuiGraphicsExtensionsKt.getCenterX(guiGraphics), y, GuiGraphicsExtensionsKt.getCautionColor(), FATickCounter.INSTANCE.getTotalTicks() % 40 >= 20, false, 32, null);
        return true;
    }

    @Override
    @NotNull
    public SafetyOptions.AlertMethod getAlertMethod() {
        return FAConfig.INSTANCE.getSafety().getAltitudeLossAlertMethod();
    }
}

