/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.impl.alert.navigation;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;
import ru.octol1ttle.flightassistant.api.alert.Alert;
import ru.octol1ttle.flightassistant.api.alert.AlertData;
import ru.octol1ttle.flightassistant.api.alert.ECAMAlert;
import ru.octol1ttle.flightassistant.api.computer.ComputerBus;
import ru.octol1ttle.flightassistant.api.util.FATickCounter;
import ru.octol1ttle.flightassistant.api.util.extensions.GuiGraphicsExtensionsKt;
import ru.octol1ttle.flightassistant.impl.computer.safety.ChunkStatusComputer;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0010\u001a\u00020\u0011H\u0016J(\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\bH\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lru/octol1ttle/flightassistant/impl/alert/navigation/SlowChunkLoadingAlert;", "Lru/octol1ttle/flightassistant/api/alert/Alert;", "Lru/octol1ttle/flightassistant/api/alert/ECAMAlert;", "computers", "Lru/octol1ttle/flightassistant/api/computer/ComputerBus;", "<init>", "(Lru/octol1ttle/flightassistant/api/computer/ComputerBus;)V", "priorityOffset", "", "getPriorityOffset", "()I", "data", "Lru/octol1ttle/flightassistant/api/alert/AlertData;", "getData", "()Lru/octol1ttle/flightassistant/api/alert/AlertData;", "alertDuration", "shouldActivate", "", "render", "guiGraphics", "Lnet/minecraft/client/gui/GuiGraphics;", "firstLineX", "otherLinesX", "firstLineY", "flightassistant-neoforge"})
public final class SlowChunkLoadingAlert
extends Alert
implements ECAMAlert {
    private final int priorityOffset;
    @NotNull
    private final AlertData data;
    private int alertDuration;

    public SlowChunkLoadingAlert(@NotNull ComputerBus computers) {
        Intrinsics.checkNotNullParameter((Object)computers, (String)"computers");
        super(computers);
        this.priorityOffset = 55;
        this.data = AlertData.Companion.getMASTER_CAUTION();
    }

    @Override
    public int getPriorityOffset() {
        return this.priorityOffset;
    }

    @Override
    @NotNull
    public AlertData getData() {
        return this.data;
    }

    @Override
    public boolean shouldActivate() {
        boolean shouldActivate;
        ChunkStatusComputer.Status status = this.getComputers().getChunk().getStatus();
        if (status != ChunkStatusComputer.Status.ALL_UNLOADED && this.alertDuration > 0) {
            this.alertDuration -= FATickCounter.INSTANCE.getTicksPassed();
            return true;
        }
        boolean bl = shouldActivate = status == ChunkStatusComputer.Status.SOME_UNLOADED;
        if (shouldActivate) {
            this.alertDuration = 100;
        }
        return shouldActivate;
    }

    @Override
    public int render(@NotNull GuiGraphics guiGraphics, int firstLineX, int otherLinesX, int firstLineY) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        MutableComponent mutableComponent = Component.translatable((String)"alert.flightassistant.navigation.slow_chunk_loading");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        return GuiGraphicsExtensionsKt.drawString$default(guiGraphics, (Component)mutableComponent, firstLineX, firstLineY, GuiGraphicsExtensionsKt.getCautionColor(), false, 16, null);
    }
}

