/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.impl.computer.autoflight;

import dev.isxander.yacl3.api.NameableEnum;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.Transient;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.internal.EnumsKt;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2d;
import org.joml.Vector2dc;
import ru.octol1ttle.flightassistant.FlightAssistant;
import ru.octol1ttle.flightassistant.api.computer.Computer;
import ru.octol1ttle.flightassistant.api.computer.ComputerBus;
import ru.octol1ttle.flightassistant.api.computer.ComputerQuery;
import ru.octol1ttle.flightassistant.api.util.LimitedFIFOQueue;
import ru.octol1ttle.flightassistant.api.util.extensions.StringExtensionsKt;
import ru.octol1ttle.flightassistant.api.util.extensions.VectorExtensionsKt;
import ru.octol1ttle.flightassistant.impl.computer.autoflight.AutoFlightComputer;
import ru.octol1ttle.flightassistant.impl.computer.autoflight.FlightPlanComputer$ArrivalData$;
import ru.octol1ttle.flightassistant.impl.computer.autoflight.FlightPlanComputer$DepartureData$;
import ru.octol1ttle.flightassistant.impl.computer.autoflight.FlightPlanComputer$EnrouteWaypoint$;
import ru.octol1ttle.flightassistant.impl.computer.autoflight.FlightPlanComputer$FlightPlan$;
import ru.octol1ttle.flightassistant.impl.computer.autoflight.modes.ConstantThrustMode;
import ru.octol1ttle.flightassistant.impl.computer.autoflight.modes.DirectCoordinatesLateralMode;
import ru.octol1ttle.flightassistant.impl.computer.autoflight.modes.HeadingLateralMode;
import ru.octol1ttle.flightassistant.impl.computer.autoflight.modes.ManagedAltitudeVerticalMode;
import ru.octol1ttle.flightassistant.impl.computer.autoflight.modes.SelectedAltitudeVerticalMode;
import ru.octol1ttle.flightassistant.impl.computer.autoflight.modes.SpeedThrustMode;
import ru.octol1ttle.flightassistant.impl.computer.autoflight.modes.TrackNavigationLateralMode;
import ru.octol1ttle.flightassistant.impl.display.StatusDisplay;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 F2\u00020\u0001:\u0006FGHIJKB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\u0007H\u0002J\b\u0010$\u001a\u00020\"H\u0002J\n\u0010%\u001a\u0004\u0018\u00010\u0017H\u0002J\n\u0010&\u001a\u0004\u0018\u00010\u0017H\u0002J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0017H\u0002J\r\u0010*\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010+J\r\u0010,\u001a\u0004\u0018\u00010-\u00a2\u0006\u0002\u0010.J\u0015\u0010/\u001a\u0004\u0018\u00010\f2\u0006\u00100\u001a\u000201\u00a2\u0006\u0002\u00102J\u0015\u00103\u001a\u0004\u0018\u00010\f2\u0006\u00100\u001a\u000201\u00a2\u0006\u0002\u00102J\u000e\u00104\u001a\u00020\f2\u0006\u0010)\u001a\u00020\u0017J\u000e\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\fJ\b\u00108\u001a\u0004\u0018\u000109J\b\u0010:\u001a\u0004\u0018\u00010;J\b\u0010<\u001a\u0004\u0018\u00010=J\u001c\u0010>\u001a\u00020\"\"\u0004\b\u0000\u0010?2\f\u0010@\u001a\b\u0012\u0004\u0012\u0002H?0AH\u0016J\u000e\u0010B\u001a\u00020\"2\u0006\u0010C\u001a\u00020DJ\b\u0010E\u001a\u00020\"H\u0016R\u001e\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR*\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\f0\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R*\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 \u00a8\u0006L"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/autoflight/FlightPlanComputer;", "Lru/octol1ttle/flightassistant/api/computer/Computer;", "computers", "Lru/octol1ttle/flightassistant/api/computer/ComputerBus;", "<init>", "(Lru/octol1ttle/flightassistant/api/computer/ComputerBus;)V", "value", "Lru/octol1ttle/flightassistant/impl/computer/autoflight/FlightPlanComputer$FlightPhase;", "currentPhase", "getCurrentPhase", "()Lru/octol1ttle/flightassistant/impl/computer/autoflight/FlightPlanComputer$FlightPhase;", "Lru/octol1ttle/flightassistant/api/util/LimitedFIFOQueue;", "", "groundSpeeds", "getGroundSpeeds", "()Lru/octol1ttle/flightassistant/api/util/LimitedFIFOQueue;", "departureData", "Lru/octol1ttle/flightassistant/impl/computer/autoflight/FlightPlanComputer$DepartureData;", "getDepartureData", "()Lru/octol1ttle/flightassistant/impl/computer/autoflight/FlightPlanComputer$DepartureData;", "setDepartureData", "(Lru/octol1ttle/flightassistant/impl/computer/autoflight/FlightPlanComputer$DepartureData;)V", "", "Lru/octol1ttle/flightassistant/impl/computer/autoflight/FlightPlanComputer$EnrouteWaypoint;", "enrouteData", "getEnrouteData", "()Ljava/util/List;", "arrivalData", "Lru/octol1ttle/flightassistant/impl/computer/autoflight/FlightPlanComputer$ArrivalData;", "getArrivalData", "()Lru/octol1ttle/flightassistant/impl/computer/autoflight/FlightPlanComputer$ArrivalData;", "setArrivalData", "(Lru/octol1ttle/flightassistant/impl/computer/autoflight/FlightPlanComputer$ArrivalData;)V", "tick", "", "updateFlightPhase", "updateEnrouteData", "getEnrouteOrigin", "getEnrouteTarget", "isCloseTo", "", "target", "getMinimums", "()Ljava/lang/Double;", "getCruiseAltitude", "", "()Ljava/lang/Integer;", "getLateralDeviation", "position", "Lnet/minecraft/world/phys/Vec3;", "(Lnet/minecraft/world/phys/Vec3;)Ljava/lang/Double;", "getVerticalDeviation", "getDistanceToTarget", "getFormattedTime", "", "distance", "getThrustMode", "Lru/octol1ttle/flightassistant/impl/computer/autoflight/AutoFlightComputer$ThrustMode;", "getVerticalMode", "Lru/octol1ttle/flightassistant/impl/computer/autoflight/AutoFlightComputer$VerticalMode;", "getLateralMode", "Lru/octol1ttle/flightassistant/impl/computer/autoflight/AutoFlightComputer$LateralMode;", "handleQuery", "Response", "query", "Lru/octol1ttle/flightassistant/api/computer/ComputerQuery;", "load", "plan", "Lru/octol1ttle/flightassistant/impl/computer/autoflight/FlightPlanComputer$FlightPlan;", "reset", "Companion", "FlightPhase", "DepartureData", "EnrouteWaypoint", "ArrivalData", "FlightPlan", "flightassistant-neoforge"})
@SourceDebugExtension(value={"SMAP\nFlightPlanComputer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FlightPlanComputer.kt\nru/octol1ttle/flightassistant/impl/computer/autoflight/FlightPlanComputer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,357:1\n360#2,7:358\n388#2,7:365\n669#2,11:372\n669#2,11:383\n1#3:394\n*S KotlinDebug\n*F\n+ 1 FlightPlanComputer.kt\nru/octol1ttle/flightassistant/impl/computer/autoflight/FlightPlanComputer\n*L\n81#1:358,7\n82#1:365,7\n120#1:372,11\n124#1:383,11\n*E\n"})
public final class FlightPlanComputer
extends Computer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private FlightPhase currentPhase;
    @NotNull
    private LimitedFIFOQueue<Double> groundSpeeds;
    @NotNull
    private DepartureData departureData;
    @NotNull
    private List<EnrouteWaypoint> enrouteData;
    @NotNull
    private ArrivalData arrivalData;
    @NotNull
    private static final ResourceLocation ID = FlightAssistant.INSTANCE.id$flightassistant_neoforge("flight_plan");

    public FlightPlanComputer(@NotNull ComputerBus computers) {
        Intrinsics.checkNotNullParameter((Object)computers, (String)"computers");
        super(computers);
        this.currentPhase = FlightPhase.UNKNOWN;
        this.groundSpeeds = new LimitedFIFOQueue(100);
        this.departureData = DepartureData.Companion.getDEFAULT();
        this.enrouteData = new ArrayList();
        this.arrivalData = ArrivalData.Companion.getDEFAULT();
    }

    @NotNull
    public final FlightPhase getCurrentPhase() {
        return this.currentPhase;
    }

    @NotNull
    public final LimitedFIFOQueue<Double> getGroundSpeeds() {
        return this.groundSpeeds;
    }

    @NotNull
    public final DepartureData getDepartureData() {
        return this.departureData;
    }

    public final void setDepartureData(@NotNull DepartureData departureData) {
        Intrinsics.checkNotNullParameter((Object)departureData, (String)"<set-?>");
        this.departureData = departureData;
    }

    @NotNull
    public final List<EnrouteWaypoint> getEnrouteData() {
        return this.enrouteData;
    }

    @NotNull
    public final ArrivalData getArrivalData() {
        return this.arrivalData;
    }

    public final void setArrivalData(@NotNull ArrivalData arrivalData) {
        Intrinsics.checkNotNullParameter((Object)arrivalData, (String)"<set-?>");
        this.arrivalData = arrivalData;
    }

    @Override
    public void tick() {
        this.updateEnrouteData();
        this.currentPhase = this.updateFlightPhase();
        this.groundSpeeds.add(this.getComputers().getData().getVelocityPerSecond().horizontalDistance());
    }

    private final FlightPhase updateFlightPhase() {
        int n;
        int firstCruise;
        EnrouteWaypoint target;
        block20: {
            int n2;
            int cruiseAltitude;
            block19: {
                if (!this.getComputers().getData().getFlying()) {
                    if (!this.departureData.isDefault() && VectorExtensionsKt.distance2d(this.departureData.getCoordinatesX(), this.departureData.getCoordinatesZ(), this.getComputers().getData().getX(), this.getComputers().getData().getZ()) < 20.0) {
                        EnrouteWaypoint enrouteWaypoint = this.getEnrouteOrigin();
                        if (enrouteWaypoint != null) {
                            enrouteWaypoint.setActive(null);
                        }
                        EnrouteWaypoint enrouteWaypoint2 = this.getEnrouteTarget();
                        if (enrouteWaypoint2 != null) {
                            enrouteWaypoint2.setActive(null);
                        }
                        EnrouteWaypoint enrouteWaypoint3 = (EnrouteWaypoint)CollectionsKt.firstOrNull(this.enrouteData);
                        if (enrouteWaypoint3 != null) {
                            enrouteWaypoint3.setActive(EnrouteWaypoint.Active.TARGET);
                        }
                        return FlightPhase.TAKEOFF;
                    }
                    return FlightPhase.UNKNOWN;
                }
                if (this.currentPhase == FlightPhase.TAKEOFF) {
                    if (!((Collection)this.enrouteData).isEmpty() && (double)((EnrouteWaypoint)CollectionsKt.first(this.enrouteData)).getAltitude() - this.getComputers().getData().getAltitude() <= 10.0) {
                        return FlightPhase.CLIMB;
                    }
                    return FlightPhase.TAKEOFF;
                }
                target = this.getEnrouteTarget();
                if (target == null) {
                    if (this.enrouteData.isEmpty() || this.arrivalData.isDefault()) {
                        return FlightPhase.UNKNOWN;
                    }
                    if (this.currentPhase == FlightPhase.GO_AROUND && (Math.abs(this.getComputers().getData().getAltitude() - (double)this.arrivalData.getGoAroundAltitude()) > 5.0 || this.enrouteData.size() > this.arrivalData.getApproachReEntryWaypointIndex())) {
                        return FlightPhase.GO_AROUND;
                    }
                    if (this.currentPhase == FlightPhase.APPROACH || this.currentPhase == FlightPhase.LANDING) {
                        if (this.getComputers().getThrust().getCurrent() == 1.0f) {
                            return FlightPhase.GO_AROUND;
                        }
                        return FlightPhase.LANDING;
                    }
                    return FlightPhase.UNKNOWN;
                }
                Integer n3 = this.getCruiseAltitude();
                if (n3 == null) {
                    return FlightPhase.UNKNOWN;
                }
                cruiseAltitude = n3;
                List<EnrouteWaypoint> $this$indexOfFirst$iv = this.enrouteData;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                Iterator<EnrouteWaypoint> iterator = $this$indexOfFirst$iv.iterator();
                while (iterator.hasNext()) {
                    EnrouteWaypoint item$iv;
                    EnrouteWaypoint it = item$iv = iterator.next();
                    boolean bl = false;
                    if (it.getAltitude() == cruiseAltitude) {
                        n2 = index$iv;
                        break block19;
                    }
                    ++index$iv;
                }
                n2 = -1;
            }
            firstCruise = n2;
            List<EnrouteWaypoint> $this$indexOfLast$iv = this.enrouteData;
            boolean $i$f$indexOfLast = false;
            ListIterator<EnrouteWaypoint> iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
            while (iterator$iv.hasPrevious()) {
                EnrouteWaypoint it = iterator$iv.previous();
                boolean bl = false;
                if (!(it.getAltitude() == cruiseAltitude)) continue;
                n = iterator$iv.nextIndex();
                break block20;
            }
            n = -1;
        }
        int lastCruise = n;
        int targetIndex = this.enrouteData.indexOf(target);
        if (targetIndex <= firstCruise) {
            return FlightPhase.CLIMB;
        }
        if (targetIndex <= lastCruise) {
            return FlightPhase.CRUISE;
        }
        if (targetIndex < this.enrouteData.size() - 1 || this.arrivalData.isDefault()) {
            return FlightPhase.DESCEND;
        }
        return FlightPhase.APPROACH;
    }

    private final void updateEnrouteData() {
        if (this.currentPhase == FlightPhase.GO_AROUND && this.getComputers().getThrust().getCurrent() < 1.0f && Math.abs(this.getComputers().getData().getAltitude() - (double)this.arrivalData.getGoAroundAltitude()) <= 5.0) {
            EnrouteWaypoint approachReEntryWaypoint;
            EnrouteWaypoint enrouteWaypoint = approachReEntryWaypoint = (EnrouteWaypoint)CollectionsKt.getOrNull(this.enrouteData, (int)this.arrivalData.getApproachReEntryWaypointIndex());
            if (enrouteWaypoint != null) {
                enrouteWaypoint.setActive(EnrouteWaypoint.Active.TARGET);
            }
        }
        EnrouteWaypoint enrouteWaypoint = this.getEnrouteTarget();
        if (enrouteWaypoint == null) {
            return;
        }
        EnrouteWaypoint target = enrouteWaypoint;
        if (this.isCloseTo(target)) {
            int targetIndex = this.enrouteData.indexOf(target);
            EnrouteWaypoint next = targetIndex + 1 >= this.enrouteData.size() ? null : this.enrouteData.get(targetIndex + 1);
            EnrouteWaypoint enrouteWaypoint2 = this.getEnrouteOrigin();
            if (enrouteWaypoint2 != null) {
                enrouteWaypoint2.setActive(null);
            }
            if (next != null) {
                target.setActive(EnrouteWaypoint.Active.ORIGIN);
                next.setActive(EnrouteWaypoint.Active.TARGET);
            } else {
                target.setActive(null);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final EnrouteWaypoint getEnrouteOrigin() {
        Object object;
        block2: {
            void var3_3;
            Iterable $this$singleOrNull$iv = this.enrouteData;
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                EnrouteWaypoint it = (EnrouteWaypoint)element$iv;
                boolean bl = false;
                if (!(it.getActive() == EnrouteWaypoint.Active.ORIGIN)) continue;
                if (found$iv) {
                    object = null;
                    break block2;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            object = !found$iv ? null : var3_3;
        }
        return (EnrouteWaypoint)object;
    }

    /*
     * WARNING - void declaration
     */
    private final EnrouteWaypoint getEnrouteTarget() {
        Object object;
        block2: {
            void var3_3;
            Iterable $this$singleOrNull$iv = this.enrouteData;
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                EnrouteWaypoint it = (EnrouteWaypoint)element$iv;
                boolean bl = false;
                if (!(it.getActive() == EnrouteWaypoint.Active.TARGET)) continue;
                if (found$iv) {
                    object = null;
                    break block2;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            object = !found$iv ? null : var3_3;
        }
        return (EnrouteWaypoint)object;
    }

    private final boolean isCloseTo(EnrouteWaypoint target) {
        return this.getDistanceToTarget(target) < this.getComputers().getData().getVelocityPerSecond().horizontalDistance() * 3.0;
    }

    @Nullable
    public final Double getMinimums() {
        if (this.getComputers().getPlan().arrivalData.isDefault()) {
            return null;
        }
        return this.getComputers().getPlan().arrivalData.getMinimumsType() == ArrivalData.MinimumsType.ABSOLUTE ? Double.valueOf(this.getComputers().getPlan().arrivalData.getMinimums()) : Double.valueOf(this.getComputers().getGpws().getGroundOrVoidY() + (double)this.getComputers().getPlan().arrivalData.getMinimums());
    }

    @Nullable
    public final Integer getCruiseAltitude() {
        Comparable comparable;
        Iterator iterator = ((Iterable)this.enrouteData).iterator();
        if (!iterator.hasNext()) {
            comparable = null;
        } else {
            EnrouteWaypoint it = (EnrouteWaypoint)iterator.next();
            boolean bl = false;
            Comparable comparable2 = Integer.valueOf(it.getAltitude());
            while (iterator.hasNext()) {
                EnrouteWaypoint it2 = (EnrouteWaypoint)iterator.next();
                $i$a$-maxOfOrNull-FlightPlanComputer$getCruiseAltitude$1 = false;
                Comparable comparable3 = Integer.valueOf(it2.getAltitude());
                if (comparable2.compareTo(comparable3) >= 0) continue;
                comparable2 = comparable3;
            }
            comparable = comparable2;
        }
        return (Integer)comparable;
    }

    @Nullable
    public final Double getLateralDeviation(@NotNull Vec3 position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        if (this.enrouteData.isEmpty()) {
            return null;
        }
        Object origin = null;
        Vec3 target = null;
        switch (WhenMappings.$EnumSwitchMapping$0[this.currentPhase.ordinal()]) {
            case 1: {
                origin = this.departureData.vec3();
                target = ((EnrouteWaypoint)CollectionsKt.first(this.enrouteData)).vec3();
                break;
            }
            case 2: {
                origin = ((EnrouteWaypoint)CollectionsKt.last(this.enrouteData)).vec3();
                target = this.arrivalData.vec3();
                break;
            }
            default: {
                EnrouteWaypoint enrouteWaypoint = this.getEnrouteOrigin();
                if (enrouteWaypoint == null || (enrouteWaypoint = enrouteWaypoint.vec3()) == null) {
                    return null;
                }
                origin = enrouteWaypoint;
                EnrouteWaypoint enrouteWaypoint2 = this.getEnrouteTarget();
                Intrinsics.checkNotNull((Object)enrouteWaypoint2);
                target = enrouteWaypoint2.vec3();
            }
        }
        Vector2d origin2d = VectorExtensionsKt.toVector2d(origin);
        Vector2d track = VectorExtensionsKt.toVector2d(target).sub((Vector2dc)origin2d);
        Vector2d toEntity = VectorExtensionsKt.toVector2d(position).sub((Vector2dc)origin2d);
        double cross = track.x * toEntity.y - track.y * toEntity.x;
        return cross / track.length();
    }

    @Nullable
    public final Double getVerticalDeviation(@NotNull Vec3 position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        if (this.enrouteData.isEmpty()) {
            return null;
        }
        Object origin = null;
        Vec3 target = null;
        switch (WhenMappings.$EnumSwitchMapping$0[this.currentPhase.ordinal()]) {
            case 1: {
                origin = this.departureData.vec3();
                target = ((EnrouteWaypoint)CollectionsKt.first(this.enrouteData)).vec3();
                break;
            }
            case 2: {
                origin = ((EnrouteWaypoint)CollectionsKt.last(this.enrouteData)).vec3();
                target = this.arrivalData.vec3();
                break;
            }
            default: {
                EnrouteWaypoint enrouteWaypoint = this.getEnrouteOrigin();
                if (enrouteWaypoint == null || (enrouteWaypoint = enrouteWaypoint.vec3()) == null) {
                    return null;
                }
                origin = enrouteWaypoint;
                EnrouteWaypoint enrouteWaypoint2 = this.getEnrouteTarget();
                Intrinsics.checkNotNull((Object)enrouteWaypoint2);
                target = enrouteWaypoint2.vec3();
            }
        }
        Vector2d track = VectorExtensionsKt.toVector2d(target).sub((Vector2dc)VectorExtensionsKt.toVector2d(origin));
        Intrinsics.checkNotNull((Object)track);
        double trackProgress = VectorExtensionsKt.getProgressOnTrack(track, VectorExtensionsKt.toVector2d(origin), new Vector2d(position.x, position.z));
        return Mth.lerp((double)trackProgress, (double)origin.y, (double)target.y) - position.y;
    }

    public final double getDistanceToTarget(@NotNull EnrouteWaypoint target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return VectorExtensionsKt.distance2d(target.getCoordinatesX(), target.getCoordinatesZ(), this.getComputers().getData().getX(), this.getComputers().getData().getZ());
    }

    @NotNull
    public final String getFormattedTime(double distance) {
        Object object;
        Duration duration = Duration.ofSeconds(MathKt.roundToLong((double)(distance / CollectionsKt.averageOfDouble((Iterable)this.groundSpeeds))));
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
        Duration duration2 = duration;
        if (this.getComputers().getData().getFlying()) {
            Object[] objectArray = new Object[]{duration2.toSecondsPart()};
            object = duration2.toMinutesPart() + ":" + StringExtensionsKt.formatRoot("%02d", objectArray);
        } else {
            object = "--:--";
        }
        return object;
    }

    @Nullable
    public final AutoFlightComputer.ThrustMode getThrustMode() {
        AutoFlightComputer.ThrustMode thrustMode;
        switch (WhenMappings.$EnumSwitchMapping$0[this.currentPhase.ordinal()]) {
            case 1: {
                float f = this.departureData.getTakeoffThrust();
                MutableComponent mutableComponent = Component.translatable((String)"mode.flightassistant.thrust.takeoff");
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
                thrustMode = new ConstantThrustMode(f, (Component)mutableComponent);
                break;
            }
            case 2: {
                float f = this.arrivalData.getLandingThrust();
                MutableComponent mutableComponent = Component.translatable((String)"mode.flightassistant.thrust.landing");
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
                thrustMode = new ConstantThrustMode(f, (Component)mutableComponent);
                break;
            }
            case 3: {
                MutableComponent mutableComponent = Component.translatable((String)"mode.flightassistant.thrust.toga");
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
                thrustMode = new ConstantThrustMode(1.0f, (Component)mutableComponent);
                break;
            }
            default: {
                EnrouteWaypoint enrouteWaypoint = this.getEnrouteTarget();
                if (enrouteWaypoint == null) {
                    return null;
                }
                EnrouteWaypoint target = enrouteWaypoint;
                return target.getSpeed() != 0 ? (AutoFlightComputer.ThrustMode)new SpeedThrustMode(target.getSpeed(), null, 2, null) : null;
            }
        }
        return thrustMode;
    }

    @Nullable
    public final AutoFlightComputer.VerticalMode getVerticalMode() {
        AutoFlightComputer.VerticalMode verticalMode;
        switch (WhenMappings.$EnumSwitchMapping$0[this.currentPhase.ordinal()]) {
            case 1: {
                EnrouteWaypoint enrouteWaypoint = this.getEnrouteTarget();
                if (enrouteWaypoint == null) {
                    return null;
                }
                EnrouteWaypoint target = enrouteWaypoint;
                return (double)target.getAltitude() - this.getComputers().getData().getAltitude() > 10.0 ? (AutoFlightComputer.VerticalMode)new SelectedAltitudeVerticalMode(target.getAltitude(), null, 2, null) : null;
            }
            case 2: {
                EnrouteWaypoint enrouteWaypoint = (EnrouteWaypoint)CollectionsKt.lastOrNull(this.enrouteData);
                if (enrouteWaypoint == null) {
                    return null;
                }
                EnrouteWaypoint approach = enrouteWaypoint;
                verticalMode = new ManagedAltitudeVerticalMode(approach.getCoordinatesX(), approach.getCoordinatesZ(), approach.getAltitude(), this.arrivalData.getCoordinatesX(), this.arrivalData.getCoordinatesZ(), this.arrivalData.getElevation(), (Component)Component.translatable((String)"mode.flightassistant.vertical.glide_slope"));
                break;
            }
            case 3: {
                verticalMode = new SelectedAltitudeVerticalMode(this.arrivalData.getGoAroundAltitude(), (Component)Component.translatable((String)"mode.flightassistant.vertical.go_around"));
                break;
            }
            default: {
                EnrouteWaypoint origin = this.getEnrouteOrigin();
                EnrouteWaypoint enrouteWaypoint = this.getEnrouteTarget();
                if (enrouteWaypoint == null) {
                    return null;
                }
                EnrouteWaypoint target = enrouteWaypoint;
                verticalMode = origin != null ? (AutoFlightComputer.VerticalMode)new ManagedAltitudeVerticalMode(origin.getCoordinatesX(), origin.getCoordinatesZ(), origin.getAltitude(), target.getCoordinatesX(), target.getCoordinatesZ(), target.getAltitude(), null, 64, null) : (AutoFlightComputer.VerticalMode)new SelectedAltitudeVerticalMode(target.getAltitude(), null, 2, null);
            }
        }
        return verticalMode;
    }

    @Nullable
    public final AutoFlightComputer.LateralMode getLateralMode() {
        AutoFlightComputer.LateralMode lateralMode;
        switch (WhenMappings.$EnumSwitchMapping$0[this.currentPhase.ordinal()]) {
            case 1: {
                EnrouteWaypoint enrouteWaypoint = this.getEnrouteTarget();
                if (enrouteWaypoint == null) {
                    return null;
                }
                EnrouteWaypoint target = enrouteWaypoint;
                lateralMode = new TrackNavigationLateralMode(this.departureData.getCoordinatesX(), this.departureData.getCoordinatesZ(), target.getCoordinatesX(), target.getCoordinatesZ(), null, 16, null);
                break;
            }
            case 2: {
                EnrouteWaypoint enrouteWaypoint = (EnrouteWaypoint)CollectionsKt.lastOrNull(this.enrouteData);
                if (enrouteWaypoint == null) {
                    return null;
                }
                EnrouteWaypoint approach = enrouteWaypoint;
                lateralMode = new TrackNavigationLateralMode(approach.getCoordinatesX(), approach.getCoordinatesZ(), this.arrivalData.getCoordinatesX(), this.arrivalData.getCoordinatesZ(), (Component)Component.translatable((String)"mode.flightassistant.lateral.localizer"));
                break;
            }
            case 3: {
                lateralMode = new HeadingLateralMode((int)this.getComputers().getData().getHeading(), (Component)Component.translatable((String)"mode.flightassistant.lateral.go_around"));
                break;
            }
            default: {
                EnrouteWaypoint origin = this.getEnrouteOrigin();
                EnrouteWaypoint enrouteWaypoint = this.getEnrouteTarget();
                if (enrouteWaypoint == null) {
                    return null;
                }
                EnrouteWaypoint target = enrouteWaypoint;
                lateralMode = origin != null ? (AutoFlightComputer.LateralMode)new TrackNavigationLateralMode(origin.getCoordinatesX(), origin.getCoordinatesZ(), target.getCoordinatesX(), target.getCoordinatesZ(), null, 16, null) : (AutoFlightComputer.LateralMode)new DirectCoordinatesLateralMode(target.getCoordinatesX(), target.getCoordinatesZ(), null, 4, null);
            }
        }
        return lateralMode;
    }

    @Override
    public <Response> void handleQuery(@NotNull ComputerQuery<Response> query) {
        Intrinsics.checkNotNullParameter(query, (String)"query");
        if (query instanceof StatusDisplay.StatusMessageQuery && this.currentPhase != FlightPhase.UNKNOWN && (!this.departureData.isDefault() || !((Collection)this.enrouteData).isEmpty())) {
            StatusDisplay.StatusMessageQuery statusMessageQuery = (StatusDisplay.StatusMessageQuery)query;
            String string = this.currentPhase.name().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            MutableComponent mutableComponent = Component.translatable((String)("status.flightassistant.flight_plan.phase." + string));
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
            statusMessageQuery.respond(mutableComponent);
            EnrouteWaypoint target = this.getEnrouteTarget();
            if (target != null) {
                double distance = this.getDistanceToTarget(target);
                StatusDisplay.StatusMessageQuery statusMessageQuery2 = (StatusDisplay.StatusMessageQuery)query;
                Object[] objectArray = new Object[]{String.valueOf(MathKt.roundToLong((double)distance))};
                MutableComponent mutableComponent2 = Component.translatable((String)"status.flightassistant.flight_plan.waypoint_distance", (Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent2, (String)"translatable(...)");
                statusMessageQuery2.respond(mutableComponent2);
                StatusDisplay.StatusMessageQuery statusMessageQuery3 = (StatusDisplay.StatusMessageQuery)query;
                objectArray = new Object[]{this.getFormattedTime(distance)};
                MutableComponent mutableComponent3 = Component.translatable((String)"status.flightassistant.flight_plan.waypoint_time", (Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent3, (String)"translatable(...)");
                statusMessageQuery3.respond(mutableComponent3);
            }
        }
    }

    public final void load(@NotNull FlightPlan plan) {
        Intrinsics.checkNotNullParameter((Object)plan, (String)"plan");
        this.departureData = plan.getDeparture();
        this.enrouteData = new ArrayList(plan.getEnroute());
        this.arrivalData = plan.getArrival();
    }

    @Override
    public void reset() {
        this.currentPhase = FlightPhase.UNKNOWN;
        this.groundSpeeds.clear();
    }

    @Serializable
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0087\b\u0018\u0000 92\u00020\u0001:\u000389:BW\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0003\u0012\b\b\u0002\u0010\f\u001a\u00020\u0003\u00a2\u0006\u0004\b\r\u0010\u000eB]\b\u0010\u0012\u0006\u0010\u000f\u001a\u00020\u0003\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u0012\u0006\u0010\f\u001a\u00020\u0003\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0004\b\r\u0010\u0012J\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020!J\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003J\t\u0010#\u001a\u00020\u0003H\u00c6\u0003J\t\u0010$\u001a\u00020\u0003H\u00c6\u0003J\t\u0010%\u001a\u00020\u0007H\u00c6\u0003J\t\u0010&\u001a\u00020\u0003H\u00c6\u0003J\t\u0010'\u001a\u00020\nH\u00c6\u0003J\t\u0010(\u001a\u00020\u0003H\u00c6\u0003J\t\u0010)\u001a\u00020\u0003H\u00c6\u0003JY\u0010*\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\u00032\b\b\u0002\u0010\f\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010+\u001a\u00020\u001f2\b\u0010,\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010-\u001a\u00020\u0003H\u00d6\u0001J\t\u0010.\u001a\u00020/H\u00d6\u0001J%\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u00002\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u000206H\u0001\u00a2\u0006\u0002\b7R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0014R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0014R\u0011\u0010\f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0014\u00a8\u0006;"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/autoflight/FlightPlanComputer$ArrivalData;", "", "coordinatesX", "", "coordinatesZ", "elevation", "landingThrust", "", "minimums", "minimumsType", "Lru/octol1ttle/flightassistant/impl/computer/autoflight/FlightPlanComputer$ArrivalData$MinimumsType;", "goAroundAltitude", "approachReEntryWaypointIndex", "<init>", "(IIIFILru/octol1ttle/flightassistant/impl/computer/autoflight/FlightPlanComputer$ArrivalData$MinimumsType;II)V", "seen0", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(IIIIFILru/octol1ttle/flightassistant/impl/computer/autoflight/FlightPlanComputer$ArrivalData$MinimumsType;IILkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getCoordinatesX", "()I", "getCoordinatesZ", "getElevation", "getLandingThrust", "()F", "getMinimums", "getMinimumsType", "()Lru/octol1ttle/flightassistant/impl/computer/autoflight/FlightPlanComputer$ArrivalData$MinimumsType;", "getGoAroundAltitude", "getApproachReEntryWaypointIndex", "isDefault", "", "vec3", "Lnet/minecraft/world/phys/Vec3;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "other", "hashCode", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$flightassistant_neoforge", "MinimumsType", "Companion", "$serializer", "flightassistant-neoforge"})
    public static final class ArrivalData {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int coordinatesX;
        private final int coordinatesZ;
        private final int elevation;
        private final float landingThrust;
        private final int minimums;
        @NotNull
        private final MinimumsType minimumsType;
        private final int goAroundAltitude;
        private final int approachReEntryWaypointIndex;
        @JvmField
        @NotNull
        private static final Lazy<KSerializer<Object>>[] $childSerializers;
        @NotNull
        private static final ArrivalData DEFAULT;

        public ArrivalData(int coordinatesX, int coordinatesZ, int elevation, float landingThrust, int minimums, @NotNull MinimumsType minimumsType, int goAroundAltitude, int approachReEntryWaypointIndex) {
            Intrinsics.checkNotNullParameter((Object)((Object)minimumsType), (String)"minimumsType");
            this.coordinatesX = coordinatesX;
            this.coordinatesZ = coordinatesZ;
            this.elevation = elevation;
            this.landingThrust = landingThrust;
            this.minimums = minimums;
            this.minimumsType = minimumsType;
            this.goAroundAltitude = goAroundAltitude;
            this.approachReEntryWaypointIndex = approachReEntryWaypointIndex;
        }

        public /* synthetic */ ArrivalData(int n, int n2, int n3, float f, int n4, MinimumsType minimumsType, int n5, int n6, int n7, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n7 & 1) != 0) {
                n = 0;
            }
            if ((n7 & 2) != 0) {
                n2 = 0;
            }
            if ((n7 & 4) != 0) {
                n3 = 0;
            }
            if ((n7 & 8) != 0) {
                f = 0.0f;
            }
            if ((n7 & 0x10) != 0) {
                n4 = 0;
            }
            if ((n7 & 0x20) != 0) {
                minimumsType = MinimumsType.ABSOLUTE;
            }
            if ((n7 & 0x40) != 0) {
                n5 = 0;
            }
            if ((n7 & 0x80) != 0) {
                n6 = 0;
            }
            this(n, n2, n3, f, n4, minimumsType, n5, n6);
        }

        public final int getCoordinatesX() {
            return this.coordinatesX;
        }

        public final int getCoordinatesZ() {
            return this.coordinatesZ;
        }

        public final int getElevation() {
            return this.elevation;
        }

        public final float getLandingThrust() {
            return this.landingThrust;
        }

        public final int getMinimums() {
            return this.minimums;
        }

        @NotNull
        public final MinimumsType getMinimumsType() {
            return this.minimumsType;
        }

        public final int getGoAroundAltitude() {
            return this.goAroundAltitude;
        }

        public final int getApproachReEntryWaypointIndex() {
            return this.approachReEntryWaypointIndex;
        }

        public final boolean isDefault() {
            return Intrinsics.areEqual((Object)this, (Object)DEFAULT);
        }

        @NotNull
        public final Vec3 vec3() {
            return new Vec3((double)this.coordinatesX, (double)this.elevation, (double)this.coordinatesZ);
        }

        public final int component1() {
            return this.coordinatesX;
        }

        public final int component2() {
            return this.coordinatesZ;
        }

        public final int component3() {
            return this.elevation;
        }

        public final float component4() {
            return this.landingThrust;
        }

        public final int component5() {
            return this.minimums;
        }

        @NotNull
        public final MinimumsType component6() {
            return this.minimumsType;
        }

        public final int component7() {
            return this.goAroundAltitude;
        }

        public final int component8() {
            return this.approachReEntryWaypointIndex;
        }

        @NotNull
        public final ArrivalData copy(int coordinatesX, int coordinatesZ, int elevation, float landingThrust, int minimums, @NotNull MinimumsType minimumsType, int goAroundAltitude, int approachReEntryWaypointIndex) {
            Intrinsics.checkNotNullParameter((Object)((Object)minimumsType), (String)"minimumsType");
            return new ArrivalData(coordinatesX, coordinatesZ, elevation, landingThrust, minimums, minimumsType, goAroundAltitude, approachReEntryWaypointIndex);
        }

        public static /* synthetic */ ArrivalData copy$default(ArrivalData arrivalData, int n, int n2, int n3, float f, int n4, MinimumsType minimumsType, int n5, int n6, int n7, Object object) {
            if ((n7 & 1) != 0) {
                n = arrivalData.coordinatesX;
            }
            if ((n7 & 2) != 0) {
                n2 = arrivalData.coordinatesZ;
            }
            if ((n7 & 4) != 0) {
                n3 = arrivalData.elevation;
            }
            if ((n7 & 8) != 0) {
                f = arrivalData.landingThrust;
            }
            if ((n7 & 0x10) != 0) {
                n4 = arrivalData.minimums;
            }
            if ((n7 & 0x20) != 0) {
                minimumsType = arrivalData.minimumsType;
            }
            if ((n7 & 0x40) != 0) {
                n5 = arrivalData.goAroundAltitude;
            }
            if ((n7 & 0x80) != 0) {
                n6 = arrivalData.approachReEntryWaypointIndex;
            }
            return arrivalData.copy(n, n2, n3, f, n4, minimumsType, n5, n6);
        }

        @NotNull
        public String toString() {
            return "ArrivalData(coordinatesX=" + this.coordinatesX + ", coordinatesZ=" + this.coordinatesZ + ", elevation=" + this.elevation + ", landingThrust=" + this.landingThrust + ", minimums=" + this.minimums + ", minimumsType=" + this.minimumsType + ", goAroundAltitude=" + this.goAroundAltitude + ", approachReEntryWaypointIndex=" + this.approachReEntryWaypointIndex + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.coordinatesX);
            result = result * 31 + Integer.hashCode(this.coordinatesZ);
            result = result * 31 + Integer.hashCode(this.elevation);
            result = result * 31 + Float.hashCode(this.landingThrust);
            result = result * 31 + Integer.hashCode(this.minimums);
            result = result * 31 + this.minimumsType.hashCode();
            result = result * 31 + Integer.hashCode(this.goAroundAltitude);
            result = result * 31 + Integer.hashCode(this.approachReEntryWaypointIndex);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ArrivalData)) {
                return false;
            }
            ArrivalData arrivalData = (ArrivalData)other;
            if (this.coordinatesX != arrivalData.coordinatesX) {
                return false;
            }
            if (this.coordinatesZ != arrivalData.coordinatesZ) {
                return false;
            }
            if (this.elevation != arrivalData.elevation) {
                return false;
            }
            if (Float.compare(this.landingThrust, arrivalData.landingThrust) != 0) {
                return false;
            }
            if (this.minimums != arrivalData.minimums) {
                return false;
            }
            if (this.minimumsType != arrivalData.minimumsType) {
                return false;
            }
            if (this.goAroundAltitude != arrivalData.goAroundAltitude) {
                return false;
            }
            return this.approachReEntryWaypointIndex == arrivalData.approachReEntryWaypointIndex;
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$flightassistant_neoforge(ArrivalData self, CompositeEncoder output, SerialDescriptor serialDesc) {
            Lazy<KSerializer<Object>>[] lazyArray = $childSerializers;
            if (output.shouldEncodeElementDefault(serialDesc, 0) ? true : self.coordinatesX != 0) {
                output.encodeIntElement(serialDesc, 0, self.coordinatesX);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 1) ? true : self.coordinatesZ != 0) {
                output.encodeIntElement(serialDesc, 1, self.coordinatesZ);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 2) ? true : self.elevation != 0) {
                output.encodeIntElement(serialDesc, 2, self.elevation);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 3) ? true : Float.compare(self.landingThrust, 0.0f) != 0) {
                output.encodeFloatElement(serialDesc, 3, self.landingThrust);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 4) ? true : self.minimums != 0) {
                output.encodeIntElement(serialDesc, 4, self.minimums);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 5) ? true : self.minimumsType != MinimumsType.ABSOLUTE) {
                output.encodeSerializableElement(serialDesc, 5, (SerializationStrategy)lazyArray[5].getValue(), (Object)self.minimumsType);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 6) ? true : self.goAroundAltitude != 0) {
                output.encodeIntElement(serialDesc, 6, self.goAroundAltitude);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 7) ? true : self.approachReEntryWaypointIndex != 0) {
                output.encodeIntElement(serialDesc, 7, self.approachReEntryWaypointIndex);
            }
        }

        public /* synthetic */ ArrivalData(int seen0, int coordinatesX, int coordinatesZ, int elevation, float landingThrust, int minimums, MinimumsType minimumsType, int goAroundAltitude, int approachReEntryWaypointIndex, SerializationConstructorMarker serializationConstructorMarker) {
            if ((0 & seen0) != 0) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)0, (SerialDescriptor)ArrivalData$$serializer.INSTANCE.getDescriptor());
            }
            this.coordinatesX = (seen0 & 1) == 0 ? 0 : coordinatesX;
            this.coordinatesZ = (seen0 & 2) == 0 ? 0 : coordinatesZ;
            this.elevation = (seen0 & 4) == 0 ? 0 : elevation;
            this.landingThrust = (seen0 & 8) == 0 ? 0.0f : landingThrust;
            this.minimums = (seen0 & 0x10) == 0 ? 0 : minimums;
            this.minimumsType = (seen0 & 0x20) == 0 ? MinimumsType.ABSOLUTE : minimumsType;
            this.goAroundAltitude = (seen0 & 0x40) == 0 ? 0 : goAroundAltitude;
            this.approachReEntryWaypointIndex = (seen0 & 0x80) == 0 ? 0 : approachReEntryWaypointIndex;
        }

        public ArrivalData() {
            this(0, 0, 0, 0.0f, 0, null, 0, 0, 255, null);
        }

        public static final /* synthetic */ Lazy[] access$get$childSerializers$cp() {
            return $childSerializers;
        }

        static {
            Lazy[] lazyArray = new Lazy[]{null, null, null, null, null, LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> EnumsKt.createSimpleEnumSerializer((String)"ru.octol1ttle.flightassistant.impl.computer.autoflight.FlightPlanComputer.ArrivalData.MinimumsType", (Enum[])MinimumsType.values())), null, null};
            $childSerializers = lazyArray;
            DEFAULT = new ArrivalData(0, 0, 0, 0.0f, 0, null, 0, 0, 255, null);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/autoflight/FlightPlanComputer$ArrivalData$Companion;", "", "<init>", "()V", "DEFAULT", "Lru/octol1ttle/flightassistant/impl/computer/autoflight/FlightPlanComputer$ArrivalData;", "getDEFAULT", "()Lru/octol1ttle/flightassistant/impl/computer/autoflight/FlightPlanComputer$ArrivalData;", "serializer", "Lkotlinx/serialization/KSerializer;", "flightassistant-neoforge"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final ArrivalData getDEFAULT() {
                return DEFAULT;
            }

            @NotNull
            public final KSerializer<ArrivalData> serializer() {
                return (KSerializer)ArrivalData$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002B\u0011\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\t\u001a\u00020\u0004H\u0016R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\n"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/autoflight/FlightPlanComputer$ArrivalData$MinimumsType;", "Ldev/isxander/yacl3/api/NameableEnum;", "", "displayName", "Lnet/minecraft/network/chat/Component;", "<init>", "(Ljava/lang/String;ILnet/minecraft/network/chat/Component;)V", "ABSOLUTE", "RELATIVE", "getDisplayName", "flightassistant-neoforge"})
        public static final class MinimumsType
        extends Enum<MinimumsType>
        implements NameableEnum {
            @JvmField
            @NotNull
            public final Component displayName;
            public static final /* enum */ MinimumsType ABSOLUTE;
            public static final /* enum */ MinimumsType RELATIVE;
            private static final /* synthetic */ MinimumsType[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            private MinimumsType(Component displayName) {
                this.displayName = displayName;
            }

            @NotNull
            public Component getDisplayName() {
                return this.displayName;
            }

            public static MinimumsType[] values() {
                return (MinimumsType[])$VALUES.clone();
            }

            public static MinimumsType valueOf(String value) {
                return Enum.valueOf(MinimumsType.class, value);
            }

            @NotNull
            public static EnumEntries<MinimumsType> getEntries() {
                return $ENTRIES;
            }

            static {
                MutableComponent mutableComponent = Component.translatable((String)"menu.flightassistant.fms.arrival.minimums.absolute");
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
                ABSOLUTE = new MinimumsType((Component)mutableComponent);
                MutableComponent mutableComponent2 = Component.translatable((String)"menu.flightassistant.fms.arrival.minimums.relative");
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent2, (String)"translatable(...)");
                RELATIVE = new MinimumsType((Component)mutableComponent2);
                $VALUES = minimumsTypeArray = new MinimumsType[]{MinimumsType.ABSOLUTE, MinimumsType.RELATIVE};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/autoflight/FlightPlanComputer$Companion;", "", "<init>", "()V", "ID", "Lnet/minecraft/resources/ResourceLocation;", "getID", "()Lnet/minecraft/resources/ResourceLocation;", "flightassistant-neoforge"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceLocation getID() {
            return ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Serializable
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 *2\u00020\u0001:\u0002*+B/\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB;\b\u0010\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\b\u0010\rJ\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0017J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0007H\u00c6\u0003J1\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u00152\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00d6\u0001J\t\u0010 \u001a\u00020!H\u00d6\u0001J%\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00002\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0001\u00a2\u0006\u0002\b)R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006,"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/autoflight/FlightPlanComputer$DepartureData;", "", "coordinatesX", "", "coordinatesZ", "elevation", "takeoffThrust", "", "<init>", "(IIIF)V", "seen0", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(IIIIFLkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getCoordinatesX", "()I", "getCoordinatesZ", "getElevation", "getTakeoffThrust", "()F", "isDefault", "", "vec3", "Lnet/minecraft/world/phys/Vec3;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$flightassistant_neoforge", "Companion", "$serializer", "flightassistant-neoforge"})
    public static final class DepartureData {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int coordinatesX;
        private final int coordinatesZ;
        private final int elevation;
        private final float takeoffThrust;
        @NotNull
        private static final DepartureData DEFAULT = new DepartureData(0, 0, 0, 0.0f, 15, null);

        public DepartureData(int coordinatesX, int coordinatesZ, int elevation, float takeoffThrust) {
            this.coordinatesX = coordinatesX;
            this.coordinatesZ = coordinatesZ;
            this.elevation = elevation;
            this.takeoffThrust = takeoffThrust;
        }

        public /* synthetic */ DepartureData(int n, int n2, int n3, float f, int n4, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n4 & 1) != 0) {
                n = 0;
            }
            if ((n4 & 2) != 0) {
                n2 = 0;
            }
            if ((n4 & 4) != 0) {
                n3 = 0;
            }
            if ((n4 & 8) != 0) {
                f = 0.0f;
            }
            this(n, n2, n3, f);
        }

        public final int getCoordinatesX() {
            return this.coordinatesX;
        }

        public final int getCoordinatesZ() {
            return this.coordinatesZ;
        }

        public final int getElevation() {
            return this.elevation;
        }

        public final float getTakeoffThrust() {
            return this.takeoffThrust;
        }

        public final boolean isDefault() {
            return Intrinsics.areEqual((Object)this, (Object)DEFAULT);
        }

        @NotNull
        public final Vec3 vec3() {
            return new Vec3((double)this.coordinatesX, (double)this.elevation, (double)this.coordinatesZ);
        }

        public final int component1() {
            return this.coordinatesX;
        }

        public final int component2() {
            return this.coordinatesZ;
        }

        public final int component3() {
            return this.elevation;
        }

        public final float component4() {
            return this.takeoffThrust;
        }

        @NotNull
        public final DepartureData copy(int coordinatesX, int coordinatesZ, int elevation, float takeoffThrust) {
            return new DepartureData(coordinatesX, coordinatesZ, elevation, takeoffThrust);
        }

        public static /* synthetic */ DepartureData copy$default(DepartureData departureData, int n, int n2, int n3, float f, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n = departureData.coordinatesX;
            }
            if ((n4 & 2) != 0) {
                n2 = departureData.coordinatesZ;
            }
            if ((n4 & 4) != 0) {
                n3 = departureData.elevation;
            }
            if ((n4 & 8) != 0) {
                f = departureData.takeoffThrust;
            }
            return departureData.copy(n, n2, n3, f);
        }

        @NotNull
        public String toString() {
            return "DepartureData(coordinatesX=" + this.coordinatesX + ", coordinatesZ=" + this.coordinatesZ + ", elevation=" + this.elevation + ", takeoffThrust=" + this.takeoffThrust + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.coordinatesX);
            result = result * 31 + Integer.hashCode(this.coordinatesZ);
            result = result * 31 + Integer.hashCode(this.elevation);
            result = result * 31 + Float.hashCode(this.takeoffThrust);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DepartureData)) {
                return false;
            }
            DepartureData departureData = (DepartureData)other;
            if (this.coordinatesX != departureData.coordinatesX) {
                return false;
            }
            if (this.coordinatesZ != departureData.coordinatesZ) {
                return false;
            }
            if (this.elevation != departureData.elevation) {
                return false;
            }
            return Float.compare(this.takeoffThrust, departureData.takeoffThrust) == 0;
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$flightassistant_neoforge(DepartureData self, CompositeEncoder output, SerialDescriptor serialDesc) {
            if (output.shouldEncodeElementDefault(serialDesc, 0) ? true : self.coordinatesX != 0) {
                output.encodeIntElement(serialDesc, 0, self.coordinatesX);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 1) ? true : self.coordinatesZ != 0) {
                output.encodeIntElement(serialDesc, 1, self.coordinatesZ);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 2) ? true : self.elevation != 0) {
                output.encodeIntElement(serialDesc, 2, self.elevation);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 3) ? true : Float.compare(self.takeoffThrust, 0.0f) != 0) {
                output.encodeFloatElement(serialDesc, 3, self.takeoffThrust);
            }
        }

        public /* synthetic */ DepartureData(int seen0, int coordinatesX, int coordinatesZ, int elevation, float takeoffThrust, SerializationConstructorMarker serializationConstructorMarker) {
            if ((0 & seen0) != 0) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)0, (SerialDescriptor)DepartureData$$serializer.INSTANCE.getDescriptor());
            }
            this.coordinatesX = (seen0 & 1) == 0 ? 0 : coordinatesX;
            this.coordinatesZ = (seen0 & 2) == 0 ? 0 : coordinatesZ;
            this.elevation = (seen0 & 4) == 0 ? 0 : elevation;
            this.takeoffThrust = (seen0 & 8) == 0 ? 0.0f : takeoffThrust;
        }

        public DepartureData() {
            this(0, 0, 0, 0.0f, 15, null);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/autoflight/FlightPlanComputer$DepartureData$Companion;", "", "<init>", "()V", "DEFAULT", "Lru/octol1ttle/flightassistant/impl/computer/autoflight/FlightPlanComputer$DepartureData;", "getDEFAULT", "()Lru/octol1ttle/flightassistant/impl/computer/autoflight/FlightPlanComputer$DepartureData;", "serializer", "Lkotlinx/serialization/KSerializer;", "flightassistant-neoforge"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final DepartureData getDEFAULT() {
                return DEFAULT;
            }

            @NotNull
            public final KSerializer<DepartureData> serializer() {
                return (KSerializer)DepartureData$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Serializable
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0087\b\u0018\u0000 82\u00020\u0001:\u0003678BE\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fB;\b\u0010\u0012\u0006\u0010\r\u001a\u00020\u0003\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0004\b\u000b\u0010\u0010J\u0006\u0010\u001f\u001a\u00020 J\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003J\t\u0010#\u001a\u00020\u0003H\u00c6\u0003J\t\u0010$\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010%\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\t\u0010&\u001a\u00020\nH\u00c6\u0003JG\u0010'\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010+\u001a\u00020\u0003H\u00d6\u0001J\t\u0010,\u001a\u00020-H\u00d6\u0001J%\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u00002\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0001\u00a2\u0006\u0002\b5R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R&\u0010\u0007\u001a\u0004\u0018\u00010\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001c\u0010\t\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001c\u0010\u0017\u001a\u0004\b\u001d\u0010\u001e\u00a8\u00069"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/autoflight/FlightPlanComputer$EnrouteWaypoint;", "", "coordinatesX", "", "coordinatesZ", "altitude", "speed", "active", "Lru/octol1ttle/flightassistant/impl/computer/autoflight/FlightPlanComputer$EnrouteWaypoint$Active;", "uuid", "Ljava/util/UUID;", "<init>", "(IIIILru/octol1ttle/flightassistant/impl/computer/autoflight/FlightPlanComputer$EnrouteWaypoint$Active;Ljava/util/UUID;)V", "seen0", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(IIIIILkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getCoordinatesX", "()I", "getCoordinatesZ", "getAltitude", "getSpeed", "getActive$annotations", "()V", "getActive", "()Lru/octol1ttle/flightassistant/impl/computer/autoflight/FlightPlanComputer$EnrouteWaypoint$Active;", "setActive", "(Lru/octol1ttle/flightassistant/impl/computer/autoflight/FlightPlanComputer$EnrouteWaypoint$Active;)V", "getUuid$annotations", "getUuid", "()Ljava/util/UUID;", "vec3", "Lnet/minecraft/world/phys/Vec3;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$flightassistant_neoforge", "Active", "$serializer", "Companion", "flightassistant-neoforge"})
    public static final class EnrouteWaypoint {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int coordinatesX;
        private final int coordinatesZ;
        private final int altitude;
        private final int speed;
        @Nullable
        private Active active;
        @NotNull
        private final UUID uuid;

        public EnrouteWaypoint(int coordinatesX, int coordinatesZ, int altitude, int speed, @Nullable Active active, @NotNull UUID uuid) {
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            this.coordinatesX = coordinatesX;
            this.coordinatesZ = coordinatesZ;
            this.altitude = altitude;
            this.speed = speed;
            this.active = active;
            this.uuid = uuid;
        }

        public /* synthetic */ EnrouteWaypoint(int n, int n2, int n3, int n4, Active active, UUID uUID, int n5, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n5 & 1) != 0) {
                n = 0;
            }
            if ((n5 & 2) != 0) {
                n2 = 0;
            }
            if ((n5 & 4) != 0) {
                n3 = 0;
            }
            if ((n5 & 8) != 0) {
                n4 = 0;
            }
            if ((n5 & 0x10) != 0) {
                active = null;
            }
            if ((n5 & 0x20) != 0) {
                UUID uUID2 = UUID.randomUUID();
                Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"randomUUID(...)");
                uUID = uUID2;
            }
            this(n, n2, n3, n4, active, uUID);
        }

        public final int getCoordinatesX() {
            return this.coordinatesX;
        }

        public final int getCoordinatesZ() {
            return this.coordinatesZ;
        }

        public final int getAltitude() {
            return this.altitude;
        }

        public final int getSpeed() {
            return this.speed;
        }

        @Nullable
        public final Active getActive() {
            return this.active;
        }

        public final void setActive(@Nullable Active active) {
            this.active = active;
        }

        @Transient
        public static /* synthetic */ void getActive$annotations() {
        }

        @NotNull
        public final UUID getUuid() {
            return this.uuid;
        }

        @Transient
        public static /* synthetic */ void getUuid$annotations() {
        }

        @NotNull
        public final Vec3 vec3() {
            return new Vec3((double)this.coordinatesX, (double)this.altitude, (double)this.coordinatesZ);
        }

        public final int component1() {
            return this.coordinatesX;
        }

        public final int component2() {
            return this.coordinatesZ;
        }

        public final int component3() {
            return this.altitude;
        }

        public final int component4() {
            return this.speed;
        }

        @Nullable
        public final Active component5() {
            return this.active;
        }

        @NotNull
        public final UUID component6() {
            return this.uuid;
        }

        @NotNull
        public final EnrouteWaypoint copy(int coordinatesX, int coordinatesZ, int altitude, int speed, @Nullable Active active, @NotNull UUID uuid) {
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            return new EnrouteWaypoint(coordinatesX, coordinatesZ, altitude, speed, active, uuid);
        }

        public static /* synthetic */ EnrouteWaypoint copy$default(EnrouteWaypoint enrouteWaypoint, int n, int n2, int n3, int n4, Active active, UUID uUID, int n5, Object object) {
            if ((n5 & 1) != 0) {
                n = enrouteWaypoint.coordinatesX;
            }
            if ((n5 & 2) != 0) {
                n2 = enrouteWaypoint.coordinatesZ;
            }
            if ((n5 & 4) != 0) {
                n3 = enrouteWaypoint.altitude;
            }
            if ((n5 & 8) != 0) {
                n4 = enrouteWaypoint.speed;
            }
            if ((n5 & 0x10) != 0) {
                active = enrouteWaypoint.active;
            }
            if ((n5 & 0x20) != 0) {
                uUID = enrouteWaypoint.uuid;
            }
            return enrouteWaypoint.copy(n, n2, n3, n4, active, uUID);
        }

        @NotNull
        public String toString() {
            return "EnrouteWaypoint(coordinatesX=" + this.coordinatesX + ", coordinatesZ=" + this.coordinatesZ + ", altitude=" + this.altitude + ", speed=" + this.speed + ", active=" + this.active + ", uuid=" + this.uuid + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.coordinatesX);
            result = result * 31 + Integer.hashCode(this.coordinatesZ);
            result = result * 31 + Integer.hashCode(this.altitude);
            result = result * 31 + Integer.hashCode(this.speed);
            result = result * 31 + (this.active == null ? 0 : this.active.hashCode());
            result = result * 31 + this.uuid.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof EnrouteWaypoint)) {
                return false;
            }
            EnrouteWaypoint enrouteWaypoint = (EnrouteWaypoint)other;
            if (this.coordinatesX != enrouteWaypoint.coordinatesX) {
                return false;
            }
            if (this.coordinatesZ != enrouteWaypoint.coordinatesZ) {
                return false;
            }
            if (this.altitude != enrouteWaypoint.altitude) {
                return false;
            }
            if (this.speed != enrouteWaypoint.speed) {
                return false;
            }
            if (this.active != enrouteWaypoint.active) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.uuid, (Object)enrouteWaypoint.uuid);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$flightassistant_neoforge(EnrouteWaypoint self, CompositeEncoder output, SerialDescriptor serialDesc) {
            if (output.shouldEncodeElementDefault(serialDesc, 0) ? true : self.coordinatesX != 0) {
                output.encodeIntElement(serialDesc, 0, self.coordinatesX);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 1) ? true : self.coordinatesZ != 0) {
                output.encodeIntElement(serialDesc, 1, self.coordinatesZ);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 2) ? true : self.altitude != 0) {
                output.encodeIntElement(serialDesc, 2, self.altitude);
            }
            if (output.shouldEncodeElementDefault(serialDesc, 3) ? true : self.speed != 0) {
                output.encodeIntElement(serialDesc, 3, self.speed);
            }
        }

        public /* synthetic */ EnrouteWaypoint(int seen0, int coordinatesX, int coordinatesZ, int altitude, int speed, SerializationConstructorMarker serializationConstructorMarker) {
            if ((0 & seen0) != 0) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)0, (SerialDescriptor)EnrouteWaypoint$$serializer.INSTANCE.getDescriptor());
            }
            this.coordinatesX = (seen0 & 1) == 0 ? 0 : coordinatesX;
            this.coordinatesZ = (seen0 & 2) == 0 ? 0 : coordinatesZ;
            this.altitude = (seen0 & 4) == 0 ? 0 : altitude;
            this.speed = (seen0 & 8) == 0 ? 0 : speed;
            this.active = null;
            UUID uUID = UUID.randomUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
            this.uuid = uUID;
        }

        public EnrouteWaypoint() {
            this(0, 0, 0, 0, null, null, 63, null);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/autoflight/FlightPlanComputer$EnrouteWaypoint$Active;", "", "<init>", "(Ljava/lang/String;I)V", "ORIGIN", "TARGET", "flightassistant-neoforge"})
        public static final class Active
        extends Enum<Active> {
            public static final /* enum */ Active ORIGIN = new Active();
            public static final /* enum */ Active TARGET = new Active();
            private static final /* synthetic */ Active[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static Active[] values() {
                return (Active[])$VALUES.clone();
            }

            public static Active valueOf(String value) {
                return Enum.valueOf(Active.class, value);
            }

            @NotNull
            public static EnumEntries<Active> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = activeArray = new Active[]{Active.ORIGIN, Active.TARGET};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/autoflight/FlightPlanComputer$EnrouteWaypoint$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lru/octol1ttle/flightassistant/impl/computer/autoflight/FlightPlanComputer$EnrouteWaypoint;", "flightassistant-neoforge"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<EnrouteWaypoint> serializer() {
                return (KSerializer)EnrouteWaypoint$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u000b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/autoflight/FlightPlanComputer$FlightPhase;", "", "<init>", "(Ljava/lang/String;I)V", "UNKNOWN", "TAKEOFF", "CLIMB", "CRUISE", "DESCEND", "APPROACH", "LANDING", "GO_AROUND", "flightassistant-neoforge"})
    public static final class FlightPhase
    extends Enum<FlightPhase> {
        public static final /* enum */ FlightPhase UNKNOWN = new FlightPhase();
        public static final /* enum */ FlightPhase TAKEOFF = new FlightPhase();
        public static final /* enum */ FlightPhase CLIMB = new FlightPhase();
        public static final /* enum */ FlightPhase CRUISE = new FlightPhase();
        public static final /* enum */ FlightPhase DESCEND = new FlightPhase();
        public static final /* enum */ FlightPhase APPROACH = new FlightPhase();
        public static final /* enum */ FlightPhase LANDING = new FlightPhase();
        public static final /* enum */ FlightPhase GO_AROUND = new FlightPhase();
        private static final /* synthetic */ FlightPhase[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static FlightPhase[] values() {
            return (FlightPhase[])$VALUES.clone();
        }

        public static FlightPhase valueOf(String value) {
            return Enum.valueOf(FlightPhase.class, value);
        }

        @NotNull
        public static EnumEntries<FlightPhase> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = flightPhaseArray = new FlightPhase[]{FlightPhase.UNKNOWN, FlightPhase.TAKEOFF, FlightPhase.CLIMB, FlightPhase.CRUISE, FlightPhase.DESCEND, FlightPhase.APPROACH, FlightPhase.LANDING, FlightPhase.GO_AROUND};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Serializable
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 ,2\u00020\u0001:\u0002+,B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nB\u0011\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\t\u0010\rB?\b\u0010\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0004\b\t\u0010\u0012J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\bH\u00c6\u0003J-\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010 \u001a\u00020\u000fH\u00d6\u0001J\t\u0010!\u001a\u00020\"H\u00d6\u0001J%\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00002\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0001\u00a2\u0006\u0002\b*R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006-"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/autoflight/FlightPlanComputer$FlightPlan;", "", "departure", "Lru/octol1ttle/flightassistant/impl/computer/autoflight/FlightPlanComputer$DepartureData;", "enroute", "", "Lru/octol1ttle/flightassistant/impl/computer/autoflight/FlightPlanComputer$EnrouteWaypoint;", "arrival", "Lru/octol1ttle/flightassistant/impl/computer/autoflight/FlightPlanComputer$ArrivalData;", "<init>", "(Lru/octol1ttle/flightassistant/impl/computer/autoflight/FlightPlanComputer$DepartureData;Ljava/util/List;Lru/octol1ttle/flightassistant/impl/computer/autoflight/FlightPlanComputer$ArrivalData;)V", "flightPlan", "Lru/octol1ttle/flightassistant/impl/computer/autoflight/FlightPlanComputer;", "(Lru/octol1ttle/flightassistant/impl/computer/autoflight/FlightPlanComputer;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILru/octol1ttle/flightassistant/impl/computer/autoflight/FlightPlanComputer$DepartureData;Ljava/util/List;Lru/octol1ttle/flightassistant/impl/computer/autoflight/FlightPlanComputer$ArrivalData;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getDeparture", "()Lru/octol1ttle/flightassistant/impl/computer/autoflight/FlightPlanComputer$DepartureData;", "getEnroute", "()Ljava/util/List;", "getArrival", "()Lru/octol1ttle/flightassistant/impl/computer/autoflight/FlightPlanComputer$ArrivalData;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$flightassistant_neoforge", "$serializer", "Companion", "flightassistant-neoforge"})
    public static final class FlightPlan {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final DepartureData departure;
        @NotNull
        private final List<EnrouteWaypoint> enroute;
        @NotNull
        private final ArrivalData arrival;
        @JvmField
        @NotNull
        private static final Lazy<KSerializer<Object>>[] $childSerializers;

        public FlightPlan(@NotNull DepartureData departure, @NotNull List<EnrouteWaypoint> enroute, @NotNull ArrivalData arrival) {
            Intrinsics.checkNotNullParameter((Object)departure, (String)"departure");
            Intrinsics.checkNotNullParameter(enroute, (String)"enroute");
            Intrinsics.checkNotNullParameter((Object)arrival, (String)"arrival");
            this.departure = departure;
            this.enroute = enroute;
            this.arrival = arrival;
        }

        @NotNull
        public final DepartureData getDeparture() {
            return this.departure;
        }

        @NotNull
        public final List<EnrouteWaypoint> getEnroute() {
            return this.enroute;
        }

        @NotNull
        public final ArrivalData getArrival() {
            return this.arrival;
        }

        public FlightPlan(@NotNull FlightPlanComputer flightPlan) {
            Intrinsics.checkNotNullParameter((Object)flightPlan, (String)"flightPlan");
            this(flightPlan.getDepartureData(), flightPlan.getEnrouteData(), flightPlan.getArrivalData());
        }

        @NotNull
        public final DepartureData component1() {
            return this.departure;
        }

        @NotNull
        public final List<EnrouteWaypoint> component2() {
            return this.enroute;
        }

        @NotNull
        public final ArrivalData component3() {
            return this.arrival;
        }

        @NotNull
        public final FlightPlan copy(@NotNull DepartureData departure, @NotNull List<EnrouteWaypoint> enroute, @NotNull ArrivalData arrival) {
            Intrinsics.checkNotNullParameter((Object)departure, (String)"departure");
            Intrinsics.checkNotNullParameter(enroute, (String)"enroute");
            Intrinsics.checkNotNullParameter((Object)arrival, (String)"arrival");
            return new FlightPlan(departure, enroute, arrival);
        }

        public static /* synthetic */ FlightPlan copy$default(FlightPlan flightPlan, DepartureData departureData, List list, ArrivalData arrivalData, int n, Object object) {
            if ((n & 1) != 0) {
                departureData = flightPlan.departure;
            }
            if ((n & 2) != 0) {
                list = flightPlan.enroute;
            }
            if ((n & 4) != 0) {
                arrivalData = flightPlan.arrival;
            }
            return flightPlan.copy(departureData, list, arrivalData);
        }

        @NotNull
        public String toString() {
            return "FlightPlan(departure=" + this.departure + ", enroute=" + this.enroute + ", arrival=" + this.arrival + ")";
        }

        public int hashCode() {
            int result = this.departure.hashCode();
            result = result * 31 + ((Object)this.enroute).hashCode();
            result = result * 31 + this.arrival.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FlightPlan)) {
                return false;
            }
            FlightPlan flightPlan = (FlightPlan)other;
            if (!Intrinsics.areEqual((Object)this.departure, (Object)flightPlan.departure)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.enroute, flightPlan.enroute)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.arrival, (Object)flightPlan.arrival);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$flightassistant_neoforge(FlightPlan self, CompositeEncoder output, SerialDescriptor serialDesc) {
            Lazy<KSerializer<Object>>[] lazyArray = $childSerializers;
            output.encodeSerializableElement(serialDesc, 0, (SerializationStrategy)DepartureData$$serializer.INSTANCE, (Object)self.departure);
            output.encodeSerializableElement(serialDesc, 1, (SerializationStrategy)lazyArray[1].getValue(), self.enroute);
            output.encodeSerializableElement(serialDesc, 2, (SerializationStrategy)ArrivalData$$serializer.INSTANCE, (Object)self.arrival);
        }

        public /* synthetic */ FlightPlan(int seen0, DepartureData departure, List enroute, ArrivalData arrival, SerializationConstructorMarker serializationConstructorMarker) {
            if (7 != (7 & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)7, (SerialDescriptor)FlightPlan$$serializer.INSTANCE.getDescriptor());
            }
            this.departure = departure;
            this.enroute = enroute;
            this.arrival = arrival;
        }

        public static final /* synthetic */ Lazy[] access$get$childSerializers$cp() {
            return $childSerializers;
        }

        static {
            Lazy[] lazyArray = new Lazy[]{null, LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> (KSerializer)new ArrayListSerializer((KSerializer)EnrouteWaypoint$$serializer.INSTANCE)), null};
            $childSerializers = lazyArray;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/autoflight/FlightPlanComputer$FlightPlan$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lru/octol1ttle/flightassistant/impl/computer/autoflight/FlightPlanComputer$FlightPlan;", "flightassistant-neoforge"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<FlightPlan> serializer() {
                return (KSerializer)FlightPlan$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FlightPhase.values().length];
            try {
                nArray[FlightPhase.TAKEOFF.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FlightPhase.LANDING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FlightPhase.GO_AROUND.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

