/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.impl.computer.autoflight.modes;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2d;
import org.joml.Vector2dc;
import ru.octol1ttle.flightassistant.api.autoflight.ControlInput;
import ru.octol1ttle.flightassistant.api.computer.ComputerBus;
import ru.octol1ttle.flightassistant.api.util.extensions.VectorExtensionsKt;
import ru.octol1ttle.flightassistant.impl.computer.autoflight.AutoFlightComputer;
import ru.octol1ttle.flightassistant.impl.computer.autoflight.modes.VerticalSpeedVerticalMode;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u0002BC\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u0012\u0006\u0010\b\u001a\u00020\u0004\u0012\u0006\u0010\t\u001a\u00020\u0004\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\t\u0010\u001b\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0004H\u00c6\u0003J\t\u0010 \u001a\u00020\u0004H\u00c6\u0003J\u000b\u0010!\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003JQ\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u00042\b\b\u0002\u0010\b\u001a\u00020\u00042\b\b\u0002\u0010\t\u001a\u00020\u00042\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bH\u00c6\u0001J\u0013\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&H\u00d6\u0003J\t\u0010'\u001a\u00020\u0004H\u00d6\u0001J\t\u0010(\u001a\u00020)H\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u0011\u0010\b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000fR\u0014\u0010\t\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000fR\u0016\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006*"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/autoflight/modes/ManagedAltitudeVerticalMode;", "Lru/octol1ttle/flightassistant/impl/computer/autoflight/AutoFlightComputer$VerticalMode;", "Lru/octol1ttle/flightassistant/impl/computer/autoflight/AutoFlightComputer$FollowsAltitudeMode;", "originX", "", "originZ", "originAltitude", "targetX", "targetZ", "targetAltitude", "textOverride", "Lnet/minecraft/network/chat/Component;", "<init>", "(IIIIIILnet/minecraft/network/chat/Component;)V", "getOriginX", "()I", "getOriginZ", "getOriginAltitude", "getTargetX", "getTargetZ", "getTargetAltitude", "getTextOverride", "()Lnet/minecraft/network/chat/Component;", "getControlInput", "Lru/octol1ttle/flightassistant/api/autoflight/ControlInput;", "computers", "Lru/octol1ttle/flightassistant/api/computer/ComputerBus;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "", "hashCode", "toString", "", "flightassistant-neoforge"})
public final class ManagedAltitudeVerticalMode
implements AutoFlightComputer.VerticalMode,
AutoFlightComputer.FollowsAltitudeMode {
    private final int originX;
    private final int originZ;
    private final int originAltitude;
    private final int targetX;
    private final int targetZ;
    private final int targetAltitude;
    @Nullable
    private final Component textOverride;

    public ManagedAltitudeVerticalMode(int originX, int originZ, int originAltitude, int targetX, int targetZ, int targetAltitude, @Nullable Component textOverride) {
        this.originX = originX;
        this.originZ = originZ;
        this.originAltitude = originAltitude;
        this.targetX = targetX;
        this.targetZ = targetZ;
        this.targetAltitude = targetAltitude;
        this.textOverride = textOverride;
    }

    public /* synthetic */ ManagedAltitudeVerticalMode(int n, int n2, int n3, int n4, int n5, int n6, Component component, int n7, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n7 & 0x40) != 0) {
            component = null;
        }
        this(n, n2, n3, n4, n5, n6, component);
    }

    public final int getOriginX() {
        return this.originX;
    }

    public final int getOriginZ() {
        return this.originZ;
    }

    public final int getOriginAltitude() {
        return this.originAltitude;
    }

    public final int getTargetX() {
        return this.targetX;
    }

    public final int getTargetZ() {
        return this.targetZ;
    }

    @Override
    public int getTargetAltitude() {
        return this.targetAltitude;
    }

    @Override
    @Nullable
    public Component getTextOverride() {
        return this.textOverride;
    }

    @Override
    @NotNull
    public ControlInput getControlInput(@NotNull ComputerBus computers) {
        Component component;
        Intrinsics.checkNotNullParameter((Object)computers, (String)"computers");
        double totalDiff = (double)this.getTargetAltitude() - computers.getData().getAltitude();
        if (Math.abs(totalDiff) <= 10.0) {
            Integer n = computers.getPlan().getCruiseAltitude();
            MutableComponent mutableComponent = n != null && this.getTargetAltitude() == n.intValue() ? Component.translatable((String)"mode.flightassistant.vertical.altitude.cruise") : Component.translatable((String)"mode.flightassistant.vertical.altitude.hold");
            Intrinsics.checkNotNull((Object)mutableComponent);
            component = (Component)mutableComponent;
        } else if (totalDiff > 0.0) {
            MutableComponent mutableComponent = Component.translatable((String)"mode.flightassistant.vertical.altitude.managed.climb");
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
            component = (Component)mutableComponent;
        } else {
            MutableComponent mutableComponent = Component.translatable((String)"mode.flightassistant.vertical.altitude.managed.descend");
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
            component = (Component)mutableComponent;
        }
        Component text = component;
        Vector2d origin = VectorExtensionsKt.vec2dFromInts(this.originX, this.originZ);
        Vector2d vector2d = VectorExtensionsKt.vec2dFromInts(this.targetX, this.targetZ).sub((Vector2dc)origin);
        Intrinsics.checkNotNullExpressionValue((Object)vector2d, (String)"sub(...)");
        Vector2d track = vector2d;
        double trackProgress = VectorExtensionsKt.getProgressOnTrack(track, origin, new Vector2d(computers.getData().getX(), computers.getData().getZ()));
        int trackDiff = this.getTargetAltitude() - this.originAltitude;
        double timeToTarget = track.length() / computers.getData().getVelocityPerSecond().horizontalDistance();
        double targetVerticalSpeed = (double)trackDiff / timeToTarget;
        double currentTarget = Mth.lerp((double)trackProgress, (double)this.originAltitude, (double)this.getTargetAltitude());
        double currentDiff = currentTarget - computers.getData().getAltitude();
        return ControlInput.copy$default(new VerticalSpeedVerticalMode(targetVerticalSpeed + currentDiff, null, 2, null).getControlInput(computers), 0.0f, text, null, 0.0f, null, 29, null);
    }

    public final int component1() {
        return this.originX;
    }

    public final int component2() {
        return this.originZ;
    }

    public final int component3() {
        return this.originAltitude;
    }

    public final int component4() {
        return this.targetX;
    }

    public final int component5() {
        return this.targetZ;
    }

    public final int component6() {
        return this.targetAltitude;
    }

    @Nullable
    public final Component component7() {
        return this.textOverride;
    }

    @NotNull
    public final ManagedAltitudeVerticalMode copy(int originX, int originZ, int originAltitude, int targetX, int targetZ, int targetAltitude, @Nullable Component textOverride) {
        return new ManagedAltitudeVerticalMode(originX, originZ, originAltitude, targetX, targetZ, targetAltitude, textOverride);
    }

    public static /* synthetic */ ManagedAltitudeVerticalMode copy$default(ManagedAltitudeVerticalMode managedAltitudeVerticalMode, int n, int n2, int n3, int n4, int n5, int n6, Component component, int n7, Object object) {
        if ((n7 & 1) != 0) {
            n = managedAltitudeVerticalMode.originX;
        }
        if ((n7 & 2) != 0) {
            n2 = managedAltitudeVerticalMode.originZ;
        }
        if ((n7 & 4) != 0) {
            n3 = managedAltitudeVerticalMode.originAltitude;
        }
        if ((n7 & 8) != 0) {
            n4 = managedAltitudeVerticalMode.targetX;
        }
        if ((n7 & 0x10) != 0) {
            n5 = managedAltitudeVerticalMode.targetZ;
        }
        if ((n7 & 0x20) != 0) {
            n6 = managedAltitudeVerticalMode.targetAltitude;
        }
        if ((n7 & 0x40) != 0) {
            component = managedAltitudeVerticalMode.textOverride;
        }
        return managedAltitudeVerticalMode.copy(n, n2, n3, n4, n5, n6, component);
    }

    @NotNull
    public String toString() {
        return "ManagedAltitudeVerticalMode(originX=" + this.originX + ", originZ=" + this.originZ + ", originAltitude=" + this.originAltitude + ", targetX=" + this.targetX + ", targetZ=" + this.targetZ + ", targetAltitude=" + this.targetAltitude + ", textOverride=" + this.textOverride + ")";
    }

    public int hashCode() {
        int result = Integer.hashCode(this.originX);
        result = result * 31 + Integer.hashCode(this.originZ);
        result = result * 31 + Integer.hashCode(this.originAltitude);
        result = result * 31 + Integer.hashCode(this.targetX);
        result = result * 31 + Integer.hashCode(this.targetZ);
        result = result * 31 + Integer.hashCode(this.targetAltitude);
        result = result * 31 + (this.textOverride == null ? 0 : this.textOverride.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ManagedAltitudeVerticalMode)) {
            return false;
        }
        ManagedAltitudeVerticalMode managedAltitudeVerticalMode = (ManagedAltitudeVerticalMode)other;
        if (this.originX != managedAltitudeVerticalMode.originX) {
            return false;
        }
        if (this.originZ != managedAltitudeVerticalMode.originZ) {
            return false;
        }
        if (this.originAltitude != managedAltitudeVerticalMode.originAltitude) {
            return false;
        }
        if (this.targetX != managedAltitudeVerticalMode.targetX) {
            return false;
        }
        if (this.targetZ != managedAltitudeVerticalMode.targetZ) {
            return false;
        }
        if (this.targetAltitude != managedAltitudeVerticalMode.targetAltitude) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.textOverride, (Object)managedAltitudeVerticalMode.textOverride);
    }
}

