/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.impl.computer.data;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.RangesKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import ru.octol1ttle.flightassistant.FAKeyMappings;
import ru.octol1ttle.flightassistant.FlightAssistant;
import ru.octol1ttle.flightassistant.api.computer.Computer;
import ru.octol1ttle.flightassistant.api.computer.ComputerBus;
import ru.octol1ttle.flightassistant.api.util.MathHelperKt;
import ru.octol1ttle.flightassistant.api.util.extensions.ClientPlayerExtensionsKt;
import ru.octol1ttle.flightassistant.api.util.extensions.LevelExtensionsKt;
import ru.octol1ttle.flightassistant.api.util.extensions.VectorExtensionsKt;
import ru.octol1ttle.flightassistant.config.FAConfig;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0012\n\u0002\u0010\u0007\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 I2\u00020\u0001:\u0001IB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010?\u001a\u00020@H\u0016J\u0010\u0010A\u001a\u00020\r2\b\b\u0002\u0010B\u001a\u00020\rJ\u000e\u0010C\u001a\u00020\r2\u0006\u0010D\u001a\u00020EJ\u000e\u0010F\u001a\u00020\u00152\u0006\u0010G\u001a\u00020\u0015J\b\u0010H\u001a\u00020@H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001bR\u0011\u0010\u001e\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001bR\u0011\u0010 \u001a\u00020!8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u001bR\u0011\u0010&\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u000fR\u0011\u0010(\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u0017R\u0011\u0010*\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u0017R\u001e\u0010-\u001a\u00020\u00152\u0006\u0010,\u001a\u00020\u0015@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\u0017R\u001e\u0010/\u001a\u00020\u00152\u0006\u0010,\u001a\u00020\u0015@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010\u0017R\u001e\u00101\u001a\u00020\u00192\u0006\u0010,\u001a\u00020\u0019@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010\u001bR\u0011\u00103\u001a\u0002048F\u00a2\u0006\u0006\u001a\u0004\b5\u00106R\u0011\u00107\u001a\u0002048F\u00a2\u0006\u0006\u001a\u0004\b8\u00106R\u0011\u00109\u001a\u0002048F\u00a2\u0006\u0006\u001a\u0004\b:\u00106R\u0011\u0010;\u001a\u0002048F\u00a2\u0006\u0006\u001a\u0004\b<\u00106R\u0011\u0010=\u001a\u0002048F\u00a2\u0006\u0006\u001a\u0004\b>\u00106\u00a8\u0006J"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/data/AirDataComputer;", "Lru/octol1ttle/flightassistant/api/computer/Computer;", "computers", "Lru/octol1ttle/flightassistant/api/computer/ComputerBus;", "mc", "Lnet/minecraft/client/Minecraft;", "<init>", "(Lru/octol1ttle/flightassistant/api/computer/ComputerBus;Lnet/minecraft/client/Minecraft;)V", "player", "Lnet/minecraft/client/player/LocalPlayer;", "getPlayer", "()Lnet/minecraft/client/player/LocalPlayer;", "flying", "", "getFlying", "()Z", "level", "Lnet/minecraft/client/multiplayer/ClientLevel;", "getLevel", "()Lnet/minecraft/client/multiplayer/ClientLevel;", "position", "Lnet/minecraft/world/phys/Vec3;", "getPosition", "()Lnet/minecraft/world/phys/Vec3;", "x", "", "getX", "()D", "z", "getZ", "altitude", "getAltitude", "voidY", "", "getVoidY", "()I", "fallDistance", "getFallDistance", "fallDistanceSafe", "getFallDistanceSafe", "velocity", "getVelocity", "velocityPerSecond", "getVelocityPerSecond", "value", "forwardVelocity", "getForwardVelocity", "forwardVelocityPerSecond", "getForwardVelocityPerSecond", "forwardAcceleration", "getForwardAcceleration", "pitch", "", "getPitch", "()F", "yaw", "getYaw", "heading", "getHeading", "flightPitch", "getFlightPitch", "flightYaw", "getFlightYaw", "tick", "", "automationsAllowed", "checkFlying", "isInvulnerableTo", "source", "Lnet/minecraft/world/damagesource/DamageSource;", "computeForwardVector", "vector", "reset", "Companion", "flightassistant-neoforge"})
public final class AirDataComputer
extends Computer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Minecraft mc;
    @NotNull
    private Vec3 forwardVelocity;
    @NotNull
    private Vec3 forwardVelocityPerSecond;
    private double forwardAcceleration;
    @NotNull
    private static final ResourceLocation ID = FlightAssistant.INSTANCE.id$flightassistant_neoforge("air_data");

    public AirDataComputer(@NotNull ComputerBus computers, @NotNull Minecraft mc) {
        Intrinsics.checkNotNullParameter((Object)computers, (String)"computers");
        Intrinsics.checkNotNullParameter((Object)mc, (String)"mc");
        super(computers);
        this.mc = mc;
        Vec3 vec3 = Vec3.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"ZERO");
        this.forwardVelocity = vec3;
        Vec3 vec32 = Vec3.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"ZERO");
        this.forwardVelocityPerSecond = vec32;
    }

    @NotNull
    public final LocalPlayer getPlayer() {
        LocalPlayer localPlayer = this.mc.player;
        if (localPlayer == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        return localPlayer;
    }

    public final boolean getFlying() {
        return this.getPlayer().isFallFlying();
    }

    @NotNull
    public final ClientLevel getLevel() {
        ClientLevel clientLevel = this.mc.level;
        if (clientLevel == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        return clientLevel;
    }

    @NotNull
    public final Vec3 getPosition() {
        Vec3 vec3 = this.getPlayer().position();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
        return vec3;
    }

    public final double getX() {
        return this.getPosition().x;
    }

    public final double getZ() {
        return this.getPosition().z;
    }

    public final double getAltitude() {
        return this.getPosition().y;
    }

    public final int getVoidY() {
        return LevelExtensionsKt.getBottomY((Level)this.getLevel()) - 64;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final double getFallDistance() {
        if (this.getComputers().getGpws().getGroundY() == null) return Double.MAX_VALUE;
        Double d = this.getComputers().getGpws().getGroundY();
        Intrinsics.checkNotNull((Object)d);
        if (d == Double.MAX_VALUE) {
            return Double.MAX_VALUE;
        }
        boolean bl = false;
        if (bl) {
            return Double.MAX_VALUE;
        }
        double d2 = this.getPlayer().fallDistance;
        double d3 = this.getAltitude();
        Double d4 = this.getComputers().getGpws().getGroundY();
        Intrinsics.checkNotNull((Object)d4);
        double d5 = Math.max(d2, d3 - d4);
        return d5;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean getFallDistanceSafe() {
        if (this.getPlayer().isInWater()) return true;
        if (this.getFallDistance() <= (double)this.getPlayer().getMaxFallDistance()) return true;
        DamageSource damageSource = this.getPlayer().damageSources().fall();
        Intrinsics.checkNotNullExpressionValue((Object)damageSource, (String)"fall(...)");
        if (!this.isInvulnerableTo(damageSource)) return false;
        return true;
    }

    @NotNull
    public final Vec3 getVelocity() {
        Vec3 vec3 = this.getPlayer().getDeltaMovement();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getDeltaMovement(...)");
        return vec3;
    }

    @NotNull
    public final Vec3 getVelocityPerSecond() {
        return VectorExtensionsKt.perSecond(this.getVelocity());
    }

    @NotNull
    public final Vec3 getForwardVelocity() {
        return this.forwardVelocity;
    }

    @NotNull
    public final Vec3 getForwardVelocityPerSecond() {
        return this.forwardVelocityPerSecond;
    }

    public final double getForwardAcceleration() {
        return this.forwardAcceleration;
    }

    public final float getPitch() {
        return -MathHelperKt.throwIfNotInRange(this.getPlayer().getXRot(), (ClosedFloatingPointRange<Float>)RangesKt.rangeTo((float)-90.0f, (float)90.0f));
    }

    public final float getYaw() {
        return MathHelperKt.throwIfNotInRange(Mth.wrapDegrees((float)this.getPlayer().getYRot()), (ClosedFloatingPointRange<Float>)RangesKt.rangeTo((float)-180.0f, (float)180.0f));
    }

    public final float getHeading() {
        return MathHelperKt.throwIfNotInRange(this.getYaw() + 180.0f, (ClosedFloatingPointRange<Float>)RangesKt.rangeTo((float)0.0f, (float)360.0f));
    }

    public final float getFlightPitch() {
        return MathHelperKt.degrees((float)Math.asin(this.getVelocity().normalize().y));
    }

    public final float getFlightYaw() {
        return MathHelperKt.degrees((float)Math.atan2(-this.getVelocity().x, this.getVelocity().z));
    }

    @Override
    public void tick() {
        this.forwardVelocity = this.computeForwardVector(this.getVelocity());
        this.forwardVelocityPerSecond = VectorExtensionsKt.perSecond(this.forwardVelocity);
        this.forwardAcceleration = this.forwardVelocity.length() - this.computeForwardVector(ClientPlayerExtensionsKt.getLerpedDeltaMovement((AbstractClientPlayer)this.getPlayer(), 0.0f)).length();
    }

    public final boolean automationsAllowed(boolean checkFlying) {
        if (FAKeyMappings.INSTANCE.getGlobalAutomationOverride().isDown()) {
            return false;
        }
        return (!checkFlying || this.getFlying()) && (FAConfig.INSTANCE.getGlobal$flightassistant_neoforge().getAutomationsAllowedInOverlays$flightassistant_neoforge() || this.mc.screen == null && this.mc.getOverlay() == null);
    }

    public static /* synthetic */ boolean automationsAllowed$default(AirDataComputer airDataComputer, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return airDataComputer.automationsAllowed(bl);
    }

    public final boolean isInvulnerableTo(@NotNull DamageSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (!FAConfig.INSTANCE.getSafety().getConsiderInvulnerability()) {
            return false;
        }
        return this.getPlayer().isInvulnerableTo(source) || this.getPlayer().getAbilities().invulnerable && !source.is(DamageTypeTags.BYPASSES_INVULNERABILITY) || this.getPlayer().getAbilities().mayfly && source.is(DamageTypeTags.IS_FALL);
    }

    @NotNull
    public final Vec3 computeForwardVector(@NotNull Vec3 vector) {
        Intrinsics.checkNotNullParameter((Object)vector, (String)"vector");
        Vec3 vec3 = this.getPlayer().getLookAngle().normalize();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"normalize(...)");
        Vec3 normalizedLookAngle = vec3;
        Vec3 vec32 = vector.normalize();
        Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"normalize(...)");
        Vec3 normalizedVector = vec32;
        Vec3 vec33 = vector.scale(RangesKt.coerceAtLeast((double)normalizedLookAngle.dot(normalizedVector), (double)0.0));
        Intrinsics.checkNotNullExpressionValue((Object)vec33, (String)"scale(...)");
        return vec33;
    }

    @Override
    public void reset() {
        Vec3 vec3 = Vec3.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"ZERO");
        this.forwardVelocity = vec3;
        Vec3 vec32 = Vec3.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"ZERO");
        this.forwardVelocityPerSecond = vec32;
        this.forwardAcceleration = 0.0;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/data/AirDataComputer$Companion;", "", "<init>", "()V", "ID", "Lnet/minecraft/resources/ResourceLocation;", "getID", "()Lnet/minecraft/resources/ResourceLocation;", "flightassistant-neoforge"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceLocation getID() {
            return ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

