/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.impl.computer.safety;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.RangesKt;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.octol1ttle.flightassistant.FlightAssistant;
import ru.octol1ttle.flightassistant.api.autoflight.ControlInput;
import ru.octol1ttle.flightassistant.api.autoflight.FlightController;
import ru.octol1ttle.flightassistant.api.autoflight.pitch.PitchControllerRegistrationCallback;
import ru.octol1ttle.flightassistant.api.autoflight.thrust.ThrustControllerRegistrationCallback;
import ru.octol1ttle.flightassistant.api.computer.Computer;
import ru.octol1ttle.flightassistant.api.computer.ComputerBus;
import ru.octol1ttle.flightassistant.api.computer.ComputerQuery;
import ru.octol1ttle.flightassistant.api.util.MathHelperKt;
import ru.octol1ttle.flightassistant.api.util.extensions.LevelExtensionsKt;
import ru.octol1ttle.flightassistant.config.FAConfig;
import ru.octol1ttle.flightassistant.impl.computer.autoflight.base.PitchComputer;
import ru.octol1ttle.flightassistant.impl.computer.data.AirDataComputer;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 F2\u00020\u00012\u00020\u0002:\u0002EFB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020#H\u0016J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J\u000f\u0010)\u001a\u0004\u0018\u00010\bH\u0002\u00a2\u0006\u0002\u0010\u001cJ\b\u0010*\u001a\u00020+H\u0002J\b\u0010,\u001a\u00020\bH\u0002JH\u0010-\u001a\u00020\n2\u0006\u0010.\u001a\u00020\n2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020+002\f\u00101\u001a\b\u0012\u0004\u0012\u00020+002\f\u00102\u001a\b\u0012\u0004\u0012\u00020+002\f\u00103\u001a\b\u0012\u0004\u0012\u00020+00H\u0002J\b\u00104\u001a\u00020\bH\u0002J\u0016\u00105\u001a\u00020\b2\u0006\u00106\u001a\u00020(2\u0006\u00107\u001a\u00020\bJ\u001c\u00108\u001a\u00020#\"\u0004\b\u0000\u001092\f\u0010:\u001a\b\u0012\u0004\u0012\u0002H90;H\u0016J\"\u0010<\u001a\u0004\u0018\u00010=2\u0006\u0010>\u001a\u00020\n2\u0006\u0010?\u001a\u00020+2\u0006\u0010@\u001a\u00020+H\u0002J\n\u0010A\u001a\u0004\u0018\u00010BH\u0016J\n\u0010C\u001a\u0004\u0018\u00010BH\u0016J\b\u0010D\u001a\u00020#H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0011\u0010\u0011\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013R\u0011\u0010\u0016\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0013R\u0011\u0010\u0018\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0013R\u001e\u0010\u001a\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001f\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0011\u0010 \u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0013\u00a8\u0006G"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/safety/GroundProximityComputer;", "Lru/octol1ttle/flightassistant/api/computer/Computer;", "Lru/octol1ttle/flightassistant/api/autoflight/FlightController;", "computers", "Lru/octol1ttle/flightassistant/api/computer/ComputerBus;", "<init>", "(Lru/octol1ttle/flightassistant/api/computer/ComputerBus;)V", "groundImpactTime", "", "value", "Lru/octol1ttle/flightassistant/impl/computer/safety/GroundProximityComputer$Status;", "groundImpactStatus", "getGroundImpactStatus", "()Lru/octol1ttle/flightassistant/impl/computer/safety/GroundProximityComputer$Status;", "obstacleImpactTime", "obstacleImpactStatus", "getObstacleImpactStatus", "safeThreshold", "getSafeThreshold", "()D", "cautionThreshold", "getCautionThreshold", "warningThreshold", "getWarningThreshold", "recoverThreshold", "getRecoverThreshold", "groundY", "getGroundY", "()Ljava/lang/Double;", "setGroundY", "(Ljava/lang/Double;)V", "Ljava/lang/Double;", "groundOrVoidY", "getGroundOrVoidY", "subscribeToEvents", "", "tick", "raycast", "Lnet/minecraft/world/phys/BlockHitResult;", "offset", "Lnet/minecraft/world/phys/Vec3;", "computeGroundY", "computeIsRecoveryUnsafe", "", "computeThresholdMultiplier", "computeStatus", "current", "safe", "Lkotlin/Function0;", "caution", "warning", "recover", "computeGroundImpactTime", "computeObstacleImpactTime", "velocity", "lookAheadTime", "handleQuery", "Response", "query", "Lru/octol1ttle/flightassistant/api/computer/ComputerQuery;", "getControlInputStatus", "Lru/octol1ttle/flightassistant/api/autoflight/ControlInput$Status;", "status", "config", "forThrust", "getThrustInput", "Lru/octol1ttle/flightassistant/api/autoflight/ControlInput;", "getPitchInput", "reset", "Status", "Companion", "flightassistant-neoforge"})
public final class GroundProximityComputer
extends Computer
implements FlightController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private double groundImpactTime;
    @NotNull
    private Status groundImpactStatus;
    private double obstacleImpactTime;
    @NotNull
    private Status obstacleImpactStatus;
    @Nullable
    private Double groundY;
    @NotNull
    private static final ResourceLocation ID = FlightAssistant.INSTANCE.id$flightassistant_neoforge("ground_proximity");

    public GroundProximityComputer(@NotNull ComputerBus computers) {
        Intrinsics.checkNotNullParameter((Object)computers, (String)"computers");
        super(computers);
        this.groundImpactTime = Double.MAX_VALUE;
        this.groundImpactStatus = Status.SAFE;
        this.obstacleImpactTime = Double.MAX_VALUE;
        this.obstacleImpactStatus = Status.SAFE;
    }

    @NotNull
    public final Status getGroundImpactStatus() {
        return this.groundImpactStatus;
    }

    @NotNull
    public final Status getObstacleImpactStatus() {
        return this.obstacleImpactStatus;
    }

    public final double getSafeThreshold() {
        return 10.0;
    }

    public final double getCautionThreshold() {
        return 7.5;
    }

    public final double getWarningThreshold() {
        return 3.0;
    }

    public final double getRecoverThreshold() {
        return 0.75;
    }

    @Nullable
    public final Double getGroundY() {
        return this.groundY;
    }

    public final void setGroundY(@Nullable Double d) {
        this.groundY = d;
    }

    public final double getGroundOrVoidY() {
        double d;
        if (this.groundY == null || Intrinsics.areEqual((Double)this.groundY, (double)Double.MAX_VALUE)) {
            d = this.getComputers().getData().getVoidY();
        } else {
            Double d2 = this.groundY;
            Intrinsics.checkNotNull((Object)d2);
            d = d2;
        }
        return d;
    }

    @Override
    public void subscribeToEvents() {
        ThrustControllerRegistrationCallback.EVENT.register(arg_0 -> GroundProximityComputer.subscribeToEvents$lambda$0(this, arg_0));
        PitchControllerRegistrationCallback.EVENT.register(arg_0 -> GroundProximityComputer.subscribeToEvents$lambda$1(this, arg_0));
    }

    @Override
    public void tick() {
        if (this.getComputers().getChunk().isCurrentLoaded()) {
            Double d = this.computeGroundY();
            Double d2 = this.groundY = d != null ? Double.valueOf(MathHelperKt.throwIfNotInRange(d, (ClosedRange<Double>)((ClosedRange)RangesKt.rangeTo((double)LevelExtensionsKt.getBottomY((Level)this.getComputers().getData().getLevel()), (double)Double.MAX_VALUE)))) : null;
        }
        if (!this.getComputers().getData().getFlying() || this.getComputers().getData().getPlayer().isInWater()) {
            this.groundImpactStatus = Status.SAFE;
            this.obstacleImpactStatus = Status.SAFE;
            return;
        }
        boolean isRecoveryUnsafe = this.computeIsRecoveryUnsafe();
        this.groundImpactTime = MathHelperKt.throwIfNotInRange(this.computeGroundImpactTime(), (ClosedRange<Double>)((ClosedRange)RangesKt.rangeTo((double)0.0, (double)Double.MAX_VALUE)));
        this.groundImpactStatus = this.computeStatus(this.groundImpactStatus, (Function0<Boolean>)((Function0)() -> GroundProximityComputer.tick$lambda$2(this)), (Function0<Boolean>)((Function0)() -> GroundProximityComputer.tick$lambda$3(this)), (Function0<Boolean>)((Function0)() -> GroundProximityComputer.tick$lambda$4(this)), (Function0<Boolean>)((Function0)() -> GroundProximityComputer.tick$lambda$5(this)));
        double thresholdMultiplier = this.computeThresholdMultiplier();
        double safe = Math.max(this.getRecoverThreshold(), this.getSafeThreshold() * thresholdMultiplier);
        double caution = Math.max(this.getRecoverThreshold(), this.getCautionThreshold() * thresholdMultiplier);
        double warning = Math.max(this.getRecoverThreshold(), this.getWarningThreshold() * thresholdMultiplier);
        this.obstacleImpactTime = MathHelperKt.throwIfNotInRange(this.computeObstacleImpactTime(this.getComputers().getData().getVelocityPerSecond(), safe), (ClosedRange<Double>)((ClosedRange)RangesKt.rangeTo((double)0.0, (double)Double.MAX_VALUE)));
        double damageOnCollision = this.getComputers().getData().getVelocity().horizontalDistance() * (double)10 - (double)3;
        AirDataComputer airDataComputer = this.getComputers().getData();
        DamageSource damageSource = this.getComputers().getData().getPlayer().damageSources().flyIntoWall();
        Intrinsics.checkNotNullExpressionValue((Object)damageSource, (String)"flyIntoWall(...)");
        boolean invulnerable = airDataComputer.isInvulnerableTo(damageSource);
        this.obstacleImpactStatus = this.computeStatus(this.obstacleImpactStatus, (Function0<Boolean>)((Function0)() -> GroundProximityComputer.tick$lambda$6(invulnerable, damageOnCollision, this, thresholdMultiplier)), (Function0<Boolean>)((Function0)() -> GroundProximityComputer.tick$lambda$7(this, damageOnCollision, caution)), (Function0<Boolean>)((Function0)() -> GroundProximityComputer.tick$lambda$8(isRecoveryUnsafe, this, warning)), (Function0<Boolean>)((Function0)() -> GroundProximityComputer.tick$lambda$9(this)));
    }

    private final BlockHitResult raycast(Vec3 offset) {
        BlockHitResult blockHitResult = this.getComputers().getData().getLevel().clip(new ClipContext(this.getComputers().getData().getPosition(), this.getComputers().getData().getPosition().add(offset), ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)this.getComputers().getData().getPlayer()));
        Intrinsics.checkNotNullExpressionValue((Object)blockHitResult, (String)"clip(...)");
        return blockHitResult;
    }

    private final Double computeGroundY() {
        if (!this.getComputers().getChunk().isCurrentLoaded()) {
            return this.groundY;
        }
        AABB playerBoundingBox = this.getComputers().getData().getPlayer().getBoundingBox();
        double minY = RangesKt.coerceAtLeast((double)LevelExtensionsKt.getBottomY((Level)this.getComputers().getData().getLevel()), (double)(this.getComputers().getData().getAltitude() - 2500.0));
        Vec3 diffFromMinY = new Vec3(0.0, minY - playerBoundingBox.minY, 0.0);
        Vec3 collisionResult = Entity.collideBoundingBox((Entity)((Entity)this.getComputers().getData().getPlayer()), (Vec3)diffFromMinY, (AABB)playerBoundingBox, (Level)((Level)this.getComputers().getData().getLevel()), (List)CollectionsKt.emptyList());
        double groundY = collisionResult.y + playerBoundingBox.minY;
        if (collisionResult.y + playerBoundingBox.maxY == minY || Intrinsics.areEqual((Object)collisionResult, (Object)diffFromMinY)) {
            return groundY > (double)LevelExtensionsKt.getBottomY((Level)this.getComputers().getData().getLevel()) ? Double.valueOf(Double.MAX_VALUE) : null;
        }
        BlockHitResult raycast = this.raycast(new Vec3(0.0, minY - this.getComputers().getData().getPosition().y, 0.0));
        if (raycast.getType() == HitResult.Type.BLOCK) {
            return Math.max(raycast.getLocation().y, groundY);
        }
        return groundY;
    }

    private final boolean computeIsRecoveryUnsafe() {
        int pitch = Math.max(0, (int)this.getComputers().getData().getPitch());
        int interval = 15;
        int n = -interval;
        int i = 90;
        int n2 = ProgressionUtilKt.getProgressionLastElement((int)90, (int)pitch, (int)n);
        if (n2 <= i) {
            while (true) {
                Vec3 offset = Vec3.directionFromRotation((float)(-((float)i)), (float)this.getComputers().getData().getYaw());
                Vec3 vec3 = offset.scale(this.getComputers().getData().getVelocityPerSecond().length() * this.getRecoverThreshold());
                Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"scale(...)");
                BlockHitResult result = this.raycast(vec3);
                if (result.getType() != HitResult.Type.BLOCK) {
                    return false;
                }
                if (i == n2) break;
                i += n;
            }
        }
        return true;
    }

    private final double computeThresholdMultiplier() {
        double maxRaycastDistance = this.getComputers().getData().getVelocityPerSecond().length() * this.getCautionThreshold();
        Object[] objectArray = new Double[]{-1.0, 0.0, 1.0};
        List xzOffsets = CollectionsKt.listOf((Object[])objectArray);
        Object[] objectArray2 = new Double[]{-1.0, 0.0, 1.0};
        List yOffsets = CollectionsKt.listOf((Object[])objectArray2);
        ArrayList<Double> distances = new ArrayList<Double>();
        Iterator iterator = xzOffsets.iterator();
        while (iterator.hasNext()) {
            double x = ((Number)iterator.next()).doubleValue();
            Iterator iterator2 = yOffsets.iterator();
            while (iterator2.hasNext()) {
                double y = ((Number)iterator2.next()).doubleValue();
                Iterator iterator3 = xzOffsets.iterator();
                while (iterator3.hasNext()) {
                    double z = ((Number)iterator3.next()).doubleValue();
                    Vec3 offset = new Vec3(x, y, z).normalize().scale(maxRaycastDistance);
                    if (offset.lengthSqr() == 0.0) continue;
                    Intrinsics.checkNotNull((Object)offset);
                    BlockHitResult result = this.raycast(offset);
                    boolean bl = result.getType() == HitResult.Type.BLOCK ? distances.add(this.getComputers().getData().getPosition().distanceTo(result.getLocation())) : distances.add(maxRaycastDistance);
                }
            }
        }
        return CollectionsKt.averageOfDouble((Iterable)distances) / maxRaycastDistance;
    }

    private final Status computeStatus(Status current, Function0<Boolean> safe, Function0<Boolean> caution, Function0<Boolean> warning, Function0<Boolean> recover) {
        if (((Boolean)safe.invoke()).booleanValue()) {
            return Status.SAFE;
        }
        Status status = current;
        while (true) {
            Status next = switch (WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
                case 1 -> {
                    if (((Boolean)caution.invoke()).booleanValue()) {
                        yield Status.CAUTION;
                    }
                    yield null;
                }
                case 2 -> {
                    if (((Boolean)caution.invoke()).booleanValue() && ((Boolean)warning.invoke()).booleanValue()) {
                        yield Status.WARNING;
                    }
                    yield null;
                }
                case 3 -> {
                    if (((Boolean)caution.invoke()).booleanValue() && ((Boolean)warning.invoke()).booleanValue() && ((Boolean)recover.invoke()).booleanValue()) {
                        yield Status.RECOVER;
                    }
                    yield null;
                }
                case 4 -> null;
                default -> throw new NoWhenBranchMatchedException();
            };
            if (next == null) break;
            status = next;
        }
        return status;
    }

    private final double computeGroundImpactTime() {
        if (this.getComputers().getData().getVelocity().y >= 0.0) {
            return Double.MAX_VALUE;
        }
        return Math.max(0.0, this.getComputers().getData().getAltitude() - this.getGroundOrVoidY()) / -this.getComputers().getData().getVelocityPerSecond().y;
    }

    public final double computeObstacleImpactTime(@NotNull Vec3 velocity, double lookAheadTime) {
        Intrinsics.checkNotNullParameter((Object)velocity, (String)"velocity");
        Vec3 vec3 = velocity.scale(lookAheadTime);
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"scale(...)");
        BlockHitResult result = this.raycast(vec3);
        if (result.getType() != HitResult.Type.BLOCK) {
            return Double.MAX_VALUE;
        }
        return this.getComputers().getData().getPosition().distanceTo(result.getLocation()) / velocity.length();
    }

    @Override
    public <Response> void handleQuery(@NotNull ComputerQuery<Response> query) {
        Intrinsics.checkNotNullParameter(query, (String)"query");
        if (query instanceof PitchComputer.MinimumPitchQuery && (this.groundImpactStatus.compareTo((Enum)Status.WARNING) <= 0 && FAConfig.INSTANCE.getSafety().getSinkRateLimitPitch() || this.obstacleImpactStatus.compareTo((Enum)Status.WARNING) <= 0 && FAConfig.INSTANCE.getSafety().getObstacleLimitPitch())) {
            ((PitchComputer.MinimumPitchQuery)query).respond(new ControlInput(RangesKt.coerceAtMost((float)this.getComputers().getData().getPitch(), (float)15.0f), (Component)Component.translatable((String)"mode.flightassistant.vertical.terrain_protection"), ControlInput.Priority.HIGH, 0.0f, null, 24, null));
        }
    }

    private final ControlInput.Status getControlInputStatus(Status status, boolean config, boolean forThrust) {
        Status activeThreshold;
        if (!config) {
            return ControlInput.Status.DISABLED;
        }
        Status armThreshold = forThrust ? Status.CAUTION : Status.WARNING;
        Status status2 = activeThreshold = forThrust ? Status.WARNING : Status.RECOVER;
        return status.compareTo((Enum)activeThreshold) <= 0 ? ControlInput.Status.ACTIVE : (status.compareTo((Enum)armThreshold) <= 0 ? ControlInput.Status.ARMED : null);
    }

    @Override
    @Nullable
    public ControlInput getThrustInput() {
        if (this.getComputers().getData().getPitch() > 15.0f) {
            return null;
        }
        ControlInput.Status sinkRateInputStatus = this.getControlInputStatus(this.groundImpactStatus, FAConfig.INSTANCE.getSafety().getSinkRateAutoThrust(), true);
        ControlInput.Status terrainInputStatus = this.getControlInputStatus(this.obstacleImpactStatus, FAConfig.INSTANCE.getSafety().getObstacleAutoThrust(), true);
        if (sinkRateInputStatus != null || terrainInputStatus != null) {
            return new ControlInput(0.0f, (Component)Component.translatable((String)"mode.flightassistant.thrust.idle"), ControlInput.Priority.HIGH, 0.0f, ControlInput.Status.Companion.highest(sinkRateInputStatus, terrainInputStatus), 8, null);
        }
        return null;
    }

    @Override
    @Nullable
    public ControlInput getPitchInput() {
        ControlInput.Status sinkRateInputStatus = this.getControlInputStatus(this.groundImpactStatus, FAConfig.INSTANCE.getSafety().getSinkRateAutoPitch(), false);
        ControlInput.Status terrainInputStatus = this.getControlInputStatus(this.obstacleImpactStatus, FAConfig.INSTANCE.getSafety().getObstacleAutoPitch(), false);
        if (sinkRateInputStatus != null || terrainInputStatus != null) {
            double d = 1.0;
            Double d2 = MathHelperKt.inverseMin(this.groundImpactTime, this.obstacleImpactTime);
            if (d2 == null) {
                return null;
            }
            double d3 = d2;
            double deltaTimeMultiplier = Math.max(d, d3);
            return new ControlInput(90.0f, (Component)Component.translatable((String)"mode.flightassistant.vertical.terrain_escape"), ControlInput.Priority.HIGH, (float)deltaTimeMultiplier, ControlInput.Status.Companion.highest(sinkRateInputStatus, terrainInputStatus));
        }
        return null;
    }

    @Override
    public void reset() {
        this.groundImpactTime = Double.MAX_VALUE;
        this.groundImpactStatus = Status.SAFE;
        this.obstacleImpactTime = Double.MAX_VALUE;
        this.obstacleImpactStatus = Status.SAFE;
        this.groundY = Double.MAX_VALUE;
    }

    @Override
    @Nullable
    public ControlInput getHeadingInput() {
        return FlightController.super.getHeadingInput();
    }

    @Override
    @Nullable
    public ControlInput getRollInput() {
        return FlightController.super.getRollInput();
    }

    private static final void subscribeToEvents$lambda$0(GroundProximityComputer this$0, Consumer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.accept(this$0);
    }

    private static final void subscribeToEvents$lambda$1(GroundProximityComputer this$0, Consumer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.accept(this$0);
    }

    private static final boolean tick$lambda$2(GroundProximityComputer this$0) {
        return this$0.getComputers().getData().getFallDistanceSafe() || this$0.getComputers().getData().getVelocityPerSecond().y > -8.5 || this$0.groundImpactTime >= this$0.getSafeThreshold();
    }

    private static final boolean tick$lambda$3(GroundProximityComputer this$0) {
        return this$0.getComputers().getData().getVelocityPerSecond().y <= -10.0 && this$0.groundImpactTime <= this$0.getCautionThreshold();
    }

    private static final boolean tick$lambda$4(GroundProximityComputer this$0) {
        return this$0.groundImpactTime <= this$0.getWarningThreshold();
    }

    private static final boolean tick$lambda$5(GroundProximityComputer this$0) {
        return this$0.groundImpactTime <= this$0.getRecoverThreshold();
    }

    private static final boolean tick$lambda$6(boolean $invulnerable, double $damageOnCollision, GroundProximityComputer this$0, double $thresholdMultiplier) {
        return $invulnerable || $damageOnCollision < (double)(this$0.getComputers().getData().getPlayer().getHealth() * 0.25f) || this$0.obstacleImpactTime * (double)1.2f > this$0.groundImpactTime || this$0.obstacleImpactTime >= this$0.getSafeThreshold() * $thresholdMultiplier;
    }

    private static final boolean tick$lambda$7(GroundProximityComputer this$0, double $damageOnCollision, double $caution) {
        return Math.abs(this$0.getComputers().getData().getYaw() - this$0.getComputers().getData().getFlightYaw()) < 10.0f && $damageOnCollision >= (double)(this$0.getComputers().getData().getPlayer().getHealth() * 0.5f) && this$0.obstacleImpactTime * (double)1.1f < this$0.groundImpactTime && this$0.obstacleImpactTime <= $caution;
    }

    private static final boolean tick$lambda$8(boolean $isRecoveryUnsafe, GroundProximityComputer this$0, double $warning) {
        return !$isRecoveryUnsafe && this$0.obstacleImpactTime <= $warning;
    }

    private static final boolean tick$lambda$9(GroundProximityComputer this$0) {
        return this$0.obstacleImpactTime <= this$0.getRecoverThreshold();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/safety/GroundProximityComputer$Companion;", "", "<init>", "()V", "ID", "Lnet/minecraft/resources/ResourceLocation;", "getID", "()Lnet/minecraft/resources/ResourceLocation;", "flightassistant-neoforge"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceLocation getID() {
            return ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/safety/GroundProximityComputer$Status;", "", "<init>", "(Ljava/lang/String;I)V", "RECOVER", "WARNING", "CAUTION", "SAFE", "flightassistant-neoforge"})
    public static final class Status
    extends Enum<Status> {
        public static final /* enum */ Status RECOVER = new Status();
        public static final /* enum */ Status WARNING = new Status();
        public static final /* enum */ Status CAUTION = new Status();
        public static final /* enum */ Status SAFE = new Status();
        private static final /* synthetic */ Status[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Status[] values() {
            return (Status[])$VALUES.clone();
        }

        public static Status valueOf(String value) {
            return Enum.valueOf(Status.class, value);
        }

        @NotNull
        public static EnumEntries<Status> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = statusArray = new Status[]{Status.RECOVER, Status.WARNING, Status.CAUTION, Status.SAFE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Status.values().length];
            try {
                nArray[Status.SAFE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.CAUTION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.WARNING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Status.RECOVER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

