/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.impl.display;

import com.mojang.blaze3d.vertex.PoseStack;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import ru.octol1ttle.flightassistant.FlightAssistant;
import ru.octol1ttle.flightassistant.api.computer.ComputerBus;
import ru.octol1ttle.flightassistant.api.display.Display;
import ru.octol1ttle.flightassistant.api.display.HudFrame;
import ru.octol1ttle.flightassistant.api.util.extensions.GuiGraphicsExtensionsKt;
import ru.octol1ttle.flightassistant.api.util.extensions.LevelExtensionsKt;
import ru.octol1ttle.flightassistant.api.util.extensions.VectorExtensionsKt;
import ru.octol1ttle.flightassistant.config.FAConfig;
import ru.octol1ttle.flightassistant.impl.computer.autoflight.AutoFlightComputer;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0004\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001c\u0010\f\u001a\u00020\t*\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u001c\u0010\u0010\u001a\u00020\t*\u00020\u000b2\u0006\u0010\r\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u0011H\u0002J,\u0010\u0012\u001a\u00020\u0007*\u00020\u000b2\u0006\u0010\r\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001c\u0010\u0016\u001a\u00020\t*\u00020\u000b2\u0006\u0010\r\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u0011H\u0002J\u0010\u0010\u0017\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\u0019"}, d2={"Lru/octol1ttle/flightassistant/impl/display/AltitudeDisplay;", "Lru/octol1ttle/flightassistant/api/display/Display;", "computers", "Lru/octol1ttle/flightassistant/api/computer/ComputerBus;", "<init>", "(Lru/octol1ttle/flightassistant/api/computer/ComputerBus;)V", "allowedByConfig", "", "render", "", "guiGraphics", "Lnet/minecraft/client/gui/GuiGraphics;", "renderAltitudeReading", "x", "", "y", "renderAltitudeScale", "", "drawAltitudeLine", "altitude", "currentAltitude", "", "renderAltitudeTarget", "renderFaulted", "Companion", "flightassistant-neoforge"})
public final class AltitudeDisplay
extends Display {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final float READING_MATRIX_SCALE = 1.5f;
    @NotNull
    private static final ResourceLocation ID = FlightAssistant.INSTANCE.id$flightassistant_neoforge("altitude");

    public AltitudeDisplay(@NotNull ComputerBus computers) {
        Intrinsics.checkNotNullParameter((Object)computers, (String)"computers");
        super(computers);
    }

    @Override
    public boolean allowedByConfig() {
        return FAConfig.INSTANCE.getDisplay().getShowAltitudeReading() || FAConfig.INSTANCE.getDisplay().getShowAltitudeScale();
    }

    @Override
    public void render(@NotNull GuiGraphics guiGraphics) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        GuiGraphics $this$render_u24lambda_u240 = guiGraphics;
        boolean bl = false;
        if (FAConfig.INSTANCE.getDisplay().getShowAltitudeReading()) {
            this.renderAltitudeReading($this$render_u24lambda_u240, HudFrame.INSTANCE.getRightF(), GuiGraphicsExtensionsKt.getCenterYF($this$render_u24lambda_u240));
        }
        if (FAConfig.INSTANCE.getDisplay().getShowAltitudeScale()) {
            this.renderAltitudeScale($this$render_u24lambda_u240, HudFrame.INSTANCE.getRight(), GuiGraphicsExtensionsKt.getCenterY($this$render_u24lambda_u240));
        }
        if (FAConfig.INSTANCE.getDisplay().getShowAutomationModes()) {
            this.renderAltitudeTarget($this$render_u24lambda_u240, HudFrame.INSTANCE.getRight() + 2, HudFrame.INSTANCE.getTop() - 9);
        }
    }

    private final void renderAltitudeReading(GuiGraphics $this$renderAltitudeReading, float x, float y) {
        PoseStack poseStack = $this$renderAltitudeReading.pose();
        Intrinsics.checkNotNullExpressionValue((Object)poseStack, (String)"pose(...)");
        GuiGraphicsExtensionsKt.push(poseStack);
        GuiGraphicsExtensionsKt.fusedTranslateScale($this$renderAltitudeReading, x, y, 1.5f);
        double altitude = this.getComputers().getHudData().getLerpedAltitude();
        String text = String.valueOf(MathKt.roundToInt((double)altitude));
        int width = GuiGraphicsExtensionsKt.textWidth(text) + 5;
        int halfHeight = 6;
        $this$renderAltitudeReading.renderOutline(0, -halfHeight, width, halfHeight * 2 - 1, GuiGraphicsExtensionsKt.getPrimaryColor());
        int textY = -4;
        GuiGraphicsExtensionsKt.drawString$default($this$renderAltitudeReading, text, 3, textY, GuiGraphicsExtensionsKt.getPrimaryColor(), false, 16, null);
        PoseStack poseStack2 = $this$renderAltitudeReading.pose();
        Intrinsics.checkNotNullExpressionValue((Object)poseStack2, (String)"pose(...)");
        GuiGraphicsExtensionsKt.pop(poseStack2);
    }

    private final void renderAltitudeScale(GuiGraphics $this$renderAltitudeScale, int x, int y) {
        int i;
        int n;
        int n2;
        int altitudeRoundedUp;
        int i2;
        double altitude = this.getComputers().getHudData().getLerpedAltitude();
        int minY = HudFrame.INSTANCE.getTop();
        int maxY = RangesKt.coerceIn((int)((int)((double)y + (double)2 * (altitude - (double)LevelExtensionsKt.getBottomY((Level)this.getComputers().getData().getLevel()) + 1.0))), (ClosedRange)((ClosedRange)new IntRange(minY - 1, HudFrame.INSTANCE.getBottom())));
        $this$renderAltitudeScale.vLine(x, minY, maxY, GuiGraphicsExtensionsKt.getPrimaryColor());
        $this$renderAltitudeScale.enableScissor(0, minY, $this$renderAltitudeScale.guiWidth(), maxY + 1);
        int scissorMaxY = ((Number)(FAConfig.INSTANCE.getDisplay().getShowAltitudeReading() ? (Number)Float.valueOf((float)y - 9.0f) : (Number)maxY)).intValue();
        $this$renderAltitudeScale.enableScissor(0, minY, $this$renderAltitudeScale.guiWidth(), scissorMaxY + 1);
        $this$renderAltitudeScale.hLine(x, x + 30, y, GuiGraphicsExtensionsKt.getPrimaryColor());
        $this$renderAltitudeScale.hLine(x, x + 35, minY, GuiGraphicsExtensionsKt.getPrimaryColor());
        if (maxY < scissorMaxY) {
            $this$renderAltitudeScale.hLine(x, x + 35, maxY, GuiGraphicsExtensionsKt.getPrimaryColor());
        }
        if ((i2 = (altitudeRoundedUp = Mth.roundToward((int)MathKt.roundToInt((double)altitude), (int)5))) <= (n2 = ProgressionUtilKt.getProgressionLastElement((int)altitudeRoundedUp, (int)(n = altitudeRoundedUp + 1000), (int)5))) {
            while (this.drawAltitudeLine($this$renderAltitudeScale, x, y, i2, altitude) && i2 != n2) {
                i2 += 5;
            }
        }
        $this$renderAltitudeScale.disableScissor();
        $this$renderAltitudeScale.enableScissor(0, ((Number)(FAConfig.INSTANCE.getDisplay().getShowAltitudeReading() ? (Number)Float.valueOf((float)y + 7.5f) : (Number)minY)).intValue(), $this$renderAltitudeScale.guiWidth(), maxY + 1);
        $this$renderAltitudeScale.hLine(x, x + 35, maxY, GuiGraphicsExtensionsKt.getPrimaryColor());
        int altitudeRoundedDown = Mth.quantize((double)altitude, (int)5);
        int n3 = RangesKt.coerceAtLeast((int)(altitudeRoundedDown - 1000), (int)LevelExtensionsKt.getBottomY((Level)this.getComputers().getData().getLevel()));
        int n4 = ProgressionUtilKt.getProgressionLastElement((int)altitudeRoundedDown, (int)n3, (int)-5);
        if (n4 <= i) {
            for (i = altitudeRoundedDown; this.drawAltitudeLine($this$renderAltitudeScale, x, y, i, altitude) && i != n4; i -= 5) {
            }
        }
        $this$renderAltitudeScale.disableScissor();
        $this$renderAltitudeScale.disableScissor();
        if (FAConfig.INSTANCE.getDisplay().getShowVerticalSpeed()) {
            $this$renderAltitudeScale.enableScissor(0, HudFrame.INSTANCE.getTop(), $this$renderAltitudeScale.guiWidth(), HudFrame.INSTANCE.getBottom());
            $this$renderAltitudeScale.fill(x - 3, y, x - 1, (int)((double)y - (double)2 * VectorExtensionsKt.perSecond((Vec3)this.getComputers().getHudData().getLerpedVelocity()).y), GuiGraphicsExtensionsKt.getSecondaryColor());
            $this$renderAltitudeScale.disableScissor();
        }
    }

    private final boolean drawAltitudeLine(GuiGraphics $this$drawAltitudeLine, int x, int y, int altitude, double currentAltitude) {
        int textY = (int)((double)y + (double)2 * (currentAltitude - (double)altitude));
        if (textY < HudFrame.INSTANCE.getTop() - 100 || textY > HudFrame.INSTANCE.getBottom() + 100) {
            return false;
        }
        $this$drawAltitudeLine.hLine(x + 5, x, textY, GuiGraphicsExtensionsKt.getPrimaryColor());
        if (altitude % 20 == 0) {
            GuiGraphicsExtensionsKt.drawString$default($this$drawAltitudeLine, String.valueOf(altitude), x + 8, textY - 3, GuiGraphicsExtensionsKt.getPrimaryColor(), false, 16, null);
        }
        return true;
    }

    private final void renderAltitudeTarget(GuiGraphics $this$renderAltitudeTarget, int x, int y) {
        int color = 0;
        AutoFlightComputer.VerticalMode active = this.getComputers().getAutoflight().getActiveVerticalMode();
        if (this.getComputers().getAutoflight().getPitchInput() != null && active instanceof AutoFlightComputer.FollowsAltitudeMode) {
            color = Intrinsics.areEqual((Object)active, (Object)this.getComputers().getAutoflight().getSelectedVerticalMode()) ? GuiGraphicsExtensionsKt.getPrimaryAdvisoryColor() : GuiGraphicsExtensionsKt.getSecondaryAdvisoryColor();
            GuiGraphicsExtensionsKt.drawString$default($this$renderAltitudeTarget, String.valueOf(((AutoFlightComputer.FollowsAltitudeMode)((Object)active)).getTargetAltitude()), x, y, color, false, 16, null);
        }
    }

    @Override
    public void renderFaulted(@NotNull GuiGraphics guiGraphics) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        GuiGraphics $this$renderFaulted_u24lambda_u241 = guiGraphics;
        boolean bl = false;
        MutableComponent mutableComponent = Component.translatable((String)"short.flightassistant.altitude");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        GuiGraphicsExtensionsKt.drawString$default($this$renderFaulted_u24lambda_u241, (Component)mutableComponent, HudFrame.INSTANCE.getRight(), GuiGraphicsExtensionsKt.getCenterY($this$renderFaulted_u24lambda_u241) - 5, GuiGraphicsExtensionsKt.getWarningColor(), false, 16, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\u00020\u00058\u0002X\u0083T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0003R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lru/octol1ttle/flightassistant/impl/display/AltitudeDisplay$Companion;", "", "<init>", "()V", "READING_MATRIX_SCALE", "", "getREADING_MATRIX_SCALE$annotations", "ID", "Lnet/minecraft/resources/ResourceLocation;", "getID", "()Lnet/minecraft/resources/ResourceLocation;", "flightassistant-neoforge"})
    public static final class Companion {
        private Companion() {
        }

        @Deprecated(message="Increase GUI scale by 1 instead")
        private static /* synthetic */ void getREADING_MATRIX_SCALE$annotations() {
        }

        @NotNull
        public final ResourceLocation getID() {
            return ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

