/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.impl.display;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import kotlin.Metadata;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import ru.octol1ttle.flightassistant.FlightAssistant;
import ru.octol1ttle.flightassistant.api.autoflight.ControlInput;
import ru.octol1ttle.flightassistant.api.computer.ComputerBus;
import ru.octol1ttle.flightassistant.api.display.Display;
import ru.octol1ttle.flightassistant.api.display.HudFrame;
import ru.octol1ttle.flightassistant.api.util.FATickCounter;
import ru.octol1ttle.flightassistant.api.util.FloatLerper;
import ru.octol1ttle.flightassistant.api.util.ScreenSpace;
import ru.octol1ttle.flightassistant.api.util.extensions.GuiGraphicsExtensionsKt;
import ru.octol1ttle.flightassistant.api.util.extensions.StringExtensionsKt;
import ru.octol1ttle.flightassistant.config.FAConfig;
import ru.octol1ttle.flightassistant.config.options.DisplayOptions;
import ru.octol1ttle.flightassistant.impl.computer.autoflight.AutoFlightComputer;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0014\u0010\u000f\u001a\u00020\f*\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0014\u0010\u0012\u001a\u00020\f*\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0014\u0010\u0013\u001a\u00020\f*\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001c\u0010\u0014\u001a\u00020\f*\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J$\u0010\u0016\u001a\u00020\f*\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0017H\u0002J\u0010\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\u0011H\u0002J\u001c\u0010\u001a\u001a\u00020\f*\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0002J\u0010\u0010\u001c\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lru/octol1ttle/flightassistant/impl/display/AttitudeDisplay;", "Lru/octol1ttle/flightassistant/api/display/Display;", "computers", "Lru/octol1ttle/flightassistant/api/computer/ComputerBus;", "<init>", "(Lru/octol1ttle/flightassistant/api/computer/ComputerBus;)V", "minimumLerper", "Lru/octol1ttle/flightassistant/api/util/FloatLerper;", "maximumLerper", "allowedByConfig", "", "render", "", "guiGraphics", "Lnet/minecraft/client/gui/GuiGraphics;", "renderHorizon", "centerX", "", "renderPitchBars", "renderPitchLimits", "drawPitchReferenceMark", "pitch", "drawPitchBar", "", "y", "getPitchBarColor", "renderPitchTarget", "x", "renderFaulted", "Companion", "flightassistant-neoforge"})
public final class AttitudeDisplay
extends Display {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FloatLerper minimumLerper;
    @NotNull
    private final FloatLerper maximumLerper;
    @NotNull
    private static final ResourceLocation ID = FlightAssistant.INSTANCE.id$flightassistant_neoforge("attitude");

    public AttitudeDisplay(@NotNull ComputerBus computers) {
        Intrinsics.checkNotNullParameter((Object)computers, (String)"computers");
        super(computers);
        this.minimumLerper = new FloatLerper();
        this.maximumLerper = new FloatLerper();
    }

    @Override
    public boolean allowedByConfig() {
        return FAConfig.INSTANCE.getDisplay().getShowAttitude() != DisplayOptions.AttitudeDisplayMode.DISABLED;
    }

    @Override
    public void render(@NotNull GuiGraphics guiGraphics) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        if (this.getComputers().getHudData().isViewMirrored()) {
            return;
        }
        GuiGraphics $this$render_u24lambda_u240 = guiGraphics;
        boolean bl = false;
        float centerX = GuiGraphicsExtensionsKt.getCenterXF($this$render_u24lambda_u240) - 0.5f;
        PoseStack poseStack = $this$render_u24lambda_u240.pose();
        Intrinsics.checkNotNullExpressionValue((Object)poseStack, (String)"pose(...)");
        GuiGraphicsExtensionsKt.push(poseStack);
        $this$render_u24lambda_u240.pose().translate(0.0f, 0.0f, -200.0f);
        $this$render_u24lambda_u240.pose().rotateAround(Axis.ZN.rotationDegrees(this.getComputers().getHudData().getRoll()), centerX, GuiGraphicsExtensionsKt.getCenterYF($this$render_u24lambda_u240), 0.0f);
        if (!FAConfig.INSTANCE.getDisplay().getDrawPitchOutsideFrame()) {
            HudFrame.INSTANCE.scissor($this$render_u24lambda_u240);
        }
        if (FAConfig.INSTANCE.getDisplay().getShowAttitude().compareTo((Enum)DisplayOptions.AttitudeDisplayMode.HORIZON_ONLY) <= 0) {
            this.renderHorizon($this$render_u24lambda_u240, centerX);
        }
        if (FAConfig.INSTANCE.getDisplay().getShowAttitude() == DisplayOptions.AttitudeDisplayMode.HORIZON_AND_LADDER) {
            this.renderPitchBars($this$render_u24lambda_u240, centerX);
            this.renderPitchLimits($this$render_u24lambda_u240, centerX);
            this.drawPitchReferenceMark($this$render_u24lambda_u240, 47.5f, centerX);
            this.drawPitchReferenceMark($this$render_u24lambda_u240, -2.2f, centerX);
            this.drawPitchReferenceMark($this$render_u24lambda_u240, -38.5f, centerX);
        }
        if (!FAConfig.INSTANCE.getDisplay().getDrawPitchOutsideFrame()) {
            $this$render_u24lambda_u240.disableScissor();
        }
        PoseStack poseStack2 = $this$render_u24lambda_u240.pose();
        Intrinsics.checkNotNullExpressionValue((Object)poseStack2, (String)"pose(...)");
        GuiGraphicsExtensionsKt.pop(poseStack2);
        if (FAConfig.INSTANCE.getDisplay().getShowAutomationModes()) {
            this.renderPitchTarget($this$render_u24lambda_u240, GuiGraphicsExtensionsKt.getCenterX($this$render_u24lambda_u240) - 6, GuiGraphicsExtensionsKt.getCenterY($this$render_u24lambda_u240) - 10);
        }
    }

    private final void renderHorizon(GuiGraphics $this$renderHorizon, float centerX) {
        block0: {
            Integer n = ScreenSpace.INSTANCE.getY(0.0f);
            if (n == null) break block0;
            int it = ((Number)n).intValue();
            boolean bl = false;
            int color = this.getPitchBarColor(0.0f);
            int leftXEnd = (int)(centerX - GuiGraphicsExtensionsKt.getHalfWidth($this$renderHorizon) * 0.025f);
            int leftXStart = (int)((float)leftXEnd - GuiGraphicsExtensionsKt.getHalfWidth($this$renderHorizon) * 0.3f);
            GuiGraphicsExtensionsKt.drawRightAlignedString$default($this$renderHorizon, "0", leftXStart - 3, it - 3, color, false, 16, null);
            $this$renderHorizon.hLine(leftXStart, leftXEnd, it, color);
            int rightXStart = (int)(centerX + GuiGraphicsExtensionsKt.getHalfWidth($this$renderHorizon) * 0.025f);
            int rightXEnd = (int)((float)rightXStart + GuiGraphicsExtensionsKt.getHalfWidth($this$renderHorizon) * 0.3f);
            $this$renderHorizon.hLine(rightXStart, rightXEnd, it, color);
            GuiGraphicsExtensionsKt.drawString$default($this$renderHorizon, "0", rightXEnd + 5, it - 3, color, false, 16, null);
        }
    }

    private final void renderPitchBars(GuiGraphics $this$renderPitchBars, float centerX) {
        int step = FAConfig.INSTANCE.getDisplay().getAttitudeDegreeStep();
        int nextUp = Mth.roundToward((int)((int)this.getComputers().getData().getPitch()), (int)step);
        if (step <= 0) {
            throw new IllegalArgumentException("Step must be positive, was: " + step + ".");
        }
        int i = nextUp;
        int n = ProgressionUtilKt.getProgressionLastElement((int)nextUp, (int)90, (int)step);
        if (i <= n) {
            while (true) {
                Integer n2 = ScreenSpace.INSTANCE.getY(i);
                if (n2 == null) {
                    break;
                }
                this.drawPitchBar($this$renderPitchBars, i, centerX, n2);
                if (i == n) break;
                i += step;
            }
        }
        int nextDown = Mth.quantize((double)this.getComputers().getData().getPitch(), (int)step);
        if (step <= 0) {
            throw new IllegalArgumentException("Step must be positive, was: " + step + ".");
        }
        n = -step;
        int i2 = nextDown;
        int n3 = ProgressionUtilKt.getProgressionLastElement((int)nextDown, (int)-90, (int)n);
        if (n3 <= i2) {
            while (true) {
                Integer n4 = ScreenSpace.INSTANCE.getY(i2);
                if (n4 == null) {
                    break;
                }
                this.drawPitchBar($this$renderPitchBars, i2, centerX, n4);
                if (i2 == n3) break;
                i2 += n;
            }
        }
    }

    private final void renderPitchLimits(GuiGraphics $this$renderPitchLimits, float centerX) {
        int y;
        float max;
        int step = FAConfig.INSTANCE.getDisplay().getAttitudeDegreeStep() / 2;
        MutableComponent mutableComponent = Component.literal((String)"V");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"literal(...)");
        Component arrowText = (Component)mutableComponent;
        ControlInput maxInput = this.getComputers().getPitch().getMaximumPitch();
        ControlInput minInput = this.getComputers().getPitch().getMinimumPitch();
        ControlInput controlInput = maxInput;
        Float f = this.maximumLerper.get(controlInput != null ? Float.valueOf(controlInput.getTarget()) : null, FATickCounter.INSTANCE.getTimePassed() * 2.0f);
        ControlInput controlInput2 = minInput;
        Float f2 = this.minimumLerper.get(controlInput2 != null ? Float.valueOf(controlInput2.getTarget()) : null, FATickCounter.INSTANCE.getTimePassed() * 2.0f);
        float min = RangesKt.coerceAtMost((float)(f2 != null ? f2.floatValue() : -90.0f), (float)max);
        for (max = (v28854) != null ? (v28854).floatValue() : 90.0f; max <= 180.0f; max += (float)step) {
            Integer n = ScreenSpace.INSTANCE.getY(max);
            if (n == null) {
                break;
            }
            y = n;
            ControlInput controlInput3 = maxInput;
            GuiGraphicsExtensionsKt.drawMiddleAlignedString$default($this$renderPitchLimits, arrowText, (int)centerX, y - 9, (controlInput3 != null ? controlInput3.getStatus() : null) == ControlInput.Status.ACTIVE ? GuiGraphicsExtensionsKt.getWarningColor() : GuiGraphicsExtensionsKt.getCautionColor(), false, 16, null);
        }
        while (min >= -180.0f) {
            Integer n = ScreenSpace.INSTANCE.getY(min);
            if (n == null) {
                break;
            }
            y = n;
            PoseStack poseStack = $this$renderPitchLimits.pose();
            Intrinsics.checkNotNullExpressionValue((Object)poseStack, (String)"pose(...)");
            GuiGraphicsExtensionsKt.push(poseStack);
            $this$renderPitchLimits.pose().translate(centerX, (float)y, 0.0f);
            $this$renderPitchLimits.pose().mulPose(Axis.ZN.rotationDegrees(180.0f));
            ControlInput controlInput4 = minInput;
            GuiGraphicsExtensionsKt.drawMiddleAlignedString$default($this$renderPitchLimits, arrowText, 0, -9, (controlInput4 != null ? controlInput4.getStatus() : null) == ControlInput.Status.ACTIVE ? GuiGraphicsExtensionsKt.getWarningColor() : GuiGraphicsExtensionsKt.getCautionColor(), false, 16, null);
            PoseStack poseStack2 = $this$renderPitchLimits.pose();
            Intrinsics.checkNotNullExpressionValue((Object)poseStack2, (String)"pose(...)");
            GuiGraphicsExtensionsKt.pop(poseStack2);
            min -= (float)step;
        }
    }

    private final void drawPitchReferenceMark(GuiGraphics $this$drawPitchReferenceMark, float pitch, float centerX) {
        Integer n = ScreenSpace.INSTANCE.getY(pitch);
        if (n == null) {
            return;
        }
        int y = n;
        int color = this.getPitchBarColor(pitch);
        int leftXEnd = (int)(centerX - GuiGraphicsExtensionsKt.getHalfWidth($this$drawPitchReferenceMark) * 0.025f);
        int leftXStart = (int)((float)leftXEnd - GuiGraphicsExtensionsKt.getHalfWidth($this$drawPitchReferenceMark) * 0.05f);
        GuiGraphicsExtensionsKt.hLineDashed($this$drawPitchReferenceMark, leftXStart, leftXEnd, y, 2, color);
        int rightXStart = (int)(centerX + GuiGraphicsExtensionsKt.getHalfWidth($this$drawPitchReferenceMark) * 0.025f);
        int rightXEnd = (int)((float)rightXStart + GuiGraphicsExtensionsKt.getHalfWidth($this$drawPitchReferenceMark) * 0.05f);
        GuiGraphicsExtensionsKt.hLineDashed($this$drawPitchReferenceMark, rightXStart, rightXEnd, y, 2, color);
    }

    private final void drawPitchBar(GuiGraphics $this$drawPitchBar, int pitch, float centerX, int y) {
        if (pitch == 0) {
            return;
        }
        int color = this.getPitchBarColor(pitch);
        int leftXEnd = (int)(centerX - GuiGraphicsExtensionsKt.getHalfWidth($this$drawPitchBar) * 0.05f);
        int leftXStart = (int)((float)leftXEnd - GuiGraphicsExtensionsKt.getHalfWidth($this$drawPitchBar) * 0.075f);
        GuiGraphicsExtensionsKt.drawRightAlignedString$default($this$drawPitchBar, String.valueOf(pitch), leftXStart - 2, pitch > 0 ? y : y - 4, color, false, 16, null);
        $this$drawPitchBar.vLine(leftXStart, y, y + 5 * MathKt.getSign((int)pitch), color);
        GuiGraphicsExtensionsKt.hLineDashed($this$drawPitchBar, leftXStart, leftXEnd, y, pitch < 0 ? 3 : 1, color);
        int rightXStart = (int)(centerX + GuiGraphicsExtensionsKt.getHalfWidth($this$drawPitchBar) * 0.05f);
        int rightXEnd = (int)((float)rightXStart + GuiGraphicsExtensionsKt.getHalfWidth($this$drawPitchBar) * 0.075f);
        GuiGraphicsExtensionsKt.hLineDashed($this$drawPitchBar, rightXStart, rightXEnd, y, pitch < 0 ? 3 : 1, color);
        $this$drawPitchBar.vLine(rightXEnd, y, y + 5 * MathKt.getSign((int)pitch), color);
        GuiGraphicsExtensionsKt.drawString$default($this$drawPitchBar, String.valueOf(pitch), rightXEnd + 4, pitch > 0 ? y : y - 4, color, false, 16, null);
    }

    private final int getPitchBarColor(float pitch) {
        ControlInput min = this.getComputers().getPitch().getMinimumPitch();
        ControlInput max = this.getComputers().getPitch().getMaximumPitch();
        return max != null && pitch > max.getTarget() ? (max.getStatus() == ControlInput.Status.ACTIVE ? GuiGraphicsExtensionsKt.getWarningColor() : GuiGraphicsExtensionsKt.getCautionColor()) : (min != null && pitch < min.getTarget() ? (min.getStatus() == ControlInput.Status.ACTIVE ? GuiGraphicsExtensionsKt.getWarningColor() : GuiGraphicsExtensionsKt.getCautionColor()) : GuiGraphicsExtensionsKt.getPrimaryColor());
    }

    private final void renderPitchTarget(GuiGraphics $this$renderPitchTarget, int x, int y) {
        AutoFlightComputer.VerticalMode active = this.getComputers().getAutoflight().getActiveVerticalMode();
        if (this.getComputers().getAutoflight().getPitchInput() != null && active instanceof AutoFlightComputer.FollowsPitchMode) {
            Object[] objectArray = new Object[]{Float.valueOf(((AutoFlightComputer.FollowsPitchMode)((Object)active)).getTargetPitch())};
            GuiGraphicsExtensionsKt.drawRightAlignedString$default($this$renderPitchTarget, StringExtensionsKt.formatRoot("%.1f", objectArray), x, y, GuiGraphicsExtensionsKt.getPrimaryAdvisoryColor(), false, 16, null);
        }
    }

    @Override
    public void renderFaulted(@NotNull GuiGraphics guiGraphics) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        GuiGraphics $this$renderFaulted_u24lambda_u242 = guiGraphics;
        boolean bl = false;
        MutableComponent mutableComponent = Component.translatable((String)"short.flightassistant.attitude");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        GuiGraphicsExtensionsKt.drawMiddleAlignedString$default($this$renderFaulted_u24lambda_u242, (Component)mutableComponent, GuiGraphicsExtensionsKt.getCenterX($this$renderFaulted_u24lambda_u242), GuiGraphicsExtensionsKt.getCenterY($this$renderFaulted_u24lambda_u242) - 16, GuiGraphicsExtensionsKt.getWarningColor(), false, 16, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lru/octol1ttle/flightassistant/impl/display/AttitudeDisplay$Companion;", "", "<init>", "()V", "ID", "Lnet/minecraft/resources/ResourceLocation;", "getID", "()Lnet/minecraft/resources/ResourceLocation;", "flightassistant-neoforge"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceLocation getID() {
            return ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

