/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.screen.system;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import ru.octol1ttle.flightassistant.api.ModuleController;
import ru.octol1ttle.flightassistant.api.util.extensions.GuiGraphicsExtensionsKt;
import ru.octol1ttle.flightassistant.screen.components.FABaseList;
import ru.octol1ttle.flightassistant.screen.components.SmartStringWidget;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u000e2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\r\u000eB3\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n\u00a2\u0006\u0004\b\u000b\u0010\f\u00a8\u0006\u000f"}, d2={"Lru/octol1ttle/flightassistant/screen/system/SystemManagementList;", "Lru/octol1ttle/flightassistant/screen/components/FABaseList;", "Lru/octol1ttle/flightassistant/screen/system/SystemManagementList$Entry;", "y0", "", "y1", "width", "baseKey", "", "controller", "Lru/octol1ttle/flightassistant/api/ModuleController;", "<init>", "(IIILjava/lang/String;Lru/octol1ttle/flightassistant/api/ModuleController;)V", "Entry", "Companion", "flightassistant-neoforge"})
public final class SystemManagementList
extends FABaseList<Entry> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int ITEM_HEIGHT = 20;

    public SystemManagementList(int y0, int y1, int width, @NotNull String baseKey, @NotNull ModuleController<?> controller) {
        Intrinsics.checkNotNullParameter((Object)baseKey, (String)"baseKey");
        Intrinsics.checkNotNullParameter(controller, (String)"controller");
        super(y0, y1, width, 20);
        for (ResourceLocation module : controller.identifiers()) {
            MutableComponent mutableComponent = Component.translatable((String)(baseKey + "." + module));
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
            this.addEntry((AbstractSelectionList.Entry)new Entry(10, width, module, (Component)mutableComponent, controller));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lru/octol1ttle/flightassistant/screen/system/SystemManagementList$Companion;", "", "<init>", "()V", "ITEM_HEIGHT", "", "flightassistant-neoforge"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 ,2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001,B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n\u00a2\u0006\u0004\b\u000b\u0010\fJX\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020)0\u0016H\u0016J\u000e\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\u0016H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u0006\u0012\u0002\b\u00030\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u0015\u001a\u0010\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00170\u00170\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006-"}, d2={"Lru/octol1ttle/flightassistant/screen/system/SystemManagementList$Entry;", "Lnet/minecraft/client/gui/components/ContainerObjectSelectionList$Entry;", "xOffset", "", "listWidth", "identifier", "Lnet/minecraft/resources/ResourceLocation;", "displayName", "Lnet/minecraft/network/chat/Component;", "controller", "Lru/octol1ttle/flightassistant/api/ModuleController;", "<init>", "(IILnet/minecraft/resources/ResourceLocation;Lnet/minecraft/network/chat/Component;Lru/octol1ttle/flightassistant/api/ModuleController;)V", "getXOffset", "()I", "Lru/octol1ttle/flightassistant/screen/components/SmartStringWidget;", "faultText", "offText", "toggleButton", "Lnet/minecraft/client/gui/components/Button;", "kotlin.jvm.PlatformType", "children", "", "Lnet/minecraft/client/gui/components/AbstractWidget;", "getChildren", "()Ljava/util/List;", "render", "", "guiGraphics", "Lnet/minecraft/client/gui/GuiGraphics;", "index", "top", "left", "width", "height", "mouseX", "mouseY", "hovering", "", "partialTick", "", "Lnet/minecraft/client/gui/components/events/GuiEventListener;", "narratables", "Lnet/minecraft/client/gui/narration/NarratableEntry;", "Companion", "flightassistant-neoforge"})
    public static final class Entry
    extends ContainerObjectSelectionList.Entry<Entry> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int xOffset;
        private final int listWidth;
        @NotNull
        private final ResourceLocation identifier;
        @NotNull
        private final ModuleController<?> controller;
        @NotNull
        private final SmartStringWidget displayName;
        @NotNull
        private final SmartStringWidget faultText;
        @NotNull
        private final SmartStringWidget offText;
        private final Button toggleButton;
        @NotNull
        private final List<AbstractWidget> children;
        @NotNull
        private static final Component FAULT_TEXT;
        @NotNull
        private static final Component OFF_TEXT;
        @NotNull
        private static final Component OFF_RESET_TEXT;
        @NotNull
        private static final Component ON_TEXT;

        public Entry(int xOffset, int listWidth, @NotNull ResourceLocation identifier, @NotNull Component displayName, @NotNull ModuleController<?> controller) {
            Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
            Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
            Intrinsics.checkNotNullParameter(controller, (String)"controller");
            this.xOffset = xOffset;
            this.listWidth = listWidth;
            this.identifier = identifier;
            this.controller = controller;
            this.displayName = new SmartStringWidget(this.xOffset, 0, displayName).leftAligned();
            this.faultText = new SmartStringWidget(this.xOffset, 0, FAULT_TEXT).rightAligned();
            this.offText = new SmartStringWidget(this.xOffset, 0, OFF_TEXT).rightAligned();
            this.toggleButton = Button.builder((Component)OFF_TEXT, arg_0 -> Entry.toggleButton$lambda$0(this, arg_0)).pos(this.xOffset, 0).size(60, 18).build();
            Object[] objectArray = new AbstractWidget[]{this.displayName, this.faultText, this.offText, this.toggleButton};
            this.children = CollectionsKt.listOf((Object[])objectArray);
        }

        public final int getXOffset() {
            return this.xOffset;
        }

        @NotNull
        public final List<AbstractWidget> getChildren() {
            return this.children;
        }

        public void render(@NotNull GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            int n;
            Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
            this.displayName.setX(this.xOffset);
            this.displayName.setY(top);
            this.displayName.render(guiGraphics, mouseX, mouseY, partialTick);
            this.toggleButton.setX(this.listWidth - this.toggleButton.getWidth() - 5);
            this.toggleButton.setY(top - this.toggleButton.getHeight() / 4 - 1);
            this.toggleButton.setMessage(this.controller.isEnabled(this.identifier) ? (this.controller.getModulesResettable() ? OFF_RESET_TEXT : OFF_TEXT) : ON_TEXT);
            this.toggleButton.render(guiGraphics, mouseX, mouseY, partialTick);
            this.offText.setX(this.toggleButton.getX() - 10 - GuiGraphicsExtensionsKt.getFont().width((FormattedText)OFF_TEXT));
            this.offText.setY(top);
            Integer n2 = (this.controller.isEnabled(this.identifier) ? ChatFormatting.DARK_GRAY : ChatFormatting.WHITE).getColor();
            Intrinsics.checkNotNull((Object)n2);
            this.offText.setColor(n2);
            this.offText.render(guiGraphics, mouseX, mouseY, partialTick);
            this.faultText.setX(this.offText.getX() - this.offText.getWidth() / 2 - GuiGraphicsExtensionsKt.getFont().width((FormattedText)FAULT_TEXT));
            this.faultText.setY(top);
            if (this.controller.isFaulted(this.identifier)) {
                n = GuiGraphicsExtensionsKt.getCautionColor();
            } else {
                Integer n3 = ChatFormatting.DARK_GRAY.getColor();
                Intrinsics.checkNotNull((Object)n3);
                n = n3;
            }
            this.faultText.setColor(n);
            this.faultText.render(guiGraphics, mouseX, mouseY, partialTick);
        }

        @NotNull
        public List<GuiEventListener> children() {
            return this.children;
        }

        @NotNull
        public List<NarratableEntry> narratables() {
            return this.children;
        }

        private static final void toggleButton$lambda$0(Entry this$0, Button it) {
            this$0.controller.toggleEnabled(this$0.identifier);
        }

        static {
            MutableComponent mutableComponent = Component.translatable((String)"menu.flightassistant.system.fault");
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
            FAULT_TEXT = (Component)mutableComponent;
            MutableComponent mutableComponent2 = Component.translatable((String)"menu.flightassistant.system.off");
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent2, (String)"translatable(...)");
            OFF_TEXT = (Component)mutableComponent2;
            MutableComponent mutableComponent3 = Component.translatable((String)"menu.flightassistant.system.off_reset");
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent3, (String)"translatable(...)");
            OFF_RESET_TEXT = (Component)mutableComponent3;
            MutableComponent mutableComponent4 = Component.translatable((String)"menu.flightassistant.system.on");
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent4, (String)"translatable(...)");
            ON_TEXT = (Component)mutableComponent4;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lru/octol1ttle/flightassistant/screen/system/SystemManagementList$Entry$Companion;", "", "<init>", "()V", "FAULT_TEXT", "Lnet/minecraft/network/chat/Component;", "getFAULT_TEXT", "()Lnet/minecraft/network/chat/Component;", "OFF_TEXT", "getOFF_TEXT", "OFF_RESET_TEXT", "getOFF_RESET_TEXT", "ON_TEXT", "getON_TEXT", "flightassistant-neoforge"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Component getFAULT_TEXT() {
                return FAULT_TEXT;
            }

            @NotNull
            public final Component getOFF_TEXT() {
                return OFF_TEXT;
            }

            @NotNull
            public final Component getOFF_RESET_TEXT() {
                return OFF_RESET_TEXT;
            }

            @NotNull
            public final Component getON_TEXT() {
                return ON_TEXT;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

