/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.api.util;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.ClosedRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u000e\u0010\u0000\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u000e\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003\u001a\n\u0010\u0005\u001a\u00020\u0001*\u00020\u0001\u001a\u0018\u0010\u0006\u001a\u00020\u0001*\u00020\u00012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\b\u001a\n\u0010\u0005\u001a\u00020\u0003*\u00020\u0003\u001a\u0018\u0010\u0006\u001a\u00020\u0003*\u00020\u00032\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u001a\u001e\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u0001\u001a&\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003\u001a\u001d\u0010\u0013\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0016\u00a8\u0006\u0017"}, d2={"degrees", "", "value", "", "radians", "throwIfNotFinite", "throwIfNotInRange", "range", "Lkotlin/ranges/ClosedFloatingPointRange;", "Lkotlin/ranges/ClosedRange;", "findShortestPath", "from", "to", "valueRange", "pointsToDirection", "targetX", "targetZ", "originX", "originZ", "inverseMin", "a", "b", "(DD)Ljava/lang/Double;", "flightassistant-forge"})
public final class MathHelperKt {
    public static final float degrees(float value) {
        return (float)((double)value * 57.29577951308232);
    }

    public static final double degrees(double value) {
        return value * 57.29577951308232;
    }

    public static final float radians(float value) {
        return (float)((double)value * (Math.PI / 180));
    }

    public static final double radians(double value) {
        return value * (Math.PI / 180);
    }

    public static final float throwIfNotFinite(float $this$throwIfNotFinite) {
        if (!(Math.abs($this$throwIfNotFinite) <= Float.MAX_VALUE)) {
            boolean bl = false;
            String string = "Float value invalid; expected finite value, got " + $this$throwIfNotFinite;
            throw new IllegalArgumentException(string.toString());
        }
        return $this$throwIfNotFinite;
    }

    public static final float throwIfNotInRange(float $this$throwIfNotInRange, @NotNull ClosedFloatingPointRange<Float> range) {
        Intrinsics.checkNotNullParameter(range, (String)"range");
        MathHelperKt.throwIfNotFinite($this$throwIfNotInRange);
        if (!range.contains((Comparable)Float.valueOf($this$throwIfNotInRange))) {
            boolean bl = false;
            String string = "Float value invalid; expected [" + range.getStart() + "; " + range.getEndInclusive() + "], got " + $this$throwIfNotInRange;
            throw new IllegalArgumentException(string.toString());
        }
        return $this$throwIfNotInRange;
    }

    public static final double throwIfNotFinite(double $this$throwIfNotFinite) {
        if (!(Math.abs($this$throwIfNotFinite) <= Double.MAX_VALUE)) {
            boolean bl = false;
            String string = "Double value invalid; expected finite value, got " + $this$throwIfNotFinite;
            throw new IllegalArgumentException(string.toString());
        }
        return $this$throwIfNotFinite;
    }

    public static final double throwIfNotInRange(double $this$throwIfNotInRange, @NotNull ClosedRange<Double> range) {
        Intrinsics.checkNotNullParameter(range, (String)"range");
        MathHelperKt.throwIfNotFinite($this$throwIfNotInRange);
        if (!range.contains((Comparable)Double.valueOf($this$throwIfNotInRange))) {
            boolean bl = false;
            String string = "Double value invalid; expected [" + range.getStart() + "; " + range.getEndInclusive() + "], got " + $this$throwIfNotInRange;
            throw new IllegalArgumentException(string.toString());
        }
        return $this$throwIfNotInRange;
    }

    public static final float findShortestPath(float from, float to, float valueRange) {
        float diff = (to - from) % valueRange;
        if ((double)diff >= (double)valueRange * 0.5) {
            diff -= valueRange;
        }
        if ((double)diff < (double)valueRange * -0.5) {
            diff += valueRange;
        }
        return diff;
    }

    public static final double pointsToDirection(double targetX, double targetZ, double originX, double originZ) {
        return MathHelperKt.degrees(Math.atan2(-(targetX - originX), targetZ - originZ));
    }

    @Nullable
    public static final Double inverseMin(double a, double b) {
        if (a == 0.0 && b == 0.0) {
            return null;
        }
        if (a == 0.0) {
            return 1.0 / b;
        }
        if (b == 0.0) {
            return 1.0 / a;
        }
        return 1.0 / Math.min(a, b);
    }
}

