/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.impl.alert;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.resources.sounds.AbstractSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import ru.octol1ttle.flightassistant.api.alert.AlertData;
import ru.octol1ttle.flightassistant.api.util.extensions.SoundManagerExtensionsKt;
import ru.octol1ttle.flightassistant.config.FAConfig;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0016\u001a\u00020\u0015H\u0016J\u0006\u0010\u0017\u001a\u00020\u0018J\u0016\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\rJ\u0006\u0010\u001f\u001a\u00020\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lru/octol1ttle/flightassistant/impl/alert/AlertSoundInstance;", "Lnet/minecraft/client/resources/sounds/AbstractSoundInstance;", "player", "Lnet/minecraft/world/entity/player/Player;", "data", "Lru/octol1ttle/flightassistant/api/alert/AlertData;", "<init>", "(Lnet/minecraft/world/entity/player/Player;Lru/octol1ttle/flightassistant/api/alert/AlertData;)V", "getPlayer", "()Lnet/minecraft/world/entity/player/Player;", "getData", "()Lru/octol1ttle/flightassistant/api/alert/AlertData;", "age", "", "getAge", "()I", "setAge", "(I)V", "actualVolume", "", "fadingOut", "", "canStartSilent", "tick", "", "setLooping", "looping", "soundManager", "Lnet/minecraft/client/sounds/SoundManager;", "fadeOut", "ticksPassed", "silence", "flightassistant-forge"})
public final class AlertSoundInstance
extends AbstractSoundInstance {
    @NotNull
    private final Player player;
    @NotNull
    private final AlertData data;
    private int age;
    private float actualVolume;
    private boolean fadingOut;

    public AlertSoundInstance(@NotNull Player player, @NotNull AlertData data) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        super(data.getSoundEvent(), SoundSource.MASTER, SoundInstance.m_235150_());
        this.player = player;
        this.data = data;
        this.actualVolume = 1.0f;
        this.f_119582_ = true;
        this.f_119580_ = SoundInstance.Attenuation.NONE;
        boolean bl = this.f_119578_ = this.data.getLooping() != AlertData.LoopType.NONE;
        if (this.data.getLooping() == AlertData.LoopType.FADE_IN_OUT) {
            this.actualVolume = 0.05f;
        }
        this.f_119573_ = this.actualVolume * FAConfig.INSTANCE.getSafety().getAlertVolume();
    }

    @NotNull
    public final Player getPlayer() {
        return this.player;
    }

    @NotNull
    public final AlertData getData() {
        return this.data;
    }

    public final int getAge() {
        return this.age;
    }

    public final void setAge(int n) {
        this.age = n;
    }

    public boolean m_7784_() {
        return true;
    }

    public final void tick() {
        int n = this.age;
        this.age = n + 1;
        if (this.fadingOut) {
            return;
        }
        if (this.age > 100) {
            if (this.data.getLooping().compareTo((Enum)AlertData.LoopType.FADE_OUT) <= 0) {
                this.actualVolume = Math.max(0.3f, this.actualVolume - 0.007f);
            }
        } else if (this.data.getLooping() == AlertData.LoopType.FADE_IN_OUT) {
            this.actualVolume = Math.min(1.0f, this.actualVolume + 0.05f);
        }
        this.f_119573_ = this.actualVolume * FAConfig.INSTANCE.getSafety().getAlertVolume();
    }

    public final void setLooping(boolean looping, @NotNull SoundManager soundManager) {
        Intrinsics.checkNotNullParameter((Object)soundManager, (String)"soundManager");
        this.f_119578_ = looping;
        SoundManagerExtensionsKt.setLooping(soundManager, (SoundInstance)this, this.f_119578_);
    }

    public final boolean fadeOut(int ticksPassed) {
        this.fadingOut = true;
        this.f_119573_ = Math.max(0.0f, this.f_119573_ - 0.1f * (float)ticksPassed);
        return this.f_119573_ <= 0.0f;
    }

    public final void silence() {
        this.f_119573_ = 0.0f;
    }
}

