/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.impl.alert.gpws;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;
import ru.octol1ttle.flightassistant.api.alert.Alert;
import ru.octol1ttle.flightassistant.api.alert.AlertData;
import ru.octol1ttle.flightassistant.api.alert.CenteredAlert;
import ru.octol1ttle.flightassistant.api.computer.ComputerBus;
import ru.octol1ttle.flightassistant.api.util.FATickCounter;
import ru.octol1ttle.flightassistant.api.util.extensions.GuiGraphicsExtensionsKt;
import ru.octol1ttle.flightassistant.config.FAConfig;
import ru.octol1ttle.flightassistant.config.options.SafetyOptions;
import ru.octol1ttle.flightassistant.impl.computer.safety.GroundProximityComputer;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lru/octol1ttle/flightassistant/impl/alert/gpws/TerrainAheadAlert;", "Lru/octol1ttle/flightassistant/api/alert/Alert;", "Lru/octol1ttle/flightassistant/api/alert/CenteredAlert;", "computers", "Lru/octol1ttle/flightassistant/api/computer/ComputerBus;", "<init>", "(Lru/octol1ttle/flightassistant/api/computer/ComputerBus;)V", "data", "Lru/octol1ttle/flightassistant/api/alert/AlertData;", "getData", "()Lru/octol1ttle/flightassistant/api/alert/AlertData;", "shouldActivate", "", "getAlertMethod", "Lru/octol1ttle/flightassistant/config/options/SafetyOptions$AlertMethod;", "render", "guiGraphics", "Lnet/minecraft/client/gui/GuiGraphics;", "y", "", "flightassistant-forge"})
public final class TerrainAheadAlert
extends Alert
implements CenteredAlert {
    @NotNull
    private final AlertData data;

    public TerrainAheadAlert(@NotNull ComputerBus computers) {
        Intrinsics.checkNotNullParameter((Object)computers, (String)"computers");
        super(computers);
        this.data = AlertData.Companion.getTERRAIN_AHEAD();
    }

    @Override
    @NotNull
    public AlertData getData() {
        return this.data;
    }

    @Override
    public boolean shouldActivate() {
        return FAConfig.INSTANCE.getSafety().getObstacleAlertMode().caution() && this.getComputers().getGpws().getObstacleImpactStatus() == GroundProximityComputer.Status.CAUTION;
    }

    @Override
    @NotNull
    public SafetyOptions.AlertMethod getAlertMethod() {
        return FAConfig.INSTANCE.getSafety().getObstacleAlertMethod();
    }

    @Override
    public boolean render(@NotNull GuiGraphics guiGraphics, int y) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        MutableComponent mutableComponent = Component.m_237115_((String)"alert.flightassistant.gpws.terrain_ahead");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        GuiGraphicsExtensionsKt.drawHighlightedCenteredText$default(guiGraphics, (Component)mutableComponent, GuiGraphicsExtensionsKt.getCenterX(guiGraphics), y, GuiGraphicsExtensionsKt.getCautionColor(), FATickCounter.INSTANCE.getTotalTicks() % 40 >= 20, false, 32, null);
        return true;
    }
}

