/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.impl.computer.autoflight;

import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.octol1ttle.flightassistant.FAKeyMappings;
import ru.octol1ttle.flightassistant.FlightAssistant;
import ru.octol1ttle.flightassistant.api.autoflight.ControlInput;
import ru.octol1ttle.flightassistant.api.autoflight.FlightController;
import ru.octol1ttle.flightassistant.api.autoflight.heading.HeadingControllerRegistrationCallback;
import ru.octol1ttle.flightassistant.api.autoflight.pitch.PitchControllerRegistrationCallback;
import ru.octol1ttle.flightassistant.api.autoflight.roll.RollControllerRegistrationCallback;
import ru.octol1ttle.flightassistant.api.autoflight.thrust.ThrustChangeCallback;
import ru.octol1ttle.flightassistant.api.autoflight.thrust.ThrustControllerRegistrationCallback;
import ru.octol1ttle.flightassistant.api.computer.Computer;
import ru.octol1ttle.flightassistant.api.computer.ComputerBus;
import ru.octol1ttle.flightassistant.api.util.FATickCounter;
import ru.octol1ttle.flightassistant.api.util.event.EntityTurnEvents;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u0000 I2\u00020\u00012\u00020\u0002:\n@ABCDEFGHIB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u00102\u001a\u000203H\u0016J\b\u00104\u001a\u000203H\u0016J\u000e\u00105\u001a\u0002032\u0006\u0010\t\u001a\u00020\bJ\u001f\u00106\u001a\u0002032\u0006\u0010\f\u001a\u00020\b2\n\b\u0002\u00107\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u00108J\u001f\u00109\u001a\u0002032\u0006\u0010\u0012\u001a\u00020\b2\n\b\u0002\u00107\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u00108J\n\u0010:\u001a\u0004\u0018\u00010;H\u0016J\n\u0010<\u001a\u0004\u0018\u00010;H\u0016J\n\u0010=\u001a\u0004\u0018\u00010;H\u0016J\n\u0010>\u001a\u0004\u0018\u00010;H\u0016J\b\u0010?\u001a\u000203H\u0016R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\f\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u001a\u0010\u000e\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000bR\u001a\u0010\u0014\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u000b\"\u0004\b\u0016\u0010\u0011R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001c\u0010 \u001a\u0004\u0018\u00010!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001c\u0010&\u001a\u0004\u0018\u00010'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u0013\u0010,\u001a\u0004\u0018\u00010\u001b8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u001dR\u0013\u0010.\u001a\u0004\u0018\u00010!8F\u00a2\u0006\u0006\u001a\u0004\b/\u0010#R\u0013\u00100\u001a\u0004\u0018\u00010'8F\u00a2\u0006\u0006\u001a\u0004\b1\u0010)\u00a8\u0006J"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/autoflight/AutoFlightComputer;", "Lru/octol1ttle/flightassistant/api/computer/Computer;", "Lru/octol1ttle/flightassistant/api/autoflight/FlightController;", "computers", "Lru/octol1ttle/flightassistant/api/computer/ComputerBus;", "<init>", "(Lru/octol1ttle/flightassistant/api/computer/ComputerBus;)V", "value", "", "flightDirectors", "getFlightDirectors", "()Z", "autoThrust", "getAutoThrust", "autoThrustAlert", "getAutoThrustAlert", "setAutoThrustAlert", "(Z)V", "autopilot", "getAutopilot", "autopilotAlert", "getAutopilotAlert", "setAutopilotAlert", "pitchResistance", "", "headingResistance", "selectedThrustMode", "Lru/octol1ttle/flightassistant/impl/computer/autoflight/AutoFlightComputer$ThrustMode;", "getSelectedThrustMode", "()Lru/octol1ttle/flightassistant/impl/computer/autoflight/AutoFlightComputer$ThrustMode;", "setSelectedThrustMode", "(Lru/octol1ttle/flightassistant/impl/computer/autoflight/AutoFlightComputer$ThrustMode;)V", "selectedVerticalMode", "Lru/octol1ttle/flightassistant/impl/computer/autoflight/AutoFlightComputer$VerticalMode;", "getSelectedVerticalMode", "()Lru/octol1ttle/flightassistant/impl/computer/autoflight/AutoFlightComputer$VerticalMode;", "setSelectedVerticalMode", "(Lru/octol1ttle/flightassistant/impl/computer/autoflight/AutoFlightComputer$VerticalMode;)V", "selectedLateralMode", "Lru/octol1ttle/flightassistant/impl/computer/autoflight/AutoFlightComputer$LateralMode;", "getSelectedLateralMode", "()Lru/octol1ttle/flightassistant/impl/computer/autoflight/AutoFlightComputer$LateralMode;", "setSelectedLateralMode", "(Lru/octol1ttle/flightassistant/impl/computer/autoflight/AutoFlightComputer$LateralMode;)V", "activeThrustMode", "getActiveThrustMode", "activeVerticalMode", "getActiveVerticalMode", "activeLateralMode", "getActiveLateralMode", "subscribeToEvents", "", "tick", "setFlightDirectors", "setAutoThrust", "alert", "(ZLjava/lang/Boolean;)V", "setAutoPilot", "getThrustInput", "Lru/octol1ttle/flightassistant/api/autoflight/ControlInput;", "getPitchInput", "getHeadingInput", "getRollInput", "reset", "AutoFlightMode", "FollowsSpeedMode", "FollowsPitchMode", "FollowsAltitudeMode", "FollowsHeadingMode", "FollowsCoordinatesMode", "ThrustMode", "VerticalMode", "LateralMode", "Companion", "flightassistant-forge"})
public final class AutoFlightComputer
extends Computer
implements FlightController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean flightDirectors;
    private boolean autoThrust;
    private boolean autoThrustAlert;
    private boolean autopilot;
    private boolean autopilotAlert;
    private float pitchResistance;
    private float headingResistance;
    @Nullable
    private ThrustMode selectedThrustMode;
    @Nullable
    private VerticalMode selectedVerticalMode;
    @Nullable
    private LateralMode selectedLateralMode;
    @NotNull
    private static final ResourceLocation ID = FlightAssistant.INSTANCE.id$flightassistant_forge("auto_flight");

    public AutoFlightComputer(@NotNull ComputerBus computers) {
        Intrinsics.checkNotNullParameter((Object)computers, (String)"computers");
        super(computers);
    }

    public final boolean getFlightDirectors() {
        return this.flightDirectors;
    }

    public final boolean getAutoThrust() {
        return this.autoThrust;
    }

    public final boolean getAutoThrustAlert() {
        return this.autoThrustAlert;
    }

    public final void setAutoThrustAlert(boolean bl) {
        this.autoThrustAlert = bl;
    }

    public final boolean getAutopilot() {
        return this.autopilot;
    }

    public final boolean getAutopilotAlert() {
        return this.autopilotAlert;
    }

    public final void setAutopilotAlert(boolean bl) {
        this.autopilotAlert = bl;
    }

    @Nullable
    public final ThrustMode getSelectedThrustMode() {
        return this.selectedThrustMode;
    }

    public final void setSelectedThrustMode(@Nullable ThrustMode thrustMode) {
        this.selectedThrustMode = thrustMode;
    }

    @Nullable
    public final VerticalMode getSelectedVerticalMode() {
        return this.selectedVerticalMode;
    }

    public final void setSelectedVerticalMode(@Nullable VerticalMode verticalMode) {
        this.selectedVerticalMode = verticalMode;
    }

    @Nullable
    public final LateralMode getSelectedLateralMode() {
        return this.selectedLateralMode;
    }

    public final void setSelectedLateralMode(@Nullable LateralMode lateralMode) {
        this.selectedLateralMode = lateralMode;
    }

    @Nullable
    public final ThrustMode getActiveThrustMode() {
        ThrustMode thrustMode = this.selectedThrustMode;
        if (thrustMode == null) {
            thrustMode = this.getComputers().getPlan().getThrustMode();
        }
        return thrustMode;
    }

    @Nullable
    public final VerticalMode getActiveVerticalMode() {
        VerticalMode verticalMode = this.selectedVerticalMode;
        if (verticalMode == null) {
            verticalMode = this.getComputers().getPlan().getVerticalMode();
        }
        return verticalMode;
    }

    @Nullable
    public final LateralMode getActiveLateralMode() {
        LateralMode lateralMode = this.selectedLateralMode;
        if (lateralMode == null) {
            lateralMode = this.getComputers().getPlan().getLateralMode();
        }
        return lateralMode;
    }

    @Override
    public void subscribeToEvents() {
        ThrustControllerRegistrationCallback.EVENT.register(arg_0 -> AutoFlightComputer.subscribeToEvents$lambda$0(this, arg_0));
        PitchControllerRegistrationCallback.EVENT.register(arg_0 -> AutoFlightComputer.subscribeToEvents$lambda$1(this, arg_0));
        HeadingControllerRegistrationCallback.EVENT.register(arg_0 -> AutoFlightComputer.subscribeToEvents$lambda$2(this, arg_0));
        RollControllerRegistrationCallback.EVENT.register(arg_0 -> AutoFlightComputer.subscribeToEvents$lambda$3(this, arg_0));
        ThrustChangeCallback.EVENT.register((arg_0, arg_1, arg_2) -> AutoFlightComputer.subscribeToEvents$lambda$4(this, arg_0, arg_1, arg_2));
        EntityTurnEvents.X_ROT.register((arg_0, arg_1) -> AutoFlightComputer.subscribeToEvents$lambda$5(this, arg_0, arg_1));
        EntityTurnEvents.Y_ROT.register((arg_0, arg_1) -> AutoFlightComputer.subscribeToEvents$lambda$6(this, arg_0, arg_1));
    }

    @Override
    public void tick() {
        if (this.getComputers().getProtections().getProtectionsLost() || !this.getComputers().getChunk().isCurrentLoaded()) {
            this.setAutoThrust(false, true);
            this.setAutoPilot(false, true);
            return;
        }
        if (FAKeyMappings.INSTANCE.getGlobalAutomationOverride().m_90857_()) {
            this.setAutoThrust(false, false);
            this.setAutoPilot(false, false);
        }
        this.pitchResistance = RangesKt.coerceAtLeast((float)(this.pitchResistance - FATickCounter.INSTANCE.getTimePassed() * 10.0f), (float)0.0f);
        this.headingResistance = RangesKt.coerceAtLeast((float)(this.headingResistance - FATickCounter.INSTANCE.getTimePassed() * 20.0f), (float)0.0f);
    }

    public final void setFlightDirectors(boolean flightDirectors) {
        this.flightDirectors = flightDirectors;
    }

    public final void setAutoThrust(boolean autoThrust, @Nullable Boolean alert) {
        if (alert != null) {
            this.autoThrustAlert = this.autoThrust && !autoThrust && alert != false;
        }
        this.autoThrust = autoThrust;
    }

    public static /* synthetic */ void setAutoThrust$default(AutoFlightComputer autoFlightComputer, boolean bl, Boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl2 = null;
        }
        autoFlightComputer.setAutoThrust(bl, bl2);
    }

    public final void setAutoPilot(boolean autopilot, @Nullable Boolean alert) {
        if (alert != null) {
            this.autopilotAlert = this.autopilot && !autopilot && alert != false;
        }
        this.autopilot = autopilot;
    }

    public static /* synthetic */ void setAutoPilot$default(AutoFlightComputer autoFlightComputer, boolean bl, Boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl2 = null;
        }
        autoFlightComputer.setAutoPilot(bl, bl2);
    }

    @Override
    @Nullable
    public ControlInput getThrustInput() {
        if (!this.autoThrust) {
            return null;
        }
        ThrustMode thrustMode = this.getActiveThrustMode();
        if (thrustMode == null) {
            return null;
        }
        ThrustMode mode = thrustMode;
        ControlInput controlInput = mode.getControlInput(this.getComputers());
        if (controlInput == null) {
            return null;
        }
        ControlInput input = controlInput;
        Component component = mode.getTextOverride();
        if (component == null) {
            component = input.getText();
        }
        return ControlInput.copy$default(input, 0.0f, component, null, 0.0f, null, 29, null);
    }

    @Override
    @Nullable
    public ControlInput getPitchInput() {
        if (!this.flightDirectors && !this.autopilot) {
            return null;
        }
        VerticalMode verticalMode = this.getActiveVerticalMode();
        if (verticalMode == null) {
            return null;
        }
        VerticalMode mode = verticalMode;
        ControlInput controlInput = mode.getControlInput(this.getComputers());
        if (controlInput == null) {
            return null;
        }
        ControlInput input = controlInput;
        Component component = mode.getTextOverride();
        if (component == null) {
            component = input.getText();
        }
        return ControlInput.copy$default(input, 0.0f, component, null, 1.5f, ControlInput.Status.Companion.fromBooleans$default(ControlInput.Status.Companion, this.autopilot, false, false, 6, null), 5, null);
    }

    @Override
    @Nullable
    public ControlInput getHeadingInput() {
        if (!this.flightDirectors && !this.autopilot) {
            return null;
        }
        LateralMode lateralMode = this.getActiveLateralMode();
        if (lateralMode == null) {
            return null;
        }
        LateralMode mode = lateralMode;
        ControlInput controlInput = mode.getControlInput(this.getComputers());
        if (controlInput == null) {
            return null;
        }
        ControlInput input = controlInput;
        Component component = mode.getTextOverride();
        if (component == null) {
            component = input.getText();
        }
        return ControlInput.copy$default(input, 0.0f, component, null, 1.5f, ControlInput.Status.Companion.fromBooleans$default(ControlInput.Status.Companion, this.autopilot, false, false, 6, null), 5, null);
    }

    @Override
    @Nullable
    public ControlInput getRollInput() {
        if (!this.autopilot) {
            return null;
        }
        return new ControlInput(0.0f, null, null, 2.0f, null, 22, null);
    }

    @Override
    public void reset() {
        this.flightDirectors = false;
        if (this.autoThrust) {
            this.autoThrustAlert = true;
        }
        this.autoThrust = false;
        if (this.autopilot) {
            this.autopilotAlert = true;
        }
        this.autopilot = false;
        this.pitchResistance = 0.0f;
        this.headingResistance = 0.0f;
    }

    private static final void subscribeToEvents$lambda$0(AutoFlightComputer this$0, Consumer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.accept(this$0);
    }

    private static final void subscribeToEvents$lambda$1(AutoFlightComputer this$0, Consumer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.accept(this$0);
    }

    private static final void subscribeToEvents$lambda$2(AutoFlightComputer this$0, Consumer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.accept(this$0);
    }

    private static final void subscribeToEvents$lambda$3(AutoFlightComputer this$0, Consumer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.accept(this$0);
    }

    private static final void subscribeToEvents$lambda$4(AutoFlightComputer this$0, float f, float f2, ControlInput input) {
        if (input == null) {
            this$0.setAutoThrust(false, false);
        }
    }

    private static final void subscribeToEvents$lambda$5(AutoFlightComputer this$0, float pitchDelta, List output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        if (this$0.getComputers().getData().getFlying() && this$0.autopilot) {
            this$0.pitchResistance += Math.abs(pitchDelta);
            if (this$0.pitchResistance < 20.0f) {
                output.add(new ControlInput(0.0f, null, ControlInput.Priority.NORMAL, 0.0f, null, 26, null));
                return;
            }
            this$0.setAutoPilot(false, true);
        }
        this$0.pitchResistance = 0.0f;
    }

    private static final void subscribeToEvents$lambda$6(AutoFlightComputer this$0, float headingDelta, List output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        if (this$0.getComputers().getData().getFlying() && this$0.autopilot) {
            this$0.headingResistance += Math.abs(headingDelta);
            if (this$0.headingResistance < 40.0f) {
                output.add(new ControlInput(0.0f, null, ControlInput.Priority.NORMAL, 0.0f, null, 26, null));
                return;
            }
            this$0.setAutoPilot(false, true);
        }
        this$0.headingResistance = 0.0f;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH&R\u0014\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\n\u00c0\u0006\u0003"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/autoflight/AutoFlightComputer$AutoFlightMode;", "", "textOverride", "Lnet/minecraft/network/chat/Component;", "getTextOverride", "()Lnet/minecraft/network/chat/Component;", "getControlInput", "Lru/octol1ttle/flightassistant/api/autoflight/ControlInput;", "computers", "Lru/octol1ttle/flightassistant/api/computer/ComputerBus;", "flightassistant-forge"})
    public static interface AutoFlightMode {
        @Nullable
        public Component getTextOverride();

        @Nullable
        public ControlInput getControlInput(@NotNull ComputerBus var1);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/autoflight/AutoFlightComputer$Companion;", "", "<init>", "()V", "ID", "Lnet/minecraft/resources/ResourceLocation;", "getID", "()Lnet/minecraft/resources/ResourceLocation;", "flightassistant-forge"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceLocation getID() {
            return ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006\u00c0\u0006\u0003"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/autoflight/AutoFlightComputer$FollowsAltitudeMode;", "Lru/octol1ttle/flightassistant/impl/computer/autoflight/AutoFlightComputer$AutoFlightMode;", "targetAltitude", "", "getTargetAltitude", "()I", "flightassistant-forge"})
    public static interface FollowsAltitudeMode
    extends AutoFlightMode {
        public int getTargetAltitude();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005\u00a8\u0006\b\u00c0\u0006\u0003"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/autoflight/AutoFlightComputer$FollowsCoordinatesMode;", "Lru/octol1ttle/flightassistant/impl/computer/autoflight/AutoFlightComputer$AutoFlightMode;", "targetX", "", "getTargetX", "()I", "targetZ", "getTargetZ", "flightassistant-forge"})
    public static interface FollowsCoordinatesMode
    extends AutoFlightMode {
        public int getTargetX();

        public int getTargetZ();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006\u00c0\u0006\u0003"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/autoflight/AutoFlightComputer$FollowsHeadingMode;", "Lru/octol1ttle/flightassistant/impl/computer/autoflight/AutoFlightComputer$AutoFlightMode;", "targetHeading", "", "getTargetHeading", "()I", "flightassistant-forge"})
    public static interface FollowsHeadingMode
    extends AutoFlightMode {
        public int getTargetHeading();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006\u00c0\u0006\u0003"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/autoflight/AutoFlightComputer$FollowsPitchMode;", "Lru/octol1ttle/flightassistant/impl/computer/autoflight/AutoFlightComputer$AutoFlightMode;", "targetPitch", "", "getTargetPitch", "()F", "flightassistant-forge"})
    public static interface FollowsPitchMode
    extends AutoFlightMode {
        public float getTargetPitch();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006\u00c0\u0006\u0003"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/autoflight/AutoFlightComputer$FollowsSpeedMode;", "Lru/octol1ttle/flightassistant/impl/computer/autoflight/AutoFlightComputer$AutoFlightMode;", "targetSpeed", "", "getTargetSpeed", "()I", "flightassistant-forge"})
    public static interface FollowsSpeedMode
    extends AutoFlightMode {
        public int getTargetSpeed();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001\u00a8\u0006\u0002\u00c0\u0006\u0003"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/autoflight/AutoFlightComputer$LateralMode;", "Lru/octol1ttle/flightassistant/impl/computer/autoflight/AutoFlightComputer$AutoFlightMode;", "flightassistant-forge"})
    public static interface LateralMode
    extends AutoFlightMode {
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001\u00a8\u0006\u0002\u00c0\u0006\u0003"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/autoflight/AutoFlightComputer$ThrustMode;", "Lru/octol1ttle/flightassistant/impl/computer/autoflight/AutoFlightComputer$AutoFlightMode;", "flightassistant-forge"})
    public static interface ThrustMode
    extends AutoFlightMode {
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001\u00a8\u0006\u0002\u00c0\u0006\u0003"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/autoflight/AutoFlightComputer$VerticalMode;", "Lru/octol1ttle/flightassistant/impl/computer/autoflight/AutoFlightComputer$AutoFlightMode;", "flightassistant-forge"})
    public static interface VerticalMode
    extends AutoFlightMode {
    }
}

