/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.impl.computer.autoflight;

import dev.architectury.event.CompoundEventResult;
import dev.architectury.event.events.common.InteractionEvent;
import java.util.Iterator;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.FireworkRocketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.octol1ttle.flightassistant.FlightAssistant;
import ru.octol1ttle.flightassistant.api.autoflight.thrust.ThrustSource;
import ru.octol1ttle.flightassistant.api.autoflight.thrust.ThrustSourceRegistrationCallback;
import ru.octol1ttle.flightassistant.api.computer.Computer;
import ru.octol1ttle.flightassistant.api.computer.ComputerBus;
import ru.octol1ttle.flightassistant.api.computer.ComputerQuery;
import ru.octol1ttle.flightassistant.api.util.FATickCounter;
import ru.octol1ttle.flightassistant.api.util.LimitedFIFOQueue;
import ru.octol1ttle.flightassistant.api.util.event.FireworkBoostCallback;
import ru.octol1ttle.flightassistant.config.FAConfig;
import ru.octol1ttle.flightassistant.impl.computer.data.AirDataComputer;
import ru.octol1ttle.flightassistant.impl.computer.safety.GroundProximityComputer;
import ru.octol1ttle.flightassistant.impl.display.StatusDisplay;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 :2\u00020\u00012\u00020\u0002:\u0001:B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020#H\u0016J\u0016\u0010%\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)J\u0010\u0010*\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u0010-\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020,H\u0002J\b\u0010.\u001a\u00020\u000eH\u0002J\u0010\u0010/\u001a\u00020#2\u0006\u0010&\u001a\u00020'H\u0002J\u0018\u00100\u001a\u00020#2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0002J\b\u00101\u001a\u00020\u000eH\u0016J\u0010\u00102\u001a\u00020#2\u0006\u00103\u001a\u000204H\u0016J\u001c\u00105\u001a\u00020#\"\u0004\b\u0000\u001062\f\u00107\u001a\b\u0012\u0004\u0012\u0002H608H\u0016J\b\u00109\u001a\u00020#H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0010\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0017\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00120\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006;"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/autoflight/FireworkComputer;", "Lru/octol1ttle/flightassistant/api/computer/Computer;", "Lru/octol1ttle/flightassistant/api/autoflight/thrust/ThrustSource;", "computers", "Lru/octol1ttle/flightassistant/api/computer/ComputerBus;", "mc", "Lnet/minecraft/client/Minecraft;", "<init>", "(Lru/octol1ttle/flightassistant/api/computer/ComputerBus;Lnet/minecraft/client/Minecraft;)V", "priority", "Lru/octol1ttle/flightassistant/api/autoflight/thrust/ThrustSource$Priority;", "getPriority", "()Lru/octol1ttle/flightassistant/api/autoflight/thrust/ThrustSource$Priority;", "supportsReverse", "", "getSupportsReverse", "()Z", "safeFireworkCount", "", "safeFireworkSlot", "Ljava/lang/Integer;", "waitingForResponse", "getWaitingForResponse", "setWaitingForResponse", "(Z)V", "lastActivationTime", "getLastActivationTime", "()I", "setLastActivationTime", "(I)V", "responseTimes", "Lru/octol1ttle/flightassistant/api/util/LimitedFIFOQueue;", "getResponseTimes", "()Lru/octol1ttle/flightassistant/api/util/LimitedFIFOQueue;", "subscribeToEvents", "", "tick", "isEmptyOrSafe", "player", "Lnet/minecraft/world/entity/player/Player;", "hand", "Lnet/minecraft/world/InteractionHand;", "isFireworkAndSafe", "stack", "Lnet/minecraft/world/item/ItemStack;", "hasNoExplosions", "anyTerrainAhead", "tryActivateFirework", "useFirework", "isAvailable", "tickThrust", "currentThrust", "", "handleQuery", "Response", "query", "Lru/octol1ttle/flightassistant/api/computer/ComputerQuery;", "reset", "Companion", "flightassistant-forge"})
public final class FireworkComputer
extends Computer
implements ThrustSource {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Minecraft mc;
    @NotNull
    private final ThrustSource.Priority priority;
    private final boolean supportsReverse;
    private int safeFireworkCount;
    @Nullable
    private Integer safeFireworkSlot;
    private boolean waitingForResponse;
    private int lastActivationTime;
    @NotNull
    private final LimitedFIFOQueue<Integer> responseTimes;
    @NotNull
    private static final ResourceLocation ID = FlightAssistant.INSTANCE.id$flightassistant_forge("firework");
    private static final float FIREWORK_SPEED = 33.33f;

    public FireworkComputer(@NotNull ComputerBus computers, @NotNull Minecraft mc) {
        Intrinsics.checkNotNullParameter((Object)computers, (String)"computers");
        Intrinsics.checkNotNullParameter((Object)mc, (String)"mc");
        super(computers);
        this.mc = mc;
        this.priority = ThrustSource.Priority.LOW;
        this.responseTimes = new LimitedFIFOQueue(5);
    }

    @Override
    @NotNull
    public ThrustSource.Priority getPriority() {
        return this.priority;
    }

    @Override
    public boolean getSupportsReverse() {
        return this.supportsReverse;
    }

    public final boolean getWaitingForResponse() {
        return this.waitingForResponse;
    }

    public final void setWaitingForResponse(boolean bl) {
        this.waitingForResponse = bl;
    }

    public final int getLastActivationTime() {
        return this.lastActivationTime;
    }

    public final void setLastActivationTime(int n) {
        this.lastActivationTime = n;
    }

    @NotNull
    public final LimitedFIFOQueue<Integer> getResponseTimes() {
        return this.responseTimes;
    }

    @Override
    public void subscribeToEvents() {
        ThrustSourceRegistrationCallback.EVENT.register(arg_0 -> FireworkComputer.subscribeToEvents$lambda$0(this, arg_0));
        InteractionEvent.RIGHT_CLICK_ITEM.register((arg_0, arg_1) -> FireworkComputer.subscribeToEvents$lambda$1(this, arg_0, arg_1));
        FireworkBoostCallback.EVENT.register((arg_0, arg_1) -> FireworkComputer.subscribeToEvents$lambda$2(this, arg_0, arg_1));
    }

    @Override
    public void tick() {
        if (!this.getComputers().getData().getFlying()) {
            this.waitingForResponse = false;
        }
        this.safeFireworkSlot = null;
        int lastSlotCount = 0;
        int n = Inventory.m_36059_();
        for (int slot = 0; slot < n; ++slot) {
            ItemStack stack;
            Intrinsics.checkNotNullExpressionValue((Object)this.getComputers().getData().getPlayer().m_150109_().m_8020_(slot), (String)"getItem(...)");
            if (!this.isFireworkAndSafe(stack) || this.safeFireworkSlot != null && stack.m_41613_() >= lastSlotCount) continue;
            this.safeFireworkSlot = slot;
            lastSlotCount = stack.m_41613_();
        }
        this.safeFireworkCount = 0;
        Iterator iterator = this.getComputers().getData().getPlayer().m_150109_().f_35974_.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Object e = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            ItemStack stack = (ItemStack)e;
            if (!this.isFireworkAndSafe(stack)) continue;
            this.safeFireworkCount += stack.m_41613_();
        }
        ItemStack itemStack = this.getComputers().getData().getPlayer().m_21206_();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getOffhandItem(...)");
        if (this.isFireworkAndSafe(itemStack)) {
            this.safeFireworkCount += this.getComputers().getData().getPlayer().m_21206_().m_41613_();
        }
    }

    public final boolean isEmptyOrSafe(@NotNull Player player, @NotNull InteractionHand hand) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        ItemStack itemStack = player.m_21120_(hand);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemInHand(...)");
        return this.hasNoExplosions(itemStack);
    }

    private final boolean isFireworkAndSafe(ItemStack stack) {
        return stack.m_41720_() instanceof FireworkRocketItem && this.hasNoExplosions(stack);
    }

    private final boolean hasNoExplosions(ItemStack stack) {
        CompoundTag compoundTag = stack.m_41737_("Fireworks");
        return !(compoundTag != null && (compoundTag = compoundTag.m_128437_("Explosions", 10)) != null ? !compoundTag.isEmpty() : false);
    }

    private final boolean anyTerrainAhead() {
        Vec3 velocity = this.getComputers().getData().getPlayer().m_20156_().m_82490_((double)33.33f);
        GroundProximityComputer groundProximityComputer = this.getComputers().getGpws();
        Intrinsics.checkNotNull((Object)velocity);
        return groundProximityComputer.computeObstacleImpactTime(velocity, this.getComputers().getGpws().getCautionThreshold()) <= this.getComputers().getGpws().getWarningThreshold();
    }

    private final void tryActivateFirework(Player player) {
        if (FATickCounter.INSTANCE.getTotalTicks() < this.lastActivationTime + 10) {
            return;
        }
        ItemStack itemStack = player.m_21206_();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getOffhandItem(...)");
        if (this.isFireworkAndSafe(itemStack)) {
            this.useFirework(player, InteractionHand.OFF_HAND);
        } else if (this.safeFireworkSlot != null) {
            Inventory inventory = player.m_150109_();
            Integer n = this.safeFireworkSlot;
            Intrinsics.checkNotNull((Object)n);
            inventory.f_35977_ = n;
            this.useFirework(player, InteractionHand.MAIN_HAND);
        }
    }

    private final void useFirework(Player player, InteractionHand hand) {
        MultiPlayerGameMode multiPlayerGameMode = this.mc.f_91072_;
        Intrinsics.checkNotNull((Object)multiPlayerGameMode);
        multiPlayerGameMode.m_233721_(player, hand);
        this.lastActivationTime = FATickCounter.INSTANCE.getTotalTicks();
        this.waitingForResponse = true;
    }

    @Override
    public boolean isAvailable() {
        return this.safeFireworkSlot != null;
    }

    @Override
    public void tickThrust(float currentThrust) {
        if ((double)currentThrust > this.getComputers().getData().getForwardVelocityPerSecond().m_82553_() / (double)33.33f && !this.anyTerrainAhead()) {
            this.tryActivateFirework((Player)this.getComputers().getData().getPlayer());
        }
    }

    @Override
    public <Response> void handleQuery(@NotNull ComputerQuery<Response> query) {
        Intrinsics.checkNotNullParameter(query, (String)"query");
        if (query instanceof StatusDisplay.StatusMessageQuery && Intrinsics.areEqual((Object)this.getComputers().getThrust().getThrustSource(), (Object)this)) {
            StatusDisplay.StatusMessageQuery statusMessageQuery = (StatusDisplay.StatusMessageQuery)query;
            Object[] objectArray = new Object[]{this.safeFireworkCount};
            MutableComponent mutableComponent = Component.m_237110_((String)"status.flightassistant.firework_count", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
            statusMessageQuery.respond(mutableComponent);
        }
    }

    @Override
    public void reset() {
        this.safeFireworkCount = 0;
        this.safeFireworkSlot = null;
        this.waitingForResponse = false;
        this.lastActivationTime = 0;
        this.responseTimes.clear();
    }

    private static final void subscribeToEvents$lambda$0(FireworkComputer this$0, Consumer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.accept(this$0);
    }

    /*
     * Unable to fully structure code
     */
    private static final CompoundEventResult subscribeToEvents$lambda$1(FireworkComputer this$0, Player player, InteractionHand hand) {
        block4: {
            v0 = player.m_21120_(hand);
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getItemInHand(...)");
            stack = v0;
            if (!player.m_9236_().m_5776_() || !this$0.getComputers().getData().getFlying() || !(stack.m_41720_() instanceof FireworkRocketItem)) break block4;
            if (!FAConfig.INSTANCE.getSafety().getFireworkLockExplosive()) ** GOTO lbl-1000
            Intrinsics.checkNotNull((Object)player);
            Intrinsics.checkNotNull((Object)hand);
            if (!this$0.isEmptyOrSafe(player, hand)) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
            explosive = v1;
            v2 = anyTerrainAhead = FAConfig.INSTANCE.getSafety().getFireworkLockObstacles() != false && this$0.anyTerrainAhead() != false;
            if (AirDataComputer.automationsAllowed$default(this$0.getComputers().getData(), false, 1, null) && (explosive || anyTerrainAhead)) {
                return CompoundEventResult.interruptFalse((Object)stack);
            }
            if (!this$0.waitingForResponse) {
                this$0.lastActivationTime = FATickCounter.INSTANCE.getTotalTicks();
                this$0.waitingForResponse = true;
            }
        }
        return CompoundEventResult.pass();
    }

    private static final void subscribeToEvents$lambda$2(FireworkComputer this$0, FireworkRocketEntity fireworkRocketEntity, LocalPlayer localPlayer) {
        Intrinsics.checkNotNullParameter((Object)localPlayer, (String)"<unused var>");
        if (this$0.waitingForResponse) {
            this$0.waitingForResponse = false;
            this$0.responseTimes.add(FATickCounter.INSTANCE.getTotalTicks() - this$0.lastActivationTime);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/autoflight/FireworkComputer$Companion;", "", "<init>", "()V", "ID", "Lnet/minecraft/resources/ResourceLocation;", "getID", "()Lnet/minecraft/resources/ResourceLocation;", "FIREWORK_SPEED", "", "flightassistant-forge"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceLocation getID() {
            return ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

