/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.impl.computer.autoflight.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.RangesKt;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.octol1ttle.flightassistant.FlightAssistant;
import ru.octol1ttle.flightassistant.api.autoflight.ControlInput;
import ru.octol1ttle.flightassistant.api.autoflight.FlightController;
import ru.octol1ttle.flightassistant.api.autoflight.pitch.PitchControllerRegistrationCallback;
import ru.octol1ttle.flightassistant.api.computer.Computer;
import ru.octol1ttle.flightassistant.api.computer.ComputerBus;
import ru.octol1ttle.flightassistant.api.computer.ComputerQuery;
import ru.octol1ttle.flightassistant.api.util.FATickCounter;
import ru.octol1ttle.flightassistant.api.util.MathHelperKt;
import ru.octol1ttle.flightassistant.api.util.event.EntityTurnEvents;
import ru.octol1ttle.flightassistant.api.util.extensions.CollectionExtensionsKt;
import ru.octol1ttle.flightassistant.impl.computer.autoflight.base.PitchComputer;
import ru.octol1ttle.flightassistant.impl.computer.data.AirDataComputer;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0007\u0018\u0000 %2\u00020\u00012\u00020\u0002:\u0003#$%B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016J\b\u0010\u0015\u001a\u00020\u0013H\u0016J\b\u0010\u0016\u001a\u00020\u0013H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u0013H\u0002J\n\u0010\u001a\u001a\u0004\u0018\u00010\nH\u0016J(\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u001fH\u0002J\b\u0010\"\u001a\u00020\u0013H\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\t\u001a\u0004\u0018\u00010\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\"\u0010\u000e\u001a\u0004\u0018\u00010\n2\b\u0010\t\u001a\u0004\u0018\u00010\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\"\u0010\u0010\u001a\u0004\u0018\u00010\n2\b\u0010\t\u001a\u0004\u0018\u00010\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\r\u00a8\u0006&"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/autoflight/base/PitchComputer;", "Lru/octol1ttle/flightassistant/api/computer/Computer;", "Lru/octol1ttle/flightassistant/api/autoflight/FlightController;", "computers", "Lru/octol1ttle/flightassistant/api/computer/ComputerBus;", "<init>", "(Lru/octol1ttle/flightassistant/api/computer/ComputerBus;)V", "controllers", "", "value", "Lru/octol1ttle/flightassistant/api/autoflight/ControlInput;", "minimumPitch", "getMinimumPitch", "()Lru/octol1ttle/flightassistant/api/autoflight/ControlInput;", "maximumPitch", "getMaximumPitch", "activeInput", "getActiveInput", "subscribeToEvents", "", "invokeEvents", "tick", "renderTick", "canMoveOrBlockPitch", "", "updateSafePitches", "getPitchInput", "smoothSetPitch", "player", "Lnet/minecraft/world/entity/player/Player;", "current", "", "target", "deltaTimeMultiplier", "reset", "MinimumPitchQuery", "MaximumPitchQuery", "Companion", "flightassistant-forge"})
@SourceDebugExtension(value={"SMAP\nPitchComputer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PitchComputer.kt\nru/octol1ttle/flightassistant/impl/computer/autoflight/base/PitchComputer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,161:1\n1617#2,9:162\n1869#2:171\n1870#2:173\n1626#2:174\n1056#2:175\n1999#2,14:176\n1056#2:190\n2423#2,14:191\n1056#2:205\n1999#2,14:206\n1#3:172\n*S KotlinDebug\n*F\n+ 1 PitchComputer.kt\nru/octol1ttle/flightassistant/impl/computer/autoflight/base/PitchComputer\n*L\n60#1:162,9\n60#1:171\n60#1:173\n60#1:174\n60#1:175\n66#1:176,14\n95#1:190\n96#1:191,14\n99#1:205\n100#1:206,14\n60#1:172\n*E\n"})
public final class PitchComputer
extends Computer
implements FlightController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<FlightController> controllers;
    @Nullable
    private ControlInput minimumPitch;
    @Nullable
    private ControlInput maximumPitch;
    @Nullable
    private ControlInput activeInput;
    @NotNull
    private static final ResourceLocation ID = FlightAssistant.INSTANCE.id$flightassistant_forge("pitch");

    public PitchComputer(@NotNull ComputerBus computers) {
        Intrinsics.checkNotNullParameter((Object)computers, (String)"computers");
        super(computers);
        this.controllers = new ArrayList();
    }

    @Nullable
    public final ControlInput getMinimumPitch() {
        return this.minimumPitch;
    }

    @Nullable
    public final ControlInput getMaximumPitch() {
        return this.maximumPitch;
    }

    @Nullable
    public final ControlInput getActiveInput() {
        return this.activeInput;
    }

    @Override
    public void subscribeToEvents() {
        PitchControllerRegistrationCallback.EVENT.register(arg_0 -> PitchComputer.subscribeToEvents$lambda$0(this, arg_0));
        EntityTurnEvents.X_ROT.register((arg_0, arg_1) -> PitchComputer.subscribeToEvents$lambda$2(this, arg_0, arg_1));
    }

    @Override
    public void invokeEvents() {
        ((PitchControllerRegistrationCallback)PitchControllerRegistrationCallback.EVENT.invoker()).register(p0 -> this.controllers.add((FlightController)p0));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void tick() {
        Object v0;
        void $this$mapNotNullTo$iv$iv;
        this.updateSafePitches();
        Iterable $this$mapNotNull$iv = CollectionExtensionsKt.filterWorking(this.controllers);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ControlInput it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            FlightController it = (FlightController)element$iv$iv;
            boolean bl2 = false;
            if ((ControlInput)this.getComputers().guardedCall(it, tick.inputs.1.1.INSTANCE) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        List inputs2 = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ControlInput it = (ControlInput)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getPriority().getValue());
                it = (ControlInput)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getPriority().getValue()));
            }
        });
        if (inputs2.isEmpty()) {
            this.activeInput = null;
            return;
        }
        Iterable $this$maxByOrNull$iv = CollectionExtensionsKt.getActiveHighestPriority(inputs2);
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                ControlInput it = (ControlInput)maxElem$iv;
                boolean bl = false;
                float maxValue$iv = it.getTarget();
                do {
                    Object e$iv = iterator$iv.next();
                    ControlInput it2 = (ControlInput)e$iv;
                    $i$a$-maxByOrNull-PitchComputer$tick$finalInput$1 = false;
                    float v$iv = it2.getTarget();
                    if (Float.compare(maxValue$iv, v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        ControlInput finalInput = v0;
        if (finalInput == null) {
            this.activeInput = null;
            return;
        }
        this.activeInput = finalInput;
    }

    @Override
    public void renderTick() {
        ControlInput controlInput = this.activeInput;
        if (controlInput == null) {
            return;
        }
        ControlInput input = controlInput;
        if (this.canMoveOrBlockPitch() && input.getStatus() == ControlInput.Status.ACTIVE) {
            float target = input.getTarget();
            ControlInput controlInput2 = this.minimumPitch;
            if (!input.getPriority().isHigherOrSame(controlInput2 != null ? controlInput2.getPriority() : null)) {
                ControlInput controlInput3 = this.minimumPitch;
                Intrinsics.checkNotNull((Object)controlInput3);
                target = RangesKt.coerceAtLeast((float)target, (float)(controlInput3.getTarget() + 1.0f));
            }
            ControlInput controlInput4 = this.maximumPitch;
            if (!input.getPriority().isHigherOrSame(controlInput4 != null ? controlInput4.getPriority() : null)) {
                ControlInput controlInput5 = this.maximumPitch;
                Intrinsics.checkNotNull((Object)controlInput5);
                target = RangesKt.coerceAtMost((float)target, (float)(controlInput5.getTarget() - 1.0f));
            }
            this.smoothSetPitch((Player)this.getComputers().getData().getPlayer(), this.getComputers().getData().getPitch(), MathHelperKt.throwIfNotInRange(target, (ClosedFloatingPointRange<Float>)RangesKt.rangeTo((float)-90.0f, (float)90.0f)), MathHelperKt.throwIfNotInRange(input.getDeltaTimeMultiplier(), (ClosedFloatingPointRange<Float>)RangesKt.rangeTo((float)0.001f, (float)Float.MAX_VALUE)));
        }
    }

    private final boolean canMoveOrBlockPitch() {
        return AirDataComputer.automationsAllowed$default(this.getComputers().getData(), false, 1, null) && !this.getComputers().getProtections().getProtectionsLost();
    }

    /*
     * WARNING - void declaration
     */
    private final void updateSafePitches() {
        Object v1;
        void $this$maxByOrNull$iv;
        Object v0;
        void $this$minByOrNull$iv;
        Iterable $this$sortedBy$iv = this.getComputers().dispatchQuery(new MaximumPitchQuery());
        boolean $i$f$sortedBy = false;
        List maximums = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ControlInput it = (ControlInput)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getPriority().getValue());
                it = (ControlInput)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getPriority().getValue()));
            }
        });
        $this$sortedBy$iv = CollectionExtensionsKt.getActiveHighestPriority(maximums);
        PitchComputer pitchComputer = this;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                ControlInput it = (ControlInput)minElem$iv;
                boolean bl = false;
                float minValue$iv = it.getTarget();
                do {
                    Object e$iv = iterator$iv.next();
                    ControlInput it2 = (ControlInput)e$iv;
                    $i$a$-minByOrNull-PitchComputer$updateSafePitches$1 = false;
                    float v$iv = it2.getTarget();
                    if (Float.compare(minValue$iv, v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        pitchComputer.maximumPitch = v0;
        ControlInput max = this.maximumPitch;
        Iterable $this$sortedBy$iv2 = this.getComputers().dispatchQuery(new MinimumPitchQuery());
        boolean $i$f$sortedBy2 = false;
        List minimums = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv2, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ControlInput it = (ControlInput)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getPriority().getValue());
                it = (ControlInput)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getPriority().getValue()));
            }
        });
        $this$sortedBy$iv2 = CollectionExtensionsKt.getActiveHighestPriority(minimums);
        pitchComputer = this;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv2 = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv2.hasNext()) {
            v1 = null;
        } else {
            Object maxElem$iv = iterator$iv2.next();
            if (!iterator$iv2.hasNext()) {
                v1 = maxElem$iv;
            } else {
                ControlInput it = (ControlInput)maxElem$iv;
                boolean bl = false;
                float maxValue$iv = it.getTarget();
                do {
                    Object e$iv = iterator$iv2.next();
                    ControlInput it3 = (ControlInput)e$iv;
                    $i$a$-maxByOrNull-PitchComputer$updateSafePitches$2 = false;
                    float v$iv = it3.getTarget();
                    if (Float.compare(maxValue$iv, v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv2.hasNext());
                v1 = maxElem$iv;
            }
        }
        pitchComputer.minimumPitch = v1;
        ControlInput min = this.minimumPitch;
        if (max != null && min != null && max.getPriority().isHigherOrSame(min.getPriority())) {
            this.minimumPitch = ControlInput.copy$default(min, RangesKt.coerceAtMost((float)min.getTarget(), (float)max.getTarget()), null, null, 0.0f, null, 30, null);
        }
    }

    @Override
    @Nullable
    public ControlInput getPitchInput() {
        if (!this.getComputers().getData().getFlying()) {
            return null;
        }
        ControlInput max = this.maximumPitch;
        if (max != null && this.getComputers().getData().getPitch() > max.getTarget()) {
            return max;
        }
        ControlInput min = this.minimumPitch;
        if (min != null && this.getComputers().getData().getPitch() < min.getTarget()) {
            return min;
        }
        return null;
    }

    private final void smoothSetPitch(Player player, float current, float target, float deltaTimeMultiplier) {
        float diff = target - current;
        float closeDistanceMultiplier = diff == 0.0f ? 1.0f : RangesKt.coerceAtLeast((float)(1.0f / Math.abs(diff)), (float)1.0f);
        float delta = diff * ((Number)((Object)RangesKt.coerceIn((Comparable)Float.valueOf(FATickCounter.INSTANCE.getTimePassed() * deltaTimeMultiplier * closeDistanceMultiplier), (ClosedFloatingPointRange)RangesKt.rangeTo((float)0.0f, (float)1.0f)))).floatValue();
        player.m_146926_(player.m_146909_() - delta);
        player.f_19860_ -= delta;
    }

    @Override
    public void reset() {
        this.minimumPitch = null;
        this.maximumPitch = null;
        this.activeInput = null;
    }

    @Override
    @Nullable
    public ControlInput getThrustInput() {
        return FlightController.super.getThrustInput();
    }

    @Override
    @Nullable
    public ControlInput getHeadingInput() {
        return FlightController.super.getHeadingInput();
    }

    @Override
    @Nullable
    public ControlInput getRollInput() {
        return FlightController.super.getRollInput();
    }

    private static final void subscribeToEvents$lambda$0(PitchComputer this$0, Consumer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.accept(this$0);
    }

    private static final float subscribeToEvents$lambda$2$lambda$1(AirDataComputer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getPitch();
    }

    private static final void subscribeToEvents$lambda$2(PitchComputer this$0, float mcPitchDelta, List output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        if (this$0.canMoveOrBlockPitch()) {
            float pitchDelta = -mcPitchDelta;
            Float oldPitch = (Float)this$0.getComputers().guardedCall(this$0.getComputers().getData(), PitchComputer::subscribeToEvents$lambda$2$lambda$1);
            if (oldPitch == null) {
                this$0.getComputers().getProtections().setProtectionsLost(true);
                return;
            }
            float newPitch = oldPitch.floatValue() + pitchDelta;
            ControlInput min = this$0.minimumPitch;
            ControlInput max = this$0.maximumPitch;
            if (max != null && max.getStatus() == ControlInput.Status.ACTIVE && pitchDelta > 0.0f && newPitch > max.getTarget()) {
                output.add(new ControlInput(-RangesKt.coerceAtLeast((float)(max.getTarget() - oldPitch.floatValue()), (float)0.0f), null, max.getPriority(), 0.0f, null, 26, null));
            } else if (min != null && min.getStatus() == ControlInput.Status.ACTIVE && pitchDelta < 0.0f && newPitch < min.getTarget()) {
                output.add(new ControlInput(-RangesKt.coerceAtMost((float)(min.getTarget() - oldPitch.floatValue()), (float)0.0f), null, min.getPriority(), 0.0f, null, 26, null));
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/autoflight/base/PitchComputer$Companion;", "", "<init>", "()V", "ID", "Lnet/minecraft/resources/ResourceLocation;", "getID", "()Lnet/minecraft/resources/ResourceLocation;", "flightassistant-forge"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceLocation getID() {
            return ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/autoflight/base/PitchComputer$MaximumPitchQuery;", "Lru/octol1ttle/flightassistant/api/computer/ComputerQuery;", "Lru/octol1ttle/flightassistant/api/autoflight/ControlInput;", "<init>", "()V", "validateResponse", "", "response", "flightassistant-forge"})
    public static final class MaximumPitchQuery
    extends ComputerQuery<ControlInput> {
        @Override
        public void validateResponse(@NotNull ControlInput response) {
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            MathHelperKt.throwIfNotInRange(response.getTarget(), (ClosedFloatingPointRange<Float>)RangesKt.rangeTo((float)-90.0f, (float)90.0f));
            MathHelperKt.throwIfNotInRange(response.getDeltaTimeMultiplier(), (ClosedFloatingPointRange<Float>)RangesKt.rangeTo((float)0.001f, (float)Float.MAX_VALUE));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lru/octol1ttle/flightassistant/impl/computer/autoflight/base/PitchComputer$MinimumPitchQuery;", "Lru/octol1ttle/flightassistant/api/computer/ComputerQuery;", "Lru/octol1ttle/flightassistant/api/autoflight/ControlInput;", "<init>", "()V", "validateResponse", "", "response", "flightassistant-forge"})
    public static final class MinimumPitchQuery
    extends ComputerQuery<ControlInput> {
        @Override
        public void validateResponse(@NotNull ControlInput response) {
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            MathHelperKt.throwIfNotInRange(response.getTarget(), (ClosedFloatingPointRange<Float>)RangesKt.rangeTo((float)-90.0f, (float)90.0f));
            MathHelperKt.throwIfNotInRange(response.getDeltaTimeMultiplier(), (ClosedFloatingPointRange<Float>)RangesKt.rangeTo((float)0.001f, (float)Float.MAX_VALUE));
        }
    }
}

