/*
 * Decompiled with CFR 0.152.
 */
package ru.octol1ttle.flightassistant.impl.display;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import ru.octol1ttle.flightassistant.FlightAssistant;
import ru.octol1ttle.flightassistant.api.alert.Alert;
import ru.octol1ttle.flightassistant.api.alert.AlertCategory;
import ru.octol1ttle.flightassistant.api.alert.AlertData;
import ru.octol1ttle.flightassistant.api.alert.CenteredAlert;
import ru.octol1ttle.flightassistant.api.alert.ECAMAlert;
import ru.octol1ttle.flightassistant.api.computer.ComputerBus;
import ru.octol1ttle.flightassistant.api.display.Display;
import ru.octol1ttle.flightassistant.api.display.HudFrame;
import ru.octol1ttle.flightassistant.api.util.extensions.GuiGraphicsExtensionsKt;
import ru.octol1ttle.flightassistant.config.FAConfig;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lru/octol1ttle/flightassistant/impl/display/AlertDisplay;", "Lru/octol1ttle/flightassistant/api/display/Display;", "computers", "Lru/octol1ttle/flightassistant/api/computer/ComputerBus;", "<init>", "(Lru/octol1ttle/flightassistant/api/computer/ComputerBus;)V", "withUnderline", "Lnet/minecraft/network/chat/Style;", "allowedByConfig", "", "render", "", "guiGraphics", "Lnet/minecraft/client/gui/GuiGraphics;", "renderFaulted", "Companion", "flightassistant-forge"})
public final class AlertDisplay
extends Display {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Style withUnderline;
    @NotNull
    private static final ResourceLocation ID = FlightAssistant.INSTANCE.id$flightassistant_forge("alert");

    public AlertDisplay(@NotNull ComputerBus computers) {
        Intrinsics.checkNotNullParameter((Object)computers, (String)"computers");
        super(computers);
        Style style = Style.f_131099_.m_131162_(Boolean.valueOf(true));
        Intrinsics.checkNotNullExpressionValue((Object)style, (String)"withUnderlined(...)");
        this.withUnderline = style;
    }

    @Override
    public boolean allowedByConfig() {
        return FAConfig.INSTANCE.getDisplay().getShowAlerts();
    }

    @Override
    public void render(@NotNull GuiGraphics guiGraphics) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        GuiGraphics $this$render_u24lambda_u241 = guiGraphics;
        boolean bl = false;
        int x = HudFrame.INSTANCE.getLeft() + 5;
        int y = HudFrame.INSTANCE.getTop() + 5;
        boolean renderedCentered = false;
        for (AlertCategory category : this.getComputers().getAlert().getCategories()) {
            MutableComponent copy;
            Intrinsics.checkNotNullExpressionValue((Object)category.getCategoryText().m_6881_(), (String)"copy(...)");
            MutableComponent mutableComponent = copy.m_6270_(this.withUnderline);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"setStyle(...)");
            AlertData alertData = category.getFirstData((Function1<? super Alert, Boolean>)((Function1)AlertDisplay::render$lambda$1$lambda$0));
            if (alertData == null) continue;
            GuiGraphicsExtensionsKt.drawString$default($this$render_u24lambda_u241, (Component)mutableComponent, x, y, ((Number)alertData.getColorSupplier().invoke()).intValue(), false, 16, null);
            copy.m_130946_(" ");
            boolean categoryRendered = false;
            int lastRenderedLines = 0;
            for (Alert alert : category.getActiveAlerts()) {
                if (!alert.getAlertMethod().screen()) continue;
                if (!renderedCentered && alert instanceof CenteredAlert) {
                    renderedCentered = ((CenteredAlert)((Object)alert)).render($this$render_u24lambda_u241, GuiGraphicsExtensionsKt.getCenterY($this$render_u24lambda_u241) + 8);
                    categoryRendered = categoryRendered || renderedCentered;
                    y += GuiGraphicsExtensionsKt.getLineHeight();
                }
                if (!(alert instanceof ECAMAlert)) continue;
                if (lastRenderedLines > 1) {
                    y += 3;
                }
                lastRenderedLines = ((ECAMAlert)((Object)alert)).render($this$render_u24lambda_u241, x + GuiGraphicsExtensionsKt.textWidth((FormattedText)copy), x, y);
                y += GuiGraphicsExtensionsKt.getLineHeight();
                if (lastRenderedLines > 1) {
                    y += (GuiGraphicsExtensionsKt.getLineHeight() + 1) * (lastRenderedLines - 1);
                }
                categoryRendered = true;
            }
            if (!categoryRendered) {
                y += GuiGraphicsExtensionsKt.getLineHeight();
            }
            y += 3;
        }
    }

    @Override
    public void renderFaulted(@NotNull GuiGraphics guiGraphics) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        GuiGraphics $this$renderFaulted_u24lambda_u242 = guiGraphics;
        boolean bl = false;
        int x = HudFrame.INSTANCE.getLeft() + 5;
        int y = HudFrame.INSTANCE.getTop() + 5;
        MutableComponent mutableComponent = Component.m_237115_((String)"short.flightassistant.alert");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        GuiGraphicsExtensionsKt.drawString$default($this$renderFaulted_u24lambda_u242, (Component)mutableComponent, x, y, GuiGraphicsExtensionsKt.getWarningColor(), false, 16, null);
    }

    private static final boolean render$lambda$1$lambda$0(Alert it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getAlertMethod().screen();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lru/octol1ttle/flightassistant/impl/display/AlertDisplay$Companion;", "", "<init>", "()V", "ID", "Lnet/minecraft/resources/ResourceLocation;", "getID", "()Lnet/minecraft/resources/ResourceLocation;", "flightassistant-forge"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceLocation getID() {
            return ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

